
// File ASSIGN.BPL

// Device assignment

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "ERRCOD.BPL"
GET "SCBDDB.BPL"
GET "DEVCAP.BPL"

MANIFEST $(  // Device assignment modes
DM.ASSIGNED     = 1     // Device is assigned to a user
DM.FREE         = 0     // Device is free
$)

LET ASSIGNDEVICE(DEVICE, LOGNAME, PD) = VALOF
$( LET SECONDTIME = FALSE
   AND D = SINGLEACCESSDEVICES
   $( UNTIL D = 0 DO
      $( IF D!DDB.NAME = DEVICE DO
         $( LET NEWDAB = NEWVEC(DAB.SIZE)
            IF NEWDAB = 0 RESULTIS ERR.MFS
            IF CHECKRESOURCE(D) DO
            $( NEWDAB!DAB.LNAME := (LOGNAME = 0) -> DEVICE, LOGNAME
               NEWDAB!DAB.NAME := DEVICE
               NEWDAB!DAB.DDB := D
               [D!DDB.ASSIGNFN](D, DM.ASSIGNED, PD)
               !NEWDAB := PD!PD.DAB
               PD!PD.DAB := NEWDAB
               RESULTIS 0
            $)
            FREE(NEWDAB)
            RESULTIS ERR.DIU
         $)
         D := !D
      $)
      D := SHAREABLEDEVICES
      SECONDTIME := NOT SECONDTIME
   $) REPEATWHILE SECONDTIME
   RESULTIS ERR.DNF
$)

AND DEASSIGNDEVICE(DEVICE, PD) BE
$( LET A = PD + PD.DAB
   UNTIL !A = 0 DO
   $( LET B = !A
      IF ((B!DAB.LNAME = DEVICE) \/ (B!DAB.NAME = DEVICE)) DO
      $( LET D = B!DAB.DDB
         IF CUPROC = PD DO
            IF (CUPROC!PD.MONSTREAM)!SCB.DDB = D DO RETURN
         !A := !B
         [D!DDB.ASSIGNFN](D, DM.FREE, PD)
         V(D + DDB.ASSIGN)
         FREE(B)
         RETURN
      $)
      A := B
   $)
$)

AND CHECKRESOURCE(DDB) =
   (DDB!DDB.CAP & CAP.RESOURCE) = 0 ->
      CP(DDB + DDB.ASSIGN), RESOURCE(DDB)

// End of file ASSIGN.BPL

