
// File BDSKRW.BPL

// Buffered disc read and write routines

GET "SYSHDG.BPL"
GET "SCBDDB.BPL"
GET "SYSHDM.BPL"
GET "FILEHD.BPL"

LET DSKREAD(SCB, ADDRESS) = VALOF
$( LET BUF = SCB!SCB.INPUT
   AND MODE = SCB!SCB.MODE & #777
   AND STATUS = 0

   $( BUF!BUF.ECNT := BUF!BUF.ECNT - 1

      IF BUF!BUF.ECNT GE 0 DO
      $( !ADDRESS := GETBYTE(BUF, MODE)
         RESULTIS STATUS
      $)

      IF BUF!BUF.DDEP = 0 DO
         RESULTIS STATUS \/ STR.EOF

      DISCREADAHEAD(BUF)

      BUF := BUF!NEXT
      SCB!SCB.INPUT := BUF
      STATUS := WAIT(BUF!BUF.SEM)
      BUF!BUF.SEM := 0

      SETUPINPUTBUFFER(BUF, MODE, BUF!BUF.DDEP = 0 ->
                          (SCB!SCB.FCBIN)!FCB.WCOUNT, DISCBLOCK.WORDS)
   $) REPEAT
$)

AND DSKWRITE(SCB, VALUE) = VALOF
$( LET BUF = SCB!SCB.OUTPUT
   AND MODE = SCB!SCB.MODE & #777
   AND STATUS = 0

   UNLESS BUF!BUF.SEM = 0 DO
      STATUS := WAITANDRESET(BUF, MODE)

   PUTBYTE(BUF, VALUE, MODE)
   BUF!BUF.ECNT := BUF!BUF.ECNT - 1

   IF BUF!BUF.ECNT = 0 DO
   $( LET R = EXTENDFILE(SCB!SCB.FCBOUT)
      BUF!BUF.SEM := DISC.WRITE.REQUEST(R, BUF + BUF.DATA)
      SCB!SCB.OUTPUT := BUF!BUF.NEXT
   $)
   RESULTIS STATUS
$)

AND EXTENDFILE(FCB) = VALOF
$( LET R = GETBLOCK()

   IF R = 0 DO JOB.ERROR(0)
   TEST FCB!FCB.START = 0 THEN
      FCB!FCB.START := R
   OR
      CHAIN(FCB!FCB.END, R)

   FCB!FCB.END, FCB!FCB.LENGTH := R, FCB!FCB.LENGTH + 1
   RESULTIS R
$)

AND DISCREADAHEAD(BUF) BE
$( LET COUNT = 0
   AND BLK = 0

   $( BLK := BUF!BUF.DDEP
      BUF := BUF!BUF.NEXT
   $) REPEATUNTIL BUF!BUF.SEM = 0

   $( IF BLK = 0 RETURN

      BUF!BUF.SEM := DISC.READ.REQUEST(BLK, BUF + BUF.DATA)

      IF BUF!BUF.SEM = 0 DO
         TEST COUNT = 0 THEN JOB.ERROR(10) OR RETURN
      COUNT := COUNT + 1
      BLK := MAP(BLK)
      BUF!BUF.DDEP := BLK

      BUF := BUF!BUF.NEXT
   $) REPEATWHILE BUF!BUF.SEM = 0
$)

AND WAITANDRESET(BUFFER, MODE) = VALOF
$( LET R = WAIT(BUFFER!BUF.SEM)

   BUFFER!BUF.SEM := 0
   SETUPOUTPUTBUFFER(BUFFER, MODE, DISCBLOCK.WORDS)
   FOR I = BUF.DATA TO DISCBUFFER.SIZE DO BUFFER!I := 0
   RESULTIS R
$)

AND DSKBLOCKREAD(SCB. ADDRESS) = VALOF
$( LET BLK = SCB!SCB.INPUT

   IF BLK = 0 RESULTIS STR.EOF
   SCB!SCB.INPUT := MAP(BLK)
   RESULTIS DISC.READ(BLK, ADDRESS)
$)

AND DSKBLOCKWRITE(SCB, ADDRESS) = VALOF
$( LET BLK = SCB!SCB.OUTPUT

   TEST BLK = 0 THEN
      EXTENDFILE(SCB!SCB.FCBOUT)
   OR
      SCB!SCB.OUTPUT := MAP(BLK)
   RESULTIS DISC.WRITE(BLK, ADDRESS)
$)

// End of file BDSKRW.BPL

