
// File CMDOV.BPL

// Command decoder -- overlaid section

GET "SYSHDG.BPL"
GET "PDMAN.BPL"
GET "SYSHDM.BPL"
GET "ERRCOD.BPL"

LET FINDCOMMAND(NEWCOMMAND, REPLY, MASK) = VALOF
$( LET AMBIGUOUS = FALSE
   AND CFUN = -1

   FOR I = 0 TO NO.OF.COMMANDS DO
   $( IF NEWCOMMAND = COMMAND.VECTOR!I DO
      $( CFUN := I
         BREAK
      $)

      IF NEWCOMMAND = (COMMAND.VECTOR!I & MASK) DO
      $( IF AMBIGUOUS DO
         $( !REPLY := ERR.AMB
            RESULTIS FALSE
         $)
         AMBIGUOUS, CFUN := TRUE, I
      $)
   $)

   TEST CFUN = -1 THEN
   $( IF (CUPROC!PD.PRIV & LOGGEDIN) = 0 DO
         !REPLY := ERR.NLI
      RESULTIS FALSE
   $)
   OR
   $( LET R = CHECKPRIVILEGES(CFUN)
      !REPLY := R = 0 -> COMMAND.FUNCTION!CFUN, R
      RESULTIS R = 0
   $)
$)

AND CHECKPRIVILEGES(INDEX) = VALOF
$( LET PRIV = (TABLE 0, 0, LOGGEDIN + SYSPRIV + SHUTPRIV,
                     LOGGEDIN, LOGGEDIN, 0,
                     LOGGEDIN + SYSPRIV, LOGGEDIN,
                     LOGGEDIN, LOGGEDIN, LOGGEDIN,
                     LOGGEDIN, LOGGEDIN, LOGGEDIN,
                     LOGGEDIN, LOGGEDIN, LOGGEDIN,
                     LOGGEDIN, LOGGEDIN)!INDEX

   LET R = PRIV & CUPROC!PD.PRIV
   UNLESS R = PRIV DO
      RESULTIS (CUPROC!PD.PRIV & LOGGEDIN) = 0 ->
         ERR.NLI, ERR.PRV
   RESULTIS 0
$)

// End of file CMDOV.BPL

