
// File DCLOSE.BPL

// Disc close routine

GET "SYSHDG.BPL"
GET "MDCNST.BPL"
GET "SCBDDB.BPL"
GET "FILEHD.BPL"

LET WAITRING(BUF) BE
$( LET B = BUF

   $( UNLESS B!BUF.SEM = 0 DO WAIT(B!BUF.SEM)
      B := B!BUF.NEXT
   $) REPEATUNTIL B = BUF
$)

AND DSKCLOSEANDLOSE(SCB, FNREAD, FNWRITE) BE
$( LET BLOCKMODE = (SCB!SCB.MODE & #777) = 2
   AND BUFI = SCB!SCB.INPUT
   AND BUFO = SCB!SCB.OUTPUT
   AND FCBIN = SCB!SCB.FCBIN
   AND FCBOUT = SCB!SCB.FCBOUT
   AND DDB = SCB!SCB.DDB

   TEST BLOCKMODE THEN
   $( UNLESS FCBIN = 0 DO FNREAD(FCBIN, DDB)
      UNLESS FCBOUT = 0 DO FNWRITE(FCBOUT, DDB)
   $)
   OR
   $( UNLESS BUFI = 0 DO
      $( WAITRING(BUFI)
         FREEBUFFERS(BUFI)
         FNREAD(FCBIN, DDB)
      $)

      UNLESS BUFO = 0 DO
      $( TEST WORDSUSED(BUFO) = 0 THEN
            FCBOUT!FCB.WCOUNT := DISCBUFFER.SIZE
         OR
         $( LET R = EXTENDFILE(FCBOUT)
            BUFO!BUF.SEM := DISC.WRITE.REQUEST(R, BUFO + BUF.DATA)
            FCBOUT!FCB.WCOUNT := WORDSUSED(BUFO)
            BUFO := BUFO!BUF.NEXT
         $)

         WAITRING(BUFO)
         FREEBUFFERS(BUFO)

         FNWRITE(FCBOUT, DDB)
      $)
   $)
$)

AND DSKCLOSE(SCB) BE
   DSKCLOSEANDLOSE(SCB, DSKCLOSEREAD, DSKCLOSEWRITE)

AND DSKLOSE(SCB) BE
   DSKCLOSEANDLOSE(SCB, DSKLOSEREAD, DSKLOSEWRITE)

// End of file DCLOSE.BPL

