
// File DDVDEP.BPL

// Disc device dependent functions

GET "SYSHDM.BPL"
GET "STATUS.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "FILEHD.BPL"
GET "ERRCOD.BPL"

MANIFEST $(
DSK.RCPROT      = 1     // Read create protection
DSK.CCPROT      = 2     // Change create protection
DSK.RDFDB       = 3     // Read file descriptor block
DSK.AFCDEF      = 4     // Add file class definition
DSK.DFCDEF      = 5     // Delete file class definition
DSK.SFSTS       = 6     // Set file status
DSK.ARCHCOM     = 7     // Indicate archive completion
$)


LET READFILEFDB(DEVBLOCK, BUFFER) = VALOF
$( LET FRB = VEC FRB.SIZE
   AND REPLY = 0

   UPDATEFRB(DEVBLOCK + 2, FRB)

   UNLESS SEARCHUFD(FRB, LV REPLY, 0) DO
      OVFAIL(REPLY, 0, 0)
   REPLY := REPLY!UFD.FDB

   DISC.READ(REPLY, BUFFER)

   RESULTIS REPLY
$)

AND READUFDFDB(USER) = VALOF
$( LET R = CUPROC!PD.UFD

   P(LV DISCBUFFER1.USE, ST.CBW)

   UNLESS USER = CUPROC!PD.USERID DO
   $( R := SEARCHMFD(USER)
      IF R = 0 DO
         OVFAIL(ERR.NME, 0, LV DISCBUFFER1.USE, 0)
      R := R!MFD.UFD
   $)

   READ.TO.BUFFER1(R)
   RESULTIS R
$)

AND OVDSKDEP(DDB, DEVBLOCK) = VALOF
$( LET USER = DEVBLOCK!2 = 0 -> CUPROC!PD.USERID, DEVBLOCK!2

   UNLESS USER = CUPROC!PD.USERID DO
      UNLESS PRIVILEGED(FILEPRIV) DO
         ERROR.REPLY(ERR.PRV)

   P(LV DIRECTORY.MUTEX, ST.MUT)

   SWITCHON DEVBLOCK!1 INTO
   $( DEFAULT:
         OVFAIL(ERR.IDF, 0, 0)

      CASE DSK.RCPROT:
         READUFDFDB(USER)
         DEVBLOCK!3 := DISCBUFFER1!FDB.CRPROT
         ENDCASE

      CASE DSK.CCPROT:
      $( LET R = READUFDFDB(USER)
         DISCBUFFER1!FDB.CRPROT := DEVBLOCK!3
         WRITE.FROM.BUFFER1(R)
         ENDCASE
      $)

      CASE DSK.RDFDB:
         READFILEFDB(DEVBLOCK, DEVBLOCK!6)
         ENDCASE

      CASE DSK.AFCDEF:
      $( LET FDB = READFILEFDB(DEVBLOCK, DISCBUFFER1)

         FOR I = PROTECTIONDEFINITIONS TO DISCBLOCK.SIZE BY 2 DO
            IF DISCBUFFER1!I = 0 DO
            $( DISCBUFFER1!I := DEVBLOCK!6
               DISCBUFFER1!(I + 1) := DEVBLOCK!7
               WRITE.FROM.BUFFER1(FDB)
               ENDCASE
            $)
         OVFAIL(ERR.NDS, 0, LV DISCBUFFER1.USE, 0)
      $)

      CASE DSK.DFCDEF:
      $( LET FDB = READFILEFDB(DEVBLOCK, DISCBUFFER1)

         FOR I = PROTECTIONDEFINITIONS TO DISCBLOCK.SIZE BY 2 DO
            UNLESS DISCBUFFER1!I = 0 DO
               IF DISCBUFFER1!(I + 1) = DEVBLOCK!7 DO
                  IF DISCBUFFER1!I = DEVBLOCK!6 DO
                  $( DISCBUFFER1!I := 0
                     BREAK
                  $)

         WRITE.FROM.BUFFER1(FDB)
         ENDCASE
      $)

      CASE DSK.SFSTS:
      $( LET FDB = READFILEFDB(DEVBLOCK, DISCBUFFER1)

         DISCBUFFER1!FDB.STATUS := DEVBLOCK!6
         WRITE.FROM.BUFFER1(FDB)
         ENDCASE
      $)

      CASE DSK.ARCHCOM:
      $( UNLESS PRIVILEGED(FILEPRIV) DO
            OVFAIL(ERR.PRV, 0, 0)

         $( LET FDB = READFILEFDB(DEVBLOCK, DISCBUFFER1)

            IF DISCBUFFER1!FDB.STATUS & FST.ARCHDEL DO
            $( RETURNCHAIN(DISCBUFFER1!FDB.START, DISCBUFFER1!FDB.END)
               DISCBUFFER1!FDB.START := 0
               DISCBUFFER1!FDB.END := 0
               DISCBUFFER1!FDB.MARKER := MARKER.SAVE
            $)

            DISCBUFFER1!FDB.STATUS := 0
            DISCBUFFER1!FDB.TSAVE := TIME()
            DISCBUFFER1!FDB.DSAVE := DATE
            DISCBUFFER1!FDB.WHERE := DEVBLOCK!6
            WRITE.FROM.BUFFER1(FDB)
            ENDCASE
         $)
      $)
   $)

   V(LV DISCBUFFER1.USE)
   V(LV DIRECTORY.MUTEX)

   RESULTIS 0
$)

// End of file DDVDEP.BPL

