
// File DKVER2.BPL

// Disc verification routines (2) -- file verification

GET "MDCNST.BPL"
GET "SYSHDG.BPL"
GET "FILEHD.BPL"

GLOBAL $( DISCBUFFER1 : 232 $)  // Use the disc map buffer

GLOBAL $( ERROR.STREAM : 137 $)  // Same as OPERATORS.CONSOLE

STATIC $(
BITMAP2         = 0
CURRENTFILE     = 0
CURRENTUSER     = 0
MAXUSERBLOCK    = 0
DISCBUFFER2     = 0
$)

LET SETBIT(N) BE
$( LET O = N/BITSPERWORD
   BITMAP2!O := BITMAP2!O \/ (1 << (N REM BITSPERWORD))
$)

AND FINDBITINMAP(N, MAP) = VALOF
$( LET OFFSET = N/BITSPERWORD
   RESULTIS MAP!OFFSET & (1 << (N REM BITSPERWORD))
$)

AND FILEERROR(S) BE
   PRINT(ERROR.STREAM,
            "%:F[:8] :S*C*L", CURRENTFILE, CURRENTUSER, S)

AND NEXTBLK(N, REPLY) = VALOF
$( LET ERROR = 0

   TEST 2 LE N LE MAXUSERBLOCK THEN
      TEST FINDBITINMAP(N, BITMAP1) THEN
         ERROR := "Links into free chain"
      OR
         IF FINDBITINMAP(N, BITMAP2) DO
            ERROR := "Block in use"
   OR
      ERROR := "Illegal bn in chain"

   TEST ERROR = 0 THEN
   $( SETBIT(N)
      !REPLY := DISCMAP!N
      RESULTIS TRUE
   $)
   OR
   $( FILEERROR(ERROR)
      RESULTIS FALSE
   $)
$)

AND READUSERBLOCK(N, BUF) = VALOF
$( IF 0 LE N LE MAXUSERBLOCK DO
      UNLESS FINDBITINMAP(N, BITMAP1) \/
             FINDBITINMAP(N, BITMAP2) DO
      $( DISC.READ(N, BUF)
         SETBIT(N)
         RESULTIS TRUE
      $)
   RESULTIS FALSE
$)

AND VERIFYFILE(BLOCK) = VALOF
$( LET ALTERED = FALSE

   UNLESS READUSERBLOCK(BLOCK, DISCBUFFER3) DO
      RESULTIS FALSE

   $( LET FILESPEC = DISCBUFFER3 + FDB.FILE1

      FOR I = 0 TO 2 DO
      $( LET CFILE = CURRENTFILE!I
         UNLESS CFILE = FILESPEC!I DO
            ALTERED := TRUE
         FILESPEC!I := CFILE
      $)

      IF ALTERED DO FILEERROR("FDB name incorrect")

      UNLESS DISCBUFFER3!FDB.OWNER = CURRENTUSER DO
      $( FILEERROR("Owner incorrect")
         DISCBUFFER3!FDB.OWNER, ALTERED := CURRENTUSER, TRUE
      $)

      UNLESS DISCBUFFER3!FDB.MARKER = MARKER.SAVE DO
      $( LET BLKCOUNT = 0
         AND CBLK = DISCBUFFER3!FDB.START

         UNTIL CBLK = 0 DO
         $( UNLESS NEXTBLK(CBLK, LV CBLK) DO
            $( IF BLKCOUNT = 0 RESULTIS FALSE
               FILEERROR("Truncated")
               DISCMAP!CBLK := 0
               DISCBUFFER3!FDB.END := CBLK
               DISCBUFFER3!FDB.LENGTH := BLKCOUNT
               DISCBUFFER3!FDB.WCOUNT := 0
               ALTERED := TRUE
               BREAK
            $)
            BLKCOUNT := BLKCOUNT + 1
         $)
         UNLESS BLKCOUNT = DISCBUFFER3!FDB.LENGTH DO
         $( FILEERROR("Length incorrect")
            DISCBUFFER3!FDB.LENGTH, ALTERED := BLKCOUNT, TRUE
         $)
      $)
   $)
   IF ALTERED DO
   $( DISCBUFFER3!FDB.STATUS := DISCBUFFER3!FDB.STATUS \/ FST.ERROR
      DISC.WRITE(BLOCK, DISCBUFFER3)
   $)
   RESULTIS TRUE
$)

AND VERIFYUFD(BLOCK) = VALOF
$( CURRENTFILE := TABLE DIRECT1, DIRECT2, DIRECT3
   UNLESS VERIFYFILE(BLOCK) DO RESULTIS FALSE

   $( LET SBLOCK = DISCBUFFER3!FDB.START
      UNTIL SBLOCK = 0 DO
      $( LET ALTERED = FALSE
         DISC.READ(SBLOCK, DISCBUFFER2)
         FOR I = 0 TO DISCBLOCK.SIZE BY 4 DO
         $( LET BLK = DISCBUFFER2!(I + UFD.FDB)
            UNLESS BLK = 0 \/ BLK = BLOCK DO
            $( CURRENTFILE := DISCBUFFER2 + I
               UNLESS VERIFYFILE(BLK) DO
               $( FILEERROR("Deleted")
                  DISCBUFFER2!(I + UFD.FDB) := 0
                  ALTERED := TRUE
               $)
            $)
         $)
      $)
      IF ALTERED DO
         DISC.WRITE(SBLOCK, DISCBUFFER2)

      SBLOCK := DISCMAP!SBLOCK
   $)
   $)
   RESULTIS TRUE
$)

AND VERIFYMFD() = VALOF
$( LET BLKCOUNT = 0

   MAXUSERBLOCK := !DISCBUFFER1

   BITMAP2 := NEWVEC(MAXUSERBLOCK/BITSPERWORD + 1)
   DISCBUFFER2 := NEWVEC(DISCBLOCK.SIZE)

   UNTIL MFDBLK = 0 DO
   $( LET ALTERED = FALSE

      UNLESS READUSERBLOCK(MFDBLK, DISCBUFFER1) DO
      $( PRINT(ERROR.STREAM, "%MFD truncated*C*L")
         IF BLKCOUNT = 0 DO
         $( PRINT(ERROR.STREAM, "?Null MFD*C*L")
            SYSTEM.ERROR(9)
         $)

         DISCMAP!ENDMFDBLK := 0
         BREAK
      $)

      FOR I = 0 TO DISCBLOCK.SIZE BY 4 DO
      $( CURRENTUSER := DISCBUFFER1!I
         UNLESS CURRENTUSER = 0 DO
         $( LET BLK = DISCBUFFER1!(I + MFD.UFD)

            UNLESS BLK = 0 DO
               UNLESS VERIFYUFD(BLK) DO
               $( FILEERROR("Deleted")
                  DISCBUFFER1!(I + MFD.UFD) := 0
                  ALTERED := TRUE
               $)
         $)
      $)
      IF ALTERED DO WRITE.FROM.BUFFER1(MFDBLK)
      ENDMFDBLK := MFDBLK
      MFDBLK := DISCMAP!MFDBLK
      BLKCOUNT := BLKCOUNT + 1
   $)
   FREE(DISCBUFFER2)
   FREE(BITMAP1)
   BITMAP1 := BITMAP2
   RESULTIS BLKCOUNT
$)

// End of file DKVER2.BPL

