
// File DSKIO.BPL

// Filing system -- input and output to disc

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"
GET "DEVCAP.BPL"

MANIFEST $( FRB.SIZE = 4 $)

GLOBAL $( LEVEL: 31; LONGJUMP: 32 $)

LET DSKINOUT(SCB, DDB, FRB1, FRB2) BE
$( OVERLAY.CALL(DSKLOOKUP, 7, SCB, DDB, FRB1)
   $( LET STK = CUPROC!PD.ERRSTK
      AND ERR = CUPROC!PD.ERRLAB
      AND FCB = SCB!SCB.FCBIN

      CUPROC!PD.ERRSTK := LEVEL()
      CUPROC!PD.ERRLAB := INOUTFAIL

      OVERLAY.CALL(DSKENTER, 7, SCB, DDB, FRB2)

      CUPROC!PD.ERRSTK := STK
      CUPROC!PD.ERRLAB := ERR

      RETURN

   INOUTFAIL:
      DSKLOSEREAD(FCB, DDB)
      LONGJUMP(STK, ERR)
   $)
$)

AND DSKFILEOPEN(SCB, DDB, DMODE, TMODE, DEVBLOCK) BE
$( LET A = VEC FRB.SIZE
   AND B = VEC FRB.SIZE
   AND FUNCTION = DSKENTER

   UPDATEFRB(DEVBLOCK + 1, A)

   SWITCHON TMODE INTO
   $( CASE M.INPUT:
         FUNCTION := DSKLOOKUP

      CASE M.OUTPUT:
         OVERLAY.CALL(FUNCTION, 7, SCB, DDB, A)
         ENDCASE

      CASE M.TWOWAY:
         UPDATEFRB(DEVBLOCK + FRB.SIZE + 2, B)
         DSKINOUT(SCB, DDB, A, B)
         ENDCASE

      DEFAULT:
         SYSTEM.ERROR(4)
   $)
$)

AND DSKDEP(DDB, DEVBLOCK) = OVCALLER(OVDSKDEP, 8, DDB, DEVBLOCK)

// End of file DSKIO.BPL

