
// File DSKIOR.BPL

// I/O routines for device DSK:

GET "SYSHDG.BPL"
GET "MDCNST.BPL"
GET "STATUS.BPL"

MANIFEST $(   // Device control block accessors
DCB.DDB         = 1     // Pointer to device descriptor
DCB.DIR         = 2     // Transfer direction (1 = read, 2 = write)
DCB.ADDR        = 3     // Core address of transfer
DCB.COUNT       = 4     // Word count
DCB.DDEP        = 5     // Device dependent value
DCB.WSEM        = 6     // Wait semaphore
DCB.REPLY       = 7     // Reply from device

DCB.SIZE        = 7
$)

LET DODISCIO(BLOCK, ADDRESS, DIRECTION, SIZE) = VALOF
$( LET R = VEC DCB.SIZE

  SEMAPHORE(R + DCB.WSEM, 0)
   R!DCB.DIR, R!DCB.ADDR := DIRECTION, ADDRESS
   R!DCB.COUNT, R!DCB.DDEP, R!DCB.REPLY := SIZE, BLOCK, 0

   DISC.IO(R)
   P(R + DCB.WSEM, ST.IO)
   RESULTIS R!DCB.REPLY
$)

AND DISC.READ(BLOCK, ADDRESS) =
   DODISCIO(BLOCK, ADDRESS, 1, DISCBLOCK.WORDS)

AND DISC.WRITE(BLOCK, ADDRESS) =
   DODISCIO(BLOCK, ADDRESS, 2, DISCBLOCK.WORDS)

AND READ.TO.BUFFER1(BLOCK) =
   DODISCIO(BLOCK, DISCBUFFER1, 1, DISCBLOCK.WORDS)

AND WRITE.FROM.BUFFER1(BLOCK) =
   DODISCIO(BLOCK, DISCBUFFER1, 2, DISCBLOCK.WORDS)

AND WAIT(DCB) = VALOF
$( P(DCB + DCB.WSEM, ST.IO)

   $( LET R = DCB!DCB.REPLY
      FREE(DCB)
      RESULTIS R
   $)
$)

AND DELAYEDDISCIO(BLOCK, ADDRESS, DIRECTION) = VALOF
$( LET R = NEWVEC(DCB.SIZE)

   UNLESS R = 0 DO
   $( R!DCB.DIR, R!DCB.ADDR := DIRECTION, ADDRESS
      R!DCB.COUNT, R!DCB.DDEP := DISCBLOCK.WORDS, BLOCK

      SEMAPHORE(R + DCB.WSEM, 0)
      DISC.IO(R)
   $)

   RESULTIS R
$)

AND DISC.READ.REQUEST(BLOCK, ADDRESS) =
   DELAYEDDISCIO(BLOCK, ADDRESS, 1)

AND DISC.WRITE.REQUEST(BLOCK, ADDRESS) =
   DELAYEDDISCIO(BLOCK, ADDRESS, 2)

// End of file DSKIOR.BPL

