
// File DSKRDD.BPL

// Disc rename, delete and read directory entry

GET "SYSHDG.BPL"
GET "ERRCOD.BPL"
GET "STATUS.BPL"
GET "FILEHD.BPL"

STATIC $(
REPLY   = 0;    CREATE  = 0;    BLK     = 0
POSN    = 0;    FDBBLK  = 0
$)

LET DSKRENAME(DDB, FRB1, FRB2) = VALOF
$( P(LV DIRECTORY.MUTEX, ST.MUT)

   UNLESS SEARCHUFD(FRB1, LV POSN, 0) DO
      OVFAIL(POSN, 0, 0)

   BLK := CUDIRBLK
   FDBBLK := POSN!UFD.FDB

   V(LV DISCBUFFER1.USE)

   TEST SEARCHUFD(FRB2, LV REPLY, LV CREATE) THEN
   $( UNLESS (BLK = CUDIRBLK) & (POSN = REPLY) DO
         OVFAIL(ERR.FNE, 0, LV DISCBUFFER1.USE, 0)
      READ.TO.BUFFER1(FDBBLK)
      UNLESS CHECKPROTECTION(DISCBUFFER1, MODE.CHANGEPROT) DO
         OVFAIL(ERR.PRF, 0, LV DISCBUFFER1.USE, 0)
      DISCBUFFER1!FDB.PROT := FRB2!FRB.PROT
      WRITE.FROM.BUFFER1(FDBBLK)
      V(LV DISCBUFFER1.USE)
   $)
   OR
   $( P(LV DISCBUFFER1.USE, ST.CBW)

      READ.TO.BUFFER1(FDBBLK)
      IF DISCBUFFER1!FDB.MARKER = MARKER.UFD DO
         OVFAIL(ERR.CRU, 0, LV DISCBUFFER1.USE, 0)

      UNLESS CHECKPROTECTION(DISCBUFFER1, MODE.RENAME) DO
         OVFAIL(ERR.PRF, 0, LV DISCBUFFER1.USE, 0)

      $( LET Q = DISCBUFFER1 + FDB.OWNER
         AND R = FRB2 + FRB.FILE1

         TEST FRB1!FRB.OWNER = FRB2!FRB.OWNER THEN
         $( FOR I = FRB.FILE1 TO FRB.PROT DO
               Q!I := FRB2!I
            WRITE.FROM.BUFFER1(FDBBLK)
            READ.TO.BUFFER1(BLK)
            FOR I = 0 TO 2 DO POSN!I := R!I
            WRITE.FROM.BUFFER1(BLK)
         $)
         OR
         $( UNLESS CREATE DO
               OVFAIL(ERR.PRF, 0, LV DISCBUFFER1.USE, 0)
            FOR I = FRB.OWNER TO FRB.PROT DO
               Q!I := FRB2!I
            WRITE.FROM.BUFFER1(FDBBLK)

            READ.TO.BUFFER1(BLK)
            POSN!UFD.FDB := 0
            WRITE.FROM.BUFFER1(BLK)

            POSN := FINDUFDENTRY(FRB2 - 1)
            FOR I = 0 TO 2 DO POSN!I := R!I
            POSN!3 := FDBBLK

            WRITE.FROM.BUFFER1(CUDIRBLK)
         $)
      $)

      V(LV DISCBUFFER1.USE)

      IF SEARCHFCBCHAIN(DDB, FRB1, LV REPLY) DO
      $( IF (REPLY!FCB.USE & READACCESS) DO
         $( LET R = REPLY + FCB.OWNER
            FOR I = FRB.OWNER TO FRB.PROT DO
               R!I := FRB2!I
         $)
         V(LV ALTERFCBCHAIN)
      $)
   $)
   V(LV DIRECTORY.MUTEX)
   RESULTIS 0
$)

AND DSKDELETE(DDB, FRB) = VALOF
$( P(LV DIRECTORY.MUTEX, ST.MUT)

   UNLESS SEARCHUFD(FRB, LV REPLY, 0) DO
      OVFAIL(REPLY, 0, 0)
   FDBBLK := REPLY!UFD.FDB

   READ.TO.BUFFER1(FDBBLK)

   IF DISCBUFFER1!FDB.MARKER = MARKER.UFD DO
      OVFAIL(ERR.DUF, 0, LV DISCBUFFER1.USE, 0)

   UNLESS CHECKPROTECTION(DISCBUFFER1, MODE.DELETE) DO
      OVFAIL(ERR.PRF, 0, LV DISCBUFFER1.USE, 0)

   $( LET SBLOCK = DISCBUFFER1!FDB.START
      AND EBLOCK = DISCBUFFER1!FDB.END

      READ.TO.BUFFER1(CUDIRBLK)
      REPLY!UFD.FDB := 0
      WRITE.FROM.BUFFER1(CUDIRBLK)

      V(LV DISCBUFFER1.USE)

      TEST SEARCHFCBCHAIN(DDB, FRB, LV REPLY) THEN
      $( IF (REPLY!FCB.USE & READACCESS) = 0 THEN
         $( REPLY!FCB.USE := REPLY!FCB.USE \/ DELETED
            V(LV ALTERFCBCHAIN)
         $)
      $)
      OR
      $( UNLESS RETURNCHAIN(FDBBLK, FDBBLK) &
                RETURNCHAIN(SBLOCK, EBLOCK) DO
         $( V(LV DIRECTORY.MUTEX)
            OVJOB.ERROR(6)
         $)
         OUTMAP()
      $)
   $)

   V(LV DIRECTORY.MUTEX)
   RESULTIS 0
$)

AND DSKDIRFN(FRB, R) = VALOF
$( LET RES = VALOF
   $( P(LV DIRECTORY.MUTEX, ST.MUT)

      UNLESS SEARCHUFD(FRB, LV REPLY, 0) DO
         RESULTIS REPLY

      READ.TO.BUFFER1(REPLY!UFD.FDB)

      UNLESS CHECKPROTECTION(DISCBUFFER1, MODE.DIRREAD) DO
      $( V(LV DISCBUFFER1.USE)
         RESULTIS ERR.PRF
      $)

      FOR I = 0 TO FDB.ENTRYSIZE DO
         R!I := DISCBUFFER1!I

      V(LV DISCBUFFER1.USE)
      RESULTIS 0
   $)
   V(LV DIRECTORY.MUTEX)
   RESULTIS RES
$)

// End of file DSKRDD.BPL

