
// File FCLOSE.BPL

// Filing system -- close and lose functions

GET "MDCNST.BPL"
GET "STATUS.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"
GET "FILEHD.BPL"

LET FINDUFDENTRY(FCB) = VALOF
$( LET FOUND = FALSE
   AND FREEBLK = 0
   AND POSN = 0
   AND USER = FCB!FCB.OWNER
   AND UFDBLK = CUPROC!PD.UFD
   AND FILEPOSN = FCB + FCB.FILE1

   IF (CUPROC!PD.USERID NE USER) \/ (UFDBLK = 0) DO
   $( LET R = SEARCHMFD(USER)
      IF R = 0 DO SYSTEM.ERROR(3)
      UFDBLK := R!MFD.UFD
   $)

   READ.TO.BUFFER1(UFDBLK)
   CUDIRBLK := DISCBUFFER1!FDB.START

   UNTIL CUDIRBLK = 0 DO
   $( READ.TO.BUFFER1(CUDIRBLK)
      FOR I = 0 TO DISCBLOCK.SIZE BY 4 DO
      $( LET CUPOSN = DISCBUFFER1 + I
         TEST CUPOSN!UFD.FDB = 0 THEN
            UNLESS FOUND DO
               FOUND, FREEBLK, POSN := TRUE, FREEBLK, CUPOSN
         OR
            IF MATCHFILES(CUPOSN, FILEPOSN) DO
               RESULTIS CUPOSN
      $)
      CUDIRBLK := MAP(CUDIRBLK)
   $)

   IF FOUND DO
   $( UNLESS CUDIRBLK = FREEBLK DO
      $( READ.TO.BUFFER1(FREEBLK)
         CUDIRBLK := FREEBLK
      $)
      RESULTIS POSN
   $)

   CUDIRBLK := GETBLOCK()

   IF CUDIRBLK = 0 DO
   $( V(LV DISCBUFFER1.USE)
      V(LV ALTERFCBCHAIN)
      JOB.ERROR(7)
   $)

   READ.TO.BUFFER1(UFDBLK)
   CHAIN(DISCBUFFER1!FDB.END, CUDIRBLK)
   DISCBUFFER1!FDB.END := CUDIRBLK
   WRITE.FROM.BUFFER1(UFDBLK)
   ZEROBUFFER1()
   RESULTIS DISCBUFFER1
$)

AND ZEROBUFFER1() BE
   FOR I = 0 TO DISCBLOCK.SIZE DO DISCBUFFER1!I := 0

AND DELETESCAN(FCB, DDB) = VALOF
$( LET OWNER = FCB!FCB.OWNER
   AND CHAIN = DDB!DDB.FCBCHN
   AND FILE = FCB + FCB.FILE1
   AND INUSE = FALSE

   UNTIL CHAIN = 0 DO
   $( UNLESS CHAIN = FCB DO
         IF CHAIN!FCB.OWNER = OWNER DO
            IF MATCHFILES(CHAIN + FCB.FILE1, FILE) DO
            $( CHAIN!FCB.USE := CHAIN!FCB.USE \/ DELETED
               INUSE := TRUE
               BREAK
            $)
      CHAIN := !CHAIN
   $)
   RESULTIS INUSE
$)

AND DSKCLOSEREAD(FCB, DDB) BE
$( P(LV ALTERFCBCHAIN, ST.MUT)

   FCB!FCB.USE := FCB!FCB.USE - 1

   IF (FCB!FCB.USE & READERS) = 0 DO
   $( FCB!FCB.USE & DELETED DO
      $( LET R = FCB!FCB.DDB
         AND A = FCB!FCB.START
         AND B = FCB!FCB.END

         UNLESS RETURNCHAIN(A, B) &
                RETURNCHAIN(R, R) DO
         $( V(LV ALTERFCBCHAIN)
            JOB.ERROR(6)
         $)

         OUTMAP()
      $)
      KILLFCB(FCB, DDB)
   $)
   V(LV ALTERFCBCHAIN)
$)

AND DSKLOSEREAD(FCB, DDB) BE DSKCLOSEREAD(FCB, DDB)

AND DSKCLOSEWRITE(FCB, DDB) BE
$( P(LV DIRECTORY.MUTEX, ST.MUT)
   P(LV ALTERFCBCHAIN, ST.MUT)
   P(LV DISCBUFFER1.USE, ST.CBW)

   ZEROBUFFFER1()

   $( LET NOW = TIME()

      DISCBUFFER1!FDB.MARKER := MARKER.FILE

      FOR I = FCB.OWNER TO FCB.WCOUNT DO
         DISCBUFFER1!I := FCB!I

      DISCBUFFER1!FDB.DCREATE := DATE
      DISCBUFFER1!FDB.DACCESS := DATE
      DISCBUFFER1!FDB.TCREATE := NOW
      DISCBUFFER1!FDB.TACCESS := NOW

      WRITE.FROM.BUFFER1(FCB!FCB.FDB)
   $)

   OUTMAP()

   $( LET POSN = FINDUFDENTRY(FCB)
      AND FILE = FCB + FCB.FILE1
      LET FDB = POSN!3

      FOR I = 0 TO 2 DO POSN!I := FILE!I
      POSN!3 := FCB!FCB.FDB

      WRITE.FROM.BUFFER1(CUDIRBLK)

      UNLESS DELETESCAN(FCB, DDB) DO
         UNLESS FDB = 0 DO
         $( LET A = DISCBUFFER1!FDB.START
            AND B = DISCBUFFER1!FDB.END

            READ.TO.BUFFER1(FDB)

            UNLESS RETURNCHAIN(A, B) &
                   RETURNCHAIN(FDB, FDB) DO
            $( V(LV ALTERFCBCHAIN)
               V(LV DISCBUFFER1.USE)
               V(LV DIRECTORY.MUTEX)
               JOB.ERROR(6)
            $)
            OUTMAP()
         $)

      V(LV DISCBUFFER1.USE)
      KILLFCB(FCB, DDB)
   $)

   V(LV ALTERFCBCHAIN)
   V(LV DIRECTORY.MUTEX)
$)

AND DSKLOSEWRITE(FCB, DDB) BE
$( P(LV ALTERFCBCHAIN, ST.MUT)
   $( LET R = FCB!FCB.FDB

      RETURNCHAIN(R, R)
      UNLESS FCB!FCB.START = 0 DO
         RETURNCHAIN(FCB!FCB.START, FCB!FCB.END)
      KILLFCB(FCB, DDB)
   $)
   V(LV ALTERFCBCHAIN)
$)

// End of file FCLOSE.BPL

