
// File MDRTNS.BPL

// Machine-dependent routines for the PDP-10

// Segment 1

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"

GLOBAL $( PACKSTRING: 66; UNPACKSTRING: 67 $)

LET WR8(X, N) BE
$( LET M = N >> 3
   UNLESS M = 0 DO WR8(X + 1, M)
   !N := (N & 7) + '0'
$)

AND S(C) = #40  LE C LE #137 -> C - #40,
           #140 LE C LE #177 -> C - #140, 0

AND PACKCOMMAND(X) = VALOF
$( IF !X > 6 DO !X := 6
   RESULTIS PACK(X)
$)

AND PACKNAME(X, Y, WHICH) = VALOF
$( LET C, C1, C2, C3, C4, C5, C6 = 0, 0, 0, 0, 0, 0, 0
   LET E = VEC 30
   AND T = 0

   UNPACKSTRING(X, LV C)
   IF WHICH DO
   $( C4, C5, C6 := 0, 0, 0
      WR8(LV C4, Y)
   $)

   C := 6
   RESULTIS PACK(LV C)
$)

AND LNAME(X) = PACKNAME(X, 0, FALSE)

AND DNAME(X, Y) = PACKNAME(X, Y, TRUE)

AND SYSFILENAME(X) = PACKNAME(X, 0, FALSE)

AND STRING(X, Y) = VALOF
$( LET R = VEC 6

   FOR I = 1 TO 6 DO
      R!I := ((X >> (36 - (I * 6))) & #77) + #40

   !R := VALOF
         $( FOR I = 6 TO 1 BY -1 DO
               UNLESS R!I = #40 RESULTIS I
            RESULTIS 0
         $)

   PACKSTRING(R, Y)
   RESULTIS Y
$)

AND GETCOMMANDCHAR(STREAM, C) BE
   IF READCH(STREAM, C) & STR.EOF DO
      IF (CUPROC!PD.PRIV & LOGGEDIN) = 0 DO
         LOGOUT(FALSE)

AND READNAME(STREAM, CHAR, SIZE) = VALOF
$( LET C = 0
   AND I = 0
   AND NAME = 0

   GETCOMMANDCHAR(STREAM, LV C)

   WHILE ALPHA(C) DO
   $( IF I < 6 DO
         NAME, I := (NAME << 6) + C - #40, I + 1
      GETCOMMANDCHAR(STREAM, LV C)
   $)

   IF I < 6 THEN NAME := NAME << (36 - 6 * I)

   IF C = '*C' THEN GETCOMMANDCHAR(STREAM, LV C)

   !CHAR := C

   UNLESS SIZE = 0 DO
      !SIZE := (TABLE 0,
                      #770000000000,
                      #777700000000,
                      #777777000000,
                      #777777770000,
                      #777777777700,
                      #777777777777)!I

   RESULTIS NAME
$)

AND READCOMMAND(STREAM, CHAR, MASK) =
   READNAME(STREAM, CHAR, MASK)

AND READDEVICENAME(STREAM, CHAR) =
   READNAME(STREAM, CHAR, 0)

AND TIME() = (((HOUR << 6) + MIN) << 6) + SEC

AND WRITEFILE(STREAM, FILE) BE
$( LET T = VEC 6
   FOR I = 0 TO 2 DO
   $( WRITES(STREAM, STRING(FILE!I, T))
      UNLESS I = 2 DO WRITECH(STREAM, '/')
   $)
$)

AND ALPHA(C) = ('A' LE C LE 'Z') \/ ('0' LE C LE '9')

AND RNO(STREAM, LASTCHAR) =
   READNUMBER(8, STREAM, LASTCHAR)

AND PACK(R) = VALOF
$( LET T = 0
   AND Q = !R
   FOR I = 1 TO Q DO
      T := (T << 6) + S(R!I)
   RESULTIS T << ((6 - Q) * 6)
$)

 .

// Segment 2

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"

LET RNAME(STREAM, R, CHAR) = VALOF
$( LET I = 0

   WHILE ALPHA(CHAR) DO
   $( IF I < 6 DO
      $( I := I + 1
         R!I := CHAR
      $)
      READCH(STREAM,LV CHAR)
   $)
   !R := I
   RESULTIS CHAR
$)

AND GETFILE(STREAM, SPEC) = VALOF
$( LET ATOM = VEC 6
   AND DEV = FALSE
   AND FILE = 2
   AND ID = FALSE
   AND PROT = FALSE
   AND CH = 0

   !ATOM := 0
   $( READCH(STREAM, LV CH)
      IF ALPHA(CH) DO CH := RNAME(STREAM, ATOM, CH)
      SWITCHON CH INTO
      $( CASE ':':  IF DEV GOTO ERR
                    !SPEC := PACK(ATOM)
                    DEV, !ATOM := TRUE, 0
                    ENDCASE

         CASE '/':  IF (FILE > 4) \/ ID \/ PROT GOTO ERR

         FTYPE:     SPEC!FILE := PACK(ATOM)
                    IF FILE = 2 DO
                       SPEC!3, SPEC!4 := 0, 0
                    FILE, !ATOM, DEV := FILE + 1, 0, TRUE
                    ENDCASE

         CASE '[':  IF ID GOTO ERR
                    SPEC!1 := RNO(STREAM, LV CH)
                    UNLESS CH = ']' GOTO ERR
                    ID, DEV := TRUE, TRUE
                    UNLESS !ATOM = 0 GOTO FTYPE
                    FILE := 5
                    ENDCASE

         CASE '<':  IF PROT GOTO ERR
                    SPEC!5 := RNO(STREAM, LV CH)
                    UNLESS CH = '>' GOTO ERR
                    PROT, DEV := TRUE, TRUE
                    UNLESS !ATOM = 0 GOTO FTYPE
                    FILE := 5
                    ENDCASE

         DEFAULT:   UNLESS !ATOM = 0 DO
                    $( IF FILE > 4 GOTO ERR
                       SPEC!FILE := PACK(ATOM)
                    $)
                    RESULTIS CH

         ERR:       RESULTIS -CH
      $)
   $) REPEAT
$)

AND RUNIMAGE(DEFAULT.CORE) BE
$( LET STREAM = (CUPROC!PD.STREAMS)!0
   AND STARTER = 0
   AND SIZE = 0
   AND WD = 0

   CHANGECORE(0)
   IF READCH(STREAM, LV STARTER) & STR.EOF DO
      JOB.ERROR(2)
   IF READCH(STREAM, LV SIZE) & STR.EOF DO
      JOB.ERROR(2)

   $( LET R = CHANGECORE(SIZE > DEFAULT.CORE -> SIZE, DEFAULT.CORE)
      UNLESS R = 0 DO
      $( COMMAND.ERROR(R)
         EXIT(3)
      $)
      $( LET ADDRESS = MAPADDRESS(0, CUSLOT)
         UNTIL READCH(STREAM, LV WD) & STR.EOF DO
         $( !ADDRESS := WD
            ADDRESS := ADDRESS + 1
         $)
         RELINQUISH(CUSLOT)
      $)
      CUPROC!PD.START := STARTER
   $)
$)

AND SAVEIMAGE(DEFAULT.CORE) BE
$( LET SIZE = GETCORE()
   LET ADDRESS = MAPADDRESS(0, CUSLOT)
   LET TOP = ADDRESS + SIZE * WORDSPERCOREBLOCK
   AND STREAM = (CUPROC!PD.STREAMS)!0

   WRITECH(STREAM, CUPROC!PD.START)
   WRITECH(STREAM, SIZE > DEFAULT.CORE -> SIZE, DEFAULT.CORE)

   FOR I = TOP TO ADDRESS BY -1 DO
      UNLESS !I = 0 DO
      $( FOR J = ADDRESS TO I DO
            WRITECH(STREAM, !J)
         BREAK
      $)
   RELINQUISH(CUSLOT)
$)

// End of file MDRTNS.BPL

