
// File MMANGR.BPL

// Memory management sub-system -- memory manager

GET "PDMAN.BPL"
GET "SYSHDM.BPL"
GET "ERRCOD.BPL"
GET "SYSHDG.BPL"
GET "STATUS.BPL"


STATIC $(
BIT             = 0
OFFSET          = 0
MAPENTRY        = 0
DISCSIZE        = 0
LOCATION        = 0
FREECORE        = COREMAPSIZE
COREMAP         = 0
MM.DISCMAP      = 0
PROCESS.SEMS    = 0
$)

MANIFEST $(
SIZEFACTOR      = 1
ALLOCATION      = 1
TOPOFCOREMAP    = COREMAPSIZE + 1
$)

LET FINDHOLE(HOLESIZE, MAP, MAPSIZE) = VALOF
$( BIT, OFFSET, MAPENTRY := 2, 0, !MAP
   FOR I = 1 TO MAPSIZE + 1 - HOLESIZE DO
   $( IF (MAPENTRY & BIT) = 0 DO
         IF FINDGAP(HOLESIZE, MAP, LV I) DO
         IF FINDGAP(HOLESIZE, MAP, LV I) DO
            RESULTIS I
         BIT := BIT << 1
         IF BIT = 0 DO
         $( BIT, OFFSET := 1, OFFSET + 1
            MAPENTRY := MAP!OFFSET
         $)
   $)
   RESULTIS -1
$)

AND FINDGAP(HOLESIZE, MAP, POSITION) = VALOF
$( LET MAPCOPY = VEC 30
   AND CUPOS = 0
   AND CUPOS = !POSITION
   AND INITIALOFFSET = OFFSET

   FOR I = CUPOS TO CUPOS + HOLESIZE - 1 DO
   $( UNLESS (MAPENTRY & BIT) = 0 DO
      $( !POSITION := I
         RESULTIS FALSE
      $)

      MAPENTRY := MAPENTRY \/ BIT

      BIT := BIT << 1
      IF BIT = 0 DO
      $( MAPCOPY!CUPOS := MAPENTRY
         CUPOS := CUPOS + 1
         BIT, OFFSET := 1, OFFSET + 1
         MAPENTRY := MAP!OFFSET
      $)
   $)
   UNLESS BIT = 1 DO MAPCOPY!CUPOS := MAPENTRY
   FOR I = INITIALOFFSET TO OFFSET DO
      MAP!I := MAPCOPY!(I - INITIALOFFSET)
   RESULTIS TRUE
$)

AND SETUPACCESSORS(INDEX, MAP) BE
$( OFFSET := INDEX!BITSPERWORD
   BIT := 1 << (INDEX REM BITSPERWORD)
   MAPENTRY := MAP!OFFSET
$)

AND DEALLOCATE(MAP, STARTBLK, SIZE) BE
$( SETUPACCESSORS(STARTBLK, MAP)
   FOR I = 1 TO SIZE DO
   $( MAPENTRY := MAPENTRY & NOT BIT
      BIT := BIT << 1
      IF BIT = 0 DO
      $( MAP!OFFSET := MAPENTRY
         BIT, OFFSET := 1, OFFSET + 1
         MAPENTRY := MAP!OFFSET
      $)
   $)
   UNLESS BIT = 1 DO MAP!OFFSET := MAPENTRY
$)

AND FINDBESTTOSWAP(SIZE) = VALOF
$( LET LARGEST = -1
   AND LARGESTSIZE = 0
   AND NEAREST = -1
   AND NEARNESS = #77777

   FOR I = 0 TO JOBSLOTS DO
      IF LOCATION!I > 0 DO
      $( LET CANDIDATE = CORESIZE!I
         IF FREECORE + CANDIDATE GE SIZE DO
            IF CANDIDATE < NEARNESS DO
               NEAREST, NEARNESS := I, CANDIDATE
         IF CANDIDATE > LARGESTSIZE DO
            LARGEST, LRAGESTSIZE := I, CANDIDATE
      $)
   RESULTIS NEAREST = -1 -> LARGEST = -1 ->
      SYSTEM.ERROR(10), LARGEST, NEAREST
$)

AND SWAPIN(SLOT) BE
$( LET RQSIZE = CORESIZE!SLOT
   AND DSKSIZE = DISCSIZE!SLOT

   UNTIL FREECORE GE RQSIZE DO
      SWAPOUT(FINDBESTTOSWAP(RQSIZE))

   $( LET POSITION = FINDHOLE(RQSIZE, COREMAP, COREMAPSIZE)
      IF POSITION = -1 DO
      $( RESHUFFLE()
         LOOP
      $)
      SWAPMEIN(SLOT, POSITION)

      FREECORE := FREECORE - RQSIZE
      UNLESS DSKSIZE = 0 DO
         DEALLOCATE(MM.DISCMAP, -(LOCATION!SLOT), DSKSIZE)
      LOCATION!SLOT := POSITION
      PROTECT.TIMES!SLOT := INCOREPROTECTTIME(SLOT)

      RETURN
   $) REPEAT
$)

AND SWAPOUT(SLOT) BE
$( UNTIL PROTECT.TIMES!SLOT LE 0 DO
      P(LV MANGR.WAIT, ST.GEN)

   P(PROCESS.SEMS + SLOT, ST.SWP)

   $( LET RQSIZE = CORESIZE!SLOT
      LET POSITION = FINDHOLE(RQSIZE, MM.DISCMAP, DISCMAPSIZE)

      IF POSITION = -1 DO
         SYSTEM.ERROR(10)   // Only for now

      SWAPMEOUT(SLOT, POSITION)

      FREECORE := FREECORE + RQSIZE
      DEALLOCATE(COREMAP, LOCATION!SLOT, RQSIZE)
      LOCATION!SLOT, DISCSIZE!SLOT := -POSITION, RQSIZE
   $)
$)

AND CHANGEALLOCATION(SLOT, SIZE) BE
$( LET CUSIZE = CORESIZE!SLOT
   AND CULOC = LOCATION!SLOT
   LET SIZECHANGE = SIZE - CUSIZE

   IF SIZE = 0 DO
   $( UNLESS CULOC = 0 DO
         TEST CULOC < 0 THEN
            DEALLOCATE(MM.DISCMAP, -CULOC, DISCSIZE!SLOT)
         OR
         $( DEALLOCATE(COREMAP, CULOC, CUSIZE)
            SEMAPHORE(PROCESS.SEMS + SLOT, 0)
            FREECORE := FREECORE + CUSIZE
         $)

      LOCATION!SLOT, CORESIZE!SLOT, DISCSIZE!SLOT := 0, 0, 0
      RETURN
   $)

   TEST CULOC = 0 THEN
      DISCSIZE!SLOT, LOCATION!SLOT := 0, -1
   OR
      IF CULOC > 0 DO
         TEST SIZE > CUSIZE THEN
            TEST CULOC + SIZE > TOPOFCOREMAP THEN
               SWAPOUT(SLOT)
            OR
            $( LET CUPOS = CULOC + CUSIZE
               LET W = CUPOS * WORDSPERCOREBLOCK
               SETUPACCESSORS(CUPOS, COREMAP)

               TEST FINDGAP(SIZECHANGE, COREMAP, LV CUPOS) THEN
               $( ZEROCORE(BASEADDRESS + W, SIZECHANGE)
                  FREECORE := FREECORE - SIZECHANGE
               $)
               OR
                  SWAPOUT(SLOT)
            $)
         OR
            TEST SIZE < CUSIZE THEN
            $( LET LIM = CULOC + CUSIZE - SIZECHANGE
               DEALLOCATE(COREMAP, LIM, SIZECHANGE)
               FREECORE := FREECORE + SIZECHANGE
            $)
            OR
               RETURN
   CORESIZE!SLOT := SIZE
$)

AND MOVECOREIMAGE(SLOT, NEWPOSITION) BE
$( LET CUPOS = LOCATION!SLOT
   AND CUSIZE = CORESIZE!SLOT

   MOVECOREBLOCKS(CUPOS, NEWPOSITION, CUSIZE)
   DEALLOCATE(COREMAP, CUPOS, CUSIZE)
   SETUPACCESSORS(NEWPOSITION, COREMAP)
   TEST FINDGAP(CUSIZE, COREMAP, LV NEWPOSITION) THEN
      LOCATION!SLOT := NEWPOSITION
   OR
      SYSTEM.ERROR(11)
$)

AND RESHUFFLE() BE
$( BIT, OFFSET, MAPENTRY := 2, 0, !COREMAP

   FOR I = 1 TO COREMAPSIZE DO
   $( IF (MAPENTRY & BIT) = 0 DO
      $( LET NEXTTOMOVE = FINDNEXTIMAGE(I)
         IF NEXTTOMOVE = -1 RETURN

         P(PROCESS.SEMS + NEXTTOMOVE, ST.SWP)
         MOVECOREIMAGE(NEXTTOMOVE, I)
         V(PROCESS.SEMS + NEXTTOMOVE)
         I := I + CORESIZE!NEXTTOMOVE - 1
         SETUPACCESSORS(I, COREMAP)
      $)
      BIT := BIT << 1
      IF BIT = 0 DO
      $( BIT, OFFSET := 1, OFFSET + 1
         MAPENTRY := COREMAP!OFFSET
      $)
   $)
$)

AND FINDNEXTIMAGE(BASE) = VALOF
$( LET JOBTOMOVE = -1
   AND JOBBASE = #77777

   FOR I = 0 TO JOBSLOTS DO
   $( LET LOC = LOCATION!I
      IF LOC > 0 DO
         IF BASE < LOC < JOBBASE DO
            JOBBASE, JOBTOMOVE := LOC, I
   $)
   RESULTIS JOBTOMOVE
$)

AND SWAPMEIN(SLOT, POSITION) BE
$( LET ONDISC =
      SWAPBASE - LOCATION!SLOT * DISCBLOCKSPERCOREBLOCK
   AND INCORE =
      BASEADDRESS + POSITION * WORDSPERCOREBLOCK
   AND SIZE = CORESIZE!SLOT < DISCSIZE!SLOT ->
                CORESIZE!SLOT, DISCSIZE!SLOT

   TEST DISCSIZE!SLOT = 0 THEN
      ZEROCORE(INCORE, CORESIZE!SLOT)
   OR
   $( DODISCIO(ONDISC, INCORE, 1, SIZE * WORDSPERCOREBLOCK)
      $( LET PD = JOBTABLE!SLOT
         PD!PD.STATUS := PD!PD.STATUS & NOT ST.NOTINCORE
      $)
   $)
$)

AND SWAPMEOUT(SLOT, POSITION) BE
$( LET INCORE =
      BASEADDRESS + LOCATION!SLOT * WORDSPERCOREBLOCK
   AND ONDISC =
      SWAPBASE + POSITION * DISCBLOCKSPERCOREBLOCK

   DODISCIO(ONDISC, INCORE, 2, CORESIZE!SLOT * WORDSPERCOREBLOCK)

   $( LET PD = JOBTABLE!SLOT
      PD!PD.STATUS := PD!PD.STATUS \/ ST.NOTINCORE
   $)
$)

AND ACCESSCOREIMAGE(SLOT) BE
   UNLESS CP(PROCESS.SEMS + SLOT) DO
      COMMUNICATE(MMANGR.PD, 0, SLOT, C.SWAPIN)

AND RELINQUISH(SLOT) BE
   V(PROCESS.SEMS + SLOT)

AND MAPADDRESS(ADDRESS, SLOT) = VALOF
$( LET TOP = CORESIZE!SLOT * WORDSPERCOREBLOCK

   UNLESS 0 LE ADDRESS LE TOP DO JOB.ERROR(20)

   ACCESSCOREIMAGE(SLOT)

   RESULTIS BASEADDRESS + ADDRESS + LOCATION!SLOT * WORDSPERCOREBLOCK
$)

AND GETWORD(ADDRESS) = VALOF
$( LET SLOT = CUPROC!PD.JBSLOT
   LET R = !(MAPADDRESS(ADDRESS & MAPMASK, SLOT))

   RELINQUISH(SLOT)
   RESULTIS R
$)

AND PLANT(ADDRESS, VALUE) BE
$( LET SLOT = CUPROC!PD.JBSLOT
   LET R = MAPADDRESS(ADDRESS & MAPMASK, SLOT)

   !R := VALUE
   RELINQUISH(SLOT)
$)

AND INCOREPROTECTTIME(SLOT) = CORESIZE!SLOT * SIZEFACTOR + ALLOCATION

MANIFEST $(
COREMAPLENGTH   = (COREMAPSIZE + BITSPERWORD - 1)/BITSPERWORD - 1
DISCMAPLENGTH   = (DISCMAPSIZE + BITSPERWORD - 1)/BITSPERWORD - 1
$)

MMANGR:
$( LET A = VEC JOBSLOTS
   AND B = VEC JOBSLOTS
   AND C = VEC JOBSLOTS
   AND D = VEC JOBSLOTS
   AND E = VEC COREMAPLENGTH
   AND F = VEC DISCMAPLENGTH
   AND G = TABLE 0, 0, 0, 0
   AND H = VEC JOBSLOTS

   CORESIZE, DISCSIZE, LOCATION := A, B, C
   PROCESS.SEMS, PROTECT.TIMES := D, H
   COREMAP, MM.DISCMAP := E, F

   FOR I = 0 TO JOBSLOTS DO
   $( CORESIZE!I, DISCSIZE!I := 0, 0
      LOCATION!I, PROTECT.TIMES!I := 0, 0
      SEMAPHORE(PROCESS.SEMS + I, 0)
   $)

   FOR I = 0 TO COREMAPLENGTH DO COREMAP!I := 0
   FOR I = 0 TO DISCMAPLENGTH DO MM.DISCMAP!I := 0

   WAIT.BLOCK(G)
   $( LET PD = JOBTABLE!(!G)
      AND REPLY = 0

      SWITCHON G!1 INTO
      $( CASE C.SWAPIN:
            SWAPIN(!G)
            ENDCASE

         CASE C.ALLOC:
         $( LET A = G!2
            TEST A > MAXCORE THEN
               REPLY := ERR.TBG
            OR CHANGEALLOCATION(!G, A)
            ENDCASE
         $)

         DEFAULT:
            SYSTEM.ERROR(12)
      $)
      COMMUNICATE.REPLY(PD, REPLY)
   $)
   $) REPEAT
$)

// End of file MMANGR.BPL

