
// File OVCALL.BPL

// Overlay call function

GET "SYSHDM.BPL"
GET "SYSHDG.BPL"
GET "STATUS.BPL"

STATIC $( USERS = 0; CURRENT.OVERLAY = 0 $)

LET OVERLAY.CALL(FN, OVERLAY, A, B, C) = VALOF
$( TEST OVERLAYING THEN
   $( P(LV OVERLAY.PENDING, ST.OVW)
      TEST OVERLAY = CURRENT.OVERLAY THEN
      $( P(LV USERS.MUTEX, ST.MUT)
         IF USERS = 0 DO
            P(LV USE.OVERLAY, ST.OVW)
      $)
      OR
      $( P(LV USE.OVERLAY, ST.OVW)
         READ.OVERLAY(OVERLAY)
         P(LV USERS.MUTEX, ST.MUT)
      $)

      USERS := USERS + 1
      V(LV USERS.MUTEX)
      V(LV OVERLAY.PENDING)

      $( LET R = FN(A, B, C)
         OVEXIT()
         RESULTIS R
      $)
   $)
   OR RESULTIS FN(A, B, C)
$)

AND OVEXIT() BE
$( IF OVERLAYING DO
   $( P(LV USERS.MUTEX, ST.MUT)
      USERS := USERS - 1
      IF USERS = 0 DO V(LV USE.OVERLAY)
      V(LV USERS.MUTEX)
   $)
$)

AND READ.OVERLAY(OVERLAY) BE
$( LET BLOCK = OVERLAY.TABLE!OVERLAY
   DODISCIO(BLOCK, OVERLAY.AREA, 1, OVERLAY.SIZE)
   CURRENT.OVERLAY := OVERLAY
$)

// End of file OVCALL.BPL

