
// File SCBDDB.BPL

// Stream control block and device descriptor accessors

MANIFEST $(  // Stream control block accessors
SCB.DDB         = 0     // Ptr to device descriptor for this stream
SCB.DEVNO       = 1     // Absolute device no within device group
SCB.READ        = 2     // Read routine for this stream
SCB.WRITE       = 3     // Write routine for this stream
SCB.INPUT       = 4     // Pointer to the input buffer
SCB.OUTPUT      = 5     // Pointer to the output buffer
SCB.FCBIN       = 6     // Pointer to the file descriptor for input
SCB.FCBOUT      = 7     // Pointer to the file descriptor for output
SCB.MODE        = 8     // I/O request mode

SCB.SIZE        = 8
$)

MANIFEST $(  // Device descriptor block accessors
DDB.NAME        = 1     // Device name
DDB.DEVNO       = 2     // Device no within similar device group
DDB.CAP         = 3     // Device capability word
DDB.READ        = 4     // Device read routine
DDB.WRITE       = 5     // Device write routine
DDB.OPEN        = 6     // Function to open a stream to this device
DDB.CLOSE       = 7     // Function to close a stream from this device
DDB.LOSE        = 8     // Function to lose a stream from this device
DDB.ASSIGNFN    = 9     // Function to be applied on ASSIGN
DDB.DEVDEP      = 10    // Device-dependent function
DDB.ASSIGN      = 11    // Assignment semaphore
//
// The following are only available on
// file-orientated devices
//
DDB.OPENFILES   = 12    // Function to open files to/from device
DDB.DELETE      = 13    // Function to delete a file
DDB.RENAME      = 14    // Function to rename a file
DDB.DIRFN       = 15    // Directory entry read function
DDB.OVNO        = 16    // Overlay no for delete, rename and directory read
DDB.FCBCHN      = 17    // File control block chain header

LONG.DDB        = 17
SHORT.DDB       = 11
$)

// End of file SCBDDB.BPL

