
// File SCHED.BPL

// Priority scheduler -- with fairness consideration

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "STATUS.BPL"

GLOBAL $( CHECK.TTY: 99 $)  // DECsystem-10 only

STATIC $( FAIRNESSCOUNT = 0 $)

MANIFEST $( FAIRNESSBREAK = 10 $)

MANIFEST $( SWAPPRIORITY = 10 $)

LET RUNSYSTEM() BE
$( CHECK.TTY()
   FAIRNESSCOUNT := FAIRNESSCOUNT + 1
   CONTEXT.CHANGES := CONTEXT.CHANGES + 1

   LOCK()
   $( LET TPD = SCHEDQ
      AND PPD = LV SCHEDQ

      TEST FAIRNESSCOUNT > FAIRNESSBREAK THEN
         FAIRNESSCOUNT := 0
      OR
      $( LET A, B = SCHEDQ, !SCHEDQ
         AND PRIO = FINDPRIORITY(SCHEDQ)

         UNTIL B = 0 DO
         $( LET P = FINDPRIORITY(B)
            IF P > PRIO DO
               PRIO, TPD, PPD := P, B, A
            A := B
            B := !B
         $)
      $)

      !PPD := !TPD
      CUPROC := TPD

      IF ESCHEDQ = TPD THEN ESCHEDQ := PPD
   $)
   LOADGO()
   WHILE SCHEDQ = 0 IDLE()
$) REPEAT

AND FINDPRIORITY(PD) = (PD!PD.STATUS & ST.NOTINCORE) ->
                       PD!PD.PRIO, SWAPPRIORITY

AND RUNPROCESS() BE
$( JOBTABLE!(NEWPD!PD.JBSLOT) := NEWPD
   PROCESSES := PROCESSES + 1
   LOCK()
   !ESCHEDQ := NEWPD
   ESCHEDQ := NEWPD
   UNLOCK()
   V(LV JOBTABLEMUTEX)
$)

// End of file SCHED.BPL

