
// File SPACE.BPL

// Free space administration routines

GET "MDCNST.BPL"
GET "STATUS.BPL"
GET "SYSHDG.BPL"

STATIC $( FREECH = 0 $)

LET INITIALISE(V) BE
$( FREECH := V
   !FREECH, 1!FREECH := 0, FREE.SPACE.SIZE
$)

AND NEWVEC(S) = VALOF   // Returns pointer to a block of S+1 words
$( P(LV SPACEWAIT, ST.SPW)
   $( LET Q, R = FREECH, LV FREECH
      LET T = VALOF
      $( UNTIL Q = 0 DO
         $( LET U = Q!1
            IF S < U DO
            $( IF U LE S + 2 DO
               $( !R := !Q
                  !Q := Q!1 - 1
                  RESULTIS Q + 1
               $)
               R := Q + U - S - 1
               Q!1 := U - S - 2
               !R := S
               RESULTIS R + 1
            $)
            R := Q
            Q := !Q
         $)
         RESULTIS 0
      $)
      V(LV SPACEWAIT)
      UNLESS T = 0 DO FOR I = T TO T + S DO !I := 0
      RESULTIS T
   $)
$)

AND MERGE(BLOCK) BE
$( LET R = !BLOCK
   UNLESS R = 0 DO
   $( IF BLOCK + BLOCK!1 + 1 = R DO
      $( BLOCK!1 := BLOCK!1 + R!1 + 1
         !BLOCK := !R
      $)
   $)
$)

AND FREE(B) BE
$( IF B LE 0 RETURN
   P(LV SPACEWAIT, ST.RET)
   $( LET Q, R = LV FREECH, B - 1
      !B := !R + 1
      UNTIL !Q = 0 \/ !Q > R DO Q := !Q
      !R := !Q
      !Q := R
      MERGE(R)
      UNLESS Q = LV FREECH DO MERGE(Q)
   $)
   V(LV SPACEWAIT)
$)

// End of file SPACE.BPL

