
// File STRUCT.BPL

// Routines for structured devices

GET "SYSHDG.BPL"
GET "ERRCOD.BPL"
GET "SCBDDB.BPL"
GET "FILEHD.BPL"
GET "DEVCAP.BPL"

LET STRUCTURED.FUNCTION(DEVBLOCK, OFFSET) = VALOF
$( LET D = FINDDEVICE(!DEVBLOCK)
   IF (D!DDB.CAP & CAP.STRUC) NE 0 DO
   $( LET A = VEC FRB.SIZE
      AND B = VEC FRB.SIZE

      UPDATEFRB(DEVBLOCK + 1, A)
      IF OFFSET = DDB.RENAME DO
         UPDATEFRB(DEVBLOCK + FRB.SIZE + 2, B)
      RESULTIS OVERLAY.CALL(D!OFFSET, D!DDB.OVNO, D, A, B)
   $)
   RESULTIS 0
$)

AND DELETE(DEVBLOCK) =
   STRUCTURED.FUNCTION(DEVBLOCK, DDB.DELETE)

AND RENAME(DEVBLOCK) =
   STRUCTURED.FUNCTION(DEVBLOCK, DDB.RENAME)

AND READDIRECTORYENTRY(DEVBLOCK, R) = VALOF
$( LET D = FINDDEVICE(!DEVBLOCK)
   AND A = VEC FRB.SIZE

   UNLESS (D!DDB.CAP & CAP.STRUC) NE 0 DO ERROR.REPLY(ERR.NFS)

   UPDATEFRB(DEVBLOCK + 1, A)
   RESULTIS OVERLAY.CALL(D!DDB.DIRFN, D!DDB.OVNO, A, R)
$)

// End of file STRUCT.BPL

