
// File SUMREP.BPL

// System statistics summary functions and error reporter

GET "SYSHDM.BPL"
GET "SYSHDG.BPL"
GET "PDMAN.BPL"

GLOBAL $( S : 137 $)

LET SUMMARY() BE
$( PRINT(S, "*C*LStatistics for :V on :D at :T*C*L")
   PRINT(S, "*C*L:N context switches*C*L", CONTEXT.CHANGES)
   PRINT(S, "idletime = ")
   PRTIME(IDLETIME)
   PROCESS.DATA(SYSTEM.PD, "master process")
   PROCESS.DATA(MMANGR.PD, "memory manager")
$)

AND PRTIME(TICKS) BE
$( LET SECONDS = TICKS/CLOCK.FREQUENCY
   LET MINUTES = SECONDS/60
   PRINT(S, ":N:::N:::N*C*L", MINUTES/60, MINUTES REM 60, SECONDS REM 60)
$)

AND PROCESS.DATA(PD, WHO) BE
$( PRINT(S, "*C*LStatistics for :S*C*L*C*L", WHO)
   PRINT(S, ":N disc transfers*C*L")
   PRINT(S, "Run time = ")
   PRTIME(PD!PD.RTIME)
   $( LET S = PD!PD.STACK
      FOR I = STACK.SIZE TO 0 BY -1 DO
         UNLESS S!I = 0 DO
         $( PRINT(S, ":N/:N = :N% stack*C*L", I, STACK.SIZE,
                                 I * 100 / STACK.SIZE)
            BREAK
         $)
   $)
$)

// End of file SUMREP.BPL

