
// File SYSHDM.BPL

// System header file for manifest constants

MANIFEST $(  // System version number, etc.
SYSVER  = #31
EDIT    = 'B'
$)

MANIFEST $(  // Device assignment block accessors
DAB.DDB         = 1     // Pointer to device descriptor block
DAB.LNAME       = 2     // Logical device name
DAB.NAME        = 3     // Device name

DAB.SIZE        = 3
$)

MANIFEST $(  // System request values
C.LOGIN         = 100   // Online login request
C.KILL          = 101   // Process deletion request
C.SHUTDOWN      = 103   // Request to close down system
C.COMM          = 104   // Process communication request
C.STOPPED       = 105   // Process stopped (at all levels)
C.LOGGEDOUT     = 106   // Process has logged out
$)

MANIFEST $(  // Process privilege and state bits
LOGGEDIN        = #1
ERROR           = #2
BATCH           = #4
SYSPRIV         = #10
FILEPRIV        = #20
SHUTPRIV        = #40
BATPRIV         = #100
INHPASS         = #200
SUBPROCESS      = #400
TEMPORARY.PRIVILEGES = #1000

LOGINMASK       = #170
$)

MANIFEST $(  // Login block accessors
LGB.USERID      = 0     // User identification
LGB.PASSWD      = 1     // Password

LGB.SIZE        = 1
$)

MANIFEST $(  // Stream status bits
STR.EOF         = #1    // End of file
STR.HDW         = #2    // Hardware detected error
STR.SFT         = #4    // Software detected error
$)

MANIFEST $(  // I/O request modes
M.INPUT         = 1     // Input only
M.OUTPUT        = 2     // Output only
M.TWOWAY        = 3     // Both ways
$)

MANIFEST $(  // Memory manager request values
C.SWAPIN        = 1     // Core image swap request
C.ALLOC         = 2     // Change core allocation request
$)

GET "MDCNST.BPL"        // Machine-dependent constants

// End of file SYSHDM.BPL

