
// File SYSLOG.BPL

// Login and logout system process

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "STATUS.BPL"
GET "ERRCOD.BPL"

STATIC $( CLOSINGDOWN = FALSE $)

LET APPLY.TO.TTY.STREAM(D, S, FN, A) BE
$( LET R = DNAME("TTY", D)
   UNLESS OVCALLER(ASSIGNDEVICE, 2, R, 0, CUPROC) DO
      SYSTEM.ERROR(8)
   UNLESS CALLER(OPEN.IO.STREAM, S, 0, LV R) = 0 DO
      SYSTEM.ERROR(8)
   FN(A)
   OVERLAY.CALL(DEASSIGNDEVICE, 2, R, CUPROC)
$)

AND OUTMESSAGE(N) BE
$( LET WHY = VALOF
   SWITCHON N INTO
   $( CASE ERR.NJS:
         RESULTIS "No job slots"

      CASE ERR.MFS:
         RESULTIS "Free space fail"

      CASE ERR.CLD:
         RESULTIS "System closing down"

      DEFAULT:
         RESULTIS "XX"
   $)
   PRINT(1, "?:S*C*L%", WHY)
   CLOSE.STREAM(1)
$)

AND MESSAGE(D, N) BE APPLY.TO.TTY.STREAM(D, 1, OUTMESSAGE, N)

AND DOSETUP() BE OVERLAY.CALL(SETDATEANDTIME, 1)

AND SETUP() BE APPLY.TO.TTY.STREAM(CONSOLE, 0, DOSETUP)

AND CHECKDISC() BE
$( OVERLAY.CALL(VERIFYFREECHAIN, 5)
   $( LET MFDSIZE = OVERLAY.CALL(VERIFYMFD, 6)
      OVERLAY.CALL(RECREATEFREECHAIN, 5, MFDSIZE)
   $)
$)

SYSTEM.START:
$( LET RQ = VEC 4

   IOSYSTEM()

   CHECKDISC()

   INITIALISEDISC()

   OVERLAY.CALL(COMMANDS, 1)

   SETUP()

   OVERLAY.CALL(HEADERS, 1)

   $( WAIT.BLOCK(RQ)
      SWITCHON RQ!1 INTO
      $( CASE C.LOGIN:
         $( LET DEVNO = RQ!2
            LET REPLY = CLOSINGDOWN -> ERR.CLD,
                           OVERLAY.CALL(CREATEJOB, 2, DEVNO)

            UNLESS REPLY = 0 DO
               MESSAGE(DEVNO, REPLY)
         $)
         ENDCASE

         CASE C.KILL:
         $( REMOVE(!RQ)
            IF CLOSINGDOWN DO
               IF PROCESSES = 0 DO
               $( OUTMAP()
                  CHECKDISC()
                  OVERLAY.CALL(SUMMARY, 7)
                  SHUTOFF()
                  FINISH
               $)
         $)
         ENDCASE

         CASE C.SHUTDOWN:
         $( P(LV JOBTABLEMUTEX, ST.MUT)
            FOR I = 0 TO JOBSLOTS DO
               UNLESS JOBTABLE!I = 0 DO
                  KILL(JOBTABLE!I)
            V(LV JOBTABLEMUTEX)
            CLOSINGDOWN := TRUE
            ENDCASE
         $)

         DEFAULT:
            SYSTEM.ERROR(7)
      $)
   $) REPEAT
$)

// End of file SYSLOG.BPL

