
//28 Jul 1983
//BCPL86-PP
//  BCPL 286 Pass1 for external declarations.

GET "LIBHDRS"

MANIFEST $(
// THE FIRST 8 VALUES ARE USED IN THE TYPE FIELD OF A NAME-USE RECORD
S.NULL    =0 //USED
S.LET     =1 //LOCAL VARIABLE (SCALAR/VECTOR) DECLARATION
S.PROC    =2 //PROCEDURE (ROUTINE/FUNCTION) DECLARATION
S.LAB     =3 //CODE LABEL
S.GLOBAL  =4
S.MANIFEST=5
S.STATIC  =6
S.FOR     =7 //LOOP CONTROL VARIABLE
S.EQ=8
S.BE=9
S.AND=10
S.NAME=11
S.GET=12
S.STRING=13
S.COLON=14
S.LPAREN=15
S.CASE=16
S.END=17
S.SEMICOL=18
S.RSECT=19
S.FILE=20
S.NEWNAME=21
S.NUMBER=22
S.SEGACCESS=23
S.DATASEG=24
S.GVEC=25
S.COMMENT=26
S.ENDCOMMENT=27
S.IMPORT=28
S.EXPORT=29
S.EXTERNAL=30
S.SEGMENT=31
S.LSECT=32

//NAMETREE RECORD
NAMETYPE=0
SOURCEMOD=1
SOURCEPROC=2
USELIST=3
XW=4 //NO. OF WORDS PRECEDING THE NAMESTRING IN A NAMETREE ENTRY

// List items.

next=0

// Import_item
ip_global=1
ip_access=2
ip_name=3
ip_size=4

// Export item.
ep_type=1
ep_name=2
ep_size=3
         $)

GLOBAL $(
// N.B START uses global UG.
SYMB        :UG+1
DECVAL      :UG+2
IP_HEAD     :UG+3
EP_HEAD     :UG+4
HEAP_PTR    :UG+5
PTR         :UG+6
CH          :UG+7
WORDV       :UG+8
WORDSIZE    :UG+9
//          :UG+10
GETV        :UG+11
GETP        :UG+12
//
SOURCESTREAM:UG+13
MODULE      :UG+14
NAMETREE    :UG+15
WORDNODE    :UG+16
OLDTYPE     :UG+17
//
TOSTREAM    :UG+18

PASS1EXIT   :UG+19
PASS1EXITLEVEL:UG+20

ch_pos: UG+21
linecount: UG+22
list_stream: UG+23
       $)
 
LET VALUECH(CH) = '0'<=CH<='9' -> CH-'0',
                'A'<=CH<='F' -> CH-'A'+10,
                100

AND RCH() BE
{1 CH:=RDCH() 
   TEST ch='*N' THEN
   {  linecount+:=1
      ch_pos:=0
   }
   ELSE ch_pos+:=1
   
   wrch(ch)
   IF CH<0 THEN CH:='.' // FORCE END OF FILE MARKER
}1

AND SKIPCOMMENT() BE
{1 UNTIL CH<0 DO 
      TEST CH='**' THEN
      $( RCH() 
         IF CH='/' THEN 
         $( RCH() 
         RETURN
         $) 
      $) 
   ELSE RCH() 
}1

AND READNUMB(RADIX) BE 
{1  LET d=valuech(ch)
    decval:=d

    { rch()
      d:=valuech(ch)
      IF d>=radix RETURN
      decval:=decval*radix+d
    } repeat
}1

AND NEXTSYMB() BE
$(1 SYMB := S.NULL
    SWITCHON CH INTO
    $(S
       CASE '*P':
       CASE '*N':
       CASE ';':
                  SYMB:=S.SEMICOL
RRET:             RCH() //A COMMON EXIT PATH
                  RETURN
       CASE '*T':
       CASE '*S': RCH() REPEATWHILE CH='*S' //FASTEST SKIPPING OF SPACES
                  LOOP
 
       CASE '0':CASE '1':CASE '2':CASE '3':CASE '4':
       CASE '5':CASE '6':CASE '7':CASE '8':CASE '9':
            SYMB:=S.NUMBER
            READNUMB(10) //CALLS 'RCH' FURTHER
            RETURN
 
       CASE '$': RCH()
                 SWITCHON CH INTO
                 $( CASE ')': SYMB := S.RSECT
                              RDTAG('$')
                              ENDCASE
                    CASE '(': RDTAG('$')
                              SYMB:=S.LSECT
                              ENDCASE
                    DEFAULT:  RCH()
                 $)
                 RETURN

       CASE '[':
       CASE '(': SYMB := S.LPAREN; GOTO RRET
 
       CASE '#': RCH()
                 $( LET RADIX = CH='B' -> 2,
                                CH='X' -> 16,8
                    UNLESS INRANGE(CH,'0','7') THEN RCH() //READ IN 1ST DIGIT
                    READNUMB(RADIX)
                 $)
                 RETURN
 
       CASE '=': SYMB := S.EQ; GOTO RRET
       CASE '/': RCH()
                 IF CH='\' THEN $( RCH(); LOOP $)
                 TEST CH='/' THEN // COMMENT
                     RCH() REPEATUNTIL CH='*N' | CH<0
                 ELSE
                 $( UNLESS CH='**' THEN RETURN
                    RCH()
                    SYMB:=S.COMMENT
                    RETURN
                 $)
                 LOOP

      CASE '**': RCH()
                 UNLESS CH='/' DO LOOP
                 SYMB:=S.ENDCOMMENT
                 GOTO RRET
 
       CASE '\':
       CASE '<':
       CASE '>': RCH()
                 IF CH='=' THEN GOTO RRET //WITH SYMB=S.NULL STILL
                 RETURN
 
       CASE '-': RCH()
                 IF CH='>' THEN GOTO RRET
                 RETURN
 
       CASE ':': RCH()
                 IF CH='=' THEN GOTO RRET
                 SYMB := S.COLON
                 RETURN
 
       CASE '*'':RCH(); RDSTRCH(); RCH()
                 RETURN

       CASE '*"':RCH()
                 WORDV!0 := 0
                 FOR I=1 TO 255 DO
                 $( IF CH='"' THEN BREAK
                    APPENDCHWORDV(RDSTRCH())
                 $)
                 SETWORDVSIZE()
                 SYMB := S.STRING
                 GOTO RRET
 
       DEFAULT:
           IF INRANGE(CH, 'a', 'z') THEN CH := CH + 'A'-'a'
           IF INRANGE(CH, 'A', 'Z') THEN
           $( RDTAG(CH)
              TEST LOOKUPWORD()
               THEN $( SYMB:=WORDNODE!NAMETYPE
                       IF SYMB=S.GET 
                        THEN $( PERFORMGET(FALSE) 
                                LOOP 
                             $)
                    $)
               ELSE SYMB:=S.NEWNAME
              RETURN
           $)
           UNLESS CH<0 THEN $( RCH(); RETURN $) //DEFAULT PUNCTUATIONS
       CASE '.':       ENDREAD()
                       IF getp=0 THEN
                       {  symb:=s.end
                          RETURN
                       }
                       GETP := GETP - 3
                       SOURCESTREAM := GETV!GETP
                       MODULE := GETV!(GETP+1)
                       CH := GETV!(GETP+2)
                       SELECTINPUT(SOURCESTREAM)
                       UNLESS GETP > 0 THEN $( SYMB:=S.END; RETURN $)
                       LOOP
    $)S
$)1 REPEAT


AND SETWORDVSIZE() BE WORDSIZE:=LENGTH(WORDV) / BYTESPERWORD

AND new_string(n) = VALOF
{1 LET s=newvec((n%0+1)/bytesperword)
   FOR i=0 TO n%0 DO s%i:=n%i
   RESULTIS s
}1

AND add_import_item(glo_num,ext_name,access) BE
{1 LET l=newvec(ip_size)
   l!next:=ip_head
   ip_head:=l

   l!ip_global:=glo_num
   l!ip_access:=new_string(access)
   l!ip_name:=ext_name
}1

AND add_export_item(type, ext_name) BE
{1 LET l = newvec(ep_size)
   
   l!next:=ep_head
   ep_head:=l
   
   l!ep_type:=type
   l!ep_name:=new_string(ext_name)
}1
 
AND ignore(sym) BE
{1 nextsymb()
   IF symb=sym THEN nextsymb()
}1

AND accept(sym,err_val) BE
   UNLESS symb=sym DO error_report(err_val)
 
AND display(s,a,b,c,d) BE
{1 LET out=output()
   selectoutput(monitor)
   writef(s,a,b,c,d)
   newline()
   selectoutput(out)
}1
 
AND extdecls() BE
{1 nextsymb()
   {  SWITCHON symb INTO
      {  CASE s.import:
            ignore(s.semicol)
            accept(s.lsect,3)
            nextsymb()
            UNTIL symb=s.rsect DO
            {2 accept(s.global,3)
             { LET gnum=wordnode!uselist
               ignore(s.colon)
               accept(s.string,3)
             { LET name=new_string(wordv)
               ignore(s.segment)
               accept(s.segaccess,3)
               add_import_item(gnum,name,wordv)
               nextsymb()
            }2
            ENDCASE

         CASE s.export:
            ignore(s.semicol)
            accept(s.lsect,4)
            nextsymb()
            UNTIL symb=s.rsect DO
            {2 LET t=symb
               UNLESS symb=s.dataseg |
                      symb=s.gvec DO error_report(4)
               ignore(s.colon)
               accept(s.string)
               add_export_item(t,wordv)
               nextsymb()
            }2
            ENDCASE

         CASE s.endcomment: RETURN

         CASE s.end: error_report(5)

         DEFAULT: ENDCASE
      }
      nextsymb()
   } REPEAT
}1
AND PASS1() BE //NEEDS A FAIR SIZE STACK, SO A NEW PROCESS RUNS IT.
$( LET V1 = VEC 127
   AND V2 = VEC 20
   PASS1EXITLEVEL:=LEVEL() //FOR ABORTS AT A DEEPER LEVEL (SEE PERFORMGET)
   WORDV := V1
   GETV, GETP := V2, 0
   NAMETREE := NIL
   // MATCHALL HAS BEEN SET BY 'BXREF'
   DECLSYSWORDS()
   SELECTINPUT(SOURCESTREAM)
   $( LET TYPE = S.NULL
      RCH()
      NEXTSYMB()
      UNTIL SYMB=S.END DO
       SWITCHON SYMB INTO
       $(  CASE S.GLOBAL:
              TYPE:=SYMB
              OLDTYPE:=SYMB 
           DEFAULT:
NEXT:                       NEXTSYMB()
                            LOOP
           CASE S.RSECT:    TYPE,OLDTYPE := S.NULL,S.NULL
                            GOTO NEXT
           CASE S.SEMICOL:  TYPE:=OLDTYPE
                            GOTO NEXT
           CASE S.COLON:
                            TYPE:=S.COLON
                            GOTO NEXT
           CASE S.NEWNAME:
              IF TYPE=S.GLOBAL THEN
                 ATTACHNAME(S.GLOBAL)
              GOTO NEXT

           CASE S.NUMBER:
               IF TYPE=S.COLON & OLDTYPE=S.GLOBAL
               THEN WORDNODE!USELIST:=DECVAL
               GOTO NEXT

           CASE S.COMMENT:
               NEXTSYMB()
               TEST SYMB=S.EXTERNAL THEN EXTDECLS()
               ELSE SKIPCOMMENT()
               GOTO NEXT
      $)
   $)
   ENDWRITE()
   SELECTOUTPUT(TOSTREAM)
   OUT_EXTERNALS()
PASS1EXIT: //LONGJUMP CAN GET HERE
$)

AND START()=VALOF
{1 WRITES("BCPL 286 Pass1 Issue:1*N")
   sourcestream:=findinput("Source") REPEATWHILE sourcestream<0
   tostream:=findoutput("Output") REPEATWHILE tostream<0
   list_stream:=findoutput("Listing") REPEATWHILE list_stream<0
   selectoutput(list_stream)
   heap_ptr:=stackend
 { LET fname=sourcestream*str.entrysize+devtable+10
   !fname:=#X11A0   // make string of 17 chars
   fname:=new_string(fname)
   ip_head, ep_head := nil, nil
   linecount, ch_pos := 0, 0
   pass1()
   selectoutput(tostream)
   endwrite()
   display("Processing of%S completed*N",fname)
   stop(0)
}1
 
AND APPENDCHWORDV(C) BE APPENDCH(C, WORDV)

AND DW(WORDS) BE
$( LET I = 1
   WORDV!0:=0 //BEGIN WITH NULL STRING
   $( LET C=GETBYTE(WORDS,I)  //WAS: LET C=WORDS%I
      TEST C='/'
      THEN $( IF LENGTH(WORDV)=0 THEN RETURN
              SETWORDVSIZE()
              UNLESS LOOKUPWORD() THEN ATTACHNAME(!PTR) //NAMETYPE FROM TABLE
              PTR := PTR+1
              WORDV!0:=0
           $)
      ELSE APPENDCHWORDV(C)
      I:=I+1
   $) REPEAT
$)

AND DECLSYSWORDS() BE
$(1 PTR:=TABLE 0,S.AND,
              S.BE,0,0,
              S.CASE,
              0,0,
              S.EQ,0,0,0,
              0,S.FOR,0,              //STANDARD RESERVED WORDS ONLY
              0,0,0,S.GLOBAL,S.GET,
              0,0,
              S.LET,0,0,0,0, 0,0,0,
              S.MANIFEST,
              0,0,0,
              0,
              0,0,0,0,0,
              0,0,0,
              0,S.STATIC,
              0,0,0,0,0,
              0,0,
              0,0,
              0,
              S.IMPORT,S.EXPORT,S.EXTERNAL,S.SEGMENT,
              S.GVEC,S.DATASEG,
              S.SEGACCESS,S.SEGACCESS,S.SEGACCESS,S.SEGACCESS
       DW("ABS/AND/*
          *BE/BREAK/BY/*
          *CASE/*
          *DO/DEFAULT/*
          *EQ/EQV/ELSE/ENDCASE/*
          *FALSE/FOR/FINISH/*
          *GOTO/GE/GT/GLOBAL/GET/*
          *IF/INTO/*
          *LET/LV/LE/LT/LOGOR/LOGAND/LOOP/LSHIFT//")
       DW("MANIFEST/*
          *NE/NOT/NEQV/*
          *OR/*
          *RESULTIS/RETURN/REM/RSHIFT/RV/*
          *REPEAT/REPEATWHILE/REPEATUNTIL/*
          *SWITCHON/STATIC/*
          *TO/TEST/TRUE/THEN/TABLE/*
          *UNTIL/UNLESS/*
          *VEC/VALOF/*
          *WHILE//")
       DW("IMPORT/EXPORT/EXTERNAL/SEGMENT/*
          *GLOBALVECTOR/DATASEG/*
          *EO/RO/RW/ER//")
$)1
 
AND CMPSTR(S1, S2) = VALOF //COMPARE ALPHABETIC RANKING OF 2 STRINGS
$( LET L1,L2 = LENGTH(S1),LENGTH(S2)
   FOR I=1 TO L1 DO
   $( LET CH1,CH2 = GETBYTE(S1,I),GETBYTE(S2,I) //WAS: LET CH1,CH2 = S1%I,S2%I
      IF I > L2 | CH1>CH2 THEN RESULTIS 1   // >0 DENOTES S1 RANKS LATER
      IF CH1<CH2 THEN RESULTIS -1           // <0 DENOTES S1 RANKS EARLIER
   $)
   RESULTIS L1<L2 -> -1,0                   // =0 DENOTES S1,S2 IDENTICAL.
$)

AND LOOKUPWORD() = VALOF//UPON RETURN, WORDNODE-> THE AE-RECORD MATCHING WORDV,
                        //OR THAT RECORD OFF WHICH TO HANG A NEW NAME
$(1 LET M = @NAMETREE
    $( WORDNODE := !M
       IF WORDNODE=0 THEN BREAK
       $( LET CMP=CMPSTR(WORDV, WORDNODE+XW)
          IF CMP=0 THEN RESULTIS TRUE
          M := WORDNODE + (CMP<0 -> 1,2) //TAKE LEFT OR RIGHT BRANCH
       $)
    $) REPEAT
    WORDNODE:=M //LEAVE WORDNODE POINTING TO LEAF
    RESULTIS FALSE
$)1

AND ATTACHNAME(TYPE) BE
$( LET M=WORDNODE
   WORDNODE := NEWVEC(WORDSIZE+XW+1)
   WORDNODE!NAMETYPE, WORDNODE!SOURCEMOD := TYPE, NIL
   WORDNODE!SOURCEPROC, WORDNODE!USELIST := NIL, NIL
   FOR I = 0 TO WORDSIZE DO WORDNODE!(I+XW) := WORDV!I
   !M := WORDNODE
$)
 
AND RDTAG(X) BE //X IS FIRST CHARACTER
$( PUTBYTE(WORDV,0,1)    //WAS:  WORDV%0:=1
   PUTBYTE(WORDV,1,X)    //WAS:  WORDV%1:=X
   $(  RCH()
       TEST 'a' <= CH <= 'z'
       THEN CH := CH + 'A' - 'a'
       ELSE UNLESS 'A'<=CH<='Z' | '0'<=CH<='9' | CH='.' | CH='_' THEN BREAK
       APPENDCHWORDV(CH)
   $) REPEAT
   SETWORDVSIZE()
$)

AND PERFORMGET() = VALOF
$(1 NEXTSYMB() 
       UNLESS SYMB=S.STRING DO ERROR_REPORT(1)
    {  LET S = FINDINPUT(WORDV)
       IF S<0 THEN ERROR_REPORT(1)
       GETV!GETP := SOURCESTREAM
       GETV!(GETP+1) := MODULE
       GETV!(GETP+2) := CH
       GETP +:= 3
       SOURCESTREAM:=S
       SELECTINPUT(SOURCESTREAM)
       RCH()
       RESULTIS TRUE
$)1 REPEAT

AND LAYOUT()= CH='*N' | CH='*S' | CH='*T' ->TRUE,FALSE

AND RDSTRCH()=VALOF
$(1 LET K=CH
    RCH()
    //IF K='*N' THEN DISP("Bad string")
    IF K='**' THEN
    $( IF LAYOUT() THEN
       $( RCH() REPEATWHILE LAYOUT()
          RCH()
          RESULTIS RDSTRCH()
       $)
       RCH()
    $)
    RESULTIS K
$)1
 
AND NEWVEC(N) = VALOF
{1 heap_ptr:=heap_ptr-n-1
   IF level()+50 >= heap_ptr
   THEN error_report(2)
   RESULTIS heap_ptr
}1

AND out_macro_defs() BE
{1 writes("//*N//MACRO definitions to do required stream switching*N//*N")
   writes("MCDEF NAME NL AS<//*N")
   writes("MCSET S11=4  /** enable output **/*N")
   writes("        <NAME>*T%WB1.*N*
          *MCSET S10=2  /** switch to INPUT1 **/*N*
          *>*N")
   writes("//*NMCDEF END WITH NL AS<//*N")
   writes("MCSET S10=2*N*
          *>*N")
}1

AND out_import_list() BE
{1 IF ip_head=nil RETURN
   writes(";*N; IMPORTed segments*N;*N")
   display("Imported symbols:*N")
 { LET p=ip_head
   UNTIL p=nil DO
   {  writef("%S*TSEGMENT*T%S PUBLIC*N",P!ip_name,p!ip_access)
      writef("%S*TENDS*N",P!ip_name)
      display(p!ip_name)
      p:=p!next
   }
   writes(";*NMCSET S10=3  /** back to assembler source **/*N") 
   writes("//*N// Arrive here after call on END macro*N//*N")
   writes(";*N; Global for IMPORTed segments*N;*N")

   p:=ip_head
   UNTIL p=nil DO
   {  writes("HEAP1*TSEGMENT*TRO COMMON*N")
      writef("*TORG OFFSET G[2**%N]*N",P!ip_global)
      writef("*TDW*T%S*N",p!ip_name)
      p:=p!next
   }
   writes("HEAP1*TENDS*N")
}1

AND out_export_list() BE
{1 LET p=ep_head
   IF p=nil RETURN

   writes("//*N// EXPORT contributions*N//*N")

   UNTIL p=nil DO
   {  TEST p!ep_type=s.dataseg THEN
      {  display("Data segment exported as %S",p!ep_name)
         writef("MCDEF <HEAP2> AS <%S>*N",P!ep_name)
      }
      ELSE TEST p!ep_type=s.gvec THEN
      {  display("Global vector exported as %S",p!ep_name)
         writef("MCDEF <HEAP1> AS <%S>*N",p!ep_name)
      }
      ELSE STOP(9)
      p:=p!next
   }
}1

AND out_externals() BE
{1 IF ip_head=nil & ep_head=nil THEN
   { display("No external directives found")
     writes("MCSET S11=5*N")
     RETURN
   }
   writes("MCSET S11=-1  /** Sink output **/*N")
   out_macro_defs()
   writes("//*NMCSET S10=3  /** switch to assembler source **/*N//*N")
   writes("//*N// Arrive here after call on NAME macro *N//*N")
   out_export_list()
   out_import_list()
   writes(";*N*T<END>*N")
}1

AND error_report(err_val) BE
{1 LET s=VALOF SWITCHON err_val INTO
   {  CASE 1: RESULTIS "Error in GET directive"
      CASE 2: RESULTIS "Workspace exhausted"
      CASE 3: RESULTIS "Error in IMPORT directive"
      CASE 4: RESULTIS "Error in EXPORT directive"
      CASE 5: RESULTIS "Error in EXTERNAL directive"
      DEFAULT: RESULTIS "Unknown error"
   }
   FOR i=0 TO ch_pos-1 DO wrch('*S')
   writef("^*N%S*N", s)
   display(s)
   newline()
   display("Detected near line %n*N", linecount)
   longjump(pass1exitlevel,pass1exit)   // abort run
}1
.
