.TH A68K 1 "UKC local %G%"
.SH NAME
a68k \- assembler for Motorola MC68000 microprocessor
.SH SYNOPSIS
.B a68k
[
.BI \-e " errors"
] [
.B \-l
] [
.BI \-m imnt
] [
.BI \-o " output"
] [
.B \-v
] [
.B \-x
] [
.B \-s
] [
.B \-A
] [
.B \-E
] [
.B \-I
] [ name ... ]
.SH DESCRIPTION
.I A68k
assembles the named Motorola MC68000 source files.
.PP
The available flags are:
.TP 8
.BI \-e " errors"
Normally, assembly errors are sent to the listing file (if any) and to
the standard error stream (usually the terminal). Use of this flag
causes the errors to be sent to the listing file (if any) and to the
file specified by
.IR errors .
.TP
.B \-l
Generate a listing on the standard output. This can of course be
redirected to a file if desired.
.TP
.B \-m
This flag must be followed immediately by one character from the set
.BR imnt .
This specifies the kind of object module to be generated; the meanings
of the various letters are:
.RS
.TP 8
.B i
Generate an Intel hex object module.
.TP
.B m
Generate a Motorola hex object module. This is the default
if the
.B \-m
flag is not specified at all.
.TP
.B n
Do not generate any object module.
.TP
.B t
Generate a binary object module for the Tripos operating system.
.RE
.TP
.BI \-o " output"
Use
.I object
as the object file, instead of the default file which is
.IR m.out .
.TP
.B \-v
Display the version number of
.IR a68k .
.TP
.B \-x
Generate a cross reference table at the end of the assembly listing.
This flag has no effect unless
.B \-l
is also selected.
.TP
.B \-s
Output additional assembly statistics to the listing file.
.TP
.B \-A
Allow 28 bit addressing (for the MC68010).
.TP
.B \-E
Allow 15 character external symbol names (normally, only 7 characters
are allowed).
.TP
.B \-I
Allow selected MC68010 instructions to be assembled.
.SH FILES
.ta \w'm.out  'u
m.out	default object file
.SH "SEE ALSO"
.IR "A Macro Assembler for the MC68000 Microprocessor" ,
by I.D. Wilson, revised by R.D. Eager.
.SH DIAGNOSTICS
The diagnostics produced by
.I a68k
itself are all intended to be self-explanatory.
.SH BUGS
It is not possible to assemble from the standard input.
.SH AUTHOR
Original version by I.D. Wilson, University of Cambridge,
England. Revisions and UNIX version by R.D. Eager, University of
Kent at Canterbury, England.
