
// File a68k1.b

// Assembler for Motorola MC68000 - segment 1

// UKC version - R.D. Eager   MCMLXXXVIII

//******************************************************************************
//*                                                                            *
//*  There are certain portions of the code which are dependent to particular  *
//*  machines and operating systems. These are handled by conditional          *
//*  compilation based on expressions which can be evaluated at compile time.  *
//*                                                                            *
//*  The conditional compilation control symbols are defined in the header     *
//*  file.                                                                     *
//*                                                                            *
//*                                                                            *
//*    N.B.  This assembler ASSUMES a 32-bit implementation of BCPL, but will  *
//*          run on a 16 bit machine, provided that only 16 bit arithmetic is  *
//*          required.                                                         *
//*                                                                            *
//*                                                                            *
//******************************************************************************
//*    I. D. Wilson              Last Modified:      IDW     24/07/85          *
//*    R. D. Eager               Last Modified:      RDE     09/10/88          *
//******************************************************************************



GET "libhdr"
GET "a68k.h"


STATIC $(
failed     = 0
$)


// STATIC variables used only on EMAS

STATIC $(
parptr     = 0
parleng    = 0
$)


// MANIFEST constants used only on EMAS

MANIFEST $(

// Bits in COMREG(27)

cr.parmx   = #X10000000   // Allow long external symbol names
cr.parmy   = #X08000000   // Allow extended (28 bit) addresses
cr.parmz   = #X04000000   // Allow selected 68010 instructions
cr.xref    = #X00000800   // Enable cross-reference
cr.nolist  = #X00000002   // Disable listing

// Parameter decoder error codes

par.ok    = 0               // No errors
par.err   =  -320           // Format error in parameter string
par.amb   =  -321           // Ambiguous keyword
par.unk   =  -322           // Unknown keyword
par.xs    =  -323           // Too many parameters
par.dup   =  -324           // Duplicated parameter
par.mis   =  -325           // Missing keyword
par.mps   =  -1000          // Mandatory parameter SOURCE omitted
par.ivm   =  -1001          // Invalid value for MODULE parameter
par.ivs   =  -1002          // Invalid value for STATISTICS parameter

// Other constants

keymax  = 6                 // Number of keywords in EMAS user interface
$)

STATIC $(
name.sourcestream = 0
name.liststream   = 0
name.codestream   = 0
name.equstream    = 0
name.errorstream  = 0
name.symbolstream = 0
printstats        = 0
$)

LET start(sargc, sargv) BE
$(  LET dv = VEC 10/bytesperword
    AND tv = VEC 9/bytesperword
    AND keys = ?
    AND defaults = ?
    AND options = ?

    IF sys.orion THEN xargc, xargv := sargc, sargv

    IF sys.clipper THEN
       xargc, xargv := sargc - 1, sargv   // Make more logical value for argc

    IF sys.vaxunix \/ sys.orion \/ sys.clipper THEN
    $( LET sccsid = "   @(#) 2.4	09/10/88 17:52"
    $)

    IF sys.vaxunix THEN xargc, xargv := argc, argv

    fatalerror   := fatalerror.l

    IF sys.orion THEN
       sysin, sysout, journal := console, console, stderr

    IF sys.clipper THEN
       sysin, sysout, journal := stdin, stdout, stderr

    IF sys.emas THEN
    $( keys, defaults := getvec(keymax), getvec(keymax)
       options := getvec(maxstrlength/bytesperword + 2*keymax)
    $)

    // Set up conditional constants which cannot be done at compile time due to limitations in the
    // Orion and Clipper compilers.

    sysversion   := sys.emas    -> 'E',     // System version letter
                    sys.vaxunix -> 'V',
                    sys.orion   -> 'H',
                    sys.clipper -> 'C',
                                   '?'

    maxfilenamelength := sys.emas    -> 31, // Maximum length of a filename
                         sys.vaxunix -> 63,
                         sys.orion   -> 63,
                         sys.clipper -> 63,
                                        0

    rc.catastrophic       :=  sys.emas -> 1000, 1
    rc.aborted            :=  sys.emas -> 1001, 2
    rc.errors             :=  sys.emas -> 1002, 3

    fatalerrorp     :=  level()

//      writef("Before date....*N")
    IF sys.emas \/ sys.vaxunix THEN
    $(
//     datestring      :=  date(dv)
//     timestring      :=  timeofday(tv)
//     writef("After date...*N")
       datestring := "00-xxx-00"
       timestring := "00:00:00"
    $)
    IF sys.orion THEN
    $( LET now = (@time)(0)
       LET ds = (@ctime)(@now)

       dv%0 := 9
       dv%1 := ds%8
       dv%2 := ds%9
       dv%3 := '-'
       dv%4 := ds%4
       dv%5 := ds%5
       dv%6 := ds%6
       dv%7 := '-'
       dv%8 := ds%22
       dv%9 := ds%23

       datestring := dv

       tv%0 := 8
       FOR i = 1 TO 8 DO
          tv%i := ds%(i+10)
       timestring := tv
    $)

    IF sys.clipper THEN
    $( LET d = date()
       AND t = timeofday()

       dv%0 := 9
       dv%1 := d%1
       IF dv%1 = '*S' THEN dv%1 := '0'
       dv%2 := d%2
       dv%3 := '-'
       dv%4 := d%4
       dv%5 := d%5
       dv%6 := d%6
       dv%7 := '-'
       dv%8 := d%10
       dv%9 := d%11
       datestring := dv

       tv%0 := 8
       FOR i = 1 TO 8 DO tv%i := t%i
       timestring := tv
    $)

    initstore(storesize)

    tagv            :=  getchunk(tagsize, TRUE)
    macroname       :=  getchunk(tagsize, TRUE)
    labelvec        :=  getchunk(tagsize, TRUE)
    expvec          :=  getchunk(expsize, TRUE)
    expvecp         :=  expvec + expsize

    inputbuff       :=  getchunk(maxllen/bytesperword,       TRUE)
    titlevec        :=  getchunk(titlecharsmax/bytesperword, TRUE)
    outbuff         :=  getchunk(maxllen/bytesperword,       TRUE)
    codebuff        :=  getchunk(codesize*cb.size,           TRUE)
    errorvec        :=  getchunk(errorsize*eb.size,          TRUE)

    extrnsymbols    :=  0
    entrysymbols    :=  0
    sourcestream    :=  0
    liststream      :=  0
    codestream      :=  0
    errorstream     :=  0

    linenumber      :=  0

    failed          :=  no
    in.movem        :=  no
    errormessages   :=  no
    crossreference  :=  no
    paging          :=  yes
    printstats      :=  no

    externalref     :=  no
    pass1           :=  no
    pass2           :=  no

    objectmodule    :=  o.none
    ts.default      :=  ts.word

    entry.point     :=  0

    IF sys.emas THEN
    $( // First, get any parameter settings from COMREG(27)

       LET com27 = comreg!27

       parmlisting    := (com27 & cr.nolist) =  0 -> yes, no
       xref           := (com27 & cr.xref)   NE 0 -> yes, no
       maxextlength   := (com27 & cr.parmx)  NE 0 -> 15, 7
       addressmask    := (com27 & cr.parmy)  NE 0 -> mask.68010, mask.68000
       inst.68010     := (com27 & cr.parmz)  NE 0 -> yes, no

       // Now get the parameters from the command line

       keys!0 := keymax
       keys!1 := "SOURCE"         ; defaults!1 := 0
       keys!2 := "OBJECT"         ; defaults!2 := ".NULL"
       keys!3 := "LISTING"        ; defaults!3 := "T#LIST"
       keys!4 := "ERRORS"         ; defaults!4 := 0
       keys!5 := "MODULE"         ; defaults!5 := "MOTOROLA"
       keys!6 := "STATISTICS"     ; defaults!6 := "NO"

       IF param%0 = 1 & param%1 = '?' THEN
       $( selectoutput(journal)
          writes("Parameters are:-*N")
          FOR i = 1 TO keymax DO
          $( writes(keys!i)
             IF defaults!i NE 0 THEN writef("=%S", defaults!i)
             UNLESS i = keymax DO wrch(',')
          $)
          newline()
          stop(0)
       $)

       paramdecode(keys, options)

       IF options!0 < 0 THEN paramerr(options!0)

       FOR i = 1 TO keymax IF options!i = 0 DO options!i := defaults!i

       name.sourcestream := options!1
       IF name.sourcestream = 0 THEN paramerr(par.mps)   // Mandatory parameter SOURCE omitted

       name.codestream   := options!2

       name.liststream   := options!3

       name.errorstream  := options!4
       IF name.errorstream = 0 THEN
       $( LET s = getvec(maxstrlength/bytesperword)

          uinfs(8, #X18000100, s << 2)  // Compiler faults stream

          IF s%0 = 0 THEN
          $( freevec(s)
             s := ".NULL"
          $)

          name.errorstream := s
       $)

       // Handle type of object module

       $( LET x = options!5

          TEST matchstrings(x, "MOTOROLA") THEN objectmodule := o.motorola OR
          TEST matchstrings(x, "INTELHEX") THEN objectmodule := o.intelhex OR
          TEST matchstrings(x, "TRIPOS")   THEN objectmodule := o.tripos   OR
             paramerr(par.ivm)          // Invalid value for MODULE parameter
       $)

       // Handle selection of statistics output

       $( LET x = options!6

          TEST matchstrings(x,"YES") THEN printstats := yes OR
          TEST matchstrings(x, "NO") THEN printstats := no OR
             paramerr(par.ivs)          // Invalid value for STATISTICS parameter
       $)

    $)

    IF sys.vaxunix \/ sys.orion \/ sys.clipper THEN
    $( LET argp = 1

       // Set default values for parameters

       name.codestream := "m.out"
       name.liststream := "<stdout>"
       parmlisting     := no
       xref            := no
       maxextlength    :=  7
       addressmask     := mask.68000
       inst.68010      := no
       objectmodule    := o.motorola

       // Read and decode argument list

       WHILE argp LE xargc DO
       $( LET a = xargv!argp
    
          TEST a%0 > 1 & a%1 = '-' THEN   // Command flags
          $( LET p = 2

             WHILE p LE a%0 DO
             $( SWITCHON a%p INTO
                $( CASE 'A' :   addressmask := mask.68010
                                ENDCASE
   
                   CASE 'E' :   maxextlength := 15
                                ENDCASE

                   CASE 'I' :   inst.68010 := yes
                                ENDCASE
       
                   CASE 'l':    parmlisting := yes
                                ENDCASE
   
                   CASE 'x':    xref := yes
                                ENDCASE
   
                   CASE 'm':    TEST p < a%0 THEN
                                $( p := p + 1
                                   SWITCHON a%p INTO
                                   $( CASE 'm':  objectmodule := o.motorola
                                                 ENDCASE
                              
                                      CASE 'i':  objectmodule := o.intelhex
                                                 ENDCASE
                              
                                      CASE 't':  objectmodule := o.tripos
                                                 ENDCASE
   
                                      CASE 'n':  objectmodule := o.none
                                                 ENDCASE
   
                                      DEFAULT:   paramerr("Invalid value after *'m*' flag")
                                   $)
                                $)
                                OR
                                   paramerr("Missing value after *'m*' flag")
                                ENDCASE
                              
                   CASE 's':    printstats := yes
                                ENDCASE

                   CASE 'o':    TEST argp < xargc THEN
                                $( argp := argp + 1
                                   name.codestream := xargv!argp
                                $)
                                OR
                                   paramerr("No file for *'o*' flag")
                                ENDCASE
                              
                   CASE 'e':    TEST argp < xargc THEN
                                $( argp := argp + 1
                                   name.errorstream := xargv!argp
                                $)
                                OR
                                   paramerr("No file for *'e*' flag")
                                ENDCASE
                              
                   CASE 'v':    $( LET o = output()
                                   selectoutput(journal)
                                   writef("%S: version %C%N.%N*N", xargv!0, sysversion, version, edit)
                                   selectoutput(o)
                                $)
                                ENDCASE

                    DEFAULT:    paramerr("Invalid flag character *'%C*'", a%p)
                                ENDCASE
                $)
                p := p + 1
             $)
          $)
          OR
          $( IF name.sourcestream NE 0 THEN
                paramerr("Too many input files")
             name.sourcestream := a
          $)
          argp := argp + 1
       $)
    $)


    TEST sys.emas THEN
    $( sourcestream := findinput(name.sourcestream)
       checkopen(sourcestream, result2, name.sourcestream, "input")
    $)
    OR
    $( TEST name.sourcestream = 0 LOGOR (name.sourcestream%0 = 1 & name.sourcestream%1 = '-') THEN
       $( name.sourcestream := "<stdin>"
          sourcestream := sysin
       $)
       OR
       $( sourcestream := findinput(name.sourcestream)
          checkopen(sourcestream, result2, name.sourcestream, "input")
       $)
    $)
    currentfile := makefile(name.sourcestream)

    TEST sys.emas THEN
    $( liststream := findoutput(name.liststream)
       checkopen(liststream, result2, name.liststream, "output")
    $)
    OR
       liststream := parmlisting -> sysout, findoutput("/dev/null")

    IF NOT failed & objectmodule NE o.none THEN
    $( codestream := findoutput(name.codestream)
       checkopen(codestream, result2, name.codestream, "output")
    $)

    IF NOT failed & name.errorstream NE 0 THEN
    $( errorstream := findoutput(name.errorstream)
       checkopen(errorstream, result2, name.errorstream, "output")
    $)

    IF sys.vaxunix \/ sys.orion \/ sys.clipper THEN
       IF errorstream = 0 THEN errorstream := journal

    IF failed  THEN  abortassembly()

    //  Now, set up the tag tables.  There are two, one for each class of
    //  symbol.

    tagtable1  :=  getchunk(tagtablesize, TRUE)
    tagtable2  :=  getchunk(tagtablesize, TRUE)

    FOR  i = 0  TO  tagtablesize-1  DO
    $( tagtable1!i  :=  0
       tagtable2!i  :=  0
    $)

    sysout := journal

    IF sys.emas THEN
    $( selectoutput(sysout)
       writef("MC68000 macro assembler - version %C%N.%N*N", sysversion, version, edit)
    $)

    systemwords  :=  yes
    declsyswords()
    systemwords  :=  no

    selectoutput(liststream)
    selectinput(sourcestream)

    firstpass()

    secondpass(name.sourcestream)

    UNLESS  noobj  DO
            TEST  objectmodule = o.tripos      THEN  triposmodule()       ELSE
            TEST  objectmodule = o.motorola    THEN  motorolamodule()     ELSE
            TEST  objectmodule = o.intelhex    THEN  intelhexmodule()     ELSE

                  UNLESS  objectmodule = o.none  DO  complain(0)

    //  We now terminate the run by printing out all the relevant information
    //  about the run.  For this, we should set "listing" to be TRUE, and then
    //  rely on "parmlisting" to tell us whether to produce output.

    listing  :=  TRUE

    //  Write out the errors (which have been stacked up in Errorvec)

    IF  parmlisting  THEN
    $(
        clearbuffer()

        TEST  errors = 0  THEN
        $(
            spacelines(2)

            listed   :=  no
            linepos  :=  0

            writestring("No errors found in this assembly")
            printbuffer()
        $)
        ELSE
        $(
            IF  aborted  THEN
            $(
                spacelines(3)

                listed   :=  no
                linepos  :=  0

                writestring("Fatal error  -  assembly aborted")
                printbuffer()
            $)

            settitle("ERROR-DIAGNOSTICS")

            errormessages  :=  yes
            onpage         :=  0

            FOR  i = 0  TO  errors-1  DO
            $(
                LET offset  =  i*eb.size
                LET line    =  errorvec!(offset + eb.line)
                LET code    =  errorvec!(offset + eb.code)
                LET file    =  errorvec!(offset + eb.file)

                clearbuffer()

                linepos  :=  0
                writestring(file)

                linepos  :=  34
                writenumber(line, 5)

                linepos  :=  43
                writestring(message(code))

                printbuffer()
            $)

            clearbuffer()
            spacelines(3)

            listed   :=  no
            linepos  :=  0

            writenumber(errors, 4)
            writestring(" error")

            UNLESS  errors = 1  DO  writechar('s')

            writestring(" found in this assembly")

            printbuffer()
        $)
    $)

    IF  xref  &  parmlisting  THEN  // Print a cross reference table
    $(  errormessages   :=  no
        crossreference  :=  yes
        xreftable       :=  0

        FOR  i = 0  TO  tagtablesize-1  DO
        $(
            LET t  =  tagtable2!i

            UNTIL  t = 0  DO
            $(
                UNLESS  t!st.definition = 0  DO  putinxreftable(t, @xreftable)

                t  :=  t!st.link
            $)
        $)

        printxreftable()
    $)

    IF bells.and.whistles. THEN
    $( //  Now print the equates file if we have been asked to do so.

       UNLESS  name.equstream = 0  DO
       $(  LET stream  =  findoutput(name.equstream)

           //  First, check that the file has actually been opened
           //  properly, then then do the symbol table dumping.

           checkopen(stream, result2, name.equstream, "output")

           IF  failed  THEN  abortassembly()

           printequates(stream, name.sourcestream)
       $)

       //  Having dumped the absolute symbols in an "equate" manner, we should
       //  look to see if we have been asked to dump the symbols for the debugger.

       UNLESS  name.symbolstream = 0  DO
       $(
           LET stream  =  findoutput(name.symbolstream)

           //  First, check that the file has actually been opened
           //  properly, then then do the symbol table dumping.

           checkopen(stream, result2, name.symbolstream, "output")

           IF  failed  THEN  abortassembly()

           dumpsymbols(stream, name.sourcestream)
       $)
    $)

    //  Now, print out the statistics associated with the assembly.
    //  This is the last thing we have to do before we can push off home!

    IF sys.emas THEN
    $( selectoutput(sysout)
       TEST  errors = 0  THEN  writes("No ")
                         ELSE  writef("%N ", errors)
   
       writef("error%S found in this assembly*N", errors = 1  ->  "", "s")
    $)

    IF parmlisting & (printstats = yes) THEN
    $( selectoutput(liststream)

       writes("*NAssembly statistics (16 bit words)*N*N*
                *           Absolute   Relocatable*N")

       writef("Code        %I6       %I6*N", ((absmax-absmin)/bytesper68000word)*2,
                                                         (relmax/bytesper68000word)*2)

       writef("Reloc [16]  %I6       %I6*N", absrp16, relrp16)
       writef("      [32]  %I6       %I6*N", absrp32, relrp32)
    $)

fatalerror.l:

    selectoutput(sysout)

    IF  aborted  THEN  writes("*N*N******  Assembly Aborted*N")

    uninitstore()

    IF parmlisting & (printstats = yes) THEN
    $( selectoutput(liststream)
       writef("*N%N out of %N words of workspace used*N", storage.wordsused, storage.totalwords)
    $)

    selectoutput(liststream)    ;   endwrite()
    selectoutput(codestream)    ;   endwrite()
    selectoutput(sysout)        ;   endwrite()
    selectoutput(errorstream)   ;   endwrite()

    selectinput(sourcestream)   ;   endread()

    stop(aborted  ->  rc.aborted, errors > 0  ->  rc.errors, 0)
$)


AND paramdecode(keys, pars) BE TEST NOT sys.emas THEN RETURN OR
$( LET pmax, pnum = keys!0, 1
   LET wksp, pn = pars + pmax + 1, ?

   FOR i = 0 TO pmax DO pars!i := 0
   parptr := 0
   parleng := param%0
   $( LET c = getpar(wksp)

      pn := (c NE '=') -> pnum, VALOF
      $( LET n = findkey(keys, wksp)

         c := getpar(wksp)
         RESULTIS n
      $)
      pars!0 := VALOF
      $( LET l = wksp%0
         IF c = '='               RESULTIS par.err
         IF pn = -1               RESULTIS par.amb
         IF pn = -2               RESULTIS par.mis
         IF pn = 0                RESULTIS par.unk
         IF pn > pmax             RESULTIS par.xs
         IF l = 0                 RESULTIS par.ok
         IF pars!pn NE 0          RESULTIS par.dup
         pars!pn := wksp
         wksp := wksp + l/bytesperword + 1
         RESULTIS par.ok
      $)
      UNLESS pars!0 = par.ok RETURN
      IF c = endstreamch RETURN
      pnum := pnum + 1
   $) REPEAT
$)

AND getpar(wksp) = NOT sys.emas -> 0, VALOF
$( LET c, spcnt = ?, 0
   AND inpr., length = FALSE, 0

   $( c := getch(param)
      SWITCHON c INTO
      $( CASE endstreamch:
         CASE ',':
         CASE '=':
            wksp%0 := length
            RESULTIS c

         CASE '*S':
            spcnt := spcnt + 1
            ENDCASE

         DEFAULT:
            TEST inpr. THEN
            $( FOR i = 1 TO spcnt DO
               $( length := length + 1
                  wksp%length := '*S'
               $)
            $)
            OR
               inpr. := TRUE

            spcnt := 0
            length := length + 1
            wksp%length := c
      $)
   $) REPEAT
$)

AND findkey(keys, wksp) = NOT sys.emas -> 0, VALOF
$( LET f = 0

   IF wksp%0 = 0 RESULTIS -2            // Missing keyword
   FOR i = 1 TO keys!0 DO
   $( IF matchstrings(wksp, keys!i) DO
      $( UNLESS f = 0 RESULTIS -1
         f := i
      $)
   $)
   RESULTIS f
$)

AND matchstrings(a, b) = NOT sys.emas -> 0, VALOF
$( LET l = a%0

   IF b%0 < l RESULTIS FALSE
   FOR i = 1 TO l DO
   UNLESS a%i = b%i RESULTIS FALSE
   RESULTIS TRUE
$)

AND getch(str) = NOT sys.emas -> 0, VALOF
$( parptr := parptr + 1
   RESULTIS parptr > parleng -> endstreamch, str%parptr
$)

AND strtonum(str) = NOT sys.emas -> 0, VALOF
$( LET base, num, minus. = 10, 0, FALSE

   parptr := 0
   param := str
   parleng := str%0

   TEST getch(str) = '-' THEN
      minus. := TRUE
   OR
      parptr := parptr -1

   TEST getch(str) = '#' THEN
   $( SWITCHON getch(str) INTO
      $( CASE 'X'  : base := 16
                     ENDCASE
         DEFAULT   : parptr := parptr - 1
         CASE 'O'  : base := 8
      $)
   $)
   OR parptr := parptr - 1

   $( LET n = getnum(str)
      IF n >= base BREAK
      num := num * base + n
   $) REPEAT
   RESULTIS minus. -> -num, num
$)

AND getnum(str) = NOT sys.emas -> 0, VALOF
$( LET c = getch(str)

   RESULTIS ('0' LE c LE '9') -> c - '0',
           ('A' LE c LE 'F') -> c - 'A' + 10, 99
$)

AND paramerr(n, a, b, c) BE TEST sys.emas THEN
$( selectoutput(journal)
   writes("*NA68K fails -")

   SWITCHON n INTO
   $( CASE par.mps:   writes(" Mandatory parameter SOURCE omitted*N")
                      ENDCASE

      CASE par.ivm:   writes(" Invalid value for MODULE parameter*N")
                      ENDCASE
      CASE par.ivs:   writes(" Invalid value for STATISTICS parameter*N")
                      ENDCASE

      DEFAULT     :   writes(ssmessage(n))
                      ENDCASE
   $)
   stop(ABS n)
$)
OR
$( selectoutput(journal)
   writef("%S: ", xargv!0)
   writef(n, a, b, c)
   newline()
   stop(rc.aborted)
$)


AND checkopen(stream, r2, name, type)  BE
/* Called after a findinput or findoutput, we must check to see that the
stream specified has been opened properly. */
TEST sys.emas THEN
$( IF stream < 0 THEN
   $( writef("*NA68K fails -%S", ssmessage(ABS stream, name))

      failed   :=  yes
   $)
$)
OR
$( IF stream = 0 THEN
   $( LET o = output()

      selectoutput(journal)

      writef("%S: can*'t open *'%S*' for %S*N", xargv!0, name, type)

      failed   :=  yes
   $)
$)


AND abortassembly()  BE
/* This routine is called on some sort of error, usually when we run out
of  store.   Close down the streams which have been opened, and free any
store which has been allocated.  Then stop, without further ado.  */
$( UNLESS sourcestream = 0 DO
   $( selectinput(sourcestream)
      endread()
   $)

   UNLESS liststream = 0 DO
   $( selectoutput(liststream)
      endwrite()
   $)

   UNLESS errorstream = 0 DO
   $( selectoutput(errorstream)
      endwrite()
   $)

   UNLESS codestream = 0 DO
   $( selectoutput(codestream)
      endwrite()
   $)

   uninitstore()

   stop(rc.catastrophic)
$)


AND firstpass()  BE
/* Perform the first pass of the assembly.  */
$(
    relmin          :=  maxint
    relmax          :=  minint
    absmin          :=  maxint
    absmax          :=  minint

    absrp16         :=  0
    absrp32         :=  0
    relrp16         :=  0
    relrp32         :=  0
    absloc          :=  0
    relloc          :=  0

    locmode         :=  s.rel
    relp16          :=  relrp16
    relp32          :=  relrp32
    minloc          :=  relmin
    maxloc          :=  relmax
    location        :=  0

    errors          :=  0
    skiplevel       :=  0
    skipping        :=  0
    macrodepth      :=  0
    getlevel        :=  0
    macrobase       :=  0
    macroend        :=  0
    asmlabel        :=  0
    pass1           :=  yes
    pass2           :=  no
    inmacro         :=  no
    errormessages   :=  no
    forwardreftype  :=  s.abs16
    charpos         :=  1
    ended           :=  no
    aborted         :=  no
    noobj           :=  objectmodule  =  o.none
    listing         :=  parmlisting

    // Perform the equivalent of ORG 0 since most output will be absolute

//    changemode(s.abs)
//    forwardreftype := s.abs16
//    setloc(0)

    settitle("")

    length          :=  -1
    charpos         :=  0
    linepos         :=  0
    onpage          :=  0
    linenumber      :=  0
    pagenumber      :=  0
    linesperpage    :=  65
    charsperline    :=  132
    llenfixed       :=  no
    plenfixed       :=  no

    selectinput(sourcestream)

    resetflags()

    listed  :=  no

    //  Fasten your safety belts...

    UNTIL  ended | aborted  DO
    $(
        resetflags()

        doline()
    $)

    //  Force the saving of final location values.

    IF  absmin = maxint   THEN  absmin  :=  0
    IF  relmin = maxint   THEN  relmin  :=  0
    IF  absmax = minint   THEN  absmax  :=  0
    IF  relmax = minint   THEN  relmax  :=  0

    IF  minloc = maxint   THEN  minloc  :=  0
    IF  maxloc = minint   THEN  maxloc  :=  0

    //  Align the code buffers to word boundaries

    changemode(s.rel) ; align(bytesper68000word)
    changemode(s.abs) ; align(bytesper68000word)
    changemode(s.rel)

    absmin  :=  absmin - (absmin REM bytesper68000word)
$)




AND secondpass(name.sourcestream)  BE
$(
//  Allocate the store required for the assembled code.  All the absolute and
//  relocatable extreme values have already been rounded up or down.

    LET avec  =  getchunk((absmax - absmin)/bytesperword, TRUE)

    absvec     :=  avec - absmin/bytesperword

    absrvec16  :=  getchunk(absrp16, TRUE)
    absrvec32  :=  getchunk(absrp32, TRUE)
    relvec     :=  getchunk(relmax/bytesperword, TRUE)
    relrvec16  :=  getchunk(relrp16, TRUE)
    relrvec32  :=  getchunk(relrp32, TRUE)

    //  Clear the code buffers (Tripos SYSLINK depends on this)

    FOR  i = absmin  TO  absmax-1  DO  absvec%i  :=  0
    FOR  i = relmin  TO  relmax-1  DO  relvec%i  :=  0

    relmin          :=  maxint
    relmax          :=  0
    absmin          :=  maxint
    absmax          :=  0

    absrp16         :=  0
    absrp32         :=  0
    relrp16         :=  0
    relrp32         :=  0
    absloc          :=  0
    relloc          :=  0

    locmode         :=  s.rel
    codevec         :=  relvec
    relocvec16      :=  relrvec16
    relocvec32      :=  relrvec32
    relp16          :=  relrp16
    relp32          :=  relrp32

    minloc          :=  relmin
    maxloc          :=  relmax
    location        :=  0

    ended           :=  no
    aborted         :=  no
    errors          :=  0
    skiplevel       :=  0
    skipping        :=  0
    macrodepth      :=  0
    getlevel        :=  0
    macrobase       :=  0
    macroend        :=  0
    asmlabel        :=  0
    pass1           :=  no
    pass2           :=  yes
    inmacro         :=  no
    errormessages   :=  no
    forwardreftype  :=  s.abs16
    noobj           :=  objectmodule  =  o.none
    listing         :=  parmlisting

    // Perform the equivalent of ORG 0 since most output will be absolute

//    changemode(s.abs)
//    forwardreftype := s.abs16
//    setloc(0)

    clearbits()

    settitle("")

    length          :=  -1
    charpos         :=  0
    linepos         :=  0
    onpage          :=  0
    linenumber      :=  0
    pagenumber      :=  0
    llenfixed       :=  no
    plenfixed       :=  no

    // Rewind the input stream and start again from the beginning.

    rewindinput()

    resetflags()

    listed  :=  no

    UNTIL  ended | aborted  DO
    $(
        resetflags()

        doline()
    $)

    UNLESS  skipping = 0  DO  warning(103)

    IF  inmacro  THEN  warning(113)

    IF  relmin = maxint  THEN  relmin  :=  0
    IF  absmin = maxint  THEN  absmin  :=  0
    IF  minloc = maxint  THEN  minloc  :=  0

    //  Align the code buffers to word boundaries

    changemode(s.rel) ; align(bytesper68000word)
    changemode(s.abs) ; align(bytesper68000word)
    changemode(s.rel)

    absmin  :=  absmin - (absmin REM bytesper68000word)
$)



AND rewindinput() BE
TEST sys.emas THEN
$( selectinput(sourcestream)
   sourcestream := rewind()
   IF sourcestream < 0 THEN
   $( selectoutput(sysout)

      writes("****** Unable to rewind input stream*N")

      abortassembly()
   $)
   selectinput(sourcestream)
$)
OR TEST sys.vaxunix THEN
$( selectinput(sourcestream)
   sourcestream := rewind()
   IF sourcestream = 0 THEN
   $( selectoutput(journal)
      writef("%S: unable to rewind input stream*N", xargv!0)

      abortassembly()
   $)
   selectinput(sourcestream)
$)
OR
$( selectinput(sourcestream)
   endread()
   sourcestream := findinput(name.sourcestream)
   IF sourcestream = 0 THEN
   $( selectoutput(journal)
      writef("%S: unable to rewind input stream*N", xargv!0)

      abortassembly()
   $)
   selectinput(sourcestream)
$)


AND doline()  BE
$(
//  Parse, and generate code for an entire input line.

    labelset      :=  no
    undefined     :=  no
    recoverlevel  :=  level()
    recoverlabel := l.recoverlabel

    rch()

    SWITCHON  ch  INTO
    $(
        CASE '**'     : // Comment line
        CASE '!'      : // New style comment line
        CASE '*N'     : // Blank line

                        skiprest()

                        symb         :=  s.none
                        commentline  :=  yes

                        ENDCASE

        CASE '.'      :
        CASE '_'      :

        CASE 'A'      : CASE 'B'      : CASE 'C'      : CASE 'D'      :
        CASE 'E'      : CASE 'F'      : CASE 'G'      : CASE 'H'      :
        CASE 'I'      : CASE 'J'      : CASE 'K'      : CASE 'L'      :
        CASE 'M'      : CASE 'N'      : CASE 'O'      : CASE 'P'      :
        CASE 'Q'      : CASE 'R'      : CASE 'S'      : CASE 'T'      :
        CASE 'U'      : CASE 'V'      : CASE 'W'      : CASE 'X'      :
        CASE 'Y'      : CASE 'Z'      :

        CASE 'a'      : CASE 'b'      : CASE 'c'      : CASE 'd'      :
        CASE 'e'      : CASE 'f'      : CASE 'g'      : CASE 'h'      :
        CASE 'i'      : CASE 'j'      : CASE 'k'      : CASE 'l'      :
        CASE 'm'      : CASE 'n'      : CASE 'o'      : CASE 'p'      :
        CASE 'q'      : CASE 'r'      : CASE 's'      : CASE 't'      :
        CASE 'u'      : CASE 'v'      : CASE 'w'      : CASE 'x'      :
        CASE 'y'      : CASE 'z'      :

                        readlabel()
                        IF  ch = ':'  THEN  rch()

                        UNLESS  tagsize.given = ts.none  DO  complain(1)

                        FOR  i = 0  TO  tagsize-1  DO  labelvec!i  :=  tagv!i

                        labelset  :=  yes
                        skiplayout()

                        undefined  :=  no
                        readopcode()

                        ENDCASE


        CASE '\'      : UNLESS  inmacro  DO  complain(117)
                        UNTIL  ch = '*S'  |  ch = '*T'  |  ch = '*N'  DO  rch()

        CASE '*S'     :
        CASE '*T'     : skiplayout()

                        IF  ch = '*N'  THEN
                        $(
                            symb         :=  s.none
                            commentline  :=  yes

                            ENDCASE
                        $)

                        IF  ch = '\'  THEN
                        $(
                            UNLESS  inmacro  DO  complain(117)

                            UNTIL  ch = '*S'  |  ch = '*T'  |  ch = '*N'  DO
                                   rch()

                            symb  :=  s.none

                            ENDCASE
                        $)

                        UNLESS  symbolchar(ch, FALSE)  DO

                                //  Not a valid start to a symbol name, and
                                //  so we should complain.

                                complain(2)

                        readlabel()

                        TEST  ch = ':'  THEN
                        $(
                            //  This really is a label, since it has the
                            //  terminating ":" character.

                            rch()

                            UNLESS  tagsize.given = ts.none  DO  complain(1)

                            FOR  i = 0  TO  tagsize-1  DO  labelvec!i  :=  tagv!i

                            labelset  :=  yes
                            skiplayout()

                            undefined  :=  no
                            readopcode()
                        $)
                        ELSE
                        $(
                            //  This isn't a label at all, and is in fact an
                            //  opcode.  We should look this symbol up in the
                            //  opcode table.

                            undefined  :=  no

                            lookup(tagv, tagtable1)
                        $)

                        ENDCASE


        CASE endstreamch :
                        symb  :=  s.none

                        UNLESS  getlevel = 0  DO
                        $(
                            //  End of a GET file, so close it, and
                            //  Return to the previous level.

                            getlevel    :=  getlevel - 1
                            linenumber  :=  linenumber - 1
                            ended       :=  no

                            RETURN
                        $)

                        IF  pass2  THEN
                        $(
                            selectoutput(sysout)

                            writes("******  'END' statement missing*N*N")

                            selectoutput(liststream)
                        $)

                        ended  :=  yes

                        ENDCASE


        DEFAULT       : complain(5)
    $)

    IF  undefined  &  pass2  THEN

        //  This is an undefined symbol in the opcode field.  This is serious
        //  unless we are in a macro, in which case this could just be
        //  something with a "\" in it.

        UNLESS  inmacro  DO  complain(96)

    //  Go on to decode the opcode/directive field.

    TEST  skiplevel > 0  THEN
    $(
          //  We are in a conditional section, and so we must only
          //  do something if we have met an ENDC or another IF..
          //  directive.

          IF  symb = s.dir  &  (symbtype!st.value = d.endc  |
                                symbtype!st.value = d.ifeq  |
                                symbtype!st.value = d.ifne  |
                                symbtype!st.value = d.iflt  |
                                symbtype!st.value = d.ifle  |
                                symbtype!st.value = d.ifgt  |
                                symbtype!st.value = d.ifge)  THEN
              dodir()

          commentline  :=  yes
    $)
    ELSE

    TEST  inmacro  THEN
    $(
        //  We are in a macro body, and unless this is an
        //  ENDM directive, we must stack up the current
        //  line in a buffer.  The exception to this is if
        //  another MACRO directive is found, in which case
        //  an error must be flagged.

        TEST  symb = s.dir  &   (symbtype!st.value = d.macro  |
                                 symbtype!st.value = d.endm)  THEN
              dodir()

        ELSE

        IF  pass1  THEN
        $(
            LET newbuff  =  getstore(length/bytesperword)
            LET newnode  =  heap3(0, 0, 0)

            FOR  i = 0  TO  length-1  DO  newbuff%i  :=  inputbuff%i

            macroend!m.buff    :=  newbuff
            macroend!m.length  :=  length
            macroend!m.link    :=  newnode

            macroend           :=  newnode
        $)

        commentline  :=  yes
    $)
    ELSE

    TEST  symb = s.instr  THEN  doinstr()      ELSE
    TEST  symb = s.dir    THEN  dodir()        ELSE
    TEST  symb = s.macro  THEN  domacro()      ELSE
    TEST  symb = s.none   THEN

          IF  labelset  THEN
              setlabel(locmode, location, no)

    ELSE  complain(3)

l.recoverlabel:                     // Recover here on error
    skiprest()                      // Just in case it hasn't been done before

    listline()
$)



AND doinstr()  BE
$(
//  We have decoded some sort of instruction.  Decode further to determine if
//  it is a special type of instruction, how many operands it takes, and what
//  its mask type is.

    LET t      =  symbtype!st.type
    LET vh     =  symbtype!st.value.high
    LET vl     =  symbtype!st.value.low
    LET sizes  =  0

    instr.mask      :=  symbtype!st.template   // instruction mask
    instr.masktype  :=  (t >> 4) & #B1111      // instruction mask type
    source.ea       :=  vh                     // source operand EA
    dest.ea         :=  vl                     // destination operand EA

    //  Instructions MUST be word aligned.

    UNLESS  aligned(2)  DO
    $(
        warning(102)

        align(2)
    $)

    IF  labelset  THEN  setlabel(locmode, location, no)

    nargs  :=  (t >> 11) & #B11         // Number of arguments
    sizes  :=  (t >>  8) & #B111        // Possible sizes allowed

    TEST  tagsize.given \= ts.none  THEN  UNLESS  tagsize.given = ts.short  DO
    $(
        LET sizebit  =  1 << (tagsize.given - 1)

        TEST  (sizes & sizebit) \= 0  THEN
              tagsize.given  :=  sizevalue(sizebit)

        ELSE  complain(6)
    $)
    ELSE  tagsize.given  :=  ts.none

    instr.size  :=  tagsize.given

    TEST  instr.masktype = 0  THEN  specialinstruction(dest.ea)
    ELSE
    $(
        //  The size of the instruction has been verified as being correct.
        //  Now read the operands (each is the form of an effective address)

        IF  nargs = 0  THEN  readsymb()

        IF  instr.size = ts.short  THEN  complain(86)

        IF  nargs = 1  THEN
        $(
            nextsymb()
            evaluate(effective.address())

            IF  (dest.ea & op.ea) = 0  THEN  complain(7)
        $)

        IF  nargs = 2  THEN
        $(
            nextsymb()
            evaluate(effective.address())

            IF  (source.ea & op.ea) = 0  THEN  complain(8)

            //  the first operand is correct, so store it away, and read the
            //  second.

            swapoperands()

            checkfor(s.comma, 10)

            evaluate(effective.address())

            IF  (dest.ea & op.ea) = 0  THEN  complain(9)
        $)

        //  the operands should have been terminated.
        //  If they were terminated by a ','  then there
        //  are too many arguments.  If not by a space, tab
        //  or newline, then bad termination of arguments.

        TEST  symb = s.comma  THEN  complain(11)     ELSE
        TEST  symb \= s.none  THEN  complain(12)     ELSE

              skiprest()

        generate(instr.masktype)
    $)
$)



AND aligned(boundary)  =  location REM boundary  =  0



AND domacro()  BE
$(
//  This line is a macro, and must be decoded as such.  Set up the argument
//  vector, and call "expandmacro" to actually do the expansion.

    LET argvec      =  VEC macroargs
    LET macrovalue  =  symbtype!st.value

    checklabel(no)

    //  Check for forward reference to a MACRO definition (which is illegal).

    IF  (symbtype!st.flags & stb.setnow) = 0  THEN  complain(151)

    FOR  i = 1  TO  macroargs  DO  argvec!i  :=  ""

    instr.size  :=  tagsize.given

    argvec!0    :=  instr.size  =  ts.byte  ->  "B",
                    instr.size  =  ts.word  ->  "W",
                    instr.size  =  ts.long  ->  "L",
                    instr.size  =  ts.short ->  "S",  ""

    skiplayout()

    FOR  i = 1  TO  macroargs  DO
    $(
        //  Read the arguments for the macro.

        LET argbuffer  =  VEC maxllen/bytesperword
        LET arglength  =  0
        LET argb       =  0

        TEST  ch = '<'  |  ch = '['  THEN    // Bracketed argument
        $(
            LET bracket  =  ch = '<'  ->  '>', ']'

            rch()

            UNTIL  ch = bracket  |  ch = '*N'  DO
            $(
                arglength              :=  arglength + 1
                argbuffer%arglength  :=  ch

                rch()
            $)

            TEST  ch = '*N'
                THEN  complain(114)
                ELSE  rch()
        $)
        ELSE

        UNTIL  ch = ','  |  ch = '*S'  |  ch = '*N'  |  ch = '*T'  DO
        $(
            arglength              :=  arglength + 1
            argbuffer%arglength  :=  ch

            rch()
        $)

        argbuffer%0  :=  arglength
        argb           :=  getstore(arglength/bytesperword)

        FOR  j = 0  TO  arglength  DO  argb%j  :=  argbuffer%j

        argvec!i  :=  argb

        readsymb()

        TEST  symb = s.none   THEN   BREAK
        ELSE
            UNLESS  symb = s.comma  DO
                complain(115)
    $)

    IF  symb = s.comma  THEN  complain(118)

    expandmacro(macrovalue, argvec)
$)



AND expandmacro(macroptr, argvec)  BE
$(
//  Expand the source macro, whose text is pointed to by "macroptr".
//  The current depth of macro nesting is given by "depth".  The
//  restriction is that depth must not be greater than 3.  This is
//  a MOTOROLA restriction, and the macro depth for this implementation
//  is given by "maxmacrodepth".

    LET macroline  =  macroptr!m.buff
    LET asml       =  0
    LET depth      =  macrodepth
    LET skip       =  skipping
    LET skipl      =  skiplevel

    //  Macro nesting too deep.  Possibly in a recursive
    //  loop of macro expansion.

    IF  macrodepth = maxmacrodepth  THEN  complain(108)

    //  Before we expand the macro, we must list the line that
    //  the macro name is on.

    commentline  :=  yes

    listline()

    macrodepth  :=  macrodepth + 1

    resetflags()

    UNTIL  macroline = 0  |  macrodepth = depth  |  ended  |  aborted  DO
    $(
        LET sptr     =  0
        LET mptr     =  0
        LET wcode    =  0
        LET mlength  =  macroptr!m.length

        FOR  i = 0  TO  maxllen-1  DO  inputbuff%i  :=  '*S'

        UNTIL  mptr = mlength  DO
        $(
            LET char  =  macroline%mptr

            TEST  char = '\'  THEN
            $(
                mptr  :=  mptr + 1

                IF  mptr = mlength  THEN
                $(
                    wcode  :=  109

                    BREAK
                $)

                char  :=  macroline%mptr

                TEST  char = '@'  THEN
                $(
                    //  This is an assembler generated label.
                    //  The first time that this is encountered in
                    //  a macro expansion, a new label is obtained
                    //  from the function "newasmlabel".  Thereafter
                    //  this value is used in the entire macro
                    //  expansion from now on.

                    LET chbuff  =  VEC 10
                    LET size    =  0
                    LET label   =  0

                    IF  asml = 0  THEN  asml  :=  newasmlabel()

                    label  :=  asml
                    size   :=  digits(asml)

                    IF  size < 3  THEN  size  :=  3

                    FOR  i = size  TO  1  BY  -1  DO
                    $(
                        chbuff!i  :=  (label REM 10) + '0'
                        label     :=  label / 10
                    $)

                    putinbuffer(inputbuff, sptr, '.')

                    FOR  i = 1  TO  size  DO
                         putinbuffer(inputbuff, sptr + i, chbuff!i)

                    sptr  :=  sptr + size + 1
                    mptr  :=  mptr + 1
                $)
                ELSE

                //  This should be an argument number (in the range
                //  '0' to '9' or 'A' to 'Z'), and can be treated as as index
                //  into "argvec".  Any other character is an error.

                TEST  macrochar(char)  THEN
                $(
                    LET argnumber  =  argoffset(char)
                    LET arg        =  argvec!argnumber

                    FOR  j = 1  TO  arg%0  DO
                    $(
                        putinbuffer(inputbuff, sptr, arg%j)

                        sptr  :=  sptr + 1
                    $)

                    mptr  :=  mptr + 1
                $)
                ELSE
                $(
                    wcode  :=  109

                    BREAK
                $)
            $)
            ELSE
            $(
                TEST  macroline%mptr = '*S'  THEN
                $(
                    //  First, skip all spaces from the macro record
                    //  to find the column of the next non-space char.

                    WHILE  mptr < mlength  &  macroline%mptr = '*S'   DO
                           mptr  :=  mptr + 1

                    //  Now pad the output record with spaces up to this
                    //  column.  We MUST pad at least one space.

                    sptr  :=  sptr + 1  REPEATWHILE  sptr < mptr
                $)
                ELSE
                $(
                    putinbuffer(inputbuff,  sptr, char)

                    sptr  :=  sptr + 1
                    mptr  :=  mptr + 1
                $)
            $)
        $)

        //  Having filled up the buffer, look to see if we have overfilled
        //  it, and if so, complain.

        UNLESS  sptr < maxllen  DO
        $(
            wcode  :=  189
            sptr   :=  maxllen
        $)

        //  Now call "doline" with the newly constructed, macro expanded
        //  line.  Then get the next line in the macro expansion (found at
        //  macroptr!m.link), and carry on.

        TEST  wcode \= 0  THEN
        $(
            //  There has been some problem in decoding the formal parameters
            //  to the Macro, and so, we must print out the offending line
            //  and not bother to expand anything from it.

            FOR  i = 0  TO  mlength-1  DO  inputbuff%i  :=  macroline%i

            length              :=  mlength
            inputbuff%length  :=  '*N'
            commentline         :=  yes

            warning(wcode)

            listline()
        $)
        ELSE
        $(
            length              :=  sptr
            inputbuff%length  :=  '*N'
            charpos             :=  0

            doline()
        $)

        macroptr   :=  macroptr!m.link
        macroline  :=  macroptr!m.buff

        resetflags()
    $)

    IF  macrodepth = depth  DO
    $(
        //  If we have executed a "MEXIT" then we must reset the
        //  "skipping" and "skiplevel" variables.

        skipping    :=  skip
        skiplevel   :=  skipl

    $)

    macrodepth  :=  depth
    listed      :=  yes
$)



AND argoffset(char)  =  '0' <= char <= '9'  ->  char - '0',
                       /* 'A' <= char <= 'Z' */   char - 'A' + 10



AND digits(value)  =  value < 10  ->  1,  (digits(value/10) + 1)



AND newasmlabel()  =  VALOF
$(
//  Returns a new assembler generated label.

    asmlabel  :=  asmlabel + 1

    RESULTIS  asmlabel
$)



AND putinxreftable(node, ptr)  BE
$(
//  "node" points to a node which we want to insert into the sorted
//  tag table, and ptr is a pointer to the location which should point
//  to this node, when the node is inserted into the tree.

    TEST  !ptr = 0  THEN  !ptr  :=  heap3(node, 0, 0)
    ELSE
    $(
        LET p  =  !ptr

        TEST  comparestrings(node+st.name, p!p.ptr0+st.name)  < 0
              THEN  putinxreftable(node, p+p.ptr1)
              ELSE  putinxreftable(node, p+p.ptr2)
    $)
$)



AND comparestrings(p1, p2)  =  VALOF
$(
//  Compare the "strings" pointed to by p1 and p2, and return
//  <0  if  p1 < p2    and
//  >0  if  p1 > p2

    LET l1  =  p1%0
    LET l2  =  p2%0

    FOR  i = 1  TO  (l1 < l2  ->  l1, l2)  DO
    $(
        LET ch1   =  p1%i
        LET ch2   =  p2%i
        LET diff  =  ch1 - ch2

        UNLESS  diff = 0  DO  RESULTIS  diff
    $)

    RESULTIS  l1 - l2
$)



AND printxreftable()  BE
$(
    listing  :=  yes
    paging   :=  yes
    listed   :=  no
    onpage   :=  0

    settitle("CROSS-REFERENCE")

    clearbuffer()
    printnode(xreftable)

    clearbuffer()
$)



AND printnode(node)  BE  UNLESS  node = 0  DO
$(
    LET t       =  node!p.ptr0
    LET l       =  node!p.ptr1
    LET r       =  node!p.ptr2

    LET type    =  t!st.type  &  st.type.mask
    LET value   =  t!st.value
    LET line    =  t!st.definition
    LET refs    =  t!st.references
    LET name    =  t+st.name

    LET online  =  0


    printnode(l)

    linepos  :=  0
    writestring(name)

    linepos  :=  32

    TEST  (t!st.type & st.type.mask) = s.ext  THEN
          writestring("******EXTERNAL******")        ELSE

    TEST  line = cr.undefined  THEN
          writestring("******UNDEFINED******")       ELSE

    TEST  line = cr.multiple   THEN
          writestring("******MULTIPLE******")        ELSE

    TEST  line = cr.setsymbol  THEN
          writestring("**********SET************")   ELSE

          writenumber(line, 5)

    linepos  :=  40

    IF  line > 0  THEN

        SWITCHON  type  INTO
        $(
            CASE s.rel     :  writehexvalue(value, 4 )
                              writechar('*'')
                              ENDCASE

            CASE s.reg     :  writehexvalue(value, 4 )
                              writechar('R')
                              ENDCASE

            CASE s.abs16   :  writehexvalue(value, 4)
                              ENDCASE

            CASE s.abs32   :  writehexvalue(value, 8)
                              ENDCASE

            CASE s.Dr      :  writechar('D')
                              writehexvalue(value, 1)
                              ENDCASE

            CASE s.Ar      :  writechar('A')
                              writehexvalue(value, 1)
                              ENDCASE

            DEFAULT        :  writestring("????")
                              ENDCASE
        $)

    //  Now print out the references to this particular symbol.

    linepos  :=  52

    TEST  refs = 0  THEN
    $(
        linepos  :=  37

        IF  line > 0  THEN  writechar('U')
    $)
    ELSE
    $(
        UNTIL  refs = 0  DO
        $(
            IF  online = 10  THEN
            $(
                printbuffer()
                clearbuffer()

                linepos  :=  50
                writestring("- ")

                online   :=  0
            $)

            writenumber(refs!r.line, 5)

            TEST  refs!r.file = currentfile
                THEN  writestring("  ")
                ELSE  writestring("** ")

            refs    :=  refs!r.link
            online  :=  online  +  1
        $)
    $)

    printbuffer()
    clearbuffer()

    printnode(r)
$)

// End of file a68k1.b

