
// File a68k4.b

// Assembler for Motorola MC68000 - segment 4

// UKC version - R.D. Eager   MCMLXXXVIII


GET "libhdr"

GET "a68k.h"


LET defineconstants( size )  BE
$(
//  Deal with a "DC" directive.

    LET restype  =  0
    LET bs       =  bytesize( size )

    skiplayout()

    dataalign(size, 191)

    IF  labelset  THEN  setlabel( locmode, location, no )

    nitems  :=  0

    $(  //  Repeat loop to read all the items on the line.  We are already
        //  aligned to the correct boundary.

        externalref  :=  no
        forwardref   :=  no

        TEST  ch = '*''  THEN
        $(
            //  This is the most revolting feature of the Motorola 68000
            //  assembler.  We are allowed to use DC.L and DC.W to declare
            //  aligned string constants as well as DC.B.

            LET charcount  =  0

            $(  //  Repeat loop to read the characters in the string.

                rch()

                IF  ch = '*''  THEN
                $(
                    rch()
                    UNLESS  ch = '*''  BREAK
                $)

                IF  ch = '*N'  THEN  complain(57 )

                stackvalue( s.abs16, 1, ascii.value( ch ), no, 0 )
                    
                charcount  :=  charcount + 1
            $)
            REPEAT

            readsymb()
                
            //  We now have to ensure that we are aligned to the right sort
            //  of boundary by filling up with the right number of nulls.
                
            UNTIL  (charcount REM bs)  =  0  DO
            $(
                stackvalue( s.abs16, 1, 0, no, 0 )
                    
                charcount  :=  charcount + 1
            $)
        $)
        ELSE
        $(
            readsymb()

            restype  :=  evalexp( expression() )

            UNLESS  size = ts.byte  DO
                IF  pass1 & forwardref  THEN  
                    relocate( 0, bs )

            IF  externalref  &  size \= ts.long  THEN
                complain(161 )
                
            IF  size = ts.byte  &  NOT absolute( restype )  THEN
                complain(123 )

            IF  pass2  THEN
            $(
                IF  size = ts.word  &  NOT wordsized( value )  THEN
                    warning( 175 )

                IF  size = ts.byte  &  NOT bytesized( value )  THEN
                    warning( 176 )
            $)

            stackvalue( restype, bs, value, externalref, externalsymb )
        $)
    $)
    REPEATWHILE  symb = s.comma

    //  If we drop through here, then, either we have reached the end
    //  of the list, and have come to an "s.none", or else, this is some
    //  sort of syntax error.

    checkfor( s.none, 77 )
$)



AND defineblock( size )  BE
$(
//  Handle the DCB directive - define a block of items which are all the same
//  value.

    LET incr     =  0
    LET newloc   =  0
    LET restype  =  0
    LET bs       =  bytesize( size )
    
    dataalign(size, 192)

    IF  labelset  THEN  setlabel( locmode, location, no )
    
    //  First read the count, which will tell us where the final location will
    //  be.
    
    nextsymb()

    restype  :=  evalexp( expression() )

    TEST  forwardref                THEN  complain(79 )   ELSE
    TEST  externalref               THEN  complain(164 )  ELSE
    TEST  NOT absolute( restype )   THEN  complain(71 )   ELSE
    TEST  value < 0                 THEN  complain(48 )   ELSE

          incr  :=  value * bs
          
    //  We now have an increment in our hands, and so can calculate what
    //  the new address would be.  If out of address range, then we should
    //  complain now.
    
    newloc  :=  location + incr
    
    UNLESS  (newloc & addressmask) = 0  DO  complain(48 )

    //  Having got this far, we can read the argument to the directive, which
    //  is the value to be repeated.

    checkfor( s.comma, 10 )

    forwardref   :=  no
    externalref  :=  no
    restype      :=  evalexp( expression() )
    
    checkfor( s.none, 47 )
    
    IF  size = ts.byte  &  NOT absolute( restype )  THEN
        complain(123 )
        
    IF  externalref  &  size \= ts.long  THEN
        complain(161 )

    IF  pass2  THEN
    $(
        IF  size = ts.word  &  NOT wordsized( value )  THEN
            warning( 175 )

        IF  size = ts.byte  &  NOT bytesized( value )  THEN
            warning( 176 )
    $)

    //  We now have the count and the item to be repeated.  We should enter a
    //  loop updating the store buffer with the value, and relocating the
    //  symbol if necessary.
    
    TEST  pass1  THEN
    $(
        //  Nothing to be done in the first pass.  Just relocate the symbol
        //  many times is necessary.
        
        UNTIL  location = newloc  DO
        $(
            UNLESS  size = ts.byte  DO  
                IF  relocatable( restype )  |  forwardref  THEN
                    relocate( 0, bs )
            
            setloc( location + bs )
        $)
    $)
    ELSE
    $(
        //  This is the second pass, and we must update the code vector with
        //  the value.  We must remember to relocate the symbol and add
        //  external references if necessary.
        
        IF  listing  THEN
        $(
            clearbuffer()

            linepos  :=  0

            writehexvalue( location, locmode = s.rel  ->  4, 6 )

            IF  locmode = s.rel  THEN  writechar( '*'' )

            linepos  :=  10
            writechar( '=' )
            writehexvalue( incr, 4 )

            IF  error.found  THEN
            $(
                linepos  :=  35
                writechar( 'E' )
                error.found  :=  no
            $)

            linepos :=  38
            writenumber( linenumber, 5 )

            IF  macrodepth > 0  &  NOT inmacro  THEN
            $(
                linepos  :=  43
                writechar( '+' )
            $)

            linepos  :=  44
            FOR  i = 0  TO  length-1  DO  writechar( inputbuff % i )

            printbuffer()

            listed   :=  yes
        $)

        //  Having listed the line, fill in all the values which we have 
        //  prepared so carefully.

        UNTIL  location = newloc  DO
        $(
            IF  relocatable( restype )  THEN  relocate( location, bs )
            IF  externalref             THEN  addexternalref( externalsymb, location )

            codebytes( bs, value )
        $)
    $)
$)



AND definestorage( size )  BE
$(
//  Deal with a "DS" directive

    LET incr     =  0
    LET newloc   =  0
    LET restype  =  0
    LET bs       =  bytesize( size )

    dataalign(size, 193)

    IF  labelset  THEN  setlabel( locmode, location, no )

    nextsymb()

    restype  :=  evalexp( expression() )

    TEST  forwardref                THEN  complain(79 )   ELSE
    TEST  externalref               THEN  complain(164 )  ELSE
    TEST  symb  \=  s.none          THEN  complain(47 )   ELSE
    TEST  NOT absolute( restype )   THEN  complain(71 )   ELSE
    TEST  value < 0                 THEN  complain(48 )   ELSE

          incr  :=  value * bs
          
    //  We now have an increment in our hands, and so can calculate what
    //  the new address would be.  If out of address range, then we should
    //  complain now.
    
    newloc  :=  location + incr
    
    UNLESS  (newloc & addressmask) = 0  DO  complain(48 )

    IF  pass2  &  listing  THEN
    $(
        clearbuffer()

        linepos  :=  0

        writehexvalue( location, locmode = s.rel  ->  4, 6 )

        IF  locmode = s.rel  THEN  writechar( '*'' )

        linepos  :=  10
        writechar( '=' )
        writehexvalue( incr, 4 )

        IF  error.found  THEN
        $(
            linepos  :=  35
            writechar( 'E' )
            error.found  :=  no
        $)

        linepos :=  38
        writenumber( linenumber, 5 )

        IF  macrodepth > 0  &  NOT inmacro  THEN
        $(
            linepos  :=  43
            writechar( '+' )
        $)

        linepos  :=  44
        FOR  i = 0  TO  length-1  DO  writechar( inputbuff % i )

        printbuffer()

        listed   :=  yes
    $)

    setloc( newloc )
$)



AND dataalign(size, mescode) BE
/*  Align  data  to  a suitable boundary if necessary, issuing a warning
message if appropriate. */
$( LET factor = bytesize(size = ts.byte -> ts.byte, ts.word)

   IF factor NE 1 THEN
   $( UNLESS aligned(2) DO
      $( warning(mescode)
         align(factor)
      $)
   $)
$)


AND checktagsize()  BE
    UNLESS  tagsize.given = ts.none  DO
            complain(80 )



AND wordsized( operand )  =  -32768 <= operand <= +32767    |
                             (operand & #XFFFF) = operand



AND bytesized( operand )  =  -128 <= operand <= +127         |
                             (operand & #XFF) = operand



AND absolute( ea )        =   ea = s.abs16   |   ea = s.abs32



AND relocatable( ea )     =   ea = s.rel



AND checkregister( reg )  =  VALOF
$(
    LET rnum   =  reg!p.ptr1
    LET rsize  =  reg!p.ptr2

    TEST  rsize = ts.none
        THEN  RESULTIS  rnum
        ELSE  complain(81 )
$)



AND checklabel( possible )  BE
    UNLESS  labelset = possible  DO
        complain( possible  ->  82, 83 )



AND nextsymb()  BE
$(
//  Get the next symbol from the input stream, irrespective of layout
//  characters.

    skiplayout()
    readsymb()
$)



AND spacelines( n )  BE  IF  pass2  &  listing  THEN
$(
    clearbuffer()
    FOR  i = 1  TO  n  DO  printbuffer()
    listed   :=  yes
$)



AND printbuffer()  BE    IF   pass2  &  (error.found  |  listing)  THEN
$(
//  Print the output buffer to the "listing" output stream
//  using the most efficient method possible.
//  First, strip trailing spaces.

    LET linelength  =  0

    FOR  i = charsperline-1  TO  0  BY  -1  DO
         UNLESS  outbuff % i  =  '*S'  DO
         $(
             linelength  :=  i + 1
             BREAK
         $)

    IF  (onpage REM (linesperpage-5) = 0)  &  paging  THEN  pageheading()


    TEST sys.emas THEN
    $( writerec(outbuff, linelength)
    $)
    OR
    $( FOR  i = 0  TO  linelength-1  DO  wrch(outbuff%i)
       newline()
    $)


    onpage  :=  onpage + 1
$)



AND pageheading()  BE  IF  pass2  &  paging  THEN
$(
    wrchsave    :=  wrch
    wrch        :=  wch
    linepos     :=  0
    pagenumber  :=  pagenumber  +  1

    writef("*PMC68000 ASSEMBLER VERSION %C%N.%N   ", sysversion, version, edit)
    FOR  i = 0  TO  titlecharsmax-1  DO  wrch( titlevec % i )

    writef( " %S %S     PAGE %N*N*N", datestring, timestring, pagenumber )

    TEST  crossreference  THEN
          writes( "            SYMBOL               DEFN   VALUE          *
                  *   REFERENCES*N" )

    ELSE  
    
    TEST  errormessages  THEN
          writes( "             FILE                  STMT                *
                  *  ERROR MESSAGE*N" )

    ELSE  writes( "   LOC              OBJECT             STMT            *
                  *SOURCE STATEMENT*N" )

    writes( "*N*N" )

    wrch    :=  wrchsave
    onpage  :=  0
$)



AND wch( ch )  BE
$(
    TEST  ch = '*N'  THEN
    $(
        wrchsave( '*N' )
        linepos  :=  0
    $)
    ELSE

    UNLESS  linepos >= charsperline  DO
    $(
        wrchsave( ch )
        linepos  :=  linepos + 1
    $)
$)



AND bytesize( size )  =  VALOF
$(
    SWITCHON  size  INTO
    $(
        CASE ts.long    : RESULTIS 4
        CASE ts.word    : RESULTIS 2
        CASE ts.byte    : RESULTIS 1

        CASE ts.none    : RESULTIS bytesize( ts.default )

        DEFAULT         : complain(0 )
    $)
$)



AND checkexpression( type, endofexpression )  BE
$(
//  Match the expression, just read in, with that which is
//  theoretically expected for the directive in "directive".
//
//  Check that:
//
//    a) The data type of the expression was correct
//    b) The expression was terminated correctly
//    c) It contained no forward references.

    TEST  forwardref       THEN  complain(79 )   ELSE
    TEST  externalref      THEN  complain(164 )  ELSE

    TEST  endofexpression  
        THEN  checkfor( s.none, 47 )  
        ELSE  checkfor( s.comma, 10 )

    SWITCHON  directive  INTO
    $(
        CASE d.equr    : // Requires "register" data type

                         UNLESS  type = s.Ar | type = s.Dr  DO
                                 complain(84 )

                         ENDCASE


        CASE d.ifeq    :
        CASE d.ifne    :
        CASE d.spc     :
        CASE d.plen    :
        CASE d.llen    :
        CASE d.cnop    :
        CASE d.org     : // Requires "absolute" data type

                         UNLESS  absolute( type )  DO
                                 complain(71 )

                         ENDCASE


        DEFAULT        : // All the rest require "relocatable" or
                         // "absolute" data types

                         UNLESS  absolute( type )  |  relocatable( type )  DO
                                 complain(85 )
    $)
$)



AND listline()  BE  
    TEST  pass2  &  (listing  |  error.found)
        THEN  printline()
        ELSE  codeline()



AND printline()  BE  UNLESS  (listed  &  NOT error.found)    DO
$(
//  We are about to list a line...

    clearbuffer()

    linepos  :=  0

    UNLESS  commentline  DO
    $(
        writehexvalue( location, locmode = s.rel  ->  4, 6 )
        IF  locmode = s.rel  THEN  writechar( '*'' )
    $)

    linepos  :=  38
    writenumber( linenumber, 5 )

    IF  macrodepth > 0  &  NOT inmacro  THEN
    $(
        linepos  :=  43
        writechar( '+' )
    $)

    linepos  :=  44
    FOR  i = 0  TO  length - 1  DO  writechar( inputbuff % i )

    FOR  itemsprinted = 0  TO  nitems-1  DO
    $(
        LET offset  =  itemsprinted * cb.size
        LET dtype   =  codebuff!(offset + cb.dtype)
        LET dsize   =  codebuff!(offset + cb.dsize)
        LET dvalue  =  codebuff!(offset + cb.dvalue)
        LET dext    =  codebuff!(offset + cb.dext)
        LET dsymb   =  codebuff!(offset + cb.dsymb)

        IF  dext  THEN  addexternalref( dsymb, location )

        writebytes( dsize, dvalue )

        IF  dtype = s.rel  THEN  relocate( location, dsize )

        codebytes( dsize, dvalue )
    $)

    IF  error.found  THEN
    $(
        linepos  :=  35
        writechar( 'E' )
    $)

    printbuffer()
$)



AND codeline()  BE
$(
//  Acts just like "printline", except does not prepare the buffer for 
//  printing.  This is used in the first pass, and when the listing option
//  is switched off.

    FOR  itemscoded = 0  TO  nitems-1  DO
    $(
        LET offset  =  itemscoded * cb.size
        LET dtype   =  codebuff!(offset + cb.dtype)
        LET dsize   =  codebuff!(offset + cb.dsize)
        LET dvalue  =  codebuff!(offset + cb.dvalue)
        LET dext    =  codebuff!(offset + cb.dext)
        LET dsymb   =  codebuff!(offset + cb.dsymb)

        IF  dext  THEN  addexternalref( dsymb, location )

        IF  dtype = s.rel  THEN  relocate( location, dsize )

        codebytes( dsize, dvalue )
    $)
$)



AND writebytes( dsize, dvalue )  BE
    FOR  i = dsize-1  TO  0  BY  -1  DO
         writebyte( (dvalue >> i*8) & #XFF )



AND codebytes( dsize, dvalue )  BE
    FOR  i = dsize-1  TO  0  BY  -1  DO
         codebyte( (dvalue >> i*8) & #XFF )



AND writebyte( byte )  BE
$(
    IF  bytesonline = 8  THEN
    $(
        printbuffer()
        clearbuffer()

        commentline  :=  yes
        bytesonline  :=  0
    $)

    linepos  :=  bytesonline!( TABLE  11, 13, 17, 19, 23, 25, 29, 31 )

    writehexvalue( byte, 2 )

    bytesonline  :=  bytesonline + 1
$)



AND codebyte( byte )  BE
$(
    IF  pass2  THEN  codevec % location  :=  byte

    setloc( location + 1 )
$)



AND align( boundary )  BE
$(
    LET try   =  (location + boundary - 1)
    LET decr  =  try REM boundary

    setloc( try - decr )
$)



AND writehexvalue( h, d )  BE
$(
    IF  d > 1  THEN  writehexvalue( h >> 4, d-1 )
    writechar( (h & #XF)!  TABLE  '0', '1', '2', '3', '4', '5', '6', '7',
                                  '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' )
$)



AND writenumber( n, d )  BE
$(
    IF  d > 1  THEN  writenumber( n/10, d-1 )
    writechar(  n = 0  ->  '*S',  (n REM 10  +  '0') )
$)



AND writestring( string )  BE
    FOR  i = 1  TO  string % 0  DO
         writechar( string % i )



AND writechar( char )  BE
$(
    IF  linepos >= charsperline  THEN  RETURN

    outbuff % linepos  :=  char
    linepos            :=  linepos + 1
$)



AND clearbits()  BE
$(
//  Clear the bits in both the symbol tables.

    cleartable( tagtable1 )
    cleartable( tagtable2 )
$)



AND cleartable( tagtable )  BE
$(
//  Clear all the symbol table bits in the table "tagtable".

    FOR  i = 0  TO  tagtablesize-1  DO
    $(
        LET ptr  =  tagtable!i

        UNTIL  ptr = 0  DO
        $(
            UNLESS  ptr!st.definition = 0  DO
                ptr!st.flags  :=  ptr!st.flags  &  (NOT stb.setnow)

            ptr  :=  !ptr
        $)
    $)
$)



AND relocate( address, size )  BE
$(
    LET re  =  size = 4  ->  relocvec32,
               size = 2  ->  relocvec16,
                             complain(0 )

    LET rp  =  size = 4  ->  @relp32,
               size = 2  ->  @relp16,
                             complain(0 )

    LET p   =  !rp

    IF  pass2  THEN  re!p  :=  address

    !rp  :=  p + 1
$)



AND generate( masktype )  BE
$(
    SWITCHON  masktype  INTO
    $(
        CASE  1 :  swapoperands()
                   codeword(  instr.mask                            |
                              (op1.exp << 9)                        |
                              (sizefield( instr.size ) << 6)        |
                              (eafield())                           )
                   genea()

                   ENDCASE


        CASE  2 :  codeword(  instr.mask                            |
                              (sizefield( instr.size ) << 6)        |
                              (eafield())                           )

                              UNLESS  source.ea = 0  DO
                              $(
                                  //  There is some Immediate data to deal with.
                                  IF  instr.size = ts.long  THEN
                                       codeword(  op1.exp  >>  16  )
                                       codeword(  op1.exp & #XFFFF )
                              $)

                              genea()

                              ENDCASE


        CASE  4 :  IF  op1.ea = am.Ar  |  op1.ea = am.Dr  THEN  swapoperands()
                   codeword(  instr.mask   |   exp  )

                   UNLESS  source.ea = 0  DO   codeword(  op1.exp & #XFFFF  )

                   ENDCASE


        CASE  5 :  codeword(  instr.mask                            |
                              ((op1.exp & #B111) << 9)              |
                              (sizefield( instr.size )  <<  6)      |
                              (eafield())                           )
                   genea()

                   ENDCASE


        CASE  6 :  codeword(  instr.mask                            |
                              (source.ea  <<  8)                    |
                              (eafield())                           )
                   genea()

                   ENDCASE


        CASE  7 :  swapoperands()
                   codeword(  instr.mask                            |
                              (op1.exp  <<  9)                      |
                              (eafield())                           )
                   genea()

                   ENDCASE


        CASE  9 :  codeword(  instr.mask                            |
                              (eafield())                           )
                   genea()

                   ENDCASE


        CASE 10 :  codeword(  instr.mask                            |
                              ((instr.size = ts.long -> 1,0) << 6)  |
                              (exp)                                 )

                   ENDCASE


        CASE 15 :  codeword(  instr.mask  )
                   UNLESS  dest.ea = 0  DO  codeword( exp & #XFFFF )

                   ENDCASE


        DEFAULT :  complain(0)
    $)
$)

// End of file a68k4.b

