/*                  The Christchurch Edit Facility
                            Version  4.7
                             1988-02-07

   Copyright  (C)  J.  E.  L.  Peck,  Vancouver,  M.  A. Maclean,
Christchurch.  Additions by R.D. Eager, Canterbury, England.

         This part contains declarations  of  manifest  constants
used throughout the editor.  */

GET "LIBHDR"

MANIFEST
 { version    = 4700
   mts.sys    = version + 1   //  MTS on Amdahl 470
   unix.sys   = version + 2   //  UNIX on PDP11 (UBC)
   unix1.sys  = version + 3   //  UNIX on PDP11 (UKC)
   rdos.sys   = version + 4   //  RDOS on NOVA or ECLIPSE
   aos.sys    = version + 5   //  AOS on ECLIPSE
   fmgr.sys   = version + 6   //  FMGR on HP21MX
   emas.sys   = version + 7   //  EMAS on ICL 2900
   unix32.sys = version + 8   //  UNIX on DEC VAX (Berkeley 4.2)
   slim.470   = version + 9   //  SLIM on Amdahl 470
   tripos.sys = version + 10  //  TRIPOS on PDP11
   prime.sys  = version + 11  //  Prime in Christchurch
   cpm.sys    = version + 12  //  CP/M on Z80
   vms.sys    = version + 13  //  VAX/VMS on DEC VAX

/*  For generation of the editor for a particular machine, change
the following constant and be sure to check the file 'SYSHDR'.
******************************************************************
***/                    computer = vms.sys                    /***
******************************************************************

   The following declarations enable one to select, from  a  menu
of  features, those which are to be incorporated into the editor.
Consult EF13 for a more extended description.
*/

   menu_class   = TRUE        // Character classes
   menu_closure = TRUE        // Closure in patterns
   menu_dsplpat = TRUE        // Display reconstructed pattern
   menu_fm      = TRUE        // The operators F and M
   menu_j       = TRUE        // The operator J
   menu_macro   = TRUE        // Control line macro expansion
   menu_new     = TRUE        // The operator N
   menu_pl      = TRUE        // The operator PL
   menu_pm      = TRUE        // The operator PM
   menu_qs      = TRUE        // Return for system command
   menu_ri      = TRUE        // The operator RI
   menu_rlu     = TRUE        // The operators RL and RU
   menu_rn      = TRUE        // Numbers after the R operator
   menu_t       = TRUE        // The operator T
   menu_u       = TRUE        // The operator U
   menu_x       = TRUE        // The operator X
   menu_xa      = TRUE        // The operator XA
   menu_xf      = TRUE        // Execute from a file
   menu_z       = TRUE        // The operator Z
   menu_a       = TRUE LOGOR  // The operator A
        menu_xa
   menu_control = TRUE LOGOR  // Control store option
        menu_macro
   menu_xc      = TRUE LOGOR  // The operator XC
        menu_xa

   menu_dynamic = FALSE       // For dynamic SLIM

/* The following decides which computer to generate code for.  */

   sys_mts    = (computer = mts.sys)    //  IBM 360/370 under MTS.
   sys_unix   = (computer = unix.sys)   //  PDP11 under UNIX (UBC).
   sys_unix1  = (computer = unix1.sys)  //  PDP11 under UNIX (UKC).
   sys_rdos   = (computer = rdos.sys)   //  DG Nova under RDOS.
   sys_aos    = (computer = aos.sys)    //  DG Eclipse under RDOS.
   sys_fmgr   = (computer = fmgr.sys)   //  HP21MX under FMGR.
   sys_emas   = (computer = emas.sys)   //  ICL 2900 under EMAS.
   sys_unix32 = (computer = unix32.sys) //  DEC VAX under UNIX (Berkeley 4.2)
   sys_470    = (computer = slim.470)   //  SLIM on the Amdahl 470
   sys_tripos = (computer = tripos.sys) //  PDP11 under TRIPOS
   sys_prime  = (computer = prime.sys)  //  Prime in Christchurch
   sys_cpm    = (computer = cpm.sys)    //  Z80 under CP/M
   sys_vms    = (computer = vms.sys)    //  DEC VAX under VAX/VMS

   hex_        = sys_mts LOGOR
                 sys_470 LOGOR
                 sys_emas LOGOR
                 sys_cpm LOGOR
                 sys_unix1 LOGOR
                 sys_unix32 LOGOR
                 sys_vms
   ascii_      = ~ (sys_mts LOGOR sys_470)
   hp_unit     = 1

/*  The  following  constant  determines  whether  or not certain
STATIC variables  are  to  be  re-initialised  on  entry  to  the
editor. This  may  be  necessary  if  the  editor is to be re-run
without being reloaded on some systems. */

   init_statics_ = sys_emas LOGOR sys_vms -> TRUE, FALSE

/* As explained fully in EF13, the capacity and efficiency of the
editor can be influenced by an appropriate choice of:
   a) the number of bytes per grab (grab_bsz)
        because the size (in bytes)  of  the  file  that  can  be
        edited will  be approximately 'max_int * grab_bsz'.  On a
        16 bit machine in which 'max_int =  32767'  a  choice  of
        'grab_bsz  =  4'  will  allow for 131,068 bytes, which is
        probably ample.
   b) the number of grabs per block (block_gsz)
        because lines are stored in memory in a  buffer  of  this
        size  and  the  larger  the  buffer  the  more  lines are
        available without disc access.  It is probably convenient
        to  make  'block_gsz * grab_bsz' equal to the appropriate
        block transfer of bytes to a file in your system.

   The following constants define the sizes of various vectors or
   strings used by the editor.  The notation used is:
               x_csz   =  size of x in cells,
               x_bsz   =  size of x in bytes,
               x_gsz   =  size of x in grabs,
               x_lsz   =  size of x in lines.
                                                                */
   // Critical size constants

   grab_bsz     =  sys_mts LOGOR
                   sys_470 LOGOR
                   sys_emas LOGOR
                   sys_unix32 LOGOR
                   sys_vms -> 1, 4  // bytes per grab
   block_gsz    =  sys_rdos -> 128,    // grabs per file block
                   sys_aos -> 128,
                   sys_unix -> 128,
                   sys_unix1 -> 128,
                   sys_mts -> 256,
                   sys_470 -> 256,
                   sys_emas -> 512,
                   sys_cpm -> 32,
                   sys_tripos -> 128,
                   sys_vms -> 512,
                   sys_unix32 -> 1024, 64  // grabs per block

   control_lsz  =  menu_control -> 27, 0 // lines in control store

   max_int      =  sys_mts -> 999999999,
                   sys_470 -> 999999999,
                   sys_emas -> 8388607,
                   sys_vms -> 2147483647,
                   sys_unix32 -> 2147483647, 32767
   file_lsz     =  max_int  // lines per file
   msg_csz      =  37  // upper bound of number of error messages

   // Byte sizes

   alpha_bsz    =  64   // upper bound of printable characters
   block_bsz    =  block_gsz * grab_bsz // bytes per block
   cell_bsz     =  sys_mts LOGOR   // bytes per BCPL cell
                   sys_470 LOGOR
                   sys_emas LOGOR
                   sys_unix32 LOGOR
                   sys_vms -> 4, 2
   line_bsz     =  sys_aos LOGOR   // characters per line
                   sys_rdos -> 128,
                   sys_vms -> 240,
                              248
   name_bsz     =  sys_emas LOGOR
                   sys_tripos LOGOR
                   sys_unix1 -> 64,
                   sys_vms -> 240,
                   sys_unix32 -> 248, 32 // characters per file name
                                         // also used by H and QS
   pattern_bsz  =  sys_emas LOGOR
                   sys_unix1 LOGOR
                   sys_vms LOGOR
                   sys_unix32 -> 128, 64
                   // characters per pattern or replacement string
   trail_bsz    =  menu_u -> 22, 0 // chars in undo command line
   number_bsz   =  sys_mts -> 4,
                   sys_470 -> 4,
                   sys_emas LOGOR
                   sys_cpm LOGOR
                   sys_tripos LOGOR
                   sys_unix1 LOGOR
                   sys_unix32 LOGOR
                   sys_vms -> 5, 6 // chars for line numbers

   // Cell sizes

   alpha_csz    = alpha_bsz / cell_bsz
   block_csz    = block_bsz / cell_bsz
   line_csz     = line_bsz / cell_bsz
   name_csz     = name_bsz / cell_bsz
   pattern_csz  = pattern_bsz / cell_bsz
   trail_csz    = trail_bsz / cell_bsz

   /* Note that the following conditions should hold:-
      name_csz + pattern_csz + 6 <= line_csz   */

   // Grab sizes (used in EF6)

   line_gsz     = (line_bsz + 2 + grab_bsz - 1)/grab_bsz

/* The following constants are necessary because of differences
between EBCDIC and ASCII.  */

   accent_grave    =  ascii_ -> #O042, #X7F // alternate "
   lbrac_symbol    =  ascii_ -> #O133, #X4C // left square bracket
   carat_symbol    =  ascii_ -> #O136, #X7C // alternate @
   delete_symbol   =  ascii_ -> #O177, #X07
   rbrac_symbol    =  ascii_ -> #O135, #X6E // right square bracket
   margin_symbol   =  ascii_ -> #O174, #X4F // backslash or stick
   tab_symbol      =  ascii_ -> #O011, #X05
   under_symbol    =  ascii_ -> #O134, #XBA // backslash

/* The following constants use values which are unprintable  both
in EBCDIC and in ASCII.  These are needed for the internal coding
of patterns.   */

   any_symbol      =  234        // .
   match_symbol    =  235        // &
   bol_symbol      =  237        // ^
   eol_symbol      =  238        // $
   closure_symbol  =  250        // *
   include_symbol  =  251        // inclusive class
   exclude_symbol  =  252        // (~) exclusive class
   range_symbol    =  253        // [
   sentinel        =  254        // for fast pattern match

/* Miscellaneous.  */

   msg_pswd = 777; null = 0; control = -1


/* Parameters used by 'out_line' in EF7, computed in EF3. */

   text_counted    = 1     // W(~dummy_f) PF(~dummy_f)
   text_only       = 2     // P
   text_lucid      = 3     // PL
   text_numbered   = 4     // PA
   text_view       = 5     // V
   byte_count_only = 6     // W(dummy_f)  PF(dummy_f)
   match_positions = 7     // PM

/* Parameters used by 'move_windows' of EF6.  */

   w_backup        = 1     // store backup grabs for undo.
   w_restore       = 2     // restore grabs for undo.
   w_enlarge       = 3     // make another empty window.

/*  The  following  constants  give  the  positions  of the error
messages in the message file.  */

   m_attn           = -1
   m_control        = -2
   m_empty          = -3
   m_end            = -4
   m_exec           = -5
   m_finder         = -6
   m_global         = -7
   m_got1           = -8
   m_got2           = -9
   m_access         = -10
   m_line1          = -11
   m_line2          = -12
   m_tag            = -13
   m_name           = -14
   m_no_close       = -15
   m_not_found      = -16
   m_over           = -17
   m_overlap        = -18
   m_pat            = -19
   m_quit           = -20
   m_range          = -21
   m_syntax         = -22
   m_control2       = -23
   m_told           = -24
   m_patt_too_long  = -25
   m_value          = -26
   m_undo           = -27
   m_recursion      = -28
   m_no_undo        = -29
   m_cmd_too_long   = -30
   m_text_too_long  = -31
   m_new_too_long   = -32
   m_input_too_long = -33
   m_na             = -34
   m_split_control  = -35
   m_combination    = -36
   m_write          = -37
}

MANIFEST
{ gpb = sys_unix LOGOR sys_emas -> 120,
        sys_unix32 -> 113,
        sys_tripos -> 150,
        sys_vms -> 105,
        100   // base of global procedures
  gvb = gpb + 105 }            // base of global variables

GLOBAL
{  // procedures. ----------------
   accept_char:            gpb + 001
   accept_delete:          gpb + 002
   accept_pat_or_tag:      gpb + 003
   accept_tab:             gpb + 004
   add_byte_count:         gpb + 005
   bell:                   gpb + 006
   char_number:            gpb + 007
   check_interrupt:        gpb + 008
   check_system:           gpb + 009
   chef_parameters:        gpb + 010
   clear_all_flags:        gpb + 011
   cmd:                    gpb + 012
   copy_bytes:             gpb + 013
   copy_cells:             gpb + 014
   check_blocks:           gpb + 015
   copy_lines:             gpb + 016
   copy_string:            gpb + 017
   create_file:            gpb + 018
   delete_lines:           gpb + 019
   display_pat:            gpb + 020
   do_b:                   gpb + 021
   do_j:                   gpb + 022
   do_k:                   gpb + 023
   do_sys_call:            gpb + 024
   do_u:                   gpb + 025
   do_q:                   gpb + 026
   do_z:                   gpb + 027
   dump:                   gpb + 028
   echo_string:            gpb + 029
   empty_work_space:       gpb + 030
   end_work_file:          gpb + 031
   eq_str:                 gpb + 032
   err:                    gpb + 033
   expand:                 gpb + 034
   fetch_grab:             gpb + 035
   fetch_line:             gpb + 036
   find_in_file:           gpb + 037
   find_out_file:          gpb + 038
   find_work_file:         gpb + 039
   fix_attention:          gpb + 040
   flag_the_line:          gpb + 041
   get_int:                gpb + 042
   get_left_lines:         gpb + 043
   get_operand:            gpb + 044
   get_operator:           gpb + 045
   get_param:              gpb + 046
   get_ch:                 gpb + 047
   get_right_lines:        gpb + 048
   got_text:               gpb + 049
   init_work_space:        gpb + 050
   insert_lines:           gpb + 051
   internal_code:          gpb + 052
   interpret:              gpb + 053
   make_indexed:           gpb + 054
   make_sequential:        gpb + 055
   make_space:             gpb + 056
   move_windows:           gpb + 057
   name_of_msg_file:       gpb + 058
   next_sig_char:          gpb + 059
   no_out_trim_or_control: gpb + 060
   no_trim:                gpb + 061
   out_line:               gpb + 062
   out_lines:              gpb + 063
   postlude:               gpb + 064
   post_trail:             gpb + 065
   pre_trail:              gpb + 066
   print_byte_count:       gpb + 067
   put_msg:                gpb + 068
   qmatch:                 gpb + 069
   read_file:              gpb + 070
   recover:                gpb + 071
   recover_eof:            gpb + 072
   reset_byte_count:       gpb + 073
   restore_block:          gpb + 074
   set_file_position:      gpb + 075
   split_line:             gpb + 076
   stack_work_space:       gpb + 077
   start_ef2:              gpb + 078
   start_ef3:              gpb + 079
   start_ef4:              gpb + 080
   start_ef5:              gpb + 081
   start_ef6:              gpb + 082
   start_ef7:              gpb + 083
   start_ef8:              gpb + 084
   start_ef9:              gpb + 085
   start_ef10:             gpb + 086
   store_line:             gpb + 087
   substitute:             gpb + 088
   scan_file:              gpb + 089
   scan_line:              gpb + 090
   save_block:             gpb + 091
   trace:                  gpb + 092
   uc_char_number:         gpb + 093
   unget_ch:               gpb + 094
   unstack_work_space:     gpb + 095
   upper_case:             gpb + 096
   valid_stream:           gpb + 097
   warn:                   gpb + 098
   was_flagged:            gpb + 099
   write_out:              gpb + 100
   // variables. -----------------
   absence_:               gvb + 001
   alpha:                  gvb + 002
   altered_:               gvb + 003
   bol_string:             gvb + 004
   centre_symbol:          gvb + 005
   cmd_line:               gvb + 006
   concat_state_:          gvb + 007
   console_in_stream:      gvb + 008
   console_out_stream:     gvb + 009
   control_chars:          gvb + 010
   cur_char:               gvb + 011
   cur_line:               gvb + 012
   cur_tag:                gvb + 013
   cur_operator:           gvb + 014
   file_name:              gvb + 015
   help_table:             gvb + 016
   l_got:                  gvb + 017
   l_line1:                gvb + 018
   l_line2:                gvb + 019
   l_margin:               gvb + 020
   l_range:                gvb + 021
   l_verge:                gvb + 022
   last_line:              gvb + 023
   len_match:              gvb + 024
   line:                   gvb + 025
   lvl:                    gvb + 026
   modifier:               gvb + 027
   msg_in_stream:          gvb + 028
   msg_table:              gvb + 029
   new_string:             gvb + 030
   no_case_:               gvb + 031
   no_name_:               gvb + 032
   old_cmd:                gvb + 033
   pat:                    gvb + 034
   prefix_on_:             gvb + 035
   quit:                   gvb + 036
   r_got:                  gvb + 037
   r_line1:                gvb + 038
   r_line2:                gvb + 039
   r_margin:               gvb + 040
   r_range:                gvb + 041
   r_verge:                gvb + 042
   re_try:                 gvb + 043
   scan_char:              gvb + 044
   show_prefix:            gvb + 045
   simple_:                gvb + 046
   tag_char:               gvb + 047
   terminated_:            gvb + 048
   test_tag:               gvb + 049
   threshold:              gvb + 050
   tmp_name:               gvb + 051
   trail_line:             gvb + 052
   tried_once_:            gvb + 053
   undo_state_:            gvb + 054
   verify_:                gvb + 055
   verify_on_:             gvb + 056
   view_half:              gvb + 057
   x_state_:               gvb + 058
   xc_state_:              gvb + 059
   xf_state_:              gvb + 060
   w_space:                gvb + 061
   warn_code:              gvb + 062
   work_space:             gvb + 063
   work_in_stream:         gvb + 064
   work_out_stream:        gvb + 065 }
