// SECTION. "EF12"  // Last modified 87-03-27
/* A program to create a message file directory. Lines which  may
have to be changed at another installation are marked thus.
                // --------------------                        */

GET "LIBHDR"

MANIFEST
{  error_size  = 37                //---------------------
   help_max    = 128
   sys_mts     = FALSE
   sys_aos     = FALSE
   sys_rdos    = FALSE
   sys_emas    = FALSE
   sys_cpm     = FALSE
   sys_unix    = FALSE
   sys_vms     = TRUE
   sys_unix32  = FALSE }

MANIFEST
{  nlsize         = sys_cpm -> 2, 1   // For carriage returns
}

STATIC
{  directory_size  = 0
   error_table     = 0
   help_table      = 0
   ch_table        = 0
   other_chs       = 0 }

LET start() BE
{1 LET v = VEC error_size; error_table := v
 { LET v = VEC help_max; help_table := v
 { LET f_in = sys_unix -> "chef.msg",
              sys_emas \/
              sys_cpm \/
              sys_unix32 -> "ef11a",
              sys_vms -> "CHEFHELP.TXT",
                            "EF11"
   LET s_in = findinput(f_in)
   LET s_out = sys_mts \/
               sys_unix -> findoutput("-D"),
               sys_rdos \/
               sys_cpm \/
               sys_emas -> findoutput("DD"),
               sys_unix32 -> findoutput("dd"),
               sys_vms -> findoutput("DD.TMP"),
                          createoutput("MFILE.D")
   IF is_void_stream(s_in) THEN
   { writef("Cannot open %S*N", f_in); RETURN  }
   selectinput(s_in)
   selectoutput(s_out)
   ch_table := sys_mts ->
     "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ?+-,:;$@.**/|*&*'*"#<>~%" ,
     "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ?+-,:;$^.**/\*&*'*"#[]~%@"
   other_chs := sys_mts -> "()=!", "()<>|=!"
   read_directory()
   read_errors()
   read_help(); endread()
   write_new_directory(); endwrite()  }1

AND read_directory() BE
  directory_size := msg_size() + (sys_mts \/ sys_vms -> 1, 0)

AND read_errors() BE
  FOR i = 1 TO error_size DO
    error_table ! i := msg_size()

AND read_help() BE
  FOR i = 1 TO ch_table%0 DO
    help_table ! i := msg_size()

AND msg_size() = VALOF
{1 LET b_n, l_n = 0, 0 AND nl_ = FALSE
   {R LET c = rdch()
      SWITCHON c INTO
      {S CASE endstreamch: writes("Input error*N"); FINISH
         CASE '.':
           IF nl_ THEN
           { b_n := b_n + 1 + flush_line(); l_n := l_n + 1
             RESULTIS sys_mts \/ sys_vms -> l_n , b_n  }
         DEFAULT: b_n := b_n + 1; nl_ := FALSE; ENDCASE
         CASE '*N': nl_ := TRUE; l_n := l_n + 1
                    b_n := b_n + nlsize }S }R
   REPEAT  }1

AND flush_line() = VALOF
{1 LET b_n = 0
   {R LET c = rdch()
      IF c = '*N' THEN RESULTIS nlsize + b_n
      b_n := b_n + 1  }R REPEAT  }1

AND write_new_directory() BE
{1 writef(" %N %N*N", directory_size, error_size)
   FOR i = 1 TO error_size DO
   { writef(" %N", error_table ! i)
     IF i REM 8 = 0 THEN wrch('*N')  }
   FOR i = 1 TO other_chs%0 DO
      writef(" %C 0", other_chs%i)
   wrch('*N')
   FOR i = 1 TO ch_table%0 DO
   { writef(" %C %N", ch_table%i, help_table ! i)
       IF i REM 8 = 0 THEN wrch('*N')  }
   writes("*N _*N")  }1

AND is_void_stream(s) =
/* We must allow for the vagaries of different systems.  */
  (sys_unix \/ sys_rdos) -> (s = -1),
  sys_aos \/ sys_emas -> (s < 0), s = 0

