
// SECTION "EF3"  // Last modified 83-06-16

/* The procedures in this section deal with  the  analysis  of  a
command.   Except  for  'start_ef3', the procedures are listed in
alphabetic order.  */

GET "ef0.h"

LET start_ef3(n) BE
{ // writes("<>start_ef3:*N")
  check_system(n, computer, 3); start_ef4(n) }

LET accept_modifier(s) = VALOF
/*  If 'cur_char' is in the string 's', it sets 'modifier' to the
value of 'cur_char', moves 'cur_char'  to  the  next  significant
character of  the command and yields the value of 'modifier'.  If
'cur_char' is not in 's', 'modifier' is not set and the  function
yields 'null'.  */
{1 // trace("accept_modifier:")
 { LET c = upper_case(cur_char)
   TEST char_number(c, s) > 0 THEN
   { get_ch(); next_sig_char(); modifier := c; RESULTIS c }
   ELSE RESULTIS null }1

AND accept_pat_or_tag(c) = VALOF
/*  If  'c'  is  the  first  character  of  a pattern or tag, the
function returns true and loads 'pat' or 'test_tag'. Otherwise it
returns false.  */
{1 // trace("accept_pat_or_tag:")
   SWITCHON c INTO
   {S CASE '/': CASE under_symbol: get_pat(c); RESULTIS TRUE
      CASE '*'': CASE accent_grave:
        TEST menu_t THEN
        { IF terminated_ THEN warn(m_tag)
          test_tag := cur_char; get_ch()
          RESULTIS TRUE  }
        ELSE warn(m_na)  }S
   RESULTIS FALSE   }1

AND check_lines() BE
/* Checks the validity of the left and right location  specifiers
of  a  command  and  calculates  the  line  ranges  'l_range' and
'r_range'.  Note that if the right operand is  a  location,  then
the modifier, if elided, is set to 'R' by 'get_operand'.  */
{1 // trace("check_lines:")
   SWITCHON cur_operator INTO
   {S CASE null: IF l_got = 0 THEN RETURN
        IF concat_state_ THEN ENDCASE
      CASE 'P': IF l_line2 > last_line THEN
        l_line2 := last_line }S
   TEST menu_control -> (l_got = control), FALSE THEN
     IF (cur_operator NE 'P') LOGAND (modifier = 'F') THEN
        warn(m_syntax)
   ELSE
   { LET low = (cur_operator = 'I' LOGOR
               (cur_operator = 'V' LOGAND modifier = 'N')) -> 0,1
     UNLESS cur_operator = 'B' THEN
     { UNLESS low <= l_line1 <= last_line THEN
         warn(last_line=0 -> m_empty,m_line1)
       UNLESS low <= l_line2 <= last_line THEN
         warn(last_line=0 -> m_empty,m_line2) }
     l_range := l_line2 - l_line1 + 1
     UNLESS l_range >= 0 THEN warn(m_range) }
   IF ((modifier = 'D') LOGOR (modifier = 'R')) LOGAND
     (menu_control -> (r_got ~= control), TRUE) THEN
   {L UNLESS 1 <= r_line1 <= last_line THEN
        warn(last_line=0 -> m_empty,m_line1)
      UNLESS 1 <= r_line2 <= last_line THEN
        warn(last_line=0 -> m_empty,m_line2)
      r_range := r_line2 - r_line1 + 1
      UNLESS r_range >= 0 THEN warn(m_range)
      SWITCHON cur_operator INTO
      {S CASE 'I': IF (r_line1 <= l_line1 < r_line2) THEN
           warn(m_overlap);                      ENDCASE
         CASE 'C': UNLESS (l_line1 > r_line2) LOGOR
           (l_line2 < r_line1) THEN warn(m_overlap) }S }L  }1

AND get_all() BE
/*  This gets  the  operand of the operator H or QS, which is the
remainder of  the  command  line  whose  first  character  is  in
'cur_char'. */
{1 // trace("get_all:")
   FOR i = 1 TO name_bsz DO
     TEST cur_char = '*N' THEN { tmp_name%0 := i-1; RETURN }
     ELSE { tmp_name%i := cur_char; get_ch()  }
     warn(m_cmd_too_long) }1

AND get_class(delim, i) = VALOF
/* This gets a class from the command line into 'pat' at position
'i' and  returns  the  length  of the class in bytes.  A class is
delimited by '[' and ']' and may be preceded by '~'  to  indicate
that it  should  match by exclusion rather than by inclusion.  In
any case, the first character, '~' or '[' has  been  accepted  by
'get_pat'.  There may be ranges in a class, e.g., A-Z or Z-A.  In
both   cases   these  are  stored  in  'pat'  in  the  format  0:
'range_symbol', 1: A, 2: Z.  The format of a class in 'pat'  will
be 0:  'include/exclude_symbol',  1:  stride, 2:  class elements.
The 'stride' is the number of character positions occupied by the
class in 'pat', i.e., the number of class  characters  plus  two.
*/
TEST ~ menu_class THEN RESULTIS 1 ELSE
{1 IF (i+2) > pattern_bsz THEN warn(m_patt_too_long)
 { LET c, d = cur_char, 0  // d checks syntax of ranges
   TEST pat%i = '~' THEN
   {N pat%i := exclude_symbol; get_ch()
      SWITCHON c INTO
      {S CASE '#': c := internal_code()
         DEFAULT: pat%(i+1), pat%(i+2) := 3, c; RESULTIS 3
         CASE lbrac_symbol: c := cur_char  }S  }N
   ELSE pat%i := include_symbol
   FOR j = i+2 TO pattern_bsz DO
   {D LET last_char = c; c := cur_char; get_ch()
      IF c = delim THEN warn(m_pat)
      SWITCHON c INTO
      {S CASE '*N': warn(m_no_close)
         CASE '-': UNLESS d > 0 THEN warn(m_pat)
           d := -1; c := last_char
           pat%(j-1) := range_symbol;           ENDCASE
         CASE rbrac_symbol: UNLESS d >= 0 THEN warn(m_pat)
           pat%(i+1) := j-i;                 RESULTIS(j-i)
         CASE '#': c := internal_code()
         DEFAULT: IF d = -1 THEN
           IF last_char > c THEN
           { pat%(j-1) := c; c := last_char }
           d := d + 1 }S
      pat%j := c }D
   warn(m_patt_too_long) }1

AND get_fm_opnd() BE
/* The operand is either  null,  or  a  string  within  arbitrary
delimiters.  The modifier 'C' is allowed.  */
TEST ~menu_fm THEN RETURN ELSE
{1 // trace("get_fm_opnd:")
   { LET delim, i = ?, 1
     accept_modifier("C")
     next_sig_char()
     TEST terminated_ THEN new_string%0 := 0 ELSE
     { delim := cur_char; get_ch()
       WHILE i < pattern_bsz DO
       { LET c = cur_char; get_ch()
         IF c = delim THEN
         { new_string%0 := i - 1; RETURN }
         IF c = '*N' THEN warn(m_no_close)
         IF c = '#' THEN c := internal_code()
         new_string%i := c
         i := i + 1
       }
       warn(m_new_too_long)
     }
   }
}1

AND get_j_opnd() BE
/* The operand of J is zero, one or two integers.  If  there  are
two,  then  they  are the left verge and the right verge, in that
order, if there is one, then it is the right verge.  */
TEST ~ menu_j THEN RETURN ELSE
{1 LET n = get_int()
   UNLESS 0 < n <= r_margin THEN RETURN
   r_verge := n; IF terminated_ THEN RETURN
   get_ch(); n := get_int()
   UNLESS r_verge < n <= r_margin THEN RETURN
   { l_verge := r_verge; r_verge := n }  }1

AND get_l_opnd() BE
/*  The  operand  is  an  integer, except after ':', when it is a
character, and after 'F', when it is a string (which is  accepted
by 'get_operand'). */
{1 accept_modifier(chef_parameters())
   SWITCHON modifier INTO
   {S CASE 'C':
        no_case_ := ~ no_case_;                   RETURN
      CASE ':': IF menu_j THEN
        {J UNLESS terminated_ THEN
           { centre_symbol := cur_char; get_ch(); ENDCASE }
           warn(m_syntax) }J
      CASE 'L': CASE 'R': CASE 'T':
        UNLESS menu_j THEN warn(m_na)
      CASE carat_symbol: CASE '$':
        r_line1 := get_int() }S }1

AND get_name() BE
/*  This  gets into 'tmp_name' a file name specified after an 'F'
modifier or the  list  of  control  lines  specified  in  an  'S'
command.  */
{1 // trace("get_name:")
   FOR i = 1 TO name_bsz DO
     TEST terminated_ LOGOR cur_char = '*S' THEN
     { tmp_name%0 := i-1; RETURN  }
     ELSE { tmp_name%i := cur_char; get_ch()  }
   warn(m_cmd_too_long) }1

AND get_new(delim) BE
/*  This gets a 'new_string' from the command line up to, but not
including the next non-escaped 'delim'.  It is used to read  part
of  the  operand  after  the  R  operator.   The character '&' is
translated to 'match_symbol'.  */
{1 // trace("get_new:")
 { LET i = 1
   WHILE i <= pattern_bsz DO
   {W LET c = cur_char; get_ch()
      IF c = delim THEN
      { new_string%0 := i-1; RETURN }
      SWITCHON c INTO
      {S CASE '*N': warn(m_no_close)
         CASE '#': c := internal_code();  ENDCASE
         CASE '&': c := match_symbol }S
      new_string%i := c
      i := i + 1 }W
   warn(m_new_too_long) }1

AND get_operand() BE
/* Analyses the modifier and right operand of a command.  In  the
special  case  of  the  'H'  command, the whole line is accepted,
although only the first significant character  following  'H'  is
used.  In the case of a 'QS' command, the entire line is accepted
and is  treated  as a system command.  After the modifier and the
appropriate right operand have been accepted, a check is made for
the command terminator (';' or '*N')  and  an  error  message  is
given if  this  is  not  found.    If  the terminator is ';', the
variable 'concat_state_' is set  to  true  to  prevent  the  null
operator being treated as a 'P' operator.  */
{1 // trace("get_operand:")
 { LET trying_ = FALSE
   r_got, tmp_name%0, tag_char, modifier := 0, 0, null, null
   next_sig_char()
   IF cur_operator = 'H' THEN get_all()
   TEST terminated_ THEN
      SWITCHON cur_operator INTO
      {S CASE '?': CASE 'Q': trying_ := tried_once_;      ENDCASE
         CASE 'L': CASE 'R': CASE 'S': CASE 'W': warn(m_syntax)
         CASE 'F':
         CASE 'M': IF menu_fm THEN new_string%0 := 0;     ENDCASE
         CASE 'X': IF menu_x THEN
                   { copy_string(bol_string, pat)
                     x_state_ := TRUE
                     scan_char := '/'; absence_ := FALSE }
      }S
   ELSE
   {O SWITCHON cur_operator INTO
      {S CASE 'A': IF menu_a THEN
         { IF accept_modifier("A") = 'A' THEN
           { get_right_lines()
             IF r_got = 2 THEN warn(m_syntax) };          ENDCASE
         CASE 'I': CASE 'C':
           UNLESS accept_modifier("DF") = 'F' THEN
                        get_right_lines()
           IF (modifier = null) LOGAND (r_got ~= 0) THEN
                            modifier := 'R';              ENDCASE
         CASE 'B':
           IF menu_u THEN
             UNLESS accept_modifier("I") = 'I' THEN warn(m_undo)
           ENDCASE
         CASE '?': accept_modifier(chef_parameters())
           SWITCHON modifier INTO
           { CASE '/': CASE under_symbol:
             accept_modifier(chef_parameters()) };        ENDCASE
         CASE 'L': get_l_opnd();                          ENDCASE
         CASE 'E': trying_ := tried_once_
         CASE 'N': CASE 'W':
           accept_modifier("F");                          ENDCASE
         CASE 'K': get_right_lines()
            IF r_got = 2 THEN warn(m_syntax);             ENDCASE
         CASE 'F':
         CASE 'M': IF menu_fm THEN
                      get_fm_opnd();                      ENDCASE
         CASE 'P': SWITCHON accept_modifier("ACFLMN") INTO
           {S1 CASE 'L': UNLESS menu_pl THEN warn(m_na)
                                                   ENDCASE
               CASE 'M': TEST menu_pm THEN
               { LET delim = cur_char; get_ch(); get_pat(delim) }
               ELSE warn(m_na)
                                                   ENDCASE
           }S1                                            ENDCASE
         CASE 'Q': accept_modifier("QS")
           SWITCHON modifier INTO
           {S CASE 'Q': UNLESS menu_new THEN warn(m_na);  ENDCASE
              CASE 'S': UNLESS menu_qs THEN warn(m_na)
                get_all()  }S ;                           ENDCASE
         CASE 'R': get_r_opnd()                           ENDCASE
         CASE 'S': TEST ~ menu_control THEN warn(m_na)
           ELSE
           {2 IF terminated_ THEN warn(m_syntax)
              accept_modifier("A")
            { LET delim = cur_char; get_ch(); get_pat(delim)
              next_sig_char(); get_name();                ENDCASE
                                                   }2
         CASE 'T': IF menu_t THEN
           { tag_char := cur_char; get_ch() }             ENDCASE
         CASE 'J': IF menu_j THEN get_j_opnd();           ENDCASE
         CASE 'V': { LET vh = view_half
                  accept_modifier("NP")
                  IF '0' <= cur_char <= '9' THEN vh := get_int()
                  UNLESS terminated_ DO warn(m_syntax)
                  view_half := vh }
                                                          ENDCASE
         CASE 'X': get_x_opnd()
            IF cur_operator = 'Y' LOGAND
               (modifier = 'C' LOGOR modifier = 'A') THEN
                    trying_ := tried_once_
   }S
      IF (modifier = 'F') LOGAND (cur_operator ~= '?') THEN
      { get_name()
        IF (tmp_name%0 = 0) LOGAND (cur_operator ~= 'L') THEN
           warn(m_name)
        IF eq_str(tmp_name, ".") THEN
           copy_string(file_name, tmp_name)  }
      next_sig_char()
      UNLESS terminated_ THEN warn(m_syntax)  }O
   tried_once_ := trying_
   IF cur_char = ';' THEN concat_state_ := TRUE
   no_name_ := (tmp_name%0 = 0)
   UNLESS char_number(cur_operator, "EHLNQUWY?") > 0 THEN
      check_lines()
   IF char_number(cur_operator, "ABCDFIJMR") > 0 THEN
   { UNLESS concat_state_ THEN
       UNLESS menu_x -> x_state_ , FALSE THEN
         UNLESS menu_xf -> xf_state_, FALSE THEN verify_ := TRUE
      UNLESS menu_control -> (l_got = control), FALSE THEN
         altered_ := TRUE } }1

AND get_operator() BE
/* Gets the operator from the command and checks if for validity.
Certain  validity checks of the location specified to the left of
the operator are also performed at this time.  */
{1 // trace("get_operator:")
   next_sig_char()
   IF terminated_ THEN { cur_operator := null; RETURN }
   cur_operator := upper_case(cur_char)
   get_ch()
   UNLESS
      char_number(cur_operator,"ABCDEFHIJKLMNPQRSTUVWXZ?")>0 THEN
     warn(m_syntax)
   SWITCHON cur_operator INTO
   {S CASE 'A': TEST menu_a THEN ENDCASE ELSE warn(m_na)
      CASE 'F':
      CASE 'M': TEST menu_fm THEN ENDCASE ELSE warn(m_na)
      CASE 'J': TEST menu_j THEN ENDCASE ELSE warn(m_na)
      CASE 'N': TEST menu_new THEN ENDCASE ELSE warn(m_na)
      CASE 'S': TEST menu_control THEN ENDCASE ELSE warn(m_na)
      CASE 'T': TEST menu_t THEN ENDCASE ELSE warn(m_na)
      CASE 'U':
      CASE 'B': TEST menu_u THEN ENDCASE ELSE warn(m_na)
      CASE 'Z': TEST menu_z THEN ENDCASE ELSE warn(m_na) }S
   IF l_got ~= 0 THEN
     IF char_number(cur_operator, "EHLNQUW?")>0 THEN warn(m_got1)
   SWITCHON l_got INTO
   {S CASE control: IF menu_control THEN
        IF char_number(cur_operator, "FIJMTVX") > 0 THEN
                   warn(m_control2)
                                                          ENDCASE
      CASE 2:
        IF char_number(cur_operator, "FIKSV") > 0 THEN
                   warn(m_got2) }S
   IF menu_x THEN
     IF x_state_ THEN
       IF char_number(cur_operator, "EHNQUX") > 0 THEN
         warn(m_global)
   IF menu_u THEN
     UNLESS undo_state_ THEN
       IF cur_operator = 'B' THEN warn(m_syntax)   }1

AND get_pat(delim) BE
/*  This  gets  a pattern into 'pat' from the command line, up to
but not including the next non-escaped 'delim'.  A null  pattern,
e.g. //  is  interpreted  as the last pattern remembered, as is a
lone 'delim'.  A non-null pattern, as input, is a sequence of one
or more elements (an element  is  a  character  or  a  class). An
element  may  be  subject  to  closure  by  being  followed by an
asterisk, '*'.  An element subject to closure is stored in  'pat'
as  a 'closure_symbol' followed by that element.  While reading a
pattern,
    i) '.' stands for 'any_symbol',
   ii) '^' stands for 'bol_symbol', if it is the first element,
  iii) '$' stands for 'eol_symbol', if it is the last element,
   iv) '[' and ']' delimit a class,
    v) '~' indicates that the next element matches by exclusion,
   vi) '*' indicates closure of the preceding element,
  vii) '#' causes the next character to escape its special
       meaning.
A  character  ('sentinel'  or  'null' is placed at the end of the
pattern to indicate whether that pattern is 'simple_' or not.   A
pattern is simple if it contains no '.', no class and no closure.
*/
{1 // trace("get_pat:")
 { LET i, simple_ = 1, TRUE
   IF cur_char = delim THEN { get_ch(); RETURN }
   IF cur_char = '*N' THEN RETURN
   WHILE i < pattern_bsz DO
   {W LET c, stride = cur_char, 1
      get_ch() // stride > 1 for a class
      IF c = delim THEN
      { pat%i := simple_ -> sentinel, null
        pat%0 := i; RETURN }
      pat%i := c
      // Now check for special symbol
      SWITCHON c INTO
      {S CASE '*N': warn(m_no_close)
         CASE '.': pat%i := any_symbol
           simple_ := FALSE;                    ENDCASE
         CASE carat_symbol: IF i = 1 THEN
         { pat%1 := bol_symbol; i := 2; LOOP }; ENDCASE
         CASE '#': pat%i := internal_code();    ENDCASE
         CASE '$':
           IF cur_char = delim THEN
           { pat%i := eol_symbol
             IF i = 2 & pat%1 = bol_symbol THEN simple_ := FALSE
             pat%(i+1) := simple_ -> sentinel, null
             pat%0 := i+1; get_ch(); RETURN };    ENDCASE
         CASE '~': CASE lbrac_symbol: IF menu_class THEN
         { stride := get_class(delim, i)
           simple_ := FALSE } }S
      IF menu_closure THEN
        IF accept_char('**') THEN        // shift element right
        { FOR j = i+stride TO i+1 BY -1 DO pat%j := pat%(j-1)
          pat%i := closure_symbol; i := i + 1
          simple_ := FALSE }
      i := i + stride  }W
   warn(m_patt_too_long) }1

AND get_r_opnd() BE
/*  The  operand  may  be  A  (to replace All occurrences), I (to
replace  Interactively),  a  digit  'n'  (to  replace   the   nth
occurrence),  or  null (to replace the first occurrence).  It may
also be L or U, to perform case conversion.  */
{1 // trace("get_r_opnd:")
   { accept_modifier("AILU123456789")
     IF terminated_ THEN warn(m_syntax)
     { LET delim = cur_char; get_ch()
       get_pat(delim)
       SWITCHON modifier INTO
       {S CASE 'L': CASE 'U': TEST menu_rlu THEN RETURN
                              ELSE warn(m_na)
          CASE 'A': CASE null: ENDCASE
          CASE 'I': TEST menu_ri THEN ENDCASE ELSE warn(m_na)
          DEFAULT:  TEST menu_rn THEN ENDCASE ELSE warn(m_na) }S
       get_new(delim) } }1

AND get_x_opnd() BE
/* If the modifier is A, C or F, then the operator is changed  to
Y.   If  the modifier is F, the operand is a file name. Otherwise
it is a pattern, or a tagger, or  null. In  the  null  case,  the
operand is treated as the pattern /^/.  */
{1 UNLESS accept_modifier("ACF") = null THEN cur_operator := 'Y'
   SWITCHON modifier INTO
   {S CASE 'A':
        UNLESS menu_xa THEN warn(m_na)
      CASE 'C':
        UNLESS menu_xc THEN warn(m_na);            ENDCASE
      CASE 'F': TEST menu_xf THEN
      { UNLESS l_got = 0 THEN warn(m_got1)
        IF xf_state_ THEN warn(m_exec)
        xf_state_ := TRUE; RETURN }
      ELSE warn(m_na);                             ENDCASE
      CASE null: TEST menu_x THEN
      { absence_ := accept_char('~')
        scan_char := cur_char; get_ch()
        UNLESS accept_pat_or_tag(scan_char) THEN warn(m_syntax)
        x_state_ := TRUE  }
      ELSE warn(m_na)  }S  }1

.

