
// SECTION "EF4"  // Last modified 83-08-03

/* The procedures in this section deal with the interpretation of
a command.  Except for 'start_ef4', the procedures are listed  in
alphabetic order.  */

GET "ef0.h"

LET start_ef4(n) BE
{ // writes("<>start_ef4:*N")
  check_system(n, computer, 4); start_ef5(n) }

AND altered_line(str,old_str) = VALOF
/*  Called  by  the  A and XA commands to edit the text in 'str',
using the editing  template  in  'line'.   The  vector  'old_str'
remembers the unedited text so that a local 'undo' can take place
if  necessary.   In  'str' there is a margin symbol in position 1
and the text starts in position 2.  Editing characters are:
   'B'        - forces a blank,
   'D'        - deletes a character,
   'I'        - inserts rest of 'line' at position of 'I',
   'O'        - overlays for each non-blank in rest of 'line',
   '%c', '%%' - changes rest of 'line' to text from control 'c'
                  or terminal respectively,
   'U'        - undoes the last edit.
Illegal editing characters cause the remainder of  'line'  to  be
abandoned.  The function yields true if the contents of 'str' are
altered, otherwise false.  */
TEST ~ menu_a THEN RESULTIS FALSE ELSE
{1 LET pos, altered_ = 1, FALSE
   WHILE pos <= line%0 DO
   {W LET c = upper_case(line%pos)
      IF pos = 1 THEN
         SWITCHON c INTO
         {S1 CASE 'O': CASE '%': CASE '*S':
                copy_string(str,old_str);             ENDCASE
             CASE 'U': copy_string(old_str,str)
             DEFAULT: RESULTIS FALSE }S1
      SWITCHON c INTO
      {S DEFAULT: RESULTIS altered_
         CASE 'B':
            str%pos := '*S'; altered_ := TRUE
         CASE '*S': pos := pos + 1;                   ENDCASE
         CASE 'D':
            IF pos <= str%0 THEN
            { copy_bytes(str%0-pos,str,pos+1,str,pos)
              str%0 := str%0 - 1 }
            copy_bytes(line%0-pos,line,pos+1,line,pos)
            line%0 := line%0 - 1
            altered_ := TRUE;                         ENDCASE
         CASE 'I':
         {I LET len = line%0 - pos
            IF pos - 1 > str%0 THEN extend_str(str,pos-1)
            IF len > 0 THEN
            { FOR i = str%0 TO pos BY -1 DO
                 str%(i+len) := str%i
              str%0 := str%0 + len }
            FOR i = pos+1 TO line%0 DO str%(i-1) := line%i
            RESULTIS TRUE }I
         CASE 'O':
            FOR index = pos+1 TO line%0 DO
            {F LET c = line%index
               IF c NE '*S' THEN
               { IF index > str%0 THEN extend_str(str,index)
                 str%index := c
                 altered_ := TRUE } }F
            RESULTIS altered_
         CASE '%': TEST ~ menu_macro THEN RESULTIS altered_
                   ELSE {C
            FOR i = 1 TO 5 DO
            {F1 LET c_l =
                 - uc_char_number(line%(pos+1),control_chars)
                TEST c_l < 0 THEN fetch_line(c_l)
                ELSE TEST line%(pos+1) = '%' THEN
                   UNLESS got_text(FALSE,FALSE) DO recover_eof()
                ELSE RESULTIS altered_
                IF (pos-1+line%0) > line_bsz THEN
                   warn(m_text_too_long)
                FOR j = line%0 TO 1 BY -1 DO
                   line%(j+pos-1) := line%j
                line%0 := line%0 + pos - 1
                UNLESS line%pos = '%' THEN ENDCASE }F1
            warn(m_recursion) }C    }S  }W
   RESULTIS altered_ }1

AND delete_lines(l1, l2, r) BE
/* Deletes the lines of the work-space from 'l1' to 'l2'.  */
{1 UNLESS l2 = last_line THEN
     copy_lines(1+l2, l1, last_line-l2)
   last_line := last_line - r }1

AND do_a() BE
/* Edits each line of the range using an editing template derived
from the terminal or a control or workspace line.  If  'modifier'
is  null,  the template comes from the terminal and each line may
be edited any number of times before passing to the next  with  a
null  edit.   If the modifier is A, a single template from either
the terminal or a control or workspace line edits  all  lines  of
the  range.   'result!0'  is  true  if  a  line has been altered,
'result!1' is true if  the  command  has  been  terminated  by  a
'dot-stop' line.  */
TEST ~ menu_a THEN RETURN ELSE
{1 LET source = (r_got = 0) -> 0, r_line1
   AND one_each_ = (modifier = 'A')
   AND result = VEC 1
   AND old_line = VEC line_csz
   FOR lno = l_line1 TO l_line2 DO
   {F LET first_ = (lno = l_line1)
      UNLESS lno < 0 DO cur_line := lno
      fetch_line(lno)
      edit_line(line,one_each_,source,first_,old_line,result)
      IF result!0 THEN store_line(lno)
      IF result!1 THEN RETURN }F  }1

AND do_c() BE
/* Change  lines  in the given range (default .).  If the operand
is elided, then the new lines come from  the  console.    If  the
modifier  is  'D',  they  come from the work-space and the source
region is deleted after the operation.  If the modifier  is  'F',
the lines  come from the named file.  Set the current line to the
last line inserted.  */
{1 // trace("do_c:")
   TEST menu_control -> l_got = control, FALSE THEN
   {C TEST modifier = null THEN   // control line
        UNLESS got_text(FALSE,FALSE) DO recover_eof()
      ELSE fetch_line(r_line1)
      store_line(l_line1)
      IF modifier = 'D' THEN
         TEST menu_control -> r_got = control, FALSE THEN
         { line%0 := 0; store_line(r_line1)  }
         ELSE delete_lines(r_line1, r_line1, 1)  }C
   ELSE
   {W l_line1 := l_line1 - 1; do_i()               // workspace
    { LET insert_size = cur_line - l_line1
      l_line1 := l_line1 + 1 + insert_size
      l_line2 := l_line2 + insert_size
      delete_lines(l_line1, l_line2, l_range)
      cur_line := l_line1 - 1 }W }1

AND do_d() BE
/* Delete the lines in the given range (default .)  and  set  the
current  line to the next line beyond the deletion, if it exists,
otherwise to the last line.  */
{1 // trace("do_d:")
   TEST menu_control -> (l_got = control), FALSE THEN
   { line%0 := 0; store_line(l_line1) }
   ELSE
   {W delete_lines(l_line1, l_line2, l_range)
      cur_line :=
        (l_line1 <= last_line) -> l_line1, last_line }W }1

AND do_e() BE
/* Empty the workspace. The value of 'tmp_name' sets the name  of
the current file, which is read if its name is not null.  */
{1 // trace("do_e:")
   IF altered_ LOGAND ~ tried_once_ THEN guard_file()
   empty_work_space(); init_work_space(TRUE)  }1

AND do_f() BE
/*  Folds the line specified by 'l_line1' at a point specified by
the user, creating a new workspace line.  If the modifier  is  C,
then the leading blanks are removed from the second new line.  If
the  operand  is  a  string,  then that string is prefixed to the
second new line.  The existing line is first displayed  to  guide
the  user,  who  positions the cursor at the character that is to
start the new line.  */
TEST ~ menu_fm THEN RETURN ELSE
{1 LET str = VEC line_csz
   fetch_line(l_line1); copy_string(line, str)
   cur_line := l_line1
   UNLESS got_editing_line(0, str) THEN RETURN
 { LET head = line%0
   IF (head > str%0) THEN extend_str(str, head)
 { LET tail = str%0 - head
   LET pfx  = new_string%0
   copy_bytes(head, str, 1, line, 1); line%0 := head
   store_line(l_line1)
   l_line2 := l_line1 + 1; cur_line := l_line2
   IF menu_t THEN cur_tag := null
   IF modifier = 'C' THEN
     FOR i = head+1 TO str%0 DO
       TEST str%i = '*S' THEN
       { tail := tail - 1; head := head + 1 } ELSE BREAK
   IF pfx + tail > line_bsz THEN warn(m_text_too_long)
   copy_string(new_string, line)
   copy_bytes(tail, str, head+1, line, pfx+1); line%0 := tail+pfx
   expand(cur_line, 1); store_line(cur_line) }1

AND do_h() BE
/*  Print the help message associated with the first character of
the operand, default '0'.  */
{1 // trace("do_h:")
   put_msg(no_name_ -> '0', tmp_name%1) }1

AND do_i() BE
/* Insert new lines into the work-space after 'l_line1'  and  set
'cur_line' to  the last line inserted.  The operands on the right
are the same as for the 'C' operator.  */
{1 // trace("do_i:")
   SWITCHON modifier INTO
   {S CASE 'F':
        TEST no_name_ THEN warn(m_name) ELSE read_file(tmp_name)
                                                    ENDCASE
      CASE 'R': CASE 'D':
        TEST menu_control -> r_got = control, FALSE THEN
        {C cur_line := l_line1 + 1
           expand(cur_line, 1)
           fetch_line(r_line1)
           store_line(cur_line)
           IF modifier = 'D' THEN
           { line%0 := 0; store_line(r_line1) } }C
        ELSE
        { LET p = 1 + l_line1
          expand(p, r_range)
          IF l_line1 < r_line1 THEN
          { r_line1 := r_line1 + r_range
            r_line2 := r_line2 + r_range }
          copy_lines(r_line1, p, r_range)
          cur_line := l_line1 + r_range
          IF modifier = 'D' THEN
          { delete_lines(r_line1, r_line2, r_range)
            IF r_line2 <= l_line1 THEN
              cur_line := cur_line - r_range } }
                                                   ENDCASE
      CASE null: insert_lines(TRUE) }S }1

AND do_l() BE
/* This loads the various  system  parameters  according  to  the
modifier given. */
{1 // trace("do_l:")
   SWITCHON modifier INTO
   {S CASE 'F': copy_string(tmp_name, file_name);   ENDCASE
      CASE 'L': TEST menu_j THEN
      {J TEST 1 <= r_line1 <= r_verge THEN
         { l_verge := r_line1;              ENDCASE }
         ELSE warn(m_combination) }J ELSE warn(m_na)
      CASE 'P': prefix_on_ := ~ prefix_on_;         RETURN
      CASE 'R': TEST menu_j THEN
      {J TEST l_verge <= r_line1 <= line_bsz THEN
         { r_verge := r_line1;              ENDCASE }
          ELSE warn(m_combination) }J ELSE warn(m_na)
      CASE 'T': TEST menu_j THEN
      {J TEST 1 <= r_line1 <= r_verge - l_verge + 1 THEN
         { threshold := r_line1;            ENDCASE }
         ELSE warn(m_combination) }J ELSE warn(m_na)
      CASE 'V': verify_on_ := ~ verify_on_;         ENDCASE
      CASE carat_symbol:
        UNLESS 1<= r_line1 <=r_margin THEN warn(m_combination)
        l_margin := r_line1;                        ENDCASE
      CASE '$':
        UNLESS l_margin <= r_line1 <= line_bsz THEN
                        warn(m_combination)
        r_margin := r_line1;                        ENDCASE }S
    do_query() }1

AND do_m() BE
/*  Merge  the  lines  in  the  given  range  (default .) and set
'cur_line' to the merged line. If  'new_string'  is  non-null,  a
copy  of  it  is  inserted  at each join. If the modifier is 'C',
intervening spaces and tabs are removed. All tags are cleared. */
TEST ~ menu_fm THEN RETURN ELSE
{1 // trace("do_m:")
  { LET mbuf = VEC line_csz AND llen, blen, first = ?, ?, ?
    AND nlen = new_string%0
    mbuf%0 := 0
    FOR i = l_line1 to l_line2 DO
    { fetch_line(i)
      llen := line%0; first := 1; blen := mbuf%0
      IF i = l_line2 THEN nlen := 0
      IF modifier = 'C' THEN
      { IF i NE l_line2 THEN
          FOR j = llen TO 1 BY -1 DO
          { IF '*T' NE line%j NE '*S' BREAK; llen := j-1 }
        IF i NE l_line1 THEN
        { FOR j = 1 to llen DO
          { IF '*T' NE line%j NE '*S' BREAK; first := j+1 }
          llen := llen-first+1
        }
      }
      IF llen + blen + nlen > line_bsz THEN warn(m_text_too_long)
      copy_bytes(llen, line, first, mbuf, blen + 1)
      IF nlen NE 0 THEN
         copy_bytes(nlen, new_string, 1, mbuf, blen + llen + 1)
      mbuf%0 := llen + blen + nlen
    }
    copy_string(mbuf, line)
    IF menu_t THEN cur_tag := null
    store_line(l_line1)
    UNLESS l_line1 = l_line2 DO
       delete_lines(l_line1+1, l_line2, l_range-1)
    cur_line := l_line1
  }
}1

AND do_n() BE
/*  Stack the current workspace and start a new one. The value of
'tmp_name' sets the name of the current file, which  is  read  if
its name is not null.  */
TEST ~menu_new THEN RETURN ELSE
{1 // trace("do_n:")
   stack_work_space(); init_work_space(FALSE)  }1

AND do_null() BE
/* If the command is on a line of its own, the null  operator  is
treated  as  'P', except that the current line is advanced by one
if the  location  is  elided.     When   several   commands   are
concatenated, a null operator causes 'cur_line' to be set without
printing  if  the location is in the work-space, but a control is
printed.  */
{1 // trace("do_null:")
   IF menu_control -> l_got = control, FALSE THEN
     { do_p(); RETURN }
   TEST concat_state_ LOGOR (last_line = 0) THEN
     cur_line := l_line2
   ELSE
   {NC IF l_got = 0 THEN
      { IF l_line1 = last_line THEN l_line1, l_line2 := 0, 0
        l_line1 := l_line1 + 1; l_line2 := l_line2 + 1  }
      do_p()   }NC }1

AND do_p() BE
/* Print the lines of the given range (default .).  */
{1 // trace("do_p:")
   IF modifier = 'N' THEN
     UNLESS menu_control -> l_got = control, FALSE THEN
     { writen(l_line1)
       IF l_got = 2 THEN writef(",%N", l_line2)
       newline(); RETURN }
 { LET file_ = FALSE
   LET out_mode = VALOF
     SWITCHON modifier INTO
     {S CASE null: RESULTIS text_only
        CASE 'A': RESULTIS text_numbered
        CASE 'L': IF menu_pl THEN RESULTIS text_lucid
        CASE 'M': IF menu_pm THEN RESULTIS match_positions
        CASE 'F': IF no_name_ THEN warn(m_name)
           file_ := TRUE; RESULTIS text_counted
        CASE 'C': RESULTIS byte_count_only  }S
   write_out(out_mode, file_)
   UNLESS l_line2 < 0 THEN cur_line := l_line2  }1

AND do_q() BE
/* With modifier S, this causes a temporary exit to the operating
system. Otherwise  it  unstacks  the  current workspace (modifier
null) or all workspaces (modifier Q).  */
{1 IF menu_qs THEN
     IF modifier = 'S' THEN { do_sys_call(); RETURN  }
   IF altered_ LOGAND ~ tried_once_ THEN guard_file()
   WHILE unstack_work_space() DO
   { writef("file: %S*N", file_name)
     IF modifier = null THEN RETURN
     IF altered_ LOGAND ~ tried_once_ THEN guard_file() }
   TEST menu_dynamic THEN transfer(quit) ELSE
   longjump(lvl, quit) }1

AND do_query() BE
/* When the operand is null, print the warning message associated
with  'warn_code'. Otherwise  print  information corresponding to
the command modifier.  */
{1 SWITCHON modifier INTO
   {S CASE 'F': writef("file: %S", file_name);    ENDCASE
      CASE 'T': TEST menu_j THEN
        { writef("T%N", threshold);               ENDCASE }
        ELSE warn(m_na)
      CASE 'L': TEST menu_j THEN
        { writef("L%N", l_verge);                 ENDCASE }
        ELSE warn(m_na)
      CASE 'P': writes(prefix_on_ -> "On", "Off");ENDCASE
      CASE 'R': IF menu_j THEN
        { writef("R%N", r_verge);                 ENDCASE }
      CASE ':': TEST menu_j THEN
        { writef(":%C", centre_symbol);           ENDCASE }
        ELSE warn(m_na)
      CASE 'V': writes(verify_on_ -> "On", "Off");ENDCASE
      CASE carat_symbol: writef("%C%N", carat_symbol, l_margin)
                                                  ENDCASE
      CASE '$': writef("$%N", r_margin);          ENDCASE
      CASE 'C': writes(no_case_ -> "On", "Off");  ENDCASE
      CASE '/': CASE under_symbol: display_pat(); ENDCASE
      DEFAULT: put_msg(warn_code)
         warn_code := m_told;                     RETURN
   }S
   newline()
}1

AND do_r() BE
/*  For  each  line in the given range (default .) substitute the
new text for the pattern matched.  If the modifier is 'A' or 'I',
then do this for all occurrences on the line,  rather  than  just
the  first.  If the modifier is 'I', ask the user to confirm each
substitution before it is made. If the modifier is a single
decimal digit, substitute for the appropriate occurrence of the
pattern, otherwise substitute for the first occurrence.  */
{1 // trace("do_r:")
   { LET interactive_ = menu_ri -> (modifier = 'I'), FALSE
     AND occurrence = 1
     IF menu_rn THEN
        IF '1'<=modifier<='9' THEN occurrence := modifier-'0'
     substitute(modifier = 'A' LOGOR interactive_,
                (menu_ri -> interactive_, FALSE), occurrence)
   }
}1

AND do_s() BE
/* Segment the specified line using 'pat' and store the  segments
in control  lines.   If the modifier is 'A' then the segments are
defined by all occurrences of 'pat' rather than just  the  first.
*/
TEST ~ menu_control THEN RETURN ELSE
  split_line(l_line1, modifier = 'A')

AND do_t() BE
/* Mark the lines in the given range (default .) with the operand
(which is a character).  Set the current line to the last line so
marked.  */
TEST ~ menu_t THEN RETURN ELSE
{1 // trace("do_t:")
   FOR i = l_line1 TO l_line2 DO
   { fetch_line(i); cur_tag := tag_char
     store_line(i); check_interrupt() }
   cur_line := l_line2 }1

AND do_v() BE
/* If there is no  modifier,  display  the  lines  in  the  range
l_line1-view_half  to  l_line1+view_half  and  set  'cur_line' to
'l_line1'.  If the modifier is 'P' (Previous), set 'cur_line'  to
'l_line1'    and    display    the    lines    in    the    range
'l_line1-2*view_half' to  'l_line1'.   If  the  modifier  is  'N'
(Next), set 'cur_line' to 'l_line1+2*view_half+1' and display the
lines in the the range 'l_line1+1' to 'cur_line'.  */
{1 LET low, high = ?, ?
   cur_line := l_line1
   SWITCHON modifier INTO
   { CASE null: low, high := l_line1-view_half, l_line1+view_half
                ENDCASE
     CASE 'P':  low, high := l_line1-2*view_half, l_line1
                ENDCASE
     CASE 'N':  low, high := l_line1+1, l_line1+2*view_half+1
                cur_line := (high > last_line) -> last_line, high
                ENDCASE
   }
   l_line1 := (low < 1) -> 1, low
   l_line2 := (high > last_line) -> last_line, high
   write_out(text_view, FALSE) }1

AND do_w() BE
/*  Write  the  entire  workspace  to  the  file   specified   in
'tmp_name'. */
{1 // trace("do_w:")
   IF no_name_ THEN warn(m_name)
   l_line1, l_line2 := 1, last_line
   write_out(text_counted, TRUE)
   altered_ := FALSE  }1

AND do_x() BE
/*  Execute  the remainder of the command line repeatedly for all
lines of the region matching the specified pattern  ('x_state'  =
'/' or  '\')  or  tagger  ('x_state'  =  '''  or '"').  Execution
proceeds forwards in  terms  of  line  number  for  '/'  or  ''',
backwards for '\' or '"'.  */
TEST ~ menu_x THEN RETURN ELSE
{1 // trace("do_x:")
 { LET count = flagged_lines()
   AND step = (scan_char='/' LOGOR scan_char='*'') -> +1, -1
   LET this_line = (step>0 -> l_line1, l_line2) - step
   LET cmd_string = VEC line_csz
   copy_string(cmd_line, cmd_string)
   FOR i = 1 TO count DO
   {FOR_i
     LET remainder = last_line    // for safety
     check_interrupt()
     {R this_line := this_line + step
        UNLESS 1 <= this_line <= last_line THEN
          this_line := (step=+1) -> 1, last_line
        IF was_flagged(this_line) THEN
        {T cur_line := this_line; cmd(cmd_string,FALSE)
           BREAK  }T         // break from the }R repeat
        remainder := remainder - 1       // perhaps deletion
        IF remainder < 0 THEN GOTO out }R
     REPEAT }FOR_i
   out: x_state_ := FALSE }1

AND do_xa() BE
/*  Modifies  the  command  saved  in  'old_cmd' using an editing
template from the terminal, then submits it for execution  unless
inhibited by a 'dot_stop' line.  */
TEST ~ menu_xa THEN RETURN ELSE
{1 LET result = VEC 1
   AND old_line = VEC 1
   edit_line(old_cmd,FALSE,0,TRUE,old_line,result)
   UNLESS result!1 DO cmd(old_cmd,TRUE) }1

AND do_xc() BE
/* Re-executes the last stored command.  */
TEST ~ menu_xc THEN RETURN ELSE
{1 // trace("do_xc:")
   IF xc_state_ THEN warn(m_exec)
   xc_state_ := TRUE
   cmd(old_cmd,FALSE)
   xc_state_ := FALSE }1

AND do_xf() BE
/* Opens the file specified by the right operand and executes the
commands in it.  */
TEST ~ menu_xf THEN RETURN ELSE
{1 // trace("do_xf:")
   IF no_name_ THEN warn(m_name)
 { LET exec_stream = find_in_file(tmp_name, 0)
   AND cur_in_stream = input()
   AND save_cmd = VEC line_csz
   copy_string(cmd_line,save_cmd)
   UNLESS valid_stream(exec_stream) THEN warn(m_access)
   selectinput(exec_stream); xf_state_ := TRUE
   WHILE got_text(FALSE, FALSE) DO cmd(line,FALSE)
   xf_state_ := FALSE; endread()
   selectinput(cur_in_stream)
   IF save_cmd%0 NE 0 THEN cmd(save_cmd,TRUE)  }1

AND edit_line(text,one_each_,source,first_,old_line,result) BE
/* Performs one or more edits of 'text' using an editing template
from  the  terminal  if 'source = 0' or otherwise from 'r_line1'.
If 'one_each' is true, only a single edit is done.  If 'first' is
true, the line to be edited is the first of the range. The vector
'old_line' holds the editing template if the same edit is  to  be
carried  out  once on all lines of the range.  'result!0' is true
if the line is altered, and 'result!1'  is  true  if  editing  is
terminated by a 'dot-stop' line.  */
TEST ~ menu_a THEN RETURN ELSE
{1 LET str = VEC line_csz
   AND old_str = VEC line_csz
   result!0 := FALSE
   copy_bytes(text%0,text,1,str,2)
   str%0, str%1 := text%0 + 1, margin_symbol
   copy_string(str,old_str)
   {R TEST one_each_ LOGAND ~ first_ THEN
      { copy_string(old_line,line)
        result!1 := FALSE }
      ELSE result!1 := ~ got_editing_line(source,str)
      IF one_each_ LOGAND first_ THEN
         copy_string(line,old_line)
      IF result!1 LOGOR (line%0 = 0) THEN BREAK
      IF altered_line(str,old_str) THEN result!0 := TRUE
   }R REPEATUNTIL one_each_
   IF result!0 THEN
   { copy_bytes(str%0-1,str,2,text,1)
     text%0 := str%0 - 1  }  }1

AND expand(index, size) BE
/* Expand the line pointers starting at 'index' and  then  moving
all forward by 'size' cells.  Then correct 'last_line'.  */
{1 // trace("expand: index=%N size=%N", index, size)
   IF last_line + size > file_lsz THEN warn(m_over)
   copy_lines(index, index+size, last_line-index+1)
   last_line := last_line + size }1

AND extend_str(str,len) BE
/* Extends the string 'str' to a length 'len' by adding blanks if
necessary. */
TEST ~ menu_a LOGAND ~ menu_fm THEN RETURN ELSE
{1 FOR i = str%0 + 1 TO len DO str%i := '*S'
   str%0 := len  }1

AND flagged_lines() = VALOF
/*  Flag  the  lines  to  be considered with the operator X, i,e,
those that match the pattern or tagger.    Yield  the  number  of
lines so flagged.  */
TEST ~ menu_x THEN RESULTIS 0 ELSE
{1 // trace("flagged_lines:")
 { LET count = 0
   FOR i = l_line1 TO l_line2 DO
   {D fetch_line(i); check_interrupt()
      { LET found_ = VALOF
        SWITCHON scan_char INTO
        {S CASE '*'': CASE accent_grave:
             IF menu_t THEN RESULTIS cur_tag = test_tag
           DEFAULT: RESULTIS scan_line(l_margin) > 0 }S
        IF found_ NEQV absence_ THEN
        { flag_the_line(i); count := count + 1 } }D
   IF count <= 0 THEN warn(m_not_found)
   RESULTIS count }1

AND got_editing_line(source,str) = VALOF
/* Obtains an editing template for use by the A, F or XA commands
from  either  the  terminal (source = 0) or the line specified by
'source'.  If the template comes from the terminal, the  contents
of  'str'  are  displayed  first  as  a  guide  to the user.  The
function returns true unless a 'dot_stop' line  is  entered  from
the terminal.  */
TEST ~ menu_a LOGAND ~ menu_fm THEN RESULTIS FALSE ELSE
{1 LET save_tag = menu_t -> cur_tag, ?
TEST (source = 0) THEN
   { IF input() = console_in_stream THEN writef("%S*N",str)
     { LET res = got_text(FALSE,TRUE)
       IF menu_t THEN cur_tag := save_tag
       RESULTIS res } }
   ELSE
   { fetch_line(source)
     IF menu_t THEN cur_tag := save_tag
     RESULTIS TRUE } }1

AND guard_file() BE
/* If the file has been altered, then warn the user.  */
 {1 tried_once_ := TRUE
    writef("file: %S*N", file_name)
    warn(m_quit) }1

AND insert_lines(dot_stop_) BE
/*  Insert  text after 'l_line1', stopping at a dot stop line, if
'dot_stop_' is true, otherwise at an end of file.  Set 'cur_line'
to the last line inserted.  */
{1 // trace("insert_lines:")
   reset_byte_count()
   cur_line := l_line1
   WHILE got_text(FALSE, dot_stop_) DO
   { cur_line := cur_line + 1
     IF w_space = 0 THEN make_space(TRUE)
     add_byte_count(store_line(cur_line)) }
   IF w_space > 0 THEN make_space(FALSE)
   IF cur_line = 0 THEN verify_ := FALSE }1

AND interpret() BE
/* Interpret the operator in 'cur_operator'.  */
{1 /* trace("interpret:")
     UNLESS eq_str(file_name, "") THEN {
   writef(" l_got=%N l_line1=%N l_line2=%N l_range=%N*N",
            l_got,   l_line1,   l_line2,   l_range)
   writef(" r_got=%N r_line1=%N r_line2=%N r_range=%N*N",
            r_got,   r_line1,   r_line2,   r_range)
   writef(" cur_line=%N cur_tag=%C cur_operator=%C(%N),*
         * modifier=%C*N",cur_line,cur_tag,cur_operator,
         cur_operator,modifier)
   writes("pattern="); display_pat()
   writef(" new_string=/%S/*N", new_string)
   writef(" altered_=%N xf_state_=%N*N", altered_, xf_state_)  }
*/
 { LET op, mdf = cur_operator, menu_u -> modifier, ?
   IF menu_u THEN pre_trail()
   SWITCHON cur_operator INTO
   {S CASE 'A': IF menu_a THEN do_a(); ENDCASE
      CASE 'B': IF menu_u THEN do_b(); ENDCASE
      CASE 'C': do_c(); ENDCASE
      CASE 'D': do_d(); ENDCASE
      CASE 'E': do_e(); ENDCASE
      CASE 'F': IF menu_fm THEN do_f(); ENDCASE
      CASE 'H': do_h(); ENDCASE
      CASE 'I': do_i(); ENDCASE
      CASE 'J': IF menu_j THEN do_j(); ENDCASE
      CASE 'K': do_k(); ENDCASE
      CASE 'L': do_l(); ENDCASE
      CASE 'M': IF menu_fm THEN do_m(); ENDCASE
      CASE 'N': IF menu_new THEN do_n(); ENDCASE
      CASE 'P': do_p(); ENDCASE
      CASE 'Q': do_q(); ENDCASE
      CASE 'R': do_r(); ENDCASE
      CASE 'S': IF menu_control THEN do_s(); ENDCASE
      CASE 'T': IF menu_t THEN do_t(); ENDCASE
      CASE 'U': IF menu_u THEN do_u(); ENDCASE
      CASE 'V': do_v(); ENDCASE
      CASE 'W': do_w(); ENDCASE
      CASE 'X': IF menu_x THEN do_x(); ENDCASE
      CASE 'Y': IF menu_xc LOGOR menu_xf THEN
        SWITCHON modifier INTO
      {T CASE 'A': IF menu_xa THEN do_xa(); ENDCASE
         CASE 'C': IF menu_xc THEN do_xc(); ENDCASE
         CASE 'F': IF menu_xf THEN do_xf()  }T
                        ENDCASE
      CASE 'Z': IF menu_z THEN do_z(); ENDCASE
      CASE null: do_null(); ENDCASE
      CASE '?': do_query() }S
   IF menu_u THEN post_trail(op,mdf)
   IF verify_ LOGAND verify_on_ THEN
     UNLESS last_line = 0 LOGOR
            (menu_control -> l_got = control, FALSE) THEN
       TEST menu_control THEN
       { fetch_line(-char_number('+', control_chars))
         cmd(line,FALSE) }
       ELSE cmd(echo_string(),FALSE)  }1

.

