
// SECTION "EF7"  // Last modified 88-02-07

/* The routines in this section  are  concerned  with  input  and
output  of  lines  of  text to files or devices, with the initial
opening and final closing  of  files,  and  with  help  messages.
Except for 'start_ef7', these are listed in alphabetic order.  */

GET "ef0.h"

GET "syshdr.h"

LET start_ef7(n) BE
{1 // writes("<>start_ef7:*N")
   msg_table!0 := FALSE
   warn_code := '0'
   check_system(n, computer, 7); start_ef8(n) }1

LET dot_stop_line() = VALOF
/* This yields true if 'line' has only  one  non-blank  character
which is a dot, '.', in position one.  */
{1 // trace("dot_stop_line:")
   IF line%0 > 0 LOGAND line%1 = '.' THEN
   {2 FOR i = 2 TO line%0 DO
        UNLESS line%i = '*S' THEN RESULTIS FALSE
      RESULTIS TRUE }2
   RESULTIS FALSE  }1

AND get_msg_directory() = VALOF
/* Open the message file and read its  directory,  then  set  the
first cell of 'msg_table' to the value TRUE, to indicate that the
directory  has  been  installed.   The format of the message file
directory is:

   d k
   e1, e2, ... ek
   c1 m1 ... cz mz _
   where d is the position of the first error message
         k is the number of error messages
         ei is the size of the i-th error message
         mi is the size of the help message associated with
            the character ci.

See  EF12  for  a  program to produce a directory.  This function
yields  TRUE  if  the  message  file  was  opened   successfully;
othwerwise it yields FALSE.  */
{1 LET m_f = name_of_msg_file()
   msg_in_stream := find_in_file(m_f, msg_pswd)
   UNLESS valid_stream(msg_in_stream) THEN
   { LET cur_out_stream = output()
     selectoutput(console_out_stream)
     writes("Help/message file not available.*N")
     selectoutput(cur_out_stream)
     RESULTIS FALSE }
 { LET in = input(); selectinput(msg_in_stream)
 { LET n = readn()
   LET k = readn()
   FOR j = 1 TO k DO { msg_table ! j := n; n := n + readn() }
   help_table ! 0, warn_code := n, '0'
 { LET c = ? AND i = 0
   {R c := rdch() REPEATWHILE c = '*S' LOGOR c = '*N'
      IF c = '_' THEN { alpha%0 := i; BREAK }
      i := i + 1; alpha%i , help_table ! i := c, n
      n := n + readn() }R   REPEAT
   IF sys_mts LOGOR sys_470 THEN rewind()
   msg_table!0 := TRUE; selectinput(in)
   RESULTIS TRUE }1

AND got_text(pfx_, dot_stop_) = VALOF
/*  If  'pfx_' is true, then console input is prompted with a '>'
character (unless prefix_on_ is FALSE). The routine reads a  line
of text into 'line', yielding false if end of file is encountered
or  (if  'dot_stop_'  is true) a dot stop line is encountered. (A
dot stop line has only one non-blank character, a '.' in position
1.) */
{1 // trace("got_text:")
   check_interrupt()
   IF input() = console_in_stream THEN
     show_prefix(prefix_on_ LOGAND pfx_)
   IF menu_t THEN cur_tag := null
  TEST sys_emas THEN
  { LET c = readrec(line,line_bsz)
    IF c < 0 THEN
    { IF c = -154 THEN warn(m_input_too_long)
      line%0 := 0
      RESULTIS FALSE
    }
  }
  ELSE TEST sys_unix32 THEN
  { LET c = readrec(line,line_bsz)
    IF c = 0 & result2 = 100 THEN warn(m_input_too_long)
    IF c < 0 THEN
    { line%0 := 0
      RESULTIS FALSE
    }
  }
  ELSE
 { LET i, c, console_ = 1, rdch(), (input() = console_in_stream)
   UNTIL c = '*N' DO
   {U IF c = endstreamch THEN { line%0 := 0; RESULTIS FALSE }
      IF sys_vms THEN
        IF c = 0 & result2 = rms$_tns THEN warn(m_input_too_long)
      IF i > line_bsz THEN warn(m_input_too_long)
      line%i := c
      IF console_ THEN SWITCHON c INTO
      {S CASE delete_symbol: i := accept_delete(i); ENDCASE
         CASE tab_symbol:    i := accept_tab(i) }S
      i := i + 1
      c := rdch() }U
   line%0 := i - 1 }
   RESULTIS dot_stop_ -> ~ dot_stop_line(), TRUE }1

AND out_line(lno, out_mode) BE
/* Send the string 'line' to  the  current  output  stream.    If
'lno>0', then precede the text with a line number and the tag, if
any.     */
{1 // trace("out_line: lno=%N out_mode=%N*N", lno, out_mode)
   LET pos = ~ menu_pm -> 1,
      (modifier = 'M') -> scan_line(l_margin,pat), 1
   AND n = 0
   IF lno > 0 LOGAND pos > 0 THEN out_lno(lno,out_mode)
   SWITCHON out_mode INTO
   {S CASE byte_count_only:                       ENDCASE
      CASE match_positions: IF menu_pm THEN
        WHILE pos > 0 DO
        {W n := n + 1; writef("%N ",pos)
           IF n = 20 THEN
           { newline(); out_lno(lno,out_mode); n := 0 }
           TEST len_match = 0 THEN BREAK
           ELSE pos := scan_line(pos+len_match,pat) }W
                                                  ENDCASE
      DEFAULT: n := sys_emas \/ sys_unix32 -> 0, 1
        TEST sys_emas \/ sys_unix32 THEN
        { LET ec = sys_emas -> 0, 1
          TEST menu_pl THEN
             TEST out_mode = text_lucid THEN
             { FOR i = 1 to line%0 DO dump(line%i)
               n := 1
             }
             ELSE
               ec := writerec(line)
          ELSE ec := writerec(line)
          IF sys_emas THEN IF ec < 0 THEN warn(m_access)
          IF sys_unix32 THEN IF ec = 0 THEN warn(m_write)
        }
        ELSE TEST sys_cpm THEN
        {C FOR i = 1 TO line%0 DO
           {F LET ch, ec = line%i, 1
              TEST menu_pl THEN
                TEST out_mode = text_lucid THEN dump(ch)
                ELSE ec := wrch(ch)
              ELSE ec := wrch(ch)
              IF ec = 0 THEN warn(m_write) }F }C
        ELSE
        { FOR i = 1 TO line%0 DO
          {F LET ch = line%i
             TEST menu_pl THEN
               TEST out_mode = text_lucid THEN dump(ch)
               ELSE wrch(ch)
             ELSE wrch(ch) }F } }S
   IF n > 0 THEN newline() }1

AND out_lines(out_mode) BE
/*  Send  the  lines  of  the range 'l_line1' to 'l_line2' to the
currently selected output stream.  If 'lno_' is true, then  print
the line number and the tag, if any.  For  the  other  parameters
see 'out_line'. */
{1 // trace("out_lines: out_mode=%N*N", out_mode)
   LET numbered_ = (out_mode = text_view) LOGOR
     (menu_pm -> ((out_mode = text_numbered) LOGOR
                (out_mode = match_positions)),
                (out_mode = text_numbered))
   reset_byte_count()
   FOR i = l_line1 TO l_line2 DO
   {F check_interrupt(); fetch_line(i)
      add_byte_count(1 + line%0)
      out_line((numbered_ -> i, 0), out_mode) }F }1

AND out_lno(lno,out_mode) BE
/*  Send  the  line  number  and  the tag, if any, to the current
output stream.  If 'out_mode' =  'text_view',  flag  the  current
line with '*'. */
{1 // trace("out_lno: lno=%N out_mode=%N*N", lno, out_mode)
   writed(lno, number_bsz)
   wrch(out_mode=text_view LOGAND lno=cur_line -> '**', ' ')
   TEST menu_t THEN wrch(cur_tag = null -> '*S', cur_tag)
   ELSE wrch('*S')
   wrch(margin_symbol) }1

AND postlude() BE
/* Close all files and destroy the work file.  */
{1 // trace("postlude:")
   IF msg_table ! 0 THEN
   { selectinput(msg_in_stream); endread() }
   end_work_file() }1

AND put_msg(n) BE
/*  Print the message corresponding to 'n'.  If n < 0, then it is
an error message, otherwise  it  is  a  help  message.   Printing
continues until a dot-stop line is encountered.  */
{1 // trace("put_msg: n=%N", n)
   UNLESS msg_table!0 THEN UNLESS get_msg_directory() RETURN
   n := (n < 0) -> msg_table!(-n),
                   help_table!uc_char_number(n,alpha)
 { LET cur_in_stream = input()
   selectinput(msg_in_stream)
   make_indexed(msg_in_stream);set_file_position(msg_in_stream,n)
   WHILE got_text(FALSE, TRUE) DO
   {R make_sequential(msg_in_stream)
      out_line(0, text_only)
      check_interrupt() }R
   selectinput(cur_in_stream) }1

AND read_file(name) BE
/*  Read  the  file 'name' into the work space.  */
{1 // trace("read_file: name=%S", name)
 { LET n = find_in_file(name, 0)
   AND cur_in_stream = input()
   UNLESS valid_stream(n) THEN warn(m_access)
   selectinput(n)
   insert_lines(FALSE); bell()
   endread()
   selectinput(cur_in_stream)
   print_byte_count() }1

AND write_out(out_mode, file_) BE
/* Write out the lines in the range 'l_line1' to 'l_line2'.   The
values of 'out_mode' are:-
  text_counted     (text and byte count)
  text_only
  text_lucid       (unprintable characters in octal or hex)
  text_numbered    (text with line numbers)
  text_view        (windowed, line numbers, 'cur_line' marker)
  byte_count_only
  match_positions
If  'file_'  is  true,  output  is  to  a  file, otherwise to the
console.  */
{1 // trace("write_out: out_mode=%N, file_=%N", out_mode, file_)
 { LET count_out_ = file_ LOGOR (out_mode = byte_count_only)
   IF file_ THEN
   { LET stream = create_file(tmp_name, 0, 3)
     selectoutput(stream); no_out_trim_or_control(stream)  }
   out_lines(out_mode)
   IF file_ THEN
   { endwrite()
     IF sys_emas THEN e.movefile(tmp_name)
     selectoutput(console_out_stream); bell() }
   IF count_out_ THEN print_byte_count() }1

 .
