
// SECTION "EF9"  // Last modified 83-05-31

/* This section is concerned with text justification.  Except for
'start_ef9', the routines are listed in alphabetic order.  */

GET "ef0.h"

STATIC
{ centred_   = ?     // centering flag
  dir_       = TRUE  // justification direction switch
  inbuf      = ?     // input buffer
  inp        = ?     // input line index
  llval      = ?     // final length of justified line
  outbuf     = ?     // output buffer
  outwds     = ?     // number of words currently in outbuf
  frozen_    = TRUE  // remembers a line to be frozen
  wrdbuf     = ?     // word buffer
  tag1       = ?     // original tag on first line of region
  tag2       = ? }   // original tag on last line of region

LET start_ef9(n) BE
{1 // writes("<>start_ef9:")
   IF menu_j THEN
   { l_verge, r_verge, threshold, centre_symbol := 1, 65, 6, ':'
     IF init_statics_ THEN
     { dir_ := TRUE
       frozen_ := TRUE } }
     check_system(n, computer, 9)
   start_ef10(n) }1

AND brk() BE
/* End current filled line.  */
TEST ~ menu_j THEN RETURN ELSE
{ IF outbuf%0 > 0 THEN put(outbuf)
  outbuf%0, outwds := 0, 0 }

AND do_j() BE
/* This is the main call to this section.  */
TEST ~ menu_j THEN RETURN ELSE
{1 // trace("do_j:")
 { LET v1 = VEC line_csz
   AND v2 = VEC line_csz
   AND v3 = VEC line_csz
   inbuf, wrdbuf, outbuf := v1, v2, v3
   cur_line := l_line2
   outbuf%0, outwds := 0, 0
   llval := r_verge - l_verge + 1
   FOR i = l_line1 TO l_line2 DO process_line(i)
   brk()   // Force out last line.
   IF w_space > 0 THEN make_space(FALSE)
   fetch_line(cur_line)
   IF menu_t THEN cur_tag := tag2
   store_line(cur_line)
   delete_lines(l_line1, l_line2, l_range)
   cur_line := cur_line - l_range }1

AND getword() = VALOF
/*  Get  a  non-blank word from 'inbuf' to 'wrdbuf' and yield the
length of the word.  Also freeze (replace by null) a blank  which
follows  a  sentence  ending  character,  and  regard such a null
character as part of the word. This means  that  sentence  ending
characters  should  be  followed  by  two blanks (or end of line)
otherwise that word will be concatenated with the following  word
(as in "Mr. J. B. Smith").  */
TEST menu_j THEN
{1 // writes("getword:*N")
   UNLESS next_word() THEN RESULTIS 0
 { LET j = 0
   {r UNTIL (inp > inbuf%0) LOGOR (inbuf%inp = '*S') DO
      { j := j + 1; wrdbuf%j := inbuf%inp; inp := inp + 1 }
      SWITCHON wrdbuf%j INTO
      {s DEFAULT: BREAK                            // Normal case
         CASE '.': CASE '?': CASE '!': CASE ':':
         /* Sentence termination chars, change following blank
            to the null character and continue.  */
         { j := j + 1; inp := inp + 1; wrdbuf%j := null } }s }r
   REPEAT
   wrdbuf%0 := j; RESULTIS j }1
ELSE RESULTIS 0

AND next_word() = VALOF
/* If there is a word following, 'inp' is advanced to its first
character and true is yielded; otherwise false.  */
TEST menu_j THEN
{1 FOR i = inp TO inbuf%0 DO
     UNLESS inbuf%i = '*S' THEN { inp := i; RESULTIS TRUE }
   RESULTIS FALSE }1
ELSE RESULTIS FALSE

AND process_line(i) BE
/*  Fetch  the i-th line into 'inbuf' for justification. The text
is picked up beginning at 'l_margin' or  at  the  first  nonblank
character,  whichever  is  first. Text  is  not  picked up beyond
'r_margin'.  If the first character picked is the 'centre_symbol'
and subsequent indentation is beyond  the  threshold,  then  that
symbol is replaced by a blank and 'centred_' is set to true.  Any
indented  (or centred) text has its leading blanks frozen, and if
indentation is beyond the 'threshold', then  the  whole  line  is
frozen.  This freezing is accomplished by replacing the blanks by
the  'null'  character.   Before  processing starts, the previous
line is flushed (brk()) if the last was frozen or if the  current
line is indented or centred.  */
TEST ~ menu_j THEN RETURN ELSE
{1 fetch_line(i)
   IF menu_t THEN
   { IF i = l_line1 THEN tag1 := cur_tag
     IF i = l_line2 THEN tag2 := cur_tag }
 { LET line_len = line%0
   LET first = l_margin
   IF line_len > r_margin THEN line_len := r_margin
   FOR i = 1 TO l_margin DO           // Set 'first'
   {2 IF i > line_len THEN { first := 1; BREAK }
      UNLESS line%i = '*S' THEN { first := i; BREAK } }2
 { LET len = line_len - (first - 1)  // working characters
   copy_bytes(len, line, first, inbuf, 1)
   IF len <= 0 THEN { len := 1; inbuf%1 := '*S' }
   inbuf%0 := len
   IF frozen_ THEN brk()
   centred_ := (inbuf%1 = centre_symbol)     // centre?
   TEST centred_ LOGOR inbuf%1 = '*S' THEN // freeze?
   {t frozen_ := TRUE
      FOR i = 2 TO (threshold+1) DO
      {f IF i > len THEN { centred_ := FALSE; BREAK }
     IF inbuf%i ~= '*S' THEN
     { frozen_, centred_ := FALSE, FALSE; BREAK } }f }t
   ELSE frozen_ := FALSE
   IF centred_ THEN inbuf%1 := '*S'
   IF inbuf%1 = '*S' THEN                   // freeze characters
   {i brk()
      FOR i = 1 TO len DO
        TEST inbuf%i = '*S' THEN inbuf%i := null
        ELSE UNLESS frozen_ THEN BREAK }i
   inp := 1
   WHILE getword() > 0 DO putword() }1

AND put(buf) BE
/* Put out text line.  */
TEST ~ menu_j THEN RETURN ELSE
{1 // trace("put:")
 { LET out_len = buf%0 AND lvm1 = l_verge - 1
   IF lvm1 + out_len >= line_bsz THEN lvm1 := line_bsz - out_len
   FOR i = 1 TO lvm1 DO line%i := '*S'
   FOR i = 1 TO out_len DO
   { LET c = buf%i; line%(i+lvm1) := (c=null) -> '*S', c }
   line%0 := out_len + lvm1
   FOR i = line%0 TO 1 BY -1 DO
      TEST line%i = '*S' THEN line%0 := i - 1 ELSE BREAK
   cur_line := cur_line + 1
   IF menu_t THEN cur_tag := cur_line = l_line2 + 1 -> tag1, null
   IF w_space = 0 THEN make_space(TRUE)
   store_line(cur_line) }1

AND putword() BE
/* Put a word into 'outbuf'.  */
TEST ~ menu_j THEN RETURN ELSE
{1 // trace("putword:")
   IF wrdbuf%1 = null THEN brk()
 { LET wrd_w = wrdbuf%0           // width of current word
   AND out_w = outbuf%0           // width of outbuf
   AND sig_ch = 1 AND cnt_ch = 1  // for centring
   LET test_w = (wrdbuf%wrd_w = null) -> wrd_w - 1, wrd_w
   UNLESS frozen_ THEN
   IF (out_w > 0) LOGAND (out_w + test_w > llval) THEN
   { // too big for line, right justify
     LET j = out_w - 1            // ignore spacing blank
     IF outbuf%j = null THEN j := j - 1  // remove sentence blank
     outbuf%0 := j                // correct outbuf width
     spread()
     brk() }                      // flush line
   IF centred_ THEN
   { WHILE (wrdbuf%sig_ch = null) DO sig_ch := sig_ch + 1
     cnt_ch :=  1+(llval+sig_ch-wrd_w)/2
     IF cnt_ch < 1 THEN cnt_ch := 1 }
   FOR i = 1 TO cnt_ch-1 DO outbuf%i := '*S'
   copy_bytes(wrd_w-sig_ch+1, wrdbuf,
     sig_ch, outbuf, cnt_ch+outbuf%0)
   outbuf%0 :=
     outbuf%0 + 1 + wrd_w + cnt_ch - sig_ch  // wrd_w >= sig_ch
   outbuf%(outbuf%0) := '*S'      // space between words
   outwds := outwds + 1 }1

AND spread() BE
/* Spread words to justify right margin.  */
TEST ~ menu_j THEN RETURN ELSE
{ LET nholes = outwds - 1 // Number of holes to fill.
  LET i = outbuf%0        // Indexes old position.
  LET nextra = llval - i  // Number of extra spaces needed.
  LET j = llval           // Indexes new position.
  UNLESS (nextra > 0) LOGAND (outwds > 1) RETURN
  dir_ := ~ dir_        // Reverse previous justify direction.
  outbuf%0 := llval
  WHILE nextra > 0 DO     // Move one byte at a time.
  { outbuf%j := outbuf%i
    IF outbuf%i = '*S' THEN
    { LET nspaces =
        dir_ -> ((nextra-1)/nholes + 1), (nextra/nholes)
      nextra, nholes := nextra - nspaces, nholes - 1
      WHILE nspaces > 0 DO
      { j := j - 1; nspaces := nspaces - 1
        outbuf%j := '*S' } }
    i := i - 1; j := j - 1 } }

.

