/*                  The Christchurch Edit Facility
                            Version  4.8
                             1983-10-25

   Copyright  (C)  J.  E.  L.  Peck,  Vancouver,  M.  A. Maclean,
Christchurch.  Additions by R.D. Eager, Canterbury, England.

         This part contains declarations  of  manifest  constants
used throughout the editor.  */

GET "LIBHDR"

MANIFEST
 { version    = 4800
   mts.sys    = version + 1   //  MTS on Amdahl 470
   unix.sys   = version + 2   //  UNIX on PDP11 (UBC)
   unix1.sys  = version + 3   //  UNIX on PDP11 (UKC)
   rdos.sys   = version + 4   //  RDOS on NOVA or ECLIPSE
   aos.sys    = version + 5   //  AOS on ECLIPSE
   fmgr.sys   = version + 6   //  FMGR on HP21MX
   emas.sys   = version + 7   //  EMAS on ICL 2900
   unix32.sys = version + 8   //  UNIX on VAX11
   slim.470   = version + 9   //  SLIM on Amdahl 470
   tripos.sys = version + 10  //  TRIPOS on PDP11
   prime.sys  = version + 11  //  Prime in Christchurch
   cpm.sys    = version + 12  //  CP/M on Z80
   vms.sys    = version + 13  //  VMS on VAX11
   msdos.sys  = version + 14  //  MSDOS on Victor 9000 (Sirius)

/*  For generation of the editor for a particular machine, change
the following constant and be sure to check the file 'SYSHDR'.
******************************************************************
***/                    computer = emas.sys                   /***
******************************************************************

   The following declarations enable one to select, from  a  menu
of  features, those which are to be incorporated into the editor.
Consult EF13 for a more extended description.
*/

   menu_class   = TRUE        // Character classes
   menu_closure = TRUE        // Closure in patterns
   menu_dsplpat = TRUE        // Display reconstructed pattern
   menu_fm      = TRUE        // The operators F and M
   menu_j       = TRUE        // The operator J
   menu_macro   = TRUE        // Control line macro expansion
   menu_new     = TRUE        // The operator N
   menu_pl      = TRUE        // The operator PL
   menu_pm      = TRUE        // The operator PM
   menu_qs      = TRUE        // Return for system command
   menu_ri      = TRUE        // The operator RI
   menu_rlu     = TRUE        // The operators RL and RU
   menu_rn      = TRUE        // Numbers after the R operator
   menu_screen  = TRUE        // The A operator with screen mode
   menu_t       = TRUE        // The operator T
   menu_u       = TRUE        // The operator U
   menu_x       = TRUE        // The operator X
   menu_xa      = TRUE        // The operator XA
   menu_xf      = TRUE        // Execute from a file
   menu_z       = FALSE       // The operator Z
   menu_a       = TRUE LOGOR  // The operator A
        menu_xa
   menu_control = TRUE LOGOR  // Control store option
        menu_macro
   menu_xc      = TRUE LOGOR  // The operator XC
        menu_xa

   menu_dynamic = FALSE       // For dynamic SLIM

   menu_ovl     = FALSE       // Overlay parts of code

/* The following decides which computer to generate code for.  */

   sys_mts    = (computer = mts.sys)    // IBM 360/370 under MTS
   sys_unix   = (computer = unix.sys)   // PDP11 under UNIX (UBC)
   sys_unix1  = (computer = unix1.sys)  // PDP11 under UNIX (UKC)
   sys_rdos   = (computer = rdos.sys)   // DG Nova under RDOS
   sys_aos    = (computer = aos.sys)    // DG Eclipse under RDOS
   sys_fmgr   = (computer = fmgr.sys)   // HP21MX under FMGR
   sys_emas   = (computer = emas.sys)   // ICL 2900 under EMAS
   sys_unix32 = (computer = unix32.sys) // VAX11 under UNIX
   sys_470    = (computer = slim.470)   // SLIM on the Amdahl 470
   sys_tripos = (computer = tripos.sys) // PDP11 under TRIPOS
   sys_prime  = (computer = prime.sys)  // Prime in Christchurch
   sys_cpm    = (computer = cpm.sys)    // Z80 under CP/M
   sys_vms    = (computer = vms.sys)    // VAX11 under VMS
   sys_msdos  = (computer = msdos.sys)  // Victor 9000 and Sirius

   hex_        = sys_mts LOGOR
                 sys_470 LOGOR
                 sys_emas LOGOR
                 sys_cpm LOGOR
                 sys_unix1 LOGOR
                 sys_unix32 LOGOR
                 sys_vms
   ascii_      = ~ (sys_mts LOGOR sys_470)
   hp_unit     = 1

/*  The  following  constant  determines  whether  or not certain
STATIC variables  are  to  be  re-initialised  on  entry  to  the
editor. This  may  be  necessary  if  the  editor is to be re-run
without being reloaded on some systems. */ 

   init_statics_ = sys_emas -> TRUE, FALSE

/* As explained fully in EF13, the capacity and efficiency of the
editor can be influenced by an appropriate choice of:
   a) the number of bytes per grab (grab_bsz)
        because the size (in bytes)  of  the  file  that  can  be
        edited will  be approximately 'max_int * grab_bsz'.  On a
        16 bit machine in which 'max_int =  32767'  a  choice  of
        'grab_bsz  =  4'  will  allow for 131,068 bytes, which is
        probably ample.
   b) the number of grabs per block (block_gsz)
        because lines are stored in memory in a  buffer  of  this
        size  and  the  larger  the  buffer  the  more  lines are
        available without disc access.  It is probably convenient
        to  make  'block_gsz * grab_bsz' equal to the appropriate
        block transfer of bytes to a file in your system.

   The following constants define the sizes of various vectors or
   strings used by the editor.  The notation used is:
               x_csz   =  size of x in cells,
               x_bsz   =  size of x in bytes,
               x_gsz   =  size of x in grabs,
               x_lsz   =  size of x in lines,
               x_nsz   =  x as a number.
                                                                */
   // Critical size constants

   grab_bsz     =  sys_mts LOGOR
                   sys_470 LOGOR
                   sys_emas LOGOR
                   sys_unix32 LOGOR
                   sys_vms -> 1, 4  // bytes per grab
   block_gsz    =  sys_rdos -> 128,    // grabs per file block
                   sys_aos -> 128,
                   sys_unix -> 128,
                   sys_unix1 -> 128,
                   sys_mts -> 256,
                   sys_470 -> 256,
                   sys_emas -> 512,
                   sys_cpm -> 32,
                   sys_tripos -> 128,
                   sys_vms -> 512,
                   sys_unix32 -> 1024, 64  // grabs per block

   buffer_nsz   =  sys_msdos -> 55,    // number of block buffers
                   sys_emas -> 60,
                   sys_unix32 -> 60,
                                 4

   control_lsz  =  menu_control -> 27, 0 // lines in control store

   max_int      =  sys_mts -> 999999999,
                   sys_470 -> 999999999,
                   sys_emas -> 8388607,
                   sys_vms -> 2147483647,
                   sys_unix32 -> 2147483647, 32767
   file_lsz     =  max_int  // lines per file
   msg_csz      =  38  // upper bound of number of error messages

   // Byte sizes

   alpha_bsz    =  64   // upper bound of help characters
   block_bsz    =  block_gsz * grab_bsz // bytes per block
   cell_bsz     =  sys_mts LOGOR   // bytes per BCPL cell
                   sys_470 LOGOR
                   sys_emas LOGOR
                   sys_unix32 LOGOR
                   sys_vms -> 4, 2
   legend_bsz   =  80
   line_bsz     =  sys_aos LOGOR   // characters per line
                   sys_rdos -> 128,
                   sys_vms -> 240,
                              248
   name_bsz     =  sys_emas -> 127,
                   sys_tripos LOGOR
                   sys_unix1 -> 64,
                   sys_vms -> 248,
                   sys_unix32 -> 248, 32 // characters per file name
                                         // also used by H and QS
   pattern_bsz  =  sys_emas LOGOR
                   sys_unix1 LOGOR
                   sys_vms LOGOR
                   sys_unix32 -> 128, 64
                   // characters per pattern or replacement string
   trail_bsz    =  menu_u -> 22, 0 // chars in undo command line
   number_bsz   =  sys_mts LOGOR
                   sys_470 LOGOR
                   sys_emas LOGOR
                   sys_unix32 -> 4,
                   sys_cpm LOGOR
                   sys_tripos LOGOR
                   sys_unix1 LOGOR
                   sys_vms -> 5, 6 // chars for line numbers

   // Cell sizes

   alpha_csz    = alpha_bsz / cell_bsz
   block_csz    = block_bsz / cell_bsz
   caps_vec_csz = menu_screen -> (sys_rdos -> 256, 350), 0
   line_csz     = line_bsz / cell_bsz
   name_csz     = name_bsz / cell_bsz
   pattern_csz  = pattern_bsz / cell_bsz
   trail_csz    = trail_bsz / cell_bsz

   /* Note that the following conditions should hold:-
      name_csz + pattern_csz + 6 <= line_csz   */

   // Grab sizes (used in EF6)

   line_gsz     = (line_bsz + 2 + grab_bsz - 1)/grab_bsz

/* The following constants are necessary because of differences
between EBCDIC and ASCII.  */

   accent_grave    =  ascii_ -> #O042, #X7F // alternate "
   lbrac_symbol    =  ascii_ -> #O133, #X4C // left square bracket
   carat_symbol    =  ascii_ -> #O136, #X7C // alternate @
   delete_symbol   =  ascii_ -> #O177, #X07
   rbrac_symbol    =  ascii_ -> #O135, #X6E // right square bracket
   margin_symbol   =  ascii_ -> #O174, #X4F // backslash or stick
   tab_symbol      =  ascii_ -> #O011, #X05
   under_symbol    =  ascii_ -> #O134, #XBA // backslash

/* The following constants use values which are unprintable  both
in EBCDIC and in ASCII.  These are needed for the internal coding
of patterns.   */

   any_symbol      =  234        // .
   match_symbol    =  235        // &
   bol_symbol      =  237        // ^
   eol_symbol      =  238        // $
   closure_symbol  =  250        // *
   include_symbol  =  251        // inclusive class
   exclude_symbol  =  252        // (~) exclusive class
   range_symbol    =  253        // [
   sentinel        =  254        // for fast pattern match

/* Miscellaneous.  */

   msg_pswd = 777; null = 0; control = -1

/* Overlay sections.  */
   o_syntax   = 0          // SECTION "EF3"  Syntactic analysis
   o_screen   = 1          // SECTION "EF4a" Operator A
   o_justify  = 2          // SECTION "EF9"  Operator J
   o_extra    = 3          // SECTION "EF7b" Extras

/* Parameters used by 'out_line' in EF7, computed in EF3. */

   text_counted    = 1     // W(~dummy_f) PF(~dummy_f)
   text_only       = 2     // P
   text_lucid      = 3     // PL
   text_numbered   = 4     // PA
   text_view       = 5     // V
   byte_count_only = 6     // W(dummy_f)  PF(dummy_f)
   match_positions = 7     // PM

/* Parameters used by 'move_windows' of EF6.  */

   w_backup        = 1     // store backup grabs for undo.
   w_restore       = 2     // restore grabs for undo.
   w_enlarge       = 3     // make another empty window.

/* Constants used for screen-mode editing.  */
  // Internal capability encoding
   cap_al = 256 +  1   // Add new blank line  (insert_line)
   cap_am = 256 +  2   // Automatic margins
   cap_ce = 256 +  3   // Clear to end of line
   cap_cl = 256 +  4   // Clear screen (scr_clear)
   cap_cm = 256 +  5   // Cursor motion (set_cursor)
   cap_co = 256 +  6   // Number of columns in a line
   cap_cr = 256 +  7   // Carriage return
   cap_dc = 256 +  8   // Delete character (ch_delete)
   cap_dl = 256 +  9   // Delete line (line_delete)
   cap_do = 256 + 10   // Down one line (line feed)
   cap_ei = 256 + 11   // End insert mode
   cap_ho = 256 + 12   // Cursor home
   cap_ic = 256 + 13   // Insert character (ch_insert)
   cap_is = 256 + 14   // Initialize terminal
   cap_im = 256 + 15   // Insert mode
   cap_k0 = 256 + 16   // Function 0 (exit)
   cap_k1 = 256 + 17   // Function 1 (renew)
   cap_k2 = 256 + 18   // Function 2 (merge)
   cap_k3 = 256 + 19   // Function 3 (mark)
   cap_k4 = 256 + 20   // Function 4 (save)
   cap_k5 = 256 + 21   // Function 5 (inject)
   cap_kb = 256 + 22   // Backspace
   cap_kd = 256 + 23   // Cursor down
   cap_ke = 256 + 24   // Disable keypad
   cap_kl = 256 + 25   // Cursor left
   cap_kr = 256 + 26   // Cursor right
   cap_ks = 256 + 27   // Enable keypad
   cap_ku = 256 + 28   // Cursor up
   cap_li = 256 + 29   // Number of lines
   cap_lg = 256 + 30   // Legend (CHEF only)
   cap_rb = 256 + 31   // Rubout or Delete (CHEF only)
   cap_se = 256 + 32   // End stand out mode (lowlight)
   cap_so = 256 + 33   // Start stand out mode (highlight)
   cap_wl = 256 + 34   // Skip to next word left
   cap_wr = 256 + 35   // Skip to next word right
   cap_sz = 35         // Max number of capabilities
   pvec_csz = (cap_sz+cell_bsz)/cell_bsz
   svec_bsz = (caps_vec_csz - pvec_csz)*cell_bsz
   left_edge       = 512 +  18  // Cursor at left edge
   right_edge      = 512 +  19  // Cursor at right edge
   left_fault      = 512 +  20  // Cursor at start of line
   right_fault     = 512 +  21  // Cursor at end of line
   legend_on       = 512 +  23  // Display legend
   legend_off      = 512 +  24  // Erase legend
   /* Screen action characters.  */
   bell_ch               =  07

/*  The  following  constants  give  the  positions  of the error
messages in the message file.  */

   m_attn           = -1
   m_control        = -2
   m_empty          = -3
   m_end            = -4
   m_exec           = -5
   m_finder         = -6
   m_global         = -7
   m_got1           = -8
   m_got2           = -9
   m_access         = -10
   m_line1          = -11
   m_line2          = -12
   m_tag            = -13
   m_name           = -14
   m_no_close       = -15
   m_not_found      = -16
   m_over           = -17
   m_overlap        = -18
   m_pat            = -19
   m_quit           = -20
   m_range          = -21
   m_syntax         = -22
   m_control2       = -23
   m_told           = -24
   m_patt_too_long  = -25
   m_value          = -26
   m_undo           = -27
   m_recursion      = -28
   m_no_undo        = -29
   m_cmd_too_long   = -30
   m_text_too_long  = -31
   m_new_too_long   = -32
   m_input_too_long = -33
   m_na             = -34
   m_split_control  = -35
   m_combination    = -36
   m_write          = -37
   m_screen_name    = -38
}

MANIFEST
{ gpb = sys_unix LOGOR sys_emas -> 120,
        sys_unix32 -> 113,
        sys_tripos -> 150,
        sys_vms -> 105,
        100   // base of global procedures
  gvb = gpb + 126 }            // base of global variables

GLOBAL
{  // procedures. ----------------
   accept_char:            gpb + 000
   accept_delete:          gpb + 001
   accept_pat_or_tag:      gpb + 002
   accept_tab:             gpb + 003
   add_byte_count:         gpb + 004
   bell:                   gpb + 005
   char_number:            gpb + 006
   check_blocks:           gpb + 007
   check_interrupt:        gpb + 008
   check_system:           gpb + 009
   chef_parameters:        gpb + 010
   clear_all_flags:        gpb + 011
   cmd:                    gpb + 012
   copy_bytes:             gpb + 013
   copy_cells:             gpb + 014
   copy_lines:             gpb + 015
   copy_string:            gpb + 016
   create_file:            gpb + 017
   delete_lines:           gpb + 018
   display_one:            gpb + 019
   display_pat:            gpb + 020
   do_a:                   gpb + 021
   do_b:                   gpb + 022
   do_e:                   gpb + 023
   do_h:                   gpb + 024
   do_j:                   gpb + 025
   do_k:                   gpb + 026
   do_l:                   gpb + 027
   do_m:                   gpb + 028
   do_q:                   gpb + 029
   do_query:               gpb + 030
   do_s:                   gpb + 031
   do_sys_call:            gpb + 032
   do_t:                   gpb + 033
   do_u:                   gpb + 034
   do_w:                   gpb + 035
   do_xa:                  gpb + 036
   do_z:                   gpb + 037
   dump:                   gpb + 038
   echo_string:            gpb + 039
   empty_work_space:       gpb + 040
   end_work_file:          gpb + 041
   eq_str:                 gpb + 042
   err:                    gpb + 043
   expand:                 gpb + 044
   extend_str:             gpb + 045
   fetch_grab:             gpb + 046
   fetch_line:             gpb + 047
   find_in_file:           gpb + 048
   find_out_file:          gpb + 049
   find_work_file:         gpb + 050
   fix_attention:          gpb + 051
   flag_the_line:          gpb + 052
   gchar:                  gpb + 053
   get_captab:             gpb + 054
   get_ch:                 gpb + 055
   get_int:                gpb + 056
   get_left_lines:         gpb + 057
   get_operand:            gpb + 058
   get_overlay:            gpb + 059
   get_operator:           gpb + 060
   get_param:              gpb + 061
   get_right_lines:        gpb + 062
   got_template:           gpb + 063
   got_text:               gpb + 064
   gt_screen_name:         gpb + 065
   init_work_space:        gpb + 066
   insert_lines:           gpb + 067
   internal_code:          gpb + 068
   interpret:              gpb + 069
   make_indexed:           gpb + 070
   make_sequential:        gpb + 071
   make_space:             gpb + 072
   move_windows:           gpb + 073
   name_of_msg_file:       gpb + 074
   name_of_work_file:      gpb + 075
   next_sig_char:          gpb + 076
   no_out_trim_or_control: gpb + 077
   no_trim:                gpb + 078
   out_line:               gpb + 079
   out_lines:              gpb + 080
   postlude:               gpb + 081
   post_trail:             gpb + 082
   pre_trail:              gpb + 083
   prefix_length:          gpb + 084
   print_byte_count:       gpb + 085
   put_msg:                gpb + 086
   put_terminal:           gpb + 087
   qmatch:                 gpb + 088
   raw_terminal:           gpb + 089
   read_file:              gpb + 090
   recover:                gpb + 091
   recover_eof:            gpb + 092
   reset_byte_count:       gpb + 093
   restore_block:          gpb + 094
   save_block:             gpb + 095
   set_file_position:      gpb + 096
   skip_word:              gpb + 097
   split_line:             gpb + 098
   stack_work_space:       gpb + 099
   start_ef2:              gpb + 100
   start_ef3:              gpb + 101
   start_ef4:              gpb + 102
   start_ef4a:             gpb + 103
   start_ef5:              gpb + 104
   start_ef6:              gpb + 105
   start_ef7:              gpb + 106
   start_ef7a:             gpb + 107
   start_ef7b:             gpb + 108
   start_ef8:              gpb + 109
   start_ef9:              gpb + 110
   start_ef10:             gpb + 111
   store_line:             gpb + 112
   substitute:             gpb + 113
   scan_file:              gpb + 114
   scan_line:              gpb + 115
   terminal_action:        gpb + 116
   trace:                  gpb + 117
   uc_char_number:         gpb + 118
   unget_ch:               gpb + 119
   unstack_work_space:     gpb + 120
   upper_case:             gpb + 121
   valid_stream:           gpb + 122
   warn:                   gpb + 123
   was_flagged:            gpb + 124
   write_out:              gpb + 125
   // variables. -----------------
   absence_:               gvb + 000
   alpha:                  gvb + 001
   altered_:               gvb + 002
   bol_string:             gvb + 003
   caps_vec:               gvb + 004
   centre_symbol:          gvb + 005
   cmd_line:               gvb + 006
   concat_state_:          gvb + 007
   console_in_stream:      gvb + 008
   console_out_stream:     gvb + 009
   control_chars:          gvb + 010
   cur_cap:                gvb + 011
   cur_char:               gvb + 012
   cur_line:               gvb + 013
   cur_operator:           gvb + 014
   cur_tag:                gvb + 015
   cursor_x:               gvb + 016
   cursor_y:               gvb + 017
   file_name:              gvb + 018
   g1vec:                  gvb + 019
   g2vec:                  gvb + 020
   g3vec:                  gvb + 021
   help_table:             gvb + 022
   impotent_:              gvb + 023
   insert_mode_:           gvb + 024
   in_screen_:             gvb + 025
   l_got:                  gvb + 026
   l_line1:                gvb + 027
   l_line2:                gvb + 028
   l_margin:               gvb + 029
   l_range:                gvb + 030
   l_verge:                gvb + 031
   last_line:              gvb + 032
   legend:                 gvb + 033
   len_match:              gvb + 034
   line:                   gvb + 035
   lvl:                    gvb + 036
   modifier:               gvb + 037
   msg_in_stream:          gvb + 038
   msg_table:              gvb + 039
   new_string:             gvb + 040
   no_cap_al_:             gvb + 041
   no_case_:               gvb + 042
   no_name_:               gvb + 043
   old_cmd:                gvb + 044
   pat:                    gvb + 045
   prefix_on_:             gvb + 046
   quit:                   gvb + 047
   r_got:                  gvb + 048
   r_line1:                gvb + 049
   r_line2:                gvb + 050
   r_margin:               gvb + 051
   r_range:                gvb + 052
   r_verge:                gvb + 053
   re_try:                 gvb + 054
   scan_char:              gvb + 055
   screen_cols:            gvb + 056
   screen_name:            gvb + 057
   screen_rows:            gvb + 058
   screen_shift:           gvb + 059
   simple_:                gvb + 060
   tag_char:               gvb + 061
   terminated_:            gvb + 062
   test_tag:               gvb + 063
   threshold:              gvb + 064
   tmp_name:               gvb + 065
   trail_line:             gvb + 066
   tried_once_:            gvb + 067
   undo_state_:            gvb + 068
   verify_:                gvb + 069
   verify_on_:             gvb + 070
   view_half:              gvb + 071
   x_state_:               gvb + 072
   xc_state_:              gvb + 073
   xf_state_:              gvb + 074
   w_space:                gvb + 075
   warn_code:              gvb + 076
   work_in_stream:         gvb + 077
   work_out_stream:        gvb + 078
   work_space:             gvb + 079 }

