
// SECTION "EF1"  // Last modified 83-10-18

SECTION "C#MAIN"

/*  The  procedures in this section deal with the reservation and
initialization of variables which are common to  all  procedures.
It  contains the main driving procedure 'start' and the beginning
of  the  section-checking  chain  'start_ef1'  It  also  contains
warning  and  error routines. Except for 'start' and 'start_ef1',
the procedures are listed in alphabetic order.  */

GET "CHEF_EF0"

GET "GO_SYSHDR"

LET start(p1, p2, p3) BE
/* The main driving routine.  */
{1 LET v = VEC alpha_csz; alpha := v
 { LET v = VEC alpha_bsz; help_table := v
 { LET v = VEC line_csz; cmd_line := v
 { LET v = VEC menu_xc -> line_csz, 0
      IF menu_xc THEN old_cmd := v
 { LET v = VEC line_csz; line := v
 { LET v = VEC msg_csz; msg_table := v
 { LET v = VEC pattern_csz; new_string := v
 { LET v = VEC pattern_csz + name_csz + 1
      pat := v; file_name := v + pattern_csz + 1
 { LET v = VEC name_csz; tmp_name := v
 { LET v = VEC trail_csz
      IF menu_u THEN trail_line := v
 { LET vr = VEC menu_dynamic -> 2, 0
 { LET vq = VEC menu_dynamic -> 2, 0
 { LET v = VEC (3+block_csz)*buffer_nsz +
     (menu_control -> 1+control_lsz, 0)
     work_space := v
 { LET v = VEC 3/cell_bsz; bol_string := v
   bol_string%0 := 2; bol_string%1 := bol_symbol
   bol_string%2 := sentinel
 { LET v = VEC menu_screen -> caps_vec_csz, 0
      IF menu_screen THEN { caps_vec := v; caps_vec%0 := 0 }
 { LET v = VEC menu_screen -> legend_bsz/cell_bsz, 0
      IF menu_screen THEN legend := v
   // writes("<>start:*N")
   re_try := menu_dynamic -> vr, j1
   quit := menu_dynamic -> vq, j2
   TEST ~ menu_dynamic THEN lvl := level()
   ELSE { remember(re_try,j1); remember(quit,j2) }
   control_chars :=
     menu_control -> "ABCDEFGHIJKLMNOPQRSTUVWXYZ+", ""
   start_ef1(computer)
   get_param(p1, p2, p3)
   no_name_ := (tmp_name%0 = 0)
   init_work_space(FALSE)
   TEST cmd_line%0 > 0 THEN cmd(cmd_line,FALSE)
   ELSE writes("Enter H for help (Q for quit)*N")
 j1: {R TEST got_text(TRUE, FALSE) THEN cmd(line,TRUE)
        ELSE recover_eof()  }R  REPEAT
 j2: IF menu_ovl THEN get_overlay(o_extra)
     postlude()   }1

AND start_ef1(n) BE
/*  This  is  called  once  by  'start'  and  does  the necessary
initialization of variables.  It is the start of a chain of calls
to initialize it and check that compilation is compatible.  */
{1 // writes("<>start_ef1:*N")
   console_out_stream := output()
   IF menu_t THEN cur_tag := null
   IF menu_xc THEN copy_string(";",old_cmd)
   modifier := null
   msg_table!0 := -1   // message file not open yet
   l_margin, r_margin, len_match := 1, line_bsz, 0
   prefix_on_, no_case_, verify_on_ := TRUE, FALSE, TRUE
   start_ef2(n)
   recover()   }1

AND check_system(n1, n2, n3) BE
/* Check that the compilations are compatible,  otherwise  abort.
*/
  UNLESS n1 = n2 THEN err("system %N %N ef%N*N", n1, n2, n3)

AND err(fmt, a, b) BE
/* Write an error message.  This should not occur.  */
{1 selectoutput(console_out_stream)
   writes("This error message should not occur.*N")
   writef(fmt, a, b)
   writes("*NPlease show this to the CHEF Maintainer.*N")
   IF menu_ovl THEN get_overlay(o_extra)
   postlude()
   TEST sys_emas THEN stop(1000) ELSE 
   TEST sys_unix1 LOGOR sys_unix32 LOGOR sys_cpm THEN stop(255)
   ELSE TEST sys_tripos THEN stop(20) ELSE
   TEST sys_vms THEN stop(1) ELSE
   FINISH }1

AND init_work_space(save_pat_) BE
/* This is called to initialize a fresh workspace and possibly to
read in a file.  */
{1 // trace("init_work_space:")
   altered_, tried_once_ := FALSE, FALSE
   cur_line, last_line, l_line1 := 0, 0, 0
   UNLESS save_pat_ THEN copy_string(bol_string, pat)
   copy_string(tmp_name, file_name)
   IF modifier = 'F' LOGAND no_name_ THEN warn(m_name)
   UNLESS no_name_ THEN
   { IF menu_ovl THEN get_overlay(o_extra)
     read_file(file_name) }
   IF sys_emas THEN
   { IF entry_reason NE e.reason_edit THEN
     { no_name_ := TRUE; file_name%0 := 0 }
     entry_reason := e.reason_edit   // No difference after this
   }
}1

AND recover() BE
/* This is called by 'warn', 'check_interrupt' and 'start_ef1' to
reset  critical  global variables and to ensure that there are no
flagged lines.  */
{1 // trace("recover:")
   IF menu_xc THEN xc_state_ := FALSE
   IF menu_xf THEN xf_state_ := FALSE
   IF menu_u THEN undo_state_ := FALSE
   IF menu_x THEN
     IF x_state_ THEN
     {X x_state_ := FALSE; clear_all_flags() }X
   IF w_space > 0 THEN make_space(FALSE) }1

AND trace(fmt, a, b, c, d, e, f, g) BE
/* A program tracing feature for software development.  */
{1 LET o = output()
   selectoutput(console_out_stream)
   writef(fmt, a, b, c, d, e, f, g); newline()
   selectoutput(o) }1

AND warn(n) BE
/* Display '?' for a warning and set 'warn_code' to  'n'.    Then
call  'recover'  to reset globals and then request a new command.
*/
{1 // trace("warn: n=%N", n)
 { LET cur_in_stream = input()
   UNLESS cur_in_stream = console_in_stream LOGOR
     cur_in_stream = msg_in_stream THEN endread()
   selectinput(console_in_stream)
   UNLESS output() = console_out_stream THEN
   { endwrite(); selectoutput(console_out_stream) }
   writes("?*N")
   warn_code := n
   recover()
   TEST menu_dynamic THEN transfer(re_try) ELSE
   longjump(lvl,re_try) }1

.


