
// SECTION "EF4A"   // Last modified 83-10-20

/*  This  section  handles  both  the "template" and the "screen"
version of the operator A (alter), depending upon the setting  of
the  option  'menu_screen'.   It  is  terminal independent in the
sense that it relies upon the procedure 'put_terminal' of EF7a to
write something to the screen, and upon 'terminal_action' of EF7a
to intercept any keyboard action that takes the cursor away  from
the current line.  */

GET "CHEF_EF0"

MANIFEST
{
  shift_bsz        =  20  // Shift of screen left or right
  cr_ch            = ascii_ ->
                     (sys_prime -> #O215, #O015), null
  lf_ch            = ascii_ ->
                     (sys_prime -> #O212, #O012), null }

STATIC
{ screen_half = ?   // Half the number of screen lines
  /* Note that the next four lose their values when the
  overlay comes in again.   This does not matter because
  they are used the first time only.  */
  pvec        = ?   // The put_terminal byte vector
  svec        = ?   // Vector of put strings
  svec_p      = ?   // Pointer (index) into svec
  gvec_t      = ?   // Current top of gvecs
  a_level     = ?   // For remembering
  a_label     = ? } //   where to transfer in 'do_a'

LET start_ef4a(n) BE
/* If using screen mode, this routine initializes the screen after
reading the screen capability tables from the message file.  */
{1 // writes("<>start_ef4a:*N")
   check_system(n, computer, 41); start_ef5(n)
   IF menu_screen THEN
   {i IF get_captab() THEN
     { put_terminal(cap_is)
       view_half := (screen_rows-1)/2 } }i }1

AND altered_line(str,old_str) = VALOF
/* This is not a screen-editing procedure.  It is called by the A
and  XA  operators  to  edit the text in 'str', using the editing
template in 'line'.  The vector 'old_str' remembers the  unedited
text  so  that  a  local  'undo' can take place if necessary.  In
'str' there is a margin symbol in position 1 and the text  starts
at position 2.  Editing characters are:
   'B'        - forces a blank,
   'D'        - deletes a character,
   'I'        - inserts rest of 'line' at position of 'I',
   'O'        - overlays for each non-blank in rest of 'line',
   '%c', '%%' - changes rest of 'line' to text from control 'c'
                  or terminal respectively,
   'U'        - undoes the last edit.
Illegal editing characters cause the remainder of  'line'  to  be
abandoned.  The function yields true if the contents of 'str' are
altered, otherwise false.  */
TEST ~ menu_a \/ menu_screen THEN RESULTIS FALSE ELSE
{1 LET pos, altered_ = 1, FALSE
   WHILE pos <= line%0 DO
   {W LET c = upper_case(line%pos)
      IF pos = 1 THEN
         SWITCHON c INTO
         {S1 CASE 'O': CASE '%': CASE '*S':
                copy_string(str,old_str);             ENDCASE
             CASE 'U': copy_string(old_str,str)
             DEFAULT: RESULTIS FALSE }S1
      SWITCHON c INTO
      {S DEFAULT: RESULTIS altered_
         CASE 'B':
            str%pos := '*S'; altered_ := TRUE
         CASE '*S': pos := pos + 1;                   ENDCASE
         CASE 'D':
            IF pos <= str%0 THEN
            { copy_bytes(str%0-pos,str,pos+1,str,pos)
              str%0 := str%0 - 1 }
            copy_bytes(line%0-pos,line,pos+1,line,pos)
            line%0 := line%0 - 1
            altered_ := TRUE;                         ENDCASE
         CASE 'I':
         {I LET len = line%0 - pos
            IF pos - 1 > str%0 THEN extend_str(str,pos-1)
            IF len > 0 THEN
            { FOR i = str%0 TO pos BY -1 DO
                 str%(i+len) := str%i
              str%0 := str%0 + len }
            FOR i = pos+1 TO line%0 DO str%(i-1) := line%i
            RESULTIS TRUE }I
         CASE 'O':
            FOR index = pos+1 TO line%0 DO
            {F LET c = line%index
               IF c NE '*S' THEN
               { IF index > str%0 THEN extend_str(str,index)
                 str%index := c
                 altered_ := TRUE } }F
            RESULTIS altered_
         CASE '%': TEST ~ menu_macro THEN RESULTIS altered_
                   ELSE {C
            FOR i = 1 TO 5 DO
            {F1 LET c_l =
                 - uc_char_number(line%(pos+1),control_chars)
                TEST c_l < 0 THEN fetch_line(c_l)
                ELSE TEST line%(pos+1) = '%' THEN
                   UNLESS got_text(FALSE,FALSE) DO recover_eof()
                ELSE RESULTIS altered_
                { LET new_len = pos - 1 + line%0
                  IF new_len > line_bsz THEN warn(m_text_too_long)
                  IF pos > str%0 THEN extend_str(str,pos)
                  copy_bytes(line%0,line,1,str,pos)
                  str%0 := new_len; altered_ := TRUE
                UNLESS line%pos = '%' THEN ENDCASE }F1
            warn(m_recursion) }C    }S  }W
   RESULTIS altered_ }1

AND check_screen_full(forward_) BE
/*  In  screen mode, check whether the screen is full, except for
the lines at top and bottom.  If so, and 'forward_' is true  then
the  existing  top line is erased and 'l_line1' is incremented to
reflect this change.  If the display is full  and  'forward_'  is
false,  the  existing  bottom  line  is  erased  and 'l_line2' is
decremented. */
TEST ~ menu_screen THEN RETURN ELSE
{1 cursor_x := 1
   IF (l_line2 - l_line1 > screen_rows - 3) THEN
     TEST forward_ THEN
       TEST sys_msdos THEN
       { cursor_y := 2; put_terminal(cap_cm)
         put_terminal(cap_dl); l_line1 := l_line1 + 1
         simulate(cap_dl) }
       ELSE
       { cursor_y := screen_rows
         put_terminal(cap_cm); put_terminal(cap_do)
         put_terminal(legend_on); l_line1 := l_line1 + 1 }
     ELSE
     { cursor_y := screen_rows; put_terminal(cap_cm)
       put_terminal(cap_ce); l_line2 := l_line2 - 1
       simulate(cap_ce) }
   cursor_y := 2 + cur_line - l_line1
   put_terminal(cap_cm) }1

AND delete_line(saved_str) = VALOF
/*  In  screen mode,  save  the  current line in 'saved_str' then
delete it.  If there are lines remaining in the file yield  true,
otherwise false.  */
TEST ~ menu_screen THEN RESULTIS FALSE ELSE
{1 fetch_line(cur_line)
   copy_string(line, saved_str); remove_line(FALSE)
   IF cur_line > l_line2 THEN
     cur_line, cursor_y := cur_line - 1, cursor_y - 1
   IF l_line2 < l_line1 THEN             RESULTIS FALSE
   put_terminal(cap_cm);                 RESULTIS TRUE }1

AND display_lines(l1, l2, cp) BE
/* In screen mode, displays the region of lines from 'l1' to 'l2'
starting  at  the  screen  line 'cursor_y'.  If 'l1 = 0' then the
current content of 'line' is displayed and no further  lines  are
fetched.   The routine displays only as many characters from each
line as will fit  into  one  line  of  the  display.   The  third
parameter 'cp' is normally zero, but is used when this routine is
called by 'simulate' for impotent screens.   It is this case that
needs the local variables 'len', 'olen' and 'nlen'.   They enable
one to know how much garbage to erase from the screen.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 LET olen, len, nlen = screen_cols, ?, ?
   cursor_x := 1; put_terminal(cap_cm)
   IF l1 NE 0 THEN fetch_line(l1)
   len := line%0
   IF l1 > 0 THEN
     FOR i = l1 TO l2 - 1 DO
     { display_one(1, line%0, 0)
       fetch_line(i+1); nlen := line%0
       IF cp > 0 THEN
         display_one(1+len, (cp=cap_al-256 -> nlen, olen), cp)
       put_terminal(cr_ch); put_terminal(lf_ch)
       olen := len; len := nlen }
   nlen := screen_cols
   display_one(1, line%0, 0)
   IF cp > 0 THEN
     display_one(1+len, (cp=cap_al-256 -> nlen, olen), cp)
   put_terminal(cap_cm) }1

AND do_a() BE
TEST menu_screen THEN
/*  Does a screen-mode edit of a control line line or a region of
the workspace.  Editing within a line is handled by the  call  to
'terminal_action'   which   fetches  and  restores  the  line  as
necessary, and exits when the terminal specifies an edit  outside
the  current  line or some special editing function.  These edits
are indicated by  the  token  returned  by  'terminal_action'  as
follows:
   cap_ku      - moves the cursor up.
   cap_kd      - moves the cursor down.
   cap_k1      - renews the display of the current line.
   cap_al      - inserts a blank line before current line.
   cap_dl      - deletes the current line.
   cap_k4      - remembers string from position of mark to cursor,
                   or if no mark then whole line.
   cap_cr      - folds the line at the cursor position.
   cap_k5      - injects saved string (or line deleted) at cursor.
   cap_k3      - remembers the cursor position (for save).
   cap_k2      - merges the current line (from cursor onwards) with
                   onwards) with the preceding line.
   left_fault  - attempt to move cursor left at start of line.
                   Cursor moves up.
   left_edge   - attempt to move cursor left at left edge of screen.
                   Work shifts right.
   right_edge  - attempt to move cursor or put a character at right
                   edge of screen.  Work shifts left.
   right_fault - attempt to move cursor right beyond end of line.
                   Cursor moves down and left.
   cap_k0 - terminates the entire edit.         */
{1 // writes("do_a:*N")
   LET saved_str = VEC line_csz
   LET mark_pos  =  0
   IF screen_name = ('0'<<8)+'0' THEN warn(m_screen_name)
   screen_half := (screen_rows - 3) / 2
   saved_str%0  := 0
 { LET screen_spread = (r_got = 1 ) ->
    ((r_line1 > screen_half) -> screen_half,r_line1), screen_half
   LET vr = VEC menu_dynamic -> 2, 0
   TEST menu_dynamic THEN
   { a_level := vr; remember(a_level, j) }
   ELSE
   { a_level := level(); a_label := j }
   raw_terminal(TRUE)
   put_terminal(cap_ks)   // enable any keypad
 j:
   put_terminal(cap_cl); cursor_y := 2
   TEST (l_line1 >= 0) THEN // No control, perhaps empty.
   {2 LET low = l_line1 - screen_spread       // User's low
      LET high = l_line1 + screen_spread      // User's high
      in_screen_ := TRUE
      TEST (last_line = 0) THEN cur_line, l_line2 := 1, 1
      ELSE
      { cur_line := l_line1
        l_line2 := (high > last_line) -> last_line, high }
      l_line1 := (low < 1) -> 1, low
      put_terminal(legend_on)
      UNLESS (l_line2 > last_line) THEN
        display_lines(l_line1, l_line2, 0)
      cursor_x, cursor_y := 1, 2 + cur_line - l_line1
      put_terminal(cap_cm)
      /* The following is repeated, until we have 'cap_k0'.  */
      {R LET action =
           terminal_action(TRUE, cur_line, (cur_line > last_line))
         UNLESS (action = cap_k4) THEN mark_pos := 0
         SWITCHON action INTO
         {S CASE cap_k0: DEFAULT:                        BREAK
            CASE left_fault:
            CASE cap_ku: go_aft()
              IF action = cap_ku THEN                    ENDCASE
              fetch_line(cur_line)
              cursor_x := line%0 - screen_shift + 1
              IF cursor_x > screen_cols THEN cursor_x := screen_cols
              put_terminal(cap_cm);                      ENDCASE
            CASE right_fault: cursor_x := 1
              IF cur_line = last_line THEN
              { put_terminal(cap_cm);                    ENDCASE }
            CASE cap_kd: go_fore();                      ENDCASE
            CASE right_edge: CASE left_edge:
              do_edge(action);                           ENDCASE
            CASE cap_k1: // Renew
              UNLESS cur_line > last_line THEN
              { put_terminal(cap_cr)
                put_terminal(cap_ce); simulate(cap_ce)
                display_lines(cur_line, cur_line, 0) };  ENDCASE
            CASE cap_k3: // Mark
              mark_pos := cursor_x + screen_shift
              put_terminal(bell_ch);                     ENDCASE
            CASE cap_k4: // Save
              save_line(mark_pos, saved_str);            ENDCASE
            CASE cap_dl:
              TEST delete_line(saved_str) THEN ENDCASE ELSE BREAK
            CASE cap_k2: // Merge
              TEST merge_line() THEN ENDCASE ELSE        BREAK
            CASE cap_al: insert_blank_line(FALSE, FALSE);
              simulate(cap_al)
              IF l_line2 > last_line THEN
                l_line2 := l_line2 - 1;                  ENDCASE
            CASE cap_k5: // Inject
              inject_string(saved_str);       ENDCASE
            CASE cap_cr: do_return() }S }R
      REPEAT
      IF cur_line > last_line THEN cur_line := last_line }2
   ELSE do_control()
   put_terminal(cap_ei); insert_mode_ := FALSE
   put_terminal(legend_off)
   cursor_x, cursor_y := 1, screen_rows
   put_terminal(cap_cm)
   screen_shift := 0
   put_terminal(cap_ke)
   in_screen_ := FALSE
   raw_terminal(FALSE)  }1
ELSE
TEST ~ menu_a THEN RETURN ELSE
/*  This  is  the non-screen mode version.  It edits each line of
the range using an editing template derived from the terminal  or
a control or workspace line.  If 'modifier' is null, the template
comes from the terminal and each line may be edited any number of
times  before  passing  to  the  next  with  a null edit.  If the
modifier is A, a single template from either the  terminal  or  a
control   or  workspace  line  edits  all  lines  of  the  range.
'result!0' is true if a line has been altered, 'result!1' is true
if the command has been terminated by a 'dot-stop' line.  */
{1 // writes("do_a:")
 { LET source = (r_got = 0) -> 0, r_line1
   AND one_each_ = (modifier = 'A')
   AND result = VEC 1
   AND old_line = VEC line_csz
   FOR lno = l_line1 TO l_line2 DO
   {F LET first_ = (lno = l_line1)
      UNLESS lno < 0 DO cur_line := lno
      fetch_line(lno)
      edit_line(line,one_each_,source,first_,old_line,result)
      IF result!0 THEN store_line(lno)
      IF result!1 THEN RETURN }F  }1

AND do_edge(action) BE
/*  In  screen mode,  if it is at right edge, then shift the work
left.  If it is at left edge, then shift the work right, but only
if this is possible.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 LET shift = (action = left_edge) -> - shift_bsz, shift_bsz
   store_line(cur_line)
   screen_shift := screen_shift + shift
   put_terminal(cap_cl);
   { LET new_x = cursor_x - shift
     cursor_y := 2
     put_terminal(legend_on)
     display_lines(l_line1, l_line2, 0)
     cursor_x, cursor_y := new_x, 2 + cur_line - l_line1
     put_terminal(cap_cm) } }1

AND do_control() BE
/* In screen mode, we now have a control line.  Here only in-line
screen action is acceptable.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 display_lines(l_line1, l_line1, 0)
   {R1 SWITCHON terminal_action(TRUE, l_line1, FALSE) INTO
       {S1 DEFAULT:                                         BREAK
           CASE cap_k1: put_terminal(cap_cr)
             put_terminal(cap_ce); simulate(cap_ce)
             display_lines(l_line1, l_line1, 0) }S1 }R1
       REPEAT }1

AND do_return() BE
/*  In  screen mode, take the tail of the current line and insert
as a new line after the current one.   This  means  that  if  the
cursor  is at the end of the current line, the line inserted will
be blank.  If the cursor is at the beginning of the current line,
then a blank line will be inserted before the current line.   The
effect  of  this  operation  can  be  undone  by  the  merge-line
facility.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 LET str = VEC line_csz
   fetch_line(cur_line)
 { LET pos = cursor_x + screen_shift
   LET head = (pos <= line%0) -> pos - 1, line%0
   LET tail = (pos <= line%0) -> line%0 - pos + 1, 0
   copy_bytes(tail, line, pos, str, 1)
   str%0 := tail; line%0 := head
   IF tail > 0 THEN
   { store_line(cur_line); put_terminal(cap_cm)
     put_terminal(cap_ce); simulate(cap_ce) }
   cur_line := cur_line + 1; cursor_y := cursor_y + 1
   insert_blank_line(TRUE, TRUE); inject_string(str) }1

AND do_xa() = VALOF
TEST ~ menu_xa THEN RESULTIS FALSE ELSE
TEST menu_screen THEN
/*  Does  a  screen-mode  edit  of  the  command  line  saved  in
'old_cmd'.  If the edit is terminated  by  RETURN,  the  modified
command  is  submitted for execution.  Any other exit from screen
mode, will abort command execution, saving the  modified  command
in 'old_command'.  */
{1 LET yield = TRUE  // Assume it will be RETURN
   copy_string(old_cmd, line)
   raw_terminal(TRUE)
   put_terminal(cap_ks)   // enable any keypad
   put_terminal(cap_cl)
   cursor_y := 2; screen_shift := 0
   display_lines(0, 0, 0)
   {R SWITCHON terminal_action(FALSE, 0, FALSE) INTO
      {S DEFAULT: yield := FALSE;               BREAK
         CASE cap_k1: put_terminal(cap_cr)
           put_terminal(cap_ce); simulate(cap_ce)
           copy_string(old_cmd, line)
           display_lines(0, 0, 0);              ENDCASE
         CASE cap_cr:               BREAK   }S  }R
   REPEAT
   copy_string(line, old_cmd)
   cursor_x, cursor_y := 1, screen_rows
   put_terminal(cap_cm)
   put_terminal(cap_ke)
   raw_terminal(FALSE)
   RESULTIS yield }1
ELSE
/* When not  in  screen  mode,  modifies  the  command  saved  in
'old_cmd'  using  an  editing  template  from  the terminal, then
submits it for execution unless inhibited by a  'dot_stop'  line.
*/
{1 LET result = VEC 1
   AND old_line = VEC line_csz
   edit_line(old_cmd,FALSE,0,TRUE,old_line,result)
   RESULTIS result!1 }1

AND edit_line(text,one_each_,source,first_,old_line,result) BE
TEST menu_screen THEN RETURN ELSE
/* Performs one or more edits of 'text' using an editing template
from  the  terminal  if 'source = 0' or otherwise from 'r_line1'.
If 'one_each' is true, only a single edit is done.  If 'first' is
true, the line to be edited is the first of the range. The vector
'old_line' holds the editing template if the same edit is  to  be
carried  out  once on all lines of the range.  'result!0' is true
if the line is altered, and 'result!1'  is  true  if  editing  is
terminated by a 'dot-stop' line.  */
TEST ~ menu_a THEN RETURN ELSE
{1 LET str = VEC line_csz
   AND old_str = VEC line_csz
   result!0 := FALSE
   copy_bytes(text%0,text,1,str,2)
   str%0, str%1 := text%0 + 1, margin_symbol
   copy_string(str,old_str)
   {R TEST one_each_ LOGAND ~ first_ THEN
      { copy_string(old_line,line)
        result!1 := FALSE }
      ELSE result!1 := ~ got_template(source,str)
      IF one_each_ LOGAND first_ THEN
         copy_string(line,old_line)
      IF result!1 LOGOR (line%0 = 0) THEN BREAK
      IF altered_line(str,old_str) THEN result!0 := TRUE
   }R REPEATUNTIL one_each_
   IF result!0 THEN
   { copy_bytes(str%0-1,str,2,text,1)
     text%0 := str%0 - 1  }  }1

AND get_captab() = VALOF
/* Get the name of the terminal and using this seek and then read
its  capability table in the message file.  This is done by first
consulting   the   message   file   directory.    The    location
'msg_table!0'  indicates  the  current state of the message file.
If it is -1, then the file has not yet been opened.  If it is -2,
the message file could not be opened.  Once the capability  table
has  been read, 'msg_table!0' is set to 1 to indicate this to the
code in EF7 which reads the  message  directory.   This  function
yields  true  if  the  capability  table  was found, otherwise it
yields false.  */
TEST ~ menu_screen THEN RESULTIS FALSE ELSE
{1 LET ii = input()
   // trace("get_captab:")
   IF screen_name = 0 THEN screen_name := gt_screen_name()
    IF msg_table!0 = -1 THEN  // open not yet attempted
   { msg_in_stream := findinput(name_of_msg_file())
     UNLESS valid_stream(msg_in_stream) DO
     { msg_table!0 := -2
       screen_name := ('0'<<8) \/ '0'
       RESULTIS FALSE }
     msg_table!0 := 1 }
   selectinput(msg_in_stream)
   set_file_position(msg_in_stream, 0)
   seek_cap(screen_name)
   rd_captab()
   no_cap_al_ := svec%(pvec%(cap_al-256)) = 0
   selectinput(ii)
   RESULTIS TRUE }1

AND go_aft() BE
/* In screen mode, if the previous line is in the display  it  is
easy,  otherwise we have to go aft (backward in the workspace) to
fetch it.  In the case where we are at the beginning of the  file
when we do nothing.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 IF (l_line2 > last_line) THEN l_line2 := l_line2 - 1
   TEST cur_line > l_line1 THEN
   { cur_line, cursor_y := cur_line - 1, cursor_y - 1
     put_terminal(cap_cm) } ELSE
   /* Now try scrolling aftward.  */
   TEST l_line1 > 1 THEN
     TEST no_cap_al_ THEN
       TEST menu_dynamic THEN transfer(a_level)
       ELSE longjump(a_level, a_label)
     ELSE
     { l_line1 := l_line1 - 1
       cursor_x, cursor_y := 1, 2; put_terminal(cap_cm)
       put_terminal(cap_al); simulate(cap_al)
       cursor_y := 2
       display_lines(l_line1, l_line1, 0)
       cur_line := cur_line - 1
       check_screen_full(FALSE) }
   ELSE
   put_terminal(cap_cm) }1

AND go_fore() BE
/*  In  screen  mode, if the next line forward is in the display,
then it is easy, otherwise we must go forward, unless we  are  at
the end of the file in which case we do nothing.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 TEST cur_line < l_line2 THEN
   { cur_line, cursor_y := cur_line + 1, cursor_y + 1
     put_terminal(cap_cm) }
   /* Now try scrolling forward.  */
   ELSE TEST l_line2 <= last_line THEN
     TEST no_cap_al_ THEN
     { l_line1 := l_line2 // step
       TEST menu_dynamic THEN transfer(a_level)
       ELSE longjump(a_level, a_label) }
     ELSE
     { l_line2 := l_line2 + 1
       cursor_y := 2 + l_line2 - l_line1
       put_terminal(cap_cm)
       UNLESS l_line2 > last_line THEN
         display_lines(l_line2, l_line2, 0)
       cur_line := cur_line + 1
       check_screen_full(TRUE) }
   ELSE put_terminal(cap_cm) }1

AND got_template(source,str) = VALOF
TEST menu_screen THEN RESULTIS FALSE ELSE
/*  When  not in screen mode, obtains an editing template for use
by the A, F or XA commands from either the terminal (source =  0)
or  the  line  specified by 'source'.  If the template comes from
the terminal, the contents of 'str'  are  displayed  first  as  a
guide to the user.  The function returns true unless a 'dot_stop'
line is entered from the terminal.  */
TEST ~ menu_a LOGAND ~ menu_fm THEN RESULTIS FALSE ELSE
{1 LET save_tag = menu_t -> cur_tag, ?
TEST (source = 0) THEN
   { IF input() = console_in_stream THEN writef("%S*N",str)
     { LET res = got_text(FALSE,TRUE)
       IF menu_t THEN cur_tag := save_tag
       RESULTIS res } }
   ELSE
   { fetch_line(source)
     IF menu_t THEN cur_tag := save_tag
     RESULTIS TRUE } }1

AND inject_string(new_str) BE
/* In screen mode, inject the string 'new_str' at the position of
the cursor.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 fetch_line(cur_line)
 { LET pos = cursor_x + screen_shift
   LET tail = (pos <= line%0) -> line%0 - pos + 1, 0
   LET insert = new_str%0
   LET len = pos - 1 + insert + tail
   IF len > line_bsz RETURN
   IF pos - 1 > line%0 THEN extend_str(line, pos-1)
   FOR i = line%0 TO pos BY -1 DO line%(i + insert) := line%i
   copy_bytes(insert, new_str, 1, line, pos)
   line%0 := len; store_line(cur_line)
   display_lines(0, 0, 0)
   cursor_x := pos - screen_shift; put_terminal(cap_cm) }1

AND insert_blank_line(make_space_, forward_) BE
/*  In  screen  mode,  insert  a  blank  line  at 'cur_line'.  If
'make_space_' is true, then do the same on the screen.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 line%0 := 0; IF menu_t THEN cur_tag := null
   expand(cur_line, 1); store_line(cur_line)
   l_line2 := l_line2 + 1; cursor_x := 1
   IF make_space_ LOGAND cur_line < l_line2 THEN
   { put_terminal(cap_cm); put_terminal(cap_al); simulate(cap_al) }
   check_screen_full(forward_) }1

AND merge_line() = VALOF
/*  In  screen  mode, merge the tail of the current line with the
previous line by appending this tail to the end of  the  previous
line.   Note  that if the cursor is at the beginning of the line,
then the effect will be the opposite of 'do_return'.  Yield false
if there is no previous line, otherwise yield true.  */
TEST ~ menu_screen THEN RESULTIS FALSE ELSE
{1 LET str = VEC line_csz
   IF cur_line = l_line1 RESULTIS FALSE
   UNLESS l_line2 > last_line THEN fetch_line(cur_line)
 { LET pos = cursor_x + screen_shift
   LET tail = (pos <= line%0) -> line%0 - pos + 1, 0
   copy_bytes(tail, line, pos, str, 1)
   str%0 := tail
   TEST cur_line <= last_line THEN remove_line(TRUE)
   ELSE l_line2 := l_line2 - 1
   cur_line := cur_line - 1
   fetch_line(cur_line)
   cursor_x := line%0 + 1 - screen_shift
   cursor_y := cursor_y - 1
   put_terminal(cap_cm)
   inject_string(str)
   RESULTIS TRUE }1

AND put_c(ch) BE
/* Put 'c' into 'svec' and update the pointer.   This is used
when reading the capability table.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 IF svec_p > svec_bsz THEN err("4a:2")
   svec%svec_p := ch; svec_p := svec_p + 1 }1

AND remove_line(erase_) BE
/* In screen mode, delete the current line.  If 'erase_' is true,
then erase it from the screen also.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 delete_lines(cur_line, cur_line, 1)
   l_line2 := l_line2 - 1
   IF erase_ THEN put_terminal(cap_dl)
   simulate(cap_dl) // Necessary anyway if impotent
   cursor_x, cursor_y := 1, 2 + cur_line - l_line1 }1

AND rd_captab() BE 
/* Read the  capability  table  and  store  it  in  memory.   The
speaking  strings  come first.  This is followed by the listening
tree.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 LET c = rdch()
   // trace("rd_captab")
   pvec := caps_vec; svec := caps_vec + pvec_csz
   FOR i = 0 TO cap_sz DO pvec%i := 0
   UNTIL (c='|')\/(c=endstreamch) DO c := rdch()
   screen_cols := 0
   IF c = endstreamch THEN err("4a:3")
   UNTIL c = '*N' DO c := rdch()
   svec_p := 1
   // Now read the speaking strings
   {2 LET cp = readn()
      UNLESS terminator = ':' THEN err("4a:4")
      IF cp = 0 THEN BREAK
    { LET len = readn()
      SWITCHON cp+256 INTO // Not all go to 'svec'
      {S DEFAULT: pvec%cp := svec_p; put_c(len);
           FOR i = 1 TO len DO put_c(readn()); ENDCASE
         CASE cap_li: screen_rows := readn(); ENDCASE
         CASE cap_co: screen_cols := screen_cols+readn(); ENDCASE
         CASE cap_am: screen_cols := screen_cols - readn()
                                                          ENDCASE
         CASE cap_lg: FOR i = 1 TO len DO legend%i := readn()
           legend%0 := len }S }2
   REPEAT
   // Now read the listening tree (triples).
 { LET used_csz = pvec_csz + (svec_p + cell_bsz)/cell_bsz
   LET gvec_csz = (caps_vec_csz - used_csz)/(3*cell_bsz)
   g1vec := caps_vec + used_csz
   g2vec := g1vec + gvec_csz; g3vec := g2vec + gvec_csz
   gvec_t := 0
   {2 LET g1, g2, g3 = readn(), readn(), readn()
      IF g1+g2+g3 = 0 THEN BREAK
      IF gvec_t > gvec_csz*cell_bsz THEN err("4a:5")
      g1vec%gvec_t, g2vec%gvec_t, g3vec%gvec_t := g1, g2, g3
      gvec_t := gvec_t + 1 }2
   REPEAT  }1

AND save_line(mark_pos, saved_str) BE
/*  In  screen mode, save the substring of 'line' from 'mark_pos'
to the current cursor position (or the other way  around).   This
can  later  be  recalled  by 'inject'.  Note that if there was no
mark on the current line, then the whole line is saved.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 UNLESS l_line2 > last_line THEN fetch_line(cur_line)
 { LET first, last = mark_pos, cursor_x + screen_shift
   IF last < first THEN
     first, last := cursor_x + screen_shift, mark_pos
   IF mark_pos = 0 THEN first, last := 1, line%0
   FOR i = first TO last DO
     saved_str%(i - first + 1) := (i <= line%0) ->line%i, '*S'
   saved_str%0 := last - first + 1
   mark_pos := 0; put_terminal(bell_ch) }1

AND seek_cap(name) BE
/*  Assume that we are positioned at the beginning of the message
file directory.  Now position it at the beginning of the terminal
capability table corresponding to 'name'.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 // trace("seek_cap:")
 { LET n = readn() AND cur_name = ?
   LET c1, c2, c3 = ?, '*S', rdch()
   {r c1, c2, c3 := c2, c3, rdch()
      REPEATUNTIL c3 = '|' \/ c3 = endstreamch
      IF c3 = endstreamch THEN err("cap tables?")
      cur_name := (c1<<8) + c2
      IF cur_name = name THEN BREAK
      IF cur_name = ('0'<<8)+'0' THEN
      { screen_name := cur_name; BREAK }
      n := n + readn() }r
   REPEAT
   UNTIL rdch() = '*N' LOOP
   make_indexed(msg_in_stream)
   // The following is needed because of a bug in the interface
   IF sys_unix THEN selectinput(msg_in_stream)
   set_file_position(msg_in_stream, n) // n grabs
   UNLESS sys_emas DO { rdch(); unrdch() }
   make_sequential(msg_in_stream) }1

AND simulate(cap) BE
/* This is needed for some impotent screens, e.g., for those that
cannot  insert  or delete lines.  The parameter is the capability
to be simulated.   There is a duplication of 'cap_ce' here and in
'refresh' of EF7a.   This is because of overlay problems on small
computers (EF4a is not resident when analysing commands).  */
TEST ~ menu_screen THEN RETURN ELSE
{1 TEST ~ impotent_ THEN RETURN ELSE impotent_ := FALSE
   SWITCHON cap INTO
   {s CASE cap_ce: // Clear to the end
        display_one(cursor_x, screen_cols, cap_ce-256)
        put_terminal(cap_cm);                ENDCASE
      CASE cap_al: // Insert line before current line
      CASE cap_dl: // Delete line before current line
        display_lines(l_line1+cursor_y-2, l_line2, cap-256)
        TEST cap = cap_al THEN
        { put_terminal(cap_cm)
          display_one(1, screen_cols, cap-256) }
        ELSE
        { LET old_y = cursor_y
          cursor_y := l_line2 - l_line1 + 3
          put_terminal(cap_cm)
          display_one(1, screen_cols, cap-256)
          cursor_y := old_y } }s
      put_terminal(cap_cm) }1

 .

