
// SECTION "MDIR"  // Last modified 83-10-25
/*  A  program  to  create  a  new  help file together with a new
directory.   Note  that,   except   for   'sys_mts',   'sys_470',
'sys_fmgr'  and  'sys_vms',  all parts:  capability tables, error
messages and help messages are rounded out to a  full  grab  with
spaces and the directory produced is in grabs.  */
 
GET "CHEF_EF0"
 
MANIFEST 
{  help_max    = 128
   cap_max     = 10 }       // Max number of different terminals

MANIFEST
{ line_end_bytes  = sys_cpm \/ sys_msdos -> 2, 1
                                    // For carriage returns
}
 
STATIC 
{  directory_size  = ?
   error_table     = ?
   help_table      = ?
   ch_table        = ?
   other_chs       = ?
   screen_name     = ?    // for two characters
   cap_table       = ?
   cap_names       = ?
   cap_top         = 0
   caps_size       = 0 }
 
LET start() BE
{1 LET v = VEC msg_csz; error_table := v
 { LET v = VEC help_max; help_table := v
 { LET v = VEC cap_max; cap_table := v
 { LET v = VEC cap_max; cap_names := v
 { LET f_in = sys_mts \/ sys_470 -> "EF11", "EF11A"
   LET f_out = sys_mts \/ sys_470 -> "NEWEF11",
               sys_msdos -> "b:chef.msg",
                            "NEWEF11A"
   LET new_out = findoutput(f_out)
   LET s_in = findinput(f_in)
   LET s_out = sys_mts \/ sys_470 -> findoutput("-dd"),
               sys_unix -> findoutput("-d"),
               sys_msdos -> findoutput("b:dd"),
               sys_rdos -> findoutput("DD"),
               sys_unix32 -> findoutput("DD"),
               sys_cpm -> findoutput("DD"),
               sys_emas -> findoutput("DD"),
               sys_vms -> findoutput("DD.TMP"),
                          createoutput("MFILE.D")
   console_out_stream := output()
   IF is_void_stream(s_in) THEN
   { writef("Cannot open %S*N", f_in); RETURN }
   IF is_void_stream(new_out) THEN
   { writef("Cannot open %S*N", f_out); RETURN }
   ch_table := sys_mts \/ sys_470 ->
     "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ?+-,:;$@.**/|&*'*"#<>~%!=" ,
     "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ?+-,:;$^.**/\&*'*"#[]~%@!="
   other_chs := sys_mts \/ sys_470 -> "()=!", "()<>|=!"
   selectinput(s_in)
   selectoutput(new_out)
   read_directory()
   read_captabs()
   read_errors()
   read_help()
   endread()
   endwrite()
   selectoutput(s_out)
   write_new_directory(); endwrite()
   selectoutput(console_out_stream)  }1
 
AND align(n) =
/* Make the n aligned on the next grab.  */
  sys_mts \/
  sys_470 \/
  sys_fmgr \/
  sys_vms -> n, (n + (grab_bsz - 1))/grab_bsz

AND flush_line(b_n) = VALOF
{1 {R LET c = rdch()
      IF c = '*N' THEN
        TEST grab_bsz > 1 THEN
        {i TEST (b_n REM grab_bsz) = (grab_bsz - line_end_bytes) THEN
           { newline(); RESULTIS b_n + line_end_bytes }
           ELSE { wrch('*S'); b_n := b_n + 1 } }i REPEAT
         ELSE
         { newline(); RESULTIS b_n + line_end_bytes }
      b_n := b_n + 1  }R REPEAT  }1
 
AND is_void_stream(s) = 
/* We must allow for the vagaries of different systems.  */
  (sys_unix \/ sys_rdos) -> (s = -1),
  sys_aos \/ sys_emas -> (s < 0), s = 0
 
AND msg_size() = VALOF
{1 LET b_n, l_n = 0, 0 AND nl_ = FALSE
   LET c1, c2, c3 = ?, '*S', '*S'
   {R c1, c2, c3 := c2, c3, rch()
      SWITCHON c3 INTO
      {S CASE endstreamch: selectoutput(console_out_stream)
           writes("Input error*N"); FINISH
         CASE '|': screen_name := (c1<<8) + c2
           b_n := b_n + 1; nl_ := FALSE;        ENDCASE
         CASE '.':
           IF nl_ THEN
           { b_n := flush_line(b_n + 1); l_n := l_n + 1
             RESULTIS sys_mts \/
                      sys_470 \/
                      sys_fmgr \/
                      sys_vms -> l_n , b_n  }
         DEFAULT: b_n := b_n + 1; nl_ := FALSE; ENDCASE
         CASE '*N': nl_ := TRUE
           l_n, b_n := l_n + 1, b_n + line_end_bytes }S }R
   REPEAT  }1

AND rch() = VALOF
/* Read and echo to new file.  */
{ LET c = rdch(); wrch(c); RESULTIS c }

AND read_captab() = VALOF
/* Read the capability tables, yielding true if there is another.
*/
{1 LET len = msg_size()
   caps_size := caps_size + len
   IF cap_top > cap_max THEN
   { writes("Too many caps*N"); FINISH }
   cap_table!cap_top, cap_names!cap_top := len, screen_name
   IF screen_name = (('0'<<8) + '0') RESULTIS FALSE
   cap_top := cap_top + 1; RESULTIS TRUE }1

AND read_captabs() BE
  WHILE read_captab() LOOP

AND read_directory() BE
  directory_size := msg_size() +
             (sys_mts \/ sys_470 \/ sys_fmgr \/ sys_vms -> 1, 0)
 
AND read_errors() BE
  FOR i = 1 TO msg_csz DO
    error_table ! i := msg_size()
 
AND read_help() BE
  FOR i = 1 TO ch_table%0 DO
    help_table ! i := msg_size()
 
AND write_new_directory() BE
{1 writef(" %N*N", align(directory_size))
   FOR i = 0 TO cap_top DO
   { writef(" %C%C|%N", (cap_names!i)>>8, (cap_names!i)&255,
       align(cap_table!i))
     IF i REM 8 = 7 THEN newline() }
   writef("*N %N*N", msg_csz)
   FOR i = 1 TO msg_csz DO
   { writef(" %N", align(error_table ! i))
     IF i REM 8 = 0 THEN newline()  }
   newline()
   FOR i = 1 TO other_chs%0 DO
     writef(" %C 0", other_chs%i)
   newline()
   FOR i = 1 TO ch_table%0 DO
   { writef(" %C %N", ch_table%i, align(help_table ! i))
     IF i REM 8 = 0 THEN newline() }
   writes("*N _*N")  }1
 

