
SECTION "C#MAIN"   // Last altered 83-10-16

/* This section should be loaded together with EF4A,
 EF7A  (with  'captest_'  set  true) and EF10.  Its purpose is to
test that the capabilities now stored in the message file can  be
recognized  properly.   Some of them are even tested to determine
whether the screen is speaking correctly.  The first part of  the
test  is  for  the  capability  'cm'  (cursor motion).  Enter two
numbers giving row and column position on  the  screen.   An  'x'
will  be  placed  in  this  position.  Touch any key to continue.
Entering 0 0 will transfer to the next part  of  the  test  which
checks  the listening and speaking tables.  One may exit from the
test by entering the character '0'.  The  last  test  places  the
pattern:

          XXXXX
          XX+XX
          XXXXX

on the sreen and positions the cursor on  the  '+'.   The  screen
action   is   then   given   so   that  one  may  determine,  for
example. whether 'ku' (cursor up) is working correctly.  */

GET "CHEF_EF0"

MANIFEST
{ escape_ch  = #O033
  rb_ch      = ascii_ -> 127, 255 }

STATIC { nm_tab = ? }

LET start() BE
{1 LET v1 = VEC caps_vec_csz; caps_vec := v1
 { LET v2 = VEC cap_sz; nm_tab := v2
 { LET s = VEC 6
   LET ii = input()
 { LET v3 = VEC 1; msg_table := v3
 { LET v4 = VEC 64; line := v4; line%0 := 4
 { LET v5 = VEC 80/cell_bsz; legend := v5
   start_ef7a(0)  //  Parameter not used for test
   msg_table!0 := -1; caps_vec!0 := 0
   msg_in_stream := 0
   console_out_stream := output()
   mk_acaps()
   get_captab()
   selectinput(ii)
   test_it()
   writes("Done*N") }1

AND acap(s, t) BE
   nm_tab!(t-256) := (s%1<<8) + s%2

AND check_system(a, b) BE RETURN

AND display_legend() BE RETURN

AND err(s) BE
{1 writes(s); newline(); FINISH }1

AND erase_legend() BE RETURN

AND expand(a,b) BE writes("expand*N")

AND extend_str(a, b) BE writes("extend_str*N")

AND fetch_line(lno) BE writes("fetch_line*N")

AND mk_acaps() BE
{ acap("al", cap_al)
  acap("am", cap_am)
  acap("ce", cap_ce)
  acap("cl", cap_cl)
  acap("cm", cap_cm)
  acap("co", cap_co)
  acap("cr", cap_cr)
  acap("dc", cap_dc)
  acap("dl", cap_dl)
  acap("do", cap_do)
  acap("ei", cap_ei)
  acap("ho", cap_ho)
  acap("ic", cap_ic)
  acap("im", cap_im)
  acap("k0", cap_k0)
  acap("k1", cap_k1)
  acap("k2", cap_k2)
  acap("k3", cap_k3)
  acap("k4", cap_k4)
  acap("k5", cap_k5)
  acap("kb", cap_kb)
  acap("kd", cap_kd)
  acap("ke", cap_ke)
  acap("kl", cap_kl)
  acap("kr", cap_kr)
  acap("ks", cap_ks)
  acap("ku", cap_ku)
  acap("lg", cap_lg)
  acap("li", cap_li)
  acap("rb", cap_rb)
  acap("se", cap_se)
  acap("so", cap_so)
  acap("wl", cap_wl)
  acap("wr", cap_wr) }

AND pr_c(c) BE
/* Write the character using \E for escape and ^ for control.  */
{1 wrch('*S')
  TEST c = escape_ch THEN writes("\E") ELSE
  TEST c = rb_ch THEN writes("RB") ELSE
  TEST c < '*S' THEN
    writef("%C%C", sys_mts ->'?','^', c+64)
  ELSE { wrch('*S'); wrch(c) } }1

AND report(f, a, b, c) BE
{1 LET oo = output()
   selectoutput(console_out_stream)
   writef(f, a, b, c); newline()
   selectoutput(oo) }1

AND store_line(lno) BE writes("store_line*N")

AND test_it() BE
{1 writef("*N screen cols=%N screen rows=%N*N",
     screen_cols, screen_rows)
   writes("Begin cursor test*N")
   put_terminal(cap_is)  // Initialize
   {R raw_terminal(FALSE)
      writes("*N*N*N Enter row, column*N")
      IF sys_emas THEN prompt(" ? ")
      cursor_y := readn(); cursor_x := readn()
      IF cursor_x + cursor_y = 0 THEN BREAK
      UNLESS (1 <= cursor_x <= screen_cols) /\
        (1 <= cursor_y <= screen_rows) THEN LOOP
      UNLESS terminator = '*N' THEN
        UNTIL rdch() = '*N' DO LOOP
      raw_terminal(TRUE)
      put_terminal(cap_cl)
      put_terminal(cap_cm)
      put_terminal('x')
      gchar() }R   // Delay to see result
   REPEAT
   writes("End cursor test*NBegin other test*N")
   {R put_terminal(cap_cl)
      put_terminal(cap_ks)   // enable any keypad
      raw_terminal(FALSE)
      cursor_x := 3 ; copy_string("XX+XX", line)
      writes("Enter*N")
      raw_terminal(TRUE)
      terminal_action(TRUE, 1, FALSE)
      raw_terminal(FALSE)
      TEST cur_cap < 256 THEN
        writef("*N*N*N*NPrintable %C*N", cur_cap)
      ELSE
      {2 LET cp = cur_cap - 256
         writef("*N*N*N*NCapability %C%C*N",
           (nm_tab!cp)>>8, (nm_tab!cp)) }2
      writef(" cursor_x=%N*N", cursor_x)
      writes("XXXXX*NXX+XX*NXXXXX*N")
      raw_terminal(TRUE)
      put_terminal(cap_ku); put_terminal(cap_ku)
      put_terminal(cap_kr); put_terminal(cap_kr)
      /* The cursor should land on the +. */
      SWITCHON cur_cap INTO
      { CASE cap_rb: cur_cap := cap_kl
        DEFAULT: put_terminal(cur_cap) }
      gchar() }R   //  Delay to see the result
   REPEATUNTIL cur_cap = '0'
   put_terminal(cap_ke)   // disable any keypad
   raw_terminal(FALSE)
   writes("*N*N*NTest ended*N") }1

AND trace(f,a,b,c) BE report(f,a,b,c)

AND warn(n) BE writes("warn*N")

.

