.TL
Using CHEF on VAX/VMS
.AU
R.D. Eager
.AI
Computing Laboratory

University of Kent at Canterbury

February 1987

DOC/VMS/K2.7/3
.NH
Introduction
.PP
CHEF is a line-based editor which shares a common ancestry with the EM
editor available on UNIX systems at the University of Kent.
.PP
This document describes those features of CHEF which are specific to its
use on VAX/VMS. For more general information, see the CHEF on-line
documentation, or the CHEF users' manual (DOC/REF/K2.7/3).
.NH
Using the editor
.PP
CHEF is normally entered on VAX/VMS by typing the command:
.IP
\f(DBCHEF\fP\ \ \ \ or\ \ \ \ \f(DBCHEF\fP \fIfilename\fP
.LP
This may be abbreviated to:
.IP
\f(DBCH\fP\ \ \ \ \ \ or\ \ \ \ \f(DBCH\fP \fIfilename\fP
.LP
The \fIfilename\fP parameter specifies the file to be edited; if it is
omitted, CHEF simply prompts for commands.
.NH
Additional parameters
.PP
An additional parameter may be included in a call of CHEF. This
parameter is treated as a complete CHEF command line, and may contain
any legal CHEF commands. Note, however, that parameters to VAX/VMS
commands are translated to upper case, so it is not possible to include
lower case characters in (for instance) a string replacement command.
.PP
The commands in this special command line are executed immediately after
entry to CHEF and, if they do not contain a Q command, CHEF will then
prompt for additional commands from the terminal.
.PP
The most common use of this facility is in the specification of a file
of CHEF commands, using the X operator with the F modifier. For example:
.IP
\f(DBCHEF FRED.TXT XFCOMFILE\fP
.LP
could be used to edit the file FRED.TXT, using the commands stored in the
file COMFILE.
.PP
Another application is that where CHEF is called from a user program to
perform an edit on (say) an intermediate data file. For example:
.IP
\f(DBCHEF BILL.FOR $D;WF.;Q\fP
.LP
could be used to delete the last line from the file BILL.FOR.
.PP
Note that CHEF suppresses its introductory message if this feature is
used, since such calls of the editor are often part of a larger process
where such extraneous messages could be a nuisance. The byte counts
produced on file input and output are suppressed during an F command,
too; this ensures that CHEF is silent as long as no errors occur.
.NH
Limits
.PP
The VAX/VMS implementation of CHEF has one or two limitations; this
section describes them.
.NH 2
Line length
.PP
No line being edited may exceed 240 characters in length at any time,
even as an intermediate stage in a command.
.NH 2
Length of patterns
.PP
No pattern or replacement string may exceed 128 characters, although a
match (using, for example, the \f(DB*\fP feature) may be longer than this.
.NH 2
File types
.PP
Currently, CHEF will only edit sequential files with fixed or variable
length records, with carriage return format. This is unlikely to be a
serious limitation, as nearly all common files conform to this
description.
.NH 0
Files used
.PP
CHEF uses a temporary file as workspace; this is stored in the TEMP:
directory and does not count toward the user's disk quota.
