GET "libhdr"

GET "dscdef.h"

MANIFEST $(
cli$_absent    = #X000381f0
$)

EXTERNAL $(
cli$get_value
cli$present
str$trim
$)

STATIC $(
journal_        = ?   // TRUE iff /JOURNAL specified
journal_stream  = ?   // Stream pointer for journal file
recover_        = ?   // TRUE iff /RECOVER specified
$)

LET start() BE
$( LET p1 = VEC maxstrlength/bytesperword
   AND p2 = VEC maxstrlength/bytesperword
   AND journal_file = VEC maxstrlength/bytesperword

   cliparams(p1, p2, journal_file)

   writef("P1 = \%S\*N", p1)
   writef("P2 = \%S\*N", p2)
   IF journal_ THEN
      writef("JOURNAL present, value = \%S\*N", journal_file)

   IF recover_ THEN writes("RECOVER present*N")
$)

AND cliparams(p1, p2, journal_file) BE
$( LET status = ?

   get_value("P1", p1)
   get_value("P2", p2)

   journal_ := present("JOURNAL")
   recover_ := present("RECOVER")

   IF journal_ THEN
   $( LET dot_found_ = FALSE
      AND l = ?

      get_value("JOURNAL", journal_file)
      l := journal_file%0

      FOR i = 1 TO l DO
         IF journal_file%i = '.' THEN
         $( dot_found_ := TRUE
            BREAK
         $)

      IF NOT dot_found_ & l <= maxstrlength - 4 THEN
      $( FOR i = 1 TO 4 DO
            journal_file%(i+l) := ".JOU"%i
         journal_file%0 := l + 4
      $)
   $)
$)

AND get_value(key, result) BE
$( LET key_d = VEC dsc$k_s_bln/bytesperword - 1
   AND res_d = VEC dsc$k_s_bln/bytesperword - 1
   AND status = ?
   AND len = ?

   key_d%dsc$w_length := key%0
   key_d%(dsc$w_length+1) := 0
   key_d%dsc$b_dtype := dsc$k_dtype_t
   key_d%dsc$b_class := dsc$k_class_s
   key_d!(dsc$a_pointer/bytesperword) := (key << 2) + 1

   res_d%dsc$w_length := maxstrlength/bytesperword
   res_d%(dsc$w_length+1) := 0
   res_d%dsc$b_dtype := dsc$k_dtype_t
   res_d%dsc$b_class := dsc$k_class_s
   res_d!(dsc$a_pointer/bytesperword) := (result << 2) + 1

   cli$get_value(key_d << 2, res_d << 2)

   str$trim(res_d << 2, res_d << 2, @len << 2)
   result%0 := len
$)

AND present(key) = VALOF
$( LET key_d = VEC dsc$k_s_bln/bytesperword - 1
   AND status = ?

   key_d%dsc$w_length := key%0
   key_d%(dsc$w_length+1) := 0
   key_d%dsc$b_dtype := dsc$k_dtype_t
   key_d%dsc$b_class := dsc$k_class_s
   key_d!(dsc$a_pointer/bytesperword) := (key << 2) + 1

   status := cli$present(key_d << 2)

   RESULTIS (status & 1) NE 0
$)

