
SECTION "E4"

GET ".ECCE-HDR"
GET ".SFO-HDR/3/S"

STATIC { 
withptr=0
logptr=0
outptr=0
workptr=0
input_pages=0
save_stream = 0
requested = FALSE
}
 
MANIFEST { 
oar=7; car=1; par=1
defaultaccess=(((par<<3)+oar)<<3)+car
defaultsize=20
defaultunits = #X8002    // small allocation units & labelled.
}

// E4 Open/Create request block format.
//
MANIFEST
{  orb_pmi = 0
   orb_part = 1
   orb_ins = 5
   crb_size = 5
   orb_prin = 6
   crb_units = 6
   orb_pw = 9
   orb_access = 10
   orb_name = 11
}
//

LET arg_error(stream, code) BE
{  writef("Error on stream: %s*N", stream)
   print_fs_err(code)
}

AND find_arg(arg, acc, type, labelled) = VALOF
{1 LET filespec = get_arg(proforma, arg)
   LET s = openfile(filespec, acc, TRUE, type, labelled)
 
   IF s>=0 RESULTIS s

   {  LET fspec = VEC 19
      arg_error(arg, E4failcode)
      request_file(arg, fspec)
      s := openfile(fspec, acc, TRUE, type, labelled)
      IF s>=0 RESULTIS s
   } REPEAT
}1
 
AND find_arg2(arg, acc, pages, buff, opt) = VALOF
{1 LET fspec = get_arg(proforma, arg)
   LET strm = open(fspec, acc, pages, buff, opt)

   IF strm>=0 RESULTIS strm

   {  LET fspec = VEC 19
      arg_error(arg, E4failcode)
      request_file(arg, fspec)
      strm := open(fspec, acc, pages, buff, opt)
      IF strm>=0 RESULTIS strm
   } REPEAT
}1
 
AND set_defaults(fspec) BE
/* Set up any defaults required for a create file request
*/
{1 IF (fspec!2 & #XFF) = 7 THEN  // create request
   {  fspec!crb_units := defaultunits
      IF fspec!orb_access = 0
      THEN fspec!orb_access := defaultaccess
      
      IF fspec!crb_size = 0
      THEN fspec!crb_size := input_pages
   }
}1
 
AND read_status(ref_rtn, v) = VALOF
{1 FOR i=1 TO 3 DO v!i := 0
   v!0 := ref_rtn
   RESULTIS extracode(SDFS, 98, v)
}1
 
AND open_null() = VALOF
{1 LET v = VEC 19
   analyse.it("**N", v)
   RESULTIS open(v, 1, 0, 0, 0)
}1
 
AND find_args(v) BE
{1 LET dtab = ?
   toptr := get_arg(proforma, "TO")

   fromptr := get_arg(proforma, "FROM")
   inplace, retain := FALSE, FALSE

   TEST (fromptr!2 & #XFF) = 7 THEN
   {  UNLESS toptr=nil DO
      {  writef("The source file may not be created.")
         stop_prog(8)
      }
      fromstream := open_null()
      input_pages := defaultsize
      toptr := fromptr
   }
   ELSE
   { fromstream := find_arg2("FROM", 1, 10, page_buffs, 0)
     dtab := fromstream*str.entrysize+devtable
     input_pages := null_stream(fromstream) ->
                       defaultsize, dtab!5
     copy_cells(19, dtab, fromptr)   // in case arg was specified interactively.
   }

   IF toptr = nil THEN
      UNLESS null_stream(fromstream) DO
      {  toptr := v          // allocate a buffer
         copy_cells(19, dtab, toptr)
         toptr!5 := input_pages
         toptr!2 := 7    // cause create.
/*       {  LET v = VEC 10
            read_status(dtab+str.rtn, v)
            toptr!orb_access := v!orb_access
            toptr!orb_pw := v!orb_pw
         }
*/
         toptr!orb_access := defaultaccess
         inplace := TRUE
      }

   set_defaults(toptr)
  
// Open the command input file.

   withstream := find_arg("WITH",1,file.serial,0)

// Open the console output stream.

   outstream := find_arg("OUT",7,file.serial,2)

// Open the work file.

   work_stream := find_arg("WORK",7,file.direct,0)
 
// Now open the command backup file.

   logptr := get_arg(proforma, "LOG")
   logstream := open(logptr, 7, 1, page_buffs+(10*page_csz), 1)
   IF logstream < 0 THEN
   {  UNLESS (E4failcode & #XFF) = #X40 // unless already exists or similar
      DO arg_error("LOG", E4failcode)
      
      TEST logptr!2 = 0 THEN
      {  logptr!2 := 7  // make a create spec
         logptr!5 := defaultsize
         logptr!crb_units := defaultunits
         logptr!10 := defaultaccess
      }
      ELSE
      {  logptr!2 := 0  // change to an open request.
         logptr!orb_ins := 0
         logptr!orb_prin := principal
         writef("Warning: Log file already exists.*N")
      }

      logstream := find_arg2("LOG", 7, 1, page_buffs+(10*page_csz), 1)
   }
}1

AND request_file(arg, analysed) BE
{1 LET resp = VEC 20
   
   requested := TRUE     // have asked user for an output file.
   askfor(-1, arg, resp)
   analyse.it(resp, analysed)
   IF analysed%0 = 0 THEN
   {  set_defaults(analysed)
      RETURN
   }
}1 REPEAT

AND open_output() BE
{1 LET v = VEC 19
   LET out = output()

   requested := FALSE  // set TRUE if user is asked for an output file.
   selectoutput(outstream)
   TEST toptr = nil THEN
   {  toptr := v
      request_file("File", toptr)
   }
   ELSE IF inplace THEN
   {  save_stream := openfile(fromptr, 7, TRUE, file.direct, 0) 
         
      TEST save_stream >= 0 THEN
      {  deletefile(save_stream)
         TEST E4failcode = 0 THEN
         {  LET n = VEC 8
            
            FOR i=1 TO 16 DO
               n%(i-1) := parity("ECCE-BAK        "%i)

            retainfile(save_stream, 0, defaultaccess, n)
            UNLESS E4failcode = 0 DO
            {  // delete the old copy.
               LET s = finddirect(".ECCE-BAK", 7)
               deletefile(s)
               closedirect(s)
               retainfile(save_stream, 0, defaultaccess, n)
               UNLESS E4failcode = 0
               DO writef("Warning: Save of input file failed*N")
            }
         }
         ELSE
         {  filing_error(save_stream, E4failcode)
            request_file("File", toptr)
         }
      }
      ELSE
      {  arg_error("FROM", E4failcode)
         request_file("File", toptr)
      }
   }

   {  tostream := open(toptr, 7, 10, page_buffs, 0)
      IF tostream >= 0 
      {  UNLESS requested DO  // if writing to 'TO' file, tell user what it is.
         {  writes("File: ")
            print_filespec(tostream)
         }
         BREAK // success 
      }
   
      TEST (E4failcode & #XFF) = #X40 THEN
      {  TEST (toptr!2 & #XFF) = 0 THEN // open request 
         {  arg_error("TO", E4failcode)
            IF yes_reply("Create?", TRUE) THEN
            {  toptr!2 := 7    // change to create request
               toptr!5 := input_pages
               toptr!6 := defaultunits
               toptr!10 := defaultaccess
               LOOP
            }
         }
         ELSE 
         {  arg_error("TO", E4failcode)
            IF yes_reply("Overwrite?", TRUE) THEN
            {  toptr!2 := 0 // change to open 
               toptr!5 := 0
               toptr!6 := principal
               LOOP
            }
         }
      }
      ELSE arg_error("TO", E4failcode)
      request_file("File", toptr)
   } REPEAT
   selectoutput(out)
}1 

AND close_streams(ok_exit) BE
{1 IF ok_exit & inplace THEN
   {  deletefile(save_stream)
      closedirect(save_stream)
   }

   UNLESS retain DO deletefile(logstream)
   close(logstream)

   IF work_stream>=0 THEN closedirect(work_stream)
   IF withstream>=0 THEN
   {  selectinput(withstream)
      endread()
   }
   IF outstream>=0 THEN
   {  selectoutput(outstream)
      endwrite()
   }
}1
