
GET ".ECCE-HDR"
GET ".SFO-HDR/3/S"

STATIC {
sin_last = ?    // last secondary line - set by connect_sin
sin_rec = ?     // current secondary record number.
noted_in_line = ?
noted_in_pos = ?
noted_out_line = ?
noted_out_pos = ?

pr_last = ?     // primary file save area - 'last_line'
pr_ml = ?       // as above - 'ml'
pr_cursor = ?   // as above - 'cursor'
pr_line = ?     // as above - 'cur_line'

sin_ml = ?      // secondary input save area - 'ml'
sin_cursor = ?  // as above - 'cursor'
sin_line = ?    // as above - 'cur_line'
}

LET start_e6(fspec, v) BE
/* Connect secondary input to 'fspec' if possible, no error report regardless.
*/
{1 so_stream := errorvalue
   noted_out_line, noted_out_pos := 1, 0
   sin_stream := errorvalue
   UNLESS fspec%0=0 & fspec%5=0 RETURN  // must be disc open filespec.
   sin_stream := open(fspec, 1, 1, v, 0)
   IF sin_stream < 0 RETURN   // failed.

   sin_last, sin_ml := 0, 0
   sin_cursor, sin_line := 0, 1
   noted_in_line, noted_in_pos := 1, 0

   {  IF seek_next(sin_stream) = errorvalue THEN
      {  sin_rec := 2
         seek_page(sin_stream, 0)
         RETURN
      }
      sin_last +:= 1
   } REPEAT
}1
 
AND connect_sin(file, v) = VALOF
{1 LET analysed = VEC 19
   
   IF sin THEN switch_sin()

   UNLESS file = nil DO analyse.it(file, analysed)
   IF file = nil |
      (analysed%0 = 0 & analysed%5 = 4) THEN
   {  // Disconnect the secondary input stream.
      UNLESS sin_stream < 0 DO close(sin_stream)  // if open then close.
      sin_stream := errorvalue  // set undefined.
      RESULTIS TRUE
   }

   UNLESS analysed%0 = 0 & analysed%5 = 0
   {  writef("Not an open filespec*N")
      RESULTIS FALSE // not a filespec 
   }
   IF sin_stream >= 0 THEN close(sin_stream) // if already connected.
   sin_stream := open(analysed, 1, 1, v, 0)
   IF sin_stream<0 THEN
   {  print_fs_err(E4failcode)
      RESULTIS FALSE
   }

   sin_last, sin_ml := 0, 0
   sin_cursor, sin_line := 0, 1
   noted_in_line, noted_in_pos := 1, 0
   
   reset_byte_count()
   {  LET len = seek_next(sin_stream)
      IF len = errorvalue THEN
      {  print_byte_count()
         sin_rec := 2  // record number of next 'get' record.
         seek_page(sin_stream, 0)
         RESULTIS TRUE
     }
     add_byte_count(len-1)  // assume record length contains *L and *C
     sin_last +:= 1
   } REPEAT
}1

AND switch_sin() = VALOF
{1 TEST sin THEN
   {  // switch secondary input off.
      sin_ml, sin_cursor, sin_line := ml, cursor, cur_line
      sin := FALSE
      cue := ">"
      file_in_stream := 0
      last_line, cur_line := pr_last, pr_line
      set_line(cur_line)
      ml := pr_ml
      cursor := pr_cursor
   }
   ELSE
   {  // switch secondary input on.
      IF sin_stream <= 0 RESULTIS FALSE  // cannot switch on if no file
      IF altered THEN
      {  altered := FALSE   // if current line changed then save it.
         store_line(cur_line, cur_len, line)
      }
      pr_last, pr_ml, pr_cursor, pr_line := last_line, ml, cursor, cur_line
      sin := TRUE
      cue := ">>"
      file_in_stream := sin_stream
      cur_line, last_line := sin_line, sin_last
      set_line(cur_line)
      ml, cursor := sin_ml, sin_cursor
   }
   RESULTIS TRUE
}1

AND fetch_sin_line(num, line) = VALOF
/* Fetch secondary line number 'num' into buffer 'line' and return
   length as result.
*/
{1 TEST num > sin_rec THEN 
      FOR i=1 TO num-sin_rec DO seek_next(sin_stream)
   ELSE FOR i=1 TO sin_rec-num DO seek_last(sin_stream)

   sin_rec := num+1   // record number of next 'get' record.
   RESULTIS ReadUnpackedLine(line, line_bsz) + 1   // plus one for 'newline'.
}1

AND insert_ln(n, offset) BE
/* Insert secondary line number 'n' before current line in the primary
   file. If offset is non-zero then subtract it from the actual length.
*/
{1 LET v = VEC line_bsz
   LET l = fetch_sin_line(n, v) -1
    
   IF l = errorvalue RETURN
   IF w_space = 0 THEN make_space(TRUE)
   add_byte_count(store_line(cur_line, l-offset, v+offset))
   cur_line +:= 1
}1
 
AND insert_lines(first, last) BE
/* Insert secondary lines from 'first' to 'last' before 'cur_line'
   in the primary file.
*/
{1 FOR i=first TO last DO 
   {  insert_ln(i, 0)
      check_for_interrupt()
   IF w_space > 0 THEN make_space(FALSE)
}1

AND insert_string(num, len, offset) = VALOF
/* Insert text from secondary line 'num' from word offset 'offset'
   before cursor in primary file. If at EOF then insert the text as
   a new line. If 'len' is negative then subtract it from the actual
   length of the line.
*/
{1 LET v = VEC line_bsz
   LET l = fetch_sin_line(num, v) - 1
   
   IF len <= 0 THEN len := l+len
   TEST cur_line > last_line THEN
   {  // Insert a new line
      make_space(TRUE)
      add_byte_count(store_line(cur_line, len, v+offset))
      cur_line +:= 1
      make_space(FALSE)
   }
   ELSE
   {  IF cur_len + len > line_bsz RESULTIS FALSE
      shuffle(len)
      copy_cells(len, v + offset, line+cursor)
      cursor +:= len
      add_byte_count(len)
   }
   RESULTIS TRUE
}1

AND abstract_in(start_line, start_pos, end_line, end_pos) = VALOF
{1 LET lines = end_line - start_line

   IF lines < 0 RESULTIS FALSE

   IF lines = 0 THEN
   {  // Insert text before cursor.
      LET l = end_pos - start_pos
      IF l <= 0 | l + cur_len > line_bsz RESULTIS FALSE
      insert_string(start_line, l , start_pos)
      RESULTIS TRUE
   }

   TEST cursor = 0 THEN
   {  insert_ln(start_line, start_pos) 
      make_space(FALSE)
   }
   ELSE
   {  // Insert first line before cursor.
      IF cursor + start_pos > line_bsz RESULTIS FALSE
      insert_string(start_line, -start_pos, start_pos)
      break_line(1)
   }

   // Insert remaining complete lines before current line.

   IF lines > 1 THEN insert_lines(start_line+1, end_line-1) 

   IF end_pos = 0 RESULTIS TRUE
   
   IF end_pos + cur_len > line_bsz RESULTIS FALSE
   insert_string(end_line, end_pos, 0)
   RESULTIS TRUE
}1

AND connect_so(file, v) = VALOF
{1 LET analysed = VEC 19
   
   IF file = nil THEN
   {  // Disconnect secondary output stream.
      UNLESS so_stream < 0 DO close(so_stream)
      so_stream := errorvalue  // set undefined.
      RESULTIS TRUE
   }
   analyse.it(file, analysed)
   UNLESS analysed%0 = 0 
   {  writef("Not a filespec*N")
      RESULTIS FALSE 
   }
   IF so_stream >= 0 THEN close(so_stream)   // if already connected.
   set_defaults(analysed)
   so_stream := open(analysed, 7, 1, v, 0)
   IF so_stream < 0 THEN
   {  print_fs_err(E4failcode)
      RESULTIS FALSE
   }
   noted_out_line, noted_out_pos := 1, 0
   RESULTIS TRUE
}1

AND write_text(num, len, offset) = VALOF
{1 LET v = VEC  line_bsz
   LET r = ?
   LET l = fetch_line(num, v) - 1

   IF len <= 0 THEN len := l+len
   r := WriteUnpackedLine(len, v + offset)

   UNLESS r = errorvalue DO add_byte_count(len + 1)

   RESULTIS r = errorvalue -> E4failcode, 0
}1

AND write_lines(start, fin) = VALOF
{1 LET v = VEC line_bsz
   
   FOR i=start TO fin DO
   {  LET l = fetch_line(i, v)
      
      IF WriteUnpackedLine(l-1, v) = errorvalue RESULTIS errorvalue
      add_byte_count(l)
      check_for_interrupt()
   }
   RESULTIS 0
}1
 
AND abstract_out(start_line, start_pos, end_line, end_pos) = VALOF
{1 IF start_line = end_line THEN 
   {  IF start_pos >= end_pos RESULTIS errorvalue
      RESULTIS write_text(start_line, end_pos-start_pos, start_pos)
   }

   UNLESS write_text(start_line, -start_pos, start_pos) = 0 &
          write_lines(start_line+1, end_line-1) = 0
   DO RESULTIS E4failcode

   IF end_pos = 0 RESULTIS 0

   RESULTIS write_text(end_line, end_pos, 0)
}1

AND do_a(rep) = VALOF 
{1 LET ok, r = ?, rep
   
   reset_byte_count()

   {  TEST sin THEN
      {  switch_sin()    // select primary file.
         file_in_stream := sin_stream  // since 'switch_sin' deselects it.
         ok := abstract_in(noted_in_line, noted_in_pos, sin_line, sin_cursor)
         switch_sin()    // re-select secondary file.
      }
      ELSE
      {  IF so_stream < 0 | noted_out_line > cur_line RESULTIS 0
         file_out_stream := so_stream
         ok := abstract_out(noted_out_line, noted_out_pos, cur_line, cursor)
         file_out_stream := 0
         TEST ok = 0 THEN ok := TRUE
         ELSE
         {  UNLESS E4failcode = 0
            DO filing_error(so_stream, E4failcode)
            ok := FALSE
         }
      }
      
      r -:= 1
   } REPEATWHILE ok & r > 0

   print_byte_count()
   RESULTIS ok -> rep, 0    // number of repetitions completed.
}1

AND do_n() = VALOF
{1 IF cur_line > last_line RESULTIS 0 // cannot Note at EOF.
   TEST sin THEN noted_in_line, noted_in_pos := cur_line, cursor
   ELSE 
   {  IF so_stream < 0 RESULTIS 0   // failure
      noted_out_line, noted_out_pos := cur_line, cursor
   }
   RESULTIS 1
}1

AND value_n() BE
/* Display value of noted position on current output stream.
*/
{1 LET format = "Line: %n, character: %n*N"
   TEST sin THEN writef(format, noted_in_line, noted_in_pos)
   ELSE writef(format, noted_out_line, noted_out_pos)
}1
