$<PDPRSX
GET "LIBHDR"
GET "SPEHDR"
$>PDPRSX

$<CAP1
GET "LIBHDR"
GET "SYSHDR"
GET ".progs.spehdr"
$>CAP1

STATIC  $( interactive = TRUE  $)		// False if winding through to end


LET check ( sorted.input ) BE			// read through it and check
$(
    LET word = VEC wordsperword+2		// buffer for word
    LET lc, co = ?, ?				// line number, frequency

    interactive := TRUE				// Just to be sure at start
    word := word + 2
    word!-1 := FALSE
    word%0 := 0					// empty to start with

    $(
	Selectinput( sorted.input )		// read a word
	readword( word )
	lc := read.pair()
	co := BINRDCH()
	IF TERMINATOR<0 THEN BREAK		// end of file
	checkword( word, lc, co, sorted.input )	// check it
    $) REPEAT

$<PDPRSX    DELETEINPUT()	// throw away sorted input				$>PDPRSX

$<CAP1      ENDREAD()		// frees slot for sorted input anon file implicitly	$>CAP1

$)


AND checkword( word, line, count, sorted.input ) BE
$(
    LET d = ?

  $(RPT
    d := dictword%0 = 0 -> 1, comparestring (dictword, word)
    SWITCHON d INTO
    $(CASES
      CASE -1:					// keep skipping thru lexicons
        TEST dictword=mylexword THEN
        $(
            LET cmp = comparestring(syslexword, mylexword)
            TEST cmp=0				// remove private words that are
	      THEN readsysword(syslexword)
              ELSE writemylexword(mylexword)	// in system lexicon
            readmylexword( mylexword )
        $)
        ELSE readsysword(syslexword)

        dictword := comparestring(syslexword, mylexword) < 0 ->
                     syslexword, mylexword
        IF dictword%0=0 THEN dictword:=dictword=syslexword->mylexword,syslexword
        ENDCASE

      CASE 0:
      CASE0:
	TEST dictword!-1
	THEN
        $(  LET oldin = INPUT()
            LET oldout = OUTPUT()
	    LET all.upper, initial.upper = TRUE, TRUE
	    LET better = dictword!-2
	    LET tempvec = VEC wordsperword

            SELECTINPUT (SYSIN)
            SELECTOUTPUT (SYSOUT)

	    initial.upper := 'A' <= word%1 <= 'Z'
	    FOR I=1 TO word%0 DO
	        IF 'a' <= word%I <= 'z'
		   THEN all.upper := FALSE

	    FOR I=1 TO (better)%0
		DO tempvec%I := all.upper -> CAPITALCH( better%I ), better%I
	    tempvec%0 := better%0

	    IF initial.upper
		THEN tempvec%1 := CAPITALCH( tempvec%1 )
		    TEST can.correct.file
		    THEN
		    $(
	    		checkforfirstquestion( TRUE )
	    		Writenodeinfo(word, line, count)
        		TEST interactive
			THEN
			$(
	    		    WRITEF ("                     Do you want it corrected to %S? ",tempvec)
$<CAP1      		    WRCH('*E')					$>CAP1
			    dictword!-2 := tempvec
	    		    get.and.dealwith.answer( TRUE, word, line, count, sorted.input, oldout )
	  		    dictword!-2 := better
			$)
			ELSE error.with.poss.correct( word, line, count, tempvec )
		    $)
		    ELSE
		    $(
			Writenodeinfo( word, line, count )
			error.with.poss.correct( word, line, count, tempvec )
		    $)

	    SELECTOUTPUT( oldout )
	    SELECTINPUT( oldin )
            BREAK
	$)
	ELSE BREAK


      CASE +1:
        IF ucequalstring (dictword, word)
           THEN GOTO CASE0			// thats OK too

        $(  LET oldin = INPUT()
            LET oldout = OUTPUT()

            SELECTINPUT (SYSIN)
            SELECTOUTPUT (SYSOUT)

	    checkforfirstquestion( FALSE )

            writenodeinfo( word, line, count )	// and ask about this word

	    TEST interactive
	    THEN
	    $(
		WRITES ("                     Is this a word? ")
$<CAP1  	WRCH('*E')						$>CAP1
	        get.and.dealwith.answer( FALSE, word, line, count, sorted.input, oldout )
	    $)
	    ELSE another.error( word, line, count )

	    SELECTINPUT(oldin)
	    SELECTOUTPUT(oldout)
	    BREAK

	$)
    $)CASES
  $)RPT  REPEAT						// till we match or overrun
$)


AND writenodeinfo(word, line, count) BE
$(
    WRITEF("%S occurs ",word)
      Writef(( count<4 -> (
             count=1 -> "once",
             count=2 -> "twice",
             count=3 -> "thrice", "many"), "%N times"), count)
    WRITEF ("%S in line %N*N",
	    count=1 -> "",", starting",
	    line)
$)

AND do.quit(sorted.input) BE
$(
$<PDPRSX
      Selectoutput( newlexstr )
      Deleteoutput()		// new lexicon
      Selectoutput(errors)
      Deleteoutput()		// error stream
      Selectinput(syslexstr);	Endread()
      Selectinput(mylexstr);	Endread()
      Selectinput( sorted.input )
      DELETEINPUT()
      FINISH
$>PDPRSX

$<CAP1
      SELECTOUTPUT( newlexstr )
      ENDWRITE()			// new lexicon was anon, so will go away
      UNLESS errors = 0 DO		// close & delete errors file
      $(
	LET rc = ?
	SELECTOUTPUT( errors )
	ENDWRITE()
	MOVESTRING( error.name , K.N0 )
	rc := ENTER( CURRENT.DIR , DIRMAN.REMOVE )
	UNLESS rc = 0 DO
	$(
	    SELECTOUTPUT( MSTREAM )
	    WRITEF("*N******Warning - errors file %S preserved - %S*N",
		error.name , FAULT(rc))
	$)
      $)
      UNLESS syslexstr = 0 DO
      $(
	SELECTINPUT( syslexstr )
	ENDREAD()			// System lexicon closed
      $)
      UNLESS mylexstr = 0 DO
      $(
	SELECTINPUT( mylexstr )
	ENDREAD()			// User lexicon closed
      $)
      SELECTINPUT( sorted.input )
      ENDREAD()				// Anon sort file will go away
      FINISH
$>CAP1
$)

AND checkforfirstquestion( funny ) BE
    IF firstquestion THEN		// tell him his options
    $(
$<PDPRSX	ATTACH( SYSIN )			$>PDPRSX
	Writes("Reply Y (yes); N (no); E (eccentric); Q (quit);*N*
	       *      W (wind through to end - rest are errors);*N*
	       *      L (place in lexicon in lower case);*N")

$<PDPRSX
	TEST can.correct.file THEN
	Writes("      word (correct spelling to this);")
			    ELSE
	Writes("      word (report correct spelling as this);")
$>PDPRSX

$<CAP1
	WRITES( errors = 0 -> can.correct.file ->
		"      word (correct spelling to this);",
		"      word (correct spelling, not reported or corrected);",
		can.correct.file ->
		"      word (correct spelling to this & report it);",
		"      word (report correct spelling as this);")
$>CAP1
	newline()
	Writes("      =word (as *'word*' but also remember this correct spelling).")

	newline(); newline()
	firstquestion := FALSE
    $)


AND get.and.dealwith.answer( funny, word, line, count, sorted.input, oldout ) BE
$(
     LET answer = VEC 80/BYTESPERWORD + 1
   try.again:
	readstring( answer, '*N' )
	TEST answer%0 > 1 THEN		// deem the answer NO and
					// dump correct spelling
	$(
		IF answer%1 = '=' THEN
		$(
		    LET bad = FALSE
			IF funny THEN	// =response to an =question not on
			$(
			    Writes("Not a reasonable reply - do you want it corrected? ")
$<CAP1			    Wrch('*E')					$>CAP1
			    GOTO try.again
			$)

			FOR I=1 TO answer%0 - 1
			DO $(
				LET ch = answer%(I+1)
				IF ch = ' ' THEN bad := TRUE
				answer%I := ch
			   $)
			FOR I=1 TO word%0 DO
			    IF word%I = '=' THEN bad := TRUE
			answer%0 := answer%0 - 1
			TEST NOT bad
			THEN $(
				word!-1 := TRUE
				word!-2 := answer
				writemylexword( word )
				word!-1 := FALSE
			     $)
			ELSE $(
				SELECTOUTPUT(sysout)
				Writes("Corrections containing space or for words containing = not allowed*N")
			     $)
		$)
	        errorcount := errorcount + count

$<CAP1		UNLESS errors = 0 DO					$>CAP1
		$(
		    SELECTOUTPUT( errors )
		    writenodeinfo( word, line, count )
		    WRITEF("     (correct%S %S)*N",
				can.correct.file -> "ed to", " spelling may be",
				answer)
		$)

		/* Do not be tempted to put in this next statement
		   without considering the ramifications of where it
		   should come in the lexicon, whether it is already there
		   and the like...
			Writeword( answer )
		*/

		remember.correction( word, answer )
		correctionstodo := correctionstodo + count
	$)

	ELSE

	$(
	    SWITCHON (answer%0 < 1 -> 'N', capitalch(answer%1)) INTO
	    $(
		CASE 'Q':			// quit - delete all new files
		      do.quit(sorted.input)

		CASE 'L':			// its correct in lower case
		      TEST funny
		      THEN			// 'l' response to an =question not on
		      $(
			    Writes("L not a reply here - do you want it corrected? ")
$<CAP1			    Wrch('*E')					$>CAP1
			    GOTO try.again
		      $)
		      ELSE
		      $(
			    LET tempvec = VEC wordsperword + 2

			    tempvec := tempvec + 2
			    tempvec!-1 := FALSE
		            tempvec%0 := word%0

			    FOR i=1 TO word%0
			    DO TEST 'A'<= word%i <='Z'
	 			THEN tempvec%i := word%i - 'A' + 'a'
				ELSE tempvec%i := word%i
       			    SELECTOUTPUT (oldout)

               		    writemylexword ( tempvec )	// shove in lexicon
		      $)
		      ENDCASE

	  	CASE 'Y':
		      TEST funny
		      THEN $(
$<CAP1				UNLESS errors=0 DO			$>CAP1
				$(
					SELECTOUTPUT( errors )
					writenodeinfo( word, line, count )
					Writef("    (corrected to %S)*N",dictword!-2)
				$)
				remember.correction( word, dictword!-2 )
				correctionstodo := correctionstodo + count
				errorcount      := errorcount      + count
				ENDCASE
			   $)
		      ELSE $(
		      		FOR I=1 TO word%0 DO
				    IF word%I='=' GOTO disallow
		      		SELECTOUTPUT (oldout)
               	      		writemylexword ( word )	// shove in lexicon
		      		ENDCASE
		   	      disallow:
		      		SELECTOUTPUT( SYSOUT )
		      		Writes("Words containing = not allowed*N")
		      		SELECTOUTPUT (oldout)
		      		ENDCASE
			    $)

	  	CASE 'E':
		      ENDCASE

		CASE 'W':
						// Wind through giving rest errors
		      interactive := FALSE	// by making non-interactive
		      another.error( word, line, count )
		      SELECTOUTPUT (oldout)
		      ENDCASE

	  	DEFAULT:			// all else -> no
		      IF TERMINATOR=Endstreamch THEN
		      $(
$<PDPRSX		  Wrch('*N')					$>PDPRSX
			  interactive := FALSE
		      $)
		      another.error( word, line, count )
		      SELECTOUTPUT (oldout)
		      ENDCASE
	   $)
        $)
$)


AND another.error( word, line, count ) BE
$(
	errorcount := errorcount + count

$<CAP1	UNLESS errors = 0 DO						$>CAP1
	$(
		SELECTOUTPUT( errors )
		writenodeinfo( word, line, count )
	$)
$)


AND error.with.poss.correct( word, line, count, correction ) BE
$(
	another.error( word, line, count )

$<CAP1	UNLESS errors = 0 DO						$>CAP1
		WRITEF("    (correct spelling may be %S)*N", correction)
$)
