// Program to compress a lexicon

$<PDPRSX
NEEDS "IOERROR"
GET "LIBHDR"
GET "SPEHDR"
$>PDPRSX

$<CAP1
GET "LIBHDR"
GET ".progs.spehdr"
$>CAP1

LET START() BE
$(
    LET t     = ?
    LET word1 = VEC wordsperword + 2
    LET word2 = VEC wordsperword + 2
    LET word3 = VEC wordsperword
    LET word4 = VEC wordsperword


$<PDPRSX
    mylexstr    := Findinput( "LEXICON" )
    newlexstr         := Findoutput( "LEXICON" )

	IF mylexstr<0 THEN Writef("Cannot open Lexicon - ") <>
		     Writef(IOerror(mylexstr),mylexstr,"LEXICON") <>
		     FINISH
$>PDPRSX

$<CAP1
    LET using.anon.file, s = ?, ?
    LET slot = GETSLOT()

    LET fatal.error.exit( in.err ) BE		// Error exit routine
    $(
	LET io.err = FAULT(ERRORCODE)
	SELECTOUTPUT(MSTREAM)
	WRITEF("*NFATAL ERROR - Cannot open %S file - %S*N", in.err -> "input", "output", io.err)
	FINISH
    $)

    mylexstr := FINDINPUT( "1|FROM|.lexicon" )	// Input file open
    IF mylexstr = 0 THEN fatal.error.exit( TRUE )
    MOVECAP( K.N0 , slot )			// Save filename just mylexstr case

    newlexstr := FINDOUTPUT( "2|TO|/A" )	// Output file open
    IF newlexstr = 0 THEN fatal.error.exit( FALSE )
    using.anon.file := EQSTRING( K.N0 , "/A" )

    UNLESS EXTRAITEMS() DO			// Warn about rubbish on command line
    $(
	LET o = OUTPUT()
	LET s = GETSLOT()
	MOVECAP( K.N0 , s )
	SELECTOUTPUT(MSTREAM)
	WRITEF("*N******Warning - unrecognized items on command line - %S*N",s)
	FREESLOT( s )
	UNLESS o = 0 DO SELECTOUTPUT( o )
    $)

$>CAP1

    word1 := word1 + 2
    word2 := word2 + 2
    word1!-1, word1!-2 := FALSE, word3
    word2!-1, word2!-2 := FALSE, word4

    word1%0:=0
    Selectinput( mylexstr )
    Selectoutput( newlexstr )

    $(
	readmylexword( word2 )
	IF word2%0 = 0 THEN BREAK
	Writeword( word2, word1 )
        $( LET t=word2
           word2:=word1
           word1:=t
        $)
    $) REPEAT

$<CAP1
    s := GETSLOT()				// just in case
    SELECTINPUT( mylexstr )			// Close all files
    ENDREAD()
    SELECTOUTPUT( newlexstr )
    ENDWRITE()
    IF using.anon.file THEN			// Rename if used anon file
    $(
	LET rc = ?
	MOVECAP( K.N0 , s )
	rc := PRESERVE( s , slot , DEFAULT.SEG.AM )
	IF rc < 0 THEN
	$(
	    SELECTOUTPUT( MSTREAM )
	    WRITEF("*NCannot update lexicon - %S*N", FAULT(rc) )
	$)
    $)
    FREESLOT( s )				// Tidy up slots
    FREESLOT( slot )
$>CAP1

$)


AND writeword(word, prevword) BE
$(
$<CAP1
   MANIFEST $( syslinelength = 254 $)		// CAP prefers long lines in system lexicon
$>CAP1
$<PDPRSX
   MANIFEST $( syslinelength = 72 $)
$>PDPRSX

   STATIC $( first=TRUE; linelength=syslinelength $)

   LET length=word%0 + (word!-1 -> (word!-2)%0, 0 )

   $( LET j=prevword%0
      FOR i=1 TO prevword%0
      DO IF word%i ~= prevword%i
         THEN $( j:=i-1
                 BREAK
              $)
      IF j=1 THEN j:=0

      UNLESS j=0
      DO length:=length+1-j
      <> IF j>9 THEN length:=length+1

      linelength := linelength + length + 1
      TEST linelength > syslinelength
      THEN $(
		UNLESS first DO NEWLINE()
		first := FALSE
		linelength := length
   	   $)
      ELSE WRCH('*S')

      UNLESS j=0 DO writen(j)
      FOR i=j+1 TO word%0 DO wrch(word%i)
      IF word!-1 THEN
      $(
	LET j=word%0
	LET new = word!-2
	Wrch('=')
      	FOR i=1 TO word%0
      	    DO IF new%i ~= word%i
         	THEN $( j:=i-1
                 	BREAK
              	     $)
      	IF j=1 THEN j:=0

      	UNLESS j=0 DO writen(j)
      	FOR i=j+1 TO new%0 DO wrch(new%i)
      $)
   $)
$)

