NEEDS "SYSTEM"
SECTION "MAXVEC"

GET "LIBHDR"
GET "SYSHDR"
GLOBAL $( SETUPHEAP: 210
        $)
STATIC $( HEAPSTART=0 $)


/*

	BCPL heap handler for the top of the task image. If there is
	insufficient room to allocate a new vector, then the task is
	extended if possible. If the top vector in the heap is freed
	then the task image size is reduced.
		DWS 28 july 79
			( with thanks to Peter Robinson )
*/


LET Setupheap() BE
$(
	LET s = VEC 15
	System(s.gtsk, s<<1 )
	Heapstart := s!13 >> 1
	System(s.extk, 1)
	!Heapstart := 31
	Heapstart!31 := 0
	Getvec := getext
	Freevec := freeext
$)

AND getext(n) = VALOF
$(
	LET vector = Heapstart
	n := n + 2
	$(
		LET length = !vector
		IF length >= n DO
		$(
			UNLESS length = n DO vector!n := length - n
			!vector := -n
			IF vector = Heapstart THEN WHILE !Heapstart<0 DO
    					Heapstart := Heapstart-!Heapstart
			RESULTIS vector + 1
		$)
		IF vector!length = 0 THEN
		$(
			LET new = (n-length+32)/32
			IF new < 32 THEN new := 32
			IF System(s.extk, new ) < 0 THEN BREAK
			vector!length := new*32
			!vector := vector!length + length
			vector!(vector!0) := 0
			LOOP
		$)
		vector := vector + length
		WHILE !vector < 0 DO vector := vector - !vector
	$) REPEAT
	RESULTIS Ie.nbf
$)

AND freeext(vector) BE
$(
	LET length = ?
	vector := vector - 1
	!vector := -!vector
	IF vector < Heapstart THEN Heapstart := vector
	vector := Heapstart
	$(
		length := !vector
		WHILE vector!length > 0 DO length := length + vector!length
		IF ( vector!length=0 ) & ( length >=1024 ) THEN
		$(
			IF System(s.extk, -(length/32)) >=0 THEN
			$(
				length := length REM 32
				vector!length := 0
			$)
		$)
		!vector := length
		vector := vector + length
		WHILE !vector < 0 DO vector := vector - !vector
	$) REPEATUNTIL !vector = 0
$)


