$<PDPRSX
GET "LIBHDR"
GET "SPEHDR"
$>PDPRSX

$<CAP1
GET "LIBHDR"
GET ".progs.spehdr"
$>CAP1

LET open.lexicons() BE
$(
$<PDPRSX
    syslexstr, mylexstr := Findinput(syslex.name),  Findinput(mylex.name)

    IF syslexstr < 0 THEN
    $(
	LET o = output()
	Selectoutput(SYSOUT)
	Writes("******Warning - unable to read system lexicon -*N")
	Writef(IOerror(syslexstr),syslexstr,syslex.name)
	Newline(); Newline()
	Selectoutput(o)
    $)

    IF mylexstr < 0 THEN
    $(
	LET o = output()
	Selectoutput(SYSOUT)
	Writes("****Warning - unable to open private lexicon -*N")
	Writef(IOerror(mylexstr),mylexstr,mylex.name)
	Newline(); Newline()
	Selectoutput(o)
    $)

    readmylexword( mylexword )
    readsysword (syslexword)

    // setup the first word ...

    dictword := comparestring(syslexword, mylexword)<0 -> syslexword, mylexword
    IF dictword%0=0 THEN dictword:=dictword=syslexword->mylexword,syslexword

    newlexstr := FINDOUTFILE( mylex.name )

$>PDPRSX


$<CAP1
    LET syslex.error() BE			// Routine to report un-availabilty of system lexicon
    $(
	LET o = OUTPUT()
	LET lex.error = FAULT(ERRORCODE)
	SELECTOUTPUT(MSTREAM)
	WRITEF("*N******Warning - unable to read system lexicon - %S*N*N",lex.error)
	UNLESS o = 0 DO SELECTOUTPUT(o)
    $)

    // Open system lexicon first, if not specified on command line try to look
    // up the file ".lexicon" in the directory whose capability should be bound
    // into slot P7 of the pcb. (P7 given by the nasty constant #X40070000)
    // If this fails a warning message will be printed.

    syslexstr := FINDINPUT("SYSLEX")
    IF syslexstr = 0 THEN
	TEST ERRORCODE = PARMS.MISSING
	THEN
	$(
	    MANIFEST	$( K.P7 = #X40070000	$)

	    LET user.dir = CURRENT.DIR		// Save user directory
	    CURRENT.DIR := K.P7			// Get SPELL one
	    syslexstr := FINDINPUT(".systemlexicon")	// Try getting system lexicon
	    CURRENT.DIR	:= user.dir		// Restore world
	    IF syslexstr = 0 THEN syslex.error()
	$)
	ELSE syslex.error()

    // Open users own lexicon for reading, if not specified by LEXICON
    // keyword on command line, lookup file ".lexicon" in current directory.
    // If this fails a warning message will be printed.
    // The new version of the user lexicon is initially opened to an anon
    // file, and the name of the user lexicon is saved in mylex.name so
    // it can be renamed at the end.

    mylex.name := GETSLOT()
    mylexstr := FINDINPUT("LEXICON|.lexicon")
    MOVECAP ( K.N0 , mylex.name )
    IF mylexstr = 0 THEN
    $(
	LET lex.error = FAULT(ERRORCODE)
	LET o = OUTPUT()
	SELECTOUTPUT(MSTREAM)
	WRITEF("*N******Warning - unable to read private lexicon - %S*N*N",lex.error)
	UNLESS o = 0 DO SELECTOUTPUT(o)
    $)

    readmylexword ( mylexword )
    readsysword (syslexword)

    // setup the first word ...

    dictword := comparestring(syslexword, mylexword)<0 -> syslexword, mylexword
    IF dictword%0=0 THEN dictword:=dictword=syslexword->mylexword,syslexword

    // Open an anon file to write the new user lexicon to
    newlexstr := FINDOUTFILE( "/A" )

$>CAP1

$)

AND close.lexicons() BE			// and copy through
$(

$<CAP1
    LET new.lex,rc = ?,?
$>CAP1

    Selectoutput( newlexstr )
    UNTIL mylexword%0 = 0 DO
    $(  LET cmp = (syslexword%0=0) -> 1, comparestring(syslexword, mylexword)
        TEST cmp<0
	THEN readsysword(syslexword)
        ELSE TEST cmp=0 THEN
             $(
		readsysword(syslexword)
		readmylexword( mylexword )
             $)
	     ELSE
             $(
        	writemylexword ( mylexword )
		readmylexword( mylexword )
	     $)
    $)

$<PDPRSX
    Selectinput(mylexstr)
    TEST Endwrite()>=0 THEN Deleteinput() ELSE Endread()
    Selectinput(syslexstr)
    Endread()
$>PDPRSX

$<CAP1
    UNLESS mylexstr = 0 DO			// Close old user lexicon input
    $(
	SELECTINPUT(mylexstr)
	ENDREAD()
    $)

    new.lex := GETSLOT()			// Close new user lexicon output
    ENDWRITE()					// Preserve as file if possible
    MOVECAP( K.N0 , new.lex )
    rc := PRESERVE( new.lex ,mylexstr=0 -> ".lexicon",mylex.name , DEFAULT.SEG.AM)
    UNLESS rc = 0 DO
    $(
	LET err.lex = FAULT( rc )
	SELECTOUTPUT(MSTREAM)
	WRITEF("*N******Warning, failed to update private lexicon - %S*N",err.lex)
    $)
    FREESLOT( new.lex )				// Free slots not needed anymore
    FREESLOT( mylex.name )

    UNLESS syslexstr = 0 DO			// Close system lexicon input
    $(
	SELECTINPUT(syslexstr)
	ENDREAD()
    $)
$>CAP1

$)

