//  SPELL.BCP
//  Program to check speeling
// Upgraded DWS 9 jul 80
//  Auto-correction PR 26 Sep 80
//  Compressed system lexicon handling DWS 22 jan 81
//  Attach/detach around question asking added DWS 22 jan 81

NEEDS "TITLE"
NEEDS "IOERROR"
NEEDS "PHBASE"
NEEDS "PHCREATE"
NEEDS "PHERROR"
NEEDS "PHINFO"

GET "LIBHDR"
GET "PHHDR"

GLOBAL
$(  linecount:		201
    wordcount:		202
    dictword:		203
    errors:		204
    findtvec:		205
    setupheap:		210
    mylexword:		211
    mylexstr:		212
    syslexword:		213
    syslexstr:		214
    linelength:		215
    newoutput:		216
    distinctwordcount:	217
    correctionstodo:	218
    errorcount:		219
    firstquestion:	220
$)


MANIFEST
$(  l.count		= 0
    l.first		= 1
    l.minus		= 2
    l.plus		= 3
    l.correction	= 4
    l.string		= 5
    charsperword	= 100
    resident		= 25
    maxlinelength	= 72
$)


LET START() BE
$(
    LET dictwordvec1 = VEC charsperword/BYTESPERWORD + 1
    LET dictwordvec2 = VEC charsperword/BYTESPERWORD + 1
    LET fvec = VEC 100
    LET root = 0
    LET phvec = ?
    LET oldinput = ?

    findtvec := fvec
    syslexword, mylexword := dictwordvec1, dictwordvec2

    setupheap()
    findio()
    phvec := GETVEC(resident*256)

    Ph.init(phvec, resident*256)
    Ph.create("LEXICON.PH", 256, 0, 0)
    Ph.open("LEXICON.PH", FALSE)

    distinctwordcount := 0
    correctionstodo   := 0
    errorcount        := 0
    firstquestion     := TRUE
    buildtree (@root)

    oldinput := REWIND ()

    syslexstr, mylexstr := Findinput("LB:[1,1]LEXICON"),  Findinput("LEXICON")
//  syslexstr, mylexstr := Findinput("LEXICON.SYS"),  Findinput("LEXICON")

    IF syslexstr < 0 THEN
    $(
	LET o = output()
	Selectoutput(SYSOUT)
	Writes("******Warning - unable to read system lexicon -*N")
	Writef(IOerror(syslexstr),syslexstr,"LB:[1,1]LEXICON")
	Newline(); Newline()
	Selectoutput(o)
    $)

    IF mylexstr < 0 THEN
    $(
	LET o = output()
	Selectoutput(SYSOUT)
	Writes("****Warning - unable to open private lexicon -*N")
	Writef(IOerror(mylexstr),mylexstr,"LEXICON")
	Newline(); Newline()
	Selectoutput(o)
    $)

    Selectinput(mylexstr);    READSTRING (mylexword, '*S')
    Selectinput(syslexstr);   readsysword (syslexword)

    dictword := comparestring(syslexword, mylexword)<0 -> syslexword, mylexword
    IF dictword%0=0 THEN dictword:=dictword=syslexword->mylexword,syslexword

    errors := OUTPUT()
    SELECTOUTPUT (FINDOUTPUT ("LEXICON"))

    linelength := maxlinelength

    ATTACH(SYSIN)
     checktree (root)
    DETACH(SYSIN)

    UNTIL mylexword%0 = 0 DO
    $(  LET cmp = comparestring(syslexword, mylexword)
        TEST cmp<0 THEN
        $(
            Selectinput(syslexstr) ; Readsysword(syslexword)
        $)
        ELSE TEST cmp=0 THEN
        $(
            Selectinput(syslexstr) ; Readsysword(syslexword)
            Selectinput(mylexstr) ;  Readstring(mylexword, ' ')
        $) ELSE
        $(
            writeword (mylexword)
            Selectinput(mylexstr)
            READSTRING (mylexword, '*S')
        $)
    $)
    Selectinput(mylexstr)
    TEST Endwrite()>=0 THEN Deleteinput() ELSE Endread()

    Selectoutput(errors)
    TEST errorcount=0
	THEN Deleteoutput()
	ELSE Endwrite()

    IF newoutput >= 0 THEN
    $(
	selectoutput (newoutput)
	TEST correctionstodo > 0 THEN
	$(
            selectinput (oldinput)
            docorrections (root)
	$)
	ELSE deleteoutput ()
    $)

    Selectoutput(Sysout)
    writef ("%N words read (%N distinct) in %N lines*N",
                wordcount, distinctwordcount, linecount)
    TEST errorcount=0 THEN Writes("No")
		      ELSE Writen(errorcount)
    writef (" error%S", [errorcount NE 1->"s",""] )
    UNLESS errorcount=0 DO
      TEST (newoutput >= 0) & (correctionstodo>0)
         THEN writef(", %N corrected",
                        correctionstodo)
	 ELSE writes(", none corrected")
    newline()
    Writef("Paging used %N blocks ",
              Ph.info(Ph.info.hwm)+1)
    $(
        LET ioc = Ph.info(Ph.info.io)
        Writef((ioc=0 -> "and no transfers*N",
           "and %N transfer%S*N"),ioc,(ioc=1->"","s"))
    $)
    Ph.close(0)

    Freevec(phvec)
    Selectinput(Findinput("LEXICON.PH"))
    Deleteinput()
$)


AND buildtree (root) BE
$(  LET word = VEC charsperword/BYTESPERWORD + 1
    LET inword = FALSE
    LET lettercount = 0
    LET ch = ?

    linecount := 1
    wordcount := 0

    $(  ch := RDCH()
        SWITCHON ch INTO
        $(CASES
        CASE '*N':
	CASE '*T': CASE '*S': CASE '*P': CASE '*C':
        CASE ',':  CASE '.':  CASE ';':  CASE ':':
        CASE '?':  CASE '!': CASE '#': CASE '|':
        CASE '*'':  CASE '*"':
        CASE '(':  CASE ')':
        CASE '[':  CASE ']':

        CASE '_': CASE '=':
        CASE '**': CASE '<': CASE '>':

        CASE ENDSTREAMCH:
            IF inword THEN
            $(  inword := FALSE
                word%0 := lettercount
                lettercount := 0
                record (root, word)
                wordcount := wordcount + 1
            $)
            IF ch = '*N' THEN
                linecount := linecount + 1
            ENDCASE
        DEFAULT:
            inword := TRUE
            lettercount := lettercount + 1
            word%lettercount := ch
            ENDCASE
        $)CASES
    $)  REPEATUNTIL ch = ENDSTREAMCH
$)


AND record (node, string) BE
$(  TEST !node = 0 THEN
    $(  LET l = length (string)
        LET leaf = Ph.getvec (l.string + l)
        LET aleaf = Ph.access(leaf)
        FOR i = 0 TO l DO
            (aleaf + l.string)!i := string!i
        aleaf!l.minus := 0
        aleaf!l.plus := 0
        aleaf!l.first := linecount
        aleaf!l.count := 1
        aleaf!l.correction := 0
        !node := leaf
        distinctwordcount := distinctwordcount + 1
    $)
    OR
    $(  LET d = ?
        node := Ph.access(!node)
        d := comparestring (string, node + l.string)
        SWITCHON d INTO
        $(CASES
        CASE +1:
            record (node+l.plus, string)
            ENDCASE
        CASE -1:
            record (node+l.minus, string)
            ENDCASE
        CASE 0:
            node!l.count := node!l.count + 1
            ENDCASE
        $)CASES
    $)
$)


AND length (string) = (string%0)/BYTESPERWORD


AND comparestring (a, b) = VALOF
$(  LET m, n = a%0, b%0
    LET l = min (m, n)
    LET d = ?

    FOR i = 1 TO l DO
    $(  LET x, y = a%i, b%i
        d := (CAPITALCH (x) - CAPITALCH (y))
        UNLESS d = 0
            RESULTIS sign (d)
    $)

    d := m - n
    UNLESS d = 0
        RESULTIS sign (d)

    FOR i = 1 TO l DO
    $(  LET x, y = a%i, b%i
        d := x - y
        UNLESS d = 0
            RESULTIS sign (d)
    $)

    RESULTIS 0
$)


AND min (x, y) = (x < y -> x, y)


AND sign (x) = (x > 0 -> 1, x < 0)

/*
AND printtree (knode) BE
    UNLESS knode = 0 DO
    $(
        LET node = Ph.access(knode)
        printtree (node!l.minus)
        node := Ph.access(knode)
        WRITEF ("%S occurs %N time%S in line %N*N", node+l.string,
            node!l.count, (node!l.count = 1 -> ",", "s, starting"), node!l.first)
        printtree (node!l.plus)
    $)
*/

AND checktree (knode) BE UNLESS knode = 0 DO
$(
    LET node=Ph.access(knode)
    LET d = ?

    checktree(node!l.minus)
    node := Ph.access(knode)
  $(RPT
    d := dictword%0 = 0 -> 1, comparestring (dictword, node+l.string)
    SWITCHON d INTO
    $(CASES
      CASE -1:
        TEST dictword=mylexword THEN
        $(
            LET cmp = comparestring(syslexword, mylexword)
            TEST cmp=0
               THEN Selectinput(syslexstr) <> Readsysword(syslexword)
               ELSE writeword(mylexword)
            Selectinput(mylexstr)
            Readstring(mylexword, '*S')
        $)
        ELSE
        $(
            Selectinput(syslexstr)
            Readsysword(syslexword)
        $)
        dictword := comparestring(syslexword, mylexword) < 0 ->
                     syslexword, mylexword
        IF dictword%0=0
            THEN dictword:=dictword=syslexword->mylexword,syslexword
        ENDCASE

      CASE 0:
        BREAK

      CASE +1:
        IF ucequalstring (dictword, node+l.string)
                    THEN BREAK
        IF VALOF
        $(
            FOR I=1 TO (node+l.string)%0 DO
                UNLESS '0'<=((node+l.string)%I)<='9' RESULTIS FALSE
            RESULTIS TRUE
        $) THEN BREAK

        $(  LET oldin = INPUT()
            LET oldout = OUTPUT()
            LET ch = ?
	    LET answer = VEC 40


            SELECTINPUT (SYSIN)
            SELECTOUTPUT (SYSOUT)

	    IF firstquestion THEN
	    $(
		Writes("Reply Y (yes); N (no); E (eccentric); Q (quit);*N*
		       *      L (place in lexicon in lower case);*N")
		TEST newoutput >= 0 THEN
		Writes("      word (correct spelling to this).")
				    ELSE
		Writes("      word (report correct spelling as this).")
		newline(); newline()
		firstquestion := FALSE
	    $)

            writenodeinfo(node)
            WRITES ("                     Is this a word? ")
	    Readstring( answer, '*N' )
	    TEST answer%0 > 1 THEN	// deem the answer NO and
					// dump correct spelling
	    $(
	        errorcount := errorcount + node!l.count
		Selectoutput(errors)
		Writenodeinfo(node)
		Writef("    (correct%S %S)*N",
			newoutput >= 0 -> "ed to", " spelling may be",
			answer)
		Selectoutput(oldout)
		/* Do not be tempted to put in this next statement
		   without considering the ramifications of where it
		   should come in the lexicon, whether it is already there
		   and the like...
			Writeword( answer )
		*/
		$(
		    LET l = length (answer)
		    LET correction = Ph.getvec (l)
		    LET ac = Ph.access (correction)
    		    FOR i = 0 TO l DO
			ac!i := answer!i
		    node := Ph.access (knode)
		    node!l.correction := correction
		    correctionstodo := correctionstodo + node!l.count
		$)
		Selectinput(oldin)
		BREAK
	    $)
            ELSE $(
		ch := (answer%0 < 1 -> 'N', capitalch(answer%1))
		SWITCHON ch INTO
		$(
		  CASE 'Q':
			Selectoutput(oldout)
			Deleteoutput()		// new lexicon
			Selectoutput(errors)
			Deleteoutput()
			Ph.close(0)
			Selectinput(syslexstr); Endread()
			Selectinput(mylexstr); Endread()
			Selectinput(Findinput("LEXICON.PH"))
			Deleteinput()
		 	IF newoutput >= 0 THEN
			$(
			    selectoutput (newoutput)
			    deleteoutput ()
			$)
			FINISH

		  CASE 'Y':

               		SELECTOUTPUT (oldout)
                       	writeword (node+l.string)
			ENDCASE

		  CASE 'L':

	    		SELECTOUTPUT (oldout)
			FOR i=1 TO (node+l.string)%0
			DO IF 'A'<=(node+l.string)%i<='Z'
		   	THEN (node+l.string)%i :=
				(node+l.string)%i - 'A' + 'a'
			writeword (node+l.string)
			ENDCASE

		  CASE 'E':

               		SELECTOUTPUT(oldout)
			ENDCASE

		  DEFAULT:
                       	IF TERMINATOR=Endstreamch THEN Wrch('*N')
	        	errorcount := errorcount + node!l.count
                       	SELECTOUTPUT(errors)
                       	writenodeinfo(node)
                       	SELECTOUTPUT (oldout)
			ENDCASE
               $)
               SELECTINPUT (oldin)
               BREAK
	   $)
        $)
     $)CASES
  $)RPT  REPEAT
        checktree (node!l.plus)
$)


AND ucequalstring (a, b) = VALOF
$(  FOR i = 0 TO a%0 DO
        UNLESS CAPITALCH (a%i) = CAPITALCH (b%i) DO
            RESULTIS FALSE
    RESULTIS TRUE
$)

AND writenodeinfo(node) BE
$(
    WRITEF("%S occurs ",node+l.string)
      Writef(( node!l.count<4 -> (
             node!l.count=1 -> "once",
             node!l.count=2 -> "twice",
             node!l.count=3 -> "thrice", "many"), "%N times"), node!l.count)
    WRITEF ("%S in line %N*N",
        node!l.count=1 -> "",", starting",
        node!l.first)
$)


AND findio() BE
$(
    LET in, out = ?, ?
    LET outcount = ?
    Selectinput(Findcml("SPE"))
    $(  IF RDCH() = ENDSTREAMCH THEN
            STOP()
        UNRDCH()
        outcount := FINDTITLES (2, findtvec, "/.ERR/")
        in := FINDINPUT (findtvec!4)
        IF in < 0 THEN
        $(
            Writes("SPE -- ")
            Writef(Ioerror(in),in,findtvec!4)
            LOOP
        $)
        TEST (findtvec!2)%0 > 0
	   THEN out := FINDOUTPUT (findtvec!2)
	   ELSE out := 0
        IF out < 0 THEN
        $(
            Writes("SPE -- ")
            Writef(Ioerror(out),out,findtvec!2)
            LOOP
        $)
        TEST (findtvec!0)%0 > 0 THEN
        $(
	    newoutput := Findoutput (findtvec!0)
	    IF newoutput < 0 THEN
	    $(
	    	writes ("SPE -- ")
		writef (ioerror(newoutput), newoutput, findtvec!2)
		LOOP
	    $)
	$)
	OR
	    newoutput := -1
        BREAK
    $)  REPEAT
    ENDREAD()

/*
    SELECTINPUT (FINDSTRINGINPUT (findtvec!1))
    $(  SWITCHON RDCH() INTO
        $(
        CASE '/':
            RDCH()
            ENDCASE
        DEFAULT:
            BREAK
        $)
        UNRDCH()
    $)  REPEAT
    ENDREAD()
*/

    SELECTINPUT (in)
    SELECTOUTPUT (out)
$)

AND writeword(word) BE
$(
   STATIC $( first=TRUE $)

   linelength := linelength + word%0 + 1
   TEST linelength > maxlinelength
   THEN $(
		UNLESS first DO NEWLINE()
		first := FALSE
		linelength := word%0
	$)
   ELSE WRCH('*S')
   WRITES(word)
$)

AND docorrections (root) BE
$(
    LET word = VEC charsperword/bytesperword + 1
    LET inword = false
    LET lettercount = 0
    LET ch = ?
    LET o = OUTPUT()

    Selectoutput(SYSOUT)
	Writes("  (starting correction pass)*N")
    Selectoutput(o)

    $(
        ch := rdch ()
        SWITCHON ch INTO
    	$(cases
	CASE '*N':
	CASE '*T': CASE '*S': CASE '*P': CASE '*C':
	CASE ',': CASE '.': CASE ';': CASE ':':
	CASE '?': CASE '!': CASE '#': CASE '|':
	CASE '*'': CASE '*"':
	CASE '(': CASE ')':
	CASE '[': CASE ']':
	CASE '_': CASE '=':
	CASE '**': CASE '<': CASE '>':
	CASE endstreamch:
	    IF inword THEN
	    $(
		LET c = ?
		inword := false
		word%0 := lettercount
		lettercount := 0
		c := findword (root, word)
		TEST c = 0 THEN
		    writes (word)		//  Never should happen!
		OR
		$(
		    TEST c!l.correction = 0 THEN
			writes (word)
		    OR
		    $(
			c := ph.access (c!l.correction)
			writes (c)
		    $)
		$)
	    $)
	    UNLESS ch = endstreamch DO
		wrch (ch)
	    ENDCASE
	DEFAULT:
	    inword := true
	    lettercount := lettercount + 1
	    word%lettercount := ch
 	    ENDCASE
	$)cases
    $)  REPEATUNTIL ch = endstreamch
$)


AND findword (node, string) = VALOF
$(
    UNLESS node = 0 DO
    $(
        LET d = ?
	node := ph.access (node)
	d := comparestring (string, node + l.string)
	SWITCHON d INTO
	$(cases
	CASE +1:
	    RESULTIS findword (node!l.plus, string)
	CASE -1:
	    RESULTIS findword (node!l.minus, string)
	$)cases
    $)
    RESULTIS node
$)

AND readsysword( oldword ) BE
$(
    LET p = READN()
	UNRDCH()
	$(
	    TERMINATOR := RDCH()
		IF TERMINATOR<0 | TERMINATOR='*N' | TERMINATOR='*S'
		   THEN BREAK
		p := p + 1
		oldword%p := TERMINATOR
	$) REPEAT
	oldword%0 := p
$)
