GLOBAL
$(

$<PDPRSX
    g0:			0		// Global zero
    findtvec:		UG+   0		// find-titles vector
$>PDPRSX

    newoutput:		UG+   1		// output stream
$<LOG
    log:		UG+   2		// log stream
$>LOG
    errors:		UG+   3		// error stream
    mylexstr:		UG+   4		// private lexicon input stream
    syslexstr:		UG+   5		// system lexicon input stream
    newlexstr:		UG+   6		// new private lexicon stream

    seedset:		UG+   7		// vector of seed words
    oldnode:		UG+   8		// previous node we wrote out
    heapvec:		UG+   9		// pseudo heap
    heapvecsize:	UG+  10		// size of it
    heapvecpointer:	UG+  11		// where we are in it

    version:		UG+  12		// first LEXICON.SOR version we made (PDPRSX)
					// Number of anon sort files (CAP)

    linecount:		UG+  13		// line number of source
    wordcount:		UG+  14		// total words in input
    distinctwordcount:	UG+  15		// sic
    correctionstodo:	UG+  16		// how many corrections to do
    errorcount:		UG+  17		// how many mistakes
    firstquestion:	UG+  18		// TRUE if first question
    correction.list:	UG+  19		// list of corrections

    dictword:		UG+  20		// current dictionary word
    mylexword:		UG+  21		// word from private lexicon
    syslexword:		UG+  22		// word from system lexicon
    linelength:		UG+  23		// length of line in new lexicon

    comparestring:	UG+  24		// dictionary compare
    ucequalstring:	UG+  25		// equalstring + capitalch
    findinfile:		UG+  26		// findinput & check
    findoutfile:	UG+  27		// findoutput & check

    open.lexicons:	UG+  28		// open lexicon streams & setup
    close.lexicons:	UG+  29		// windup lexicon streams
    readsysword:	UG+  30		// read word from system lexicon (selects syslexstr)
    readmylexword:	UG+  31		// read word from user lexicon (selects mylexstr)
    writemylexword:	UG+  32		// write word to private lexicon

    build.tree:		UG+  33		// build trees
    write.tree:		UG+  34		// write out a tree
    merge:		UG+  35		// merge all intermediate files
    find.newoutput:	UG+  36		// find new intermediate file
    getnode:		UG+  37		// get a piece of pseudo-heap

    readword:		UG+  38		// read intermediate file word
    read.pair:		UG+  39		// and its line-count

    check:		UG+  40		// check sorted input
    remember.correction: UG+  41	// remember a correction
    do.corrections:	UG+  42		// sic
    can.correct.file:	UG+  43		// boolean

    mylex.name:		UG+  44		// Lexicon names

$<PDPRSX
    syslex.name:	UG+  45
$>PDPRSX

$<CAP1
//  Globals for those library routines and constants not available on CAP
    capitalch:		UG+  46		// uppercase chars
    readstring:		UG+  47
    SYSIN:		UG+  48		// For terminal input stream
    TERMINATOR:		UG+  49         // To be UNRDCHed into, UGH
    sort.file.cap:	UG+  50		// Vector for capabilities for anon sorting files
    error.name:		UG+  51		// Error file name
  $<LOG
    start.time:		UG+  52		// Program start time for time tests
  $>LOG
    Old.selectinput:	UG+  53		// The real routines!
    Old.selectoutput:	UG+  54
    SYSOUT:		UG+  55		// Contains the same as MSTREAM
$>CAP1
    Read.input.word:	UG+  56		// Get a word from INPUT stream
    Min:		UG+  57		// Guess

$<PDPRSX
    big.global:		300		// to get a lot of globals
$>PDPRSX

$)

MANIFEST
$(  l.count		= 0		// node offsets
    l.first		= 1
    l.minus		= 2
    l.plus		= 3
    l.string		= 4
    charsperword	= 100		// maximum number of chars per word
    wordsperword	= charsperword/BYTESPERWORD + 1
    maxlinelength	= 72		// for private lexicons

$<PDPRSX
    Low.priority        = 40		// Priority for CPU bound parts
$>PDPRSX
$<CAP1
    maxsortversion	= 15		// Max size of vector for anon sort file capabilities
$>CAP1

$)
