NEEDS "SYSTEM"

GET "LIBHDR"
GET "SYSHDR"

MANIFEST $(
   TC.TTP = #10			     // terminal type
   IO.GMC = #2560		     // Get multiple characteristics
   IO.SMC = #2440		     // Set multiple characteristics
	 $)

GLOBAL $(
	Term.lun:	UG+ 0
	Term.flag:	UG+ 1
       $)

LET start() BE
$(
    LET cml = Findcml("VDU")
    LET list= 0
    LET name = VEC 40
    LET rc = ?
	Term.lun := SYSIN
	Term.flag:= GETFLAG()
	make.list( @list )
	$(
		Selectinput( cml )
		Readstring( name, '*N' )
		IF Terminator<0 THEN FINISH
		IF name%0 = 0
		   THEN $(
				write.list( @list )
				write.type( @list, read.type() )
				LOOP
			$)
		rc := find.name( @list, name )
		IF rc = 0
		   THEN $(
				writes("No such type:*N")
				write.list( @list )
				LOOP
			$)
		set.type( rc )
		FINISH
	$) REPEAT
$)

AND make.list( at.head ) BE
$(
    LET add.list( a, n, v, e ) BE
    $(
	LET o = GETVEC( 3 )
	o!0 := !a
	o!1 := n
	o!2 := v
	o!3 := e
	!a  := o
    $)

//*********New types go in here***********//
	add.list( at.head, "HAZEL", #213, "Hazeltine executive 80" )
	add.list( at.head, "LYME", #212, "LYME 5000" )
	add.list( at.head, "CMC", #211, "Cambridge Micro-computers" )
	add.list( at.head, "AMPEX", #207, "Ampex dialogue 80" )
	add.list( at.head, "GT101", #206, "GT 101" )
	add.list( at.head, "ADM" , #204, "ADM80a" )
	add.list( at.head, "3101", #205, "IBM 3101" )
	add.list( at.head, "2632", #210, "Cifer 2632" )
	add.list( at.head, "2605", #203, "Cifer 2605 (Rutherford version)" )
	add.list( at.head, "7009", #202, "Newbury 7009 (seven screen version, or modified 7004/9)" )
	add.list( at.head, "7004", #201, "Newbury 7004, unmodified, and old 7009 unmodified" )
	add.list( at.head, "VT55" , #12, "DEC VT55" )
	add.list( at.head, "VT52" , #11, "DEC VT52" )
	add.list( at.head, "VT100", #15, "DEC VT100" )
$)

AND write.list( at.head ) BE
$(
    LET n = !at.head
    Writes("Available types are*N")
    UNTIL n = 0 DO
	Writef("%S*T*T%S*N",n!1,n!3) <> n:=n!0
$)

AND find.name( at.head, name ) = VALOF
$(
    LET n = !at.head
	UNTIL n=0 | Equalstring( n!1, name ) DO n := n!0
	IF n=0 RESULTIS 0
	RESULTIS n!2
$)

AND write.type( at.head, t ) BE
$(
    LET n    = !at.head
	IF t=0 THEN Writes("Current type is unset*N") <> RETURN
	UNTIL n=0 | n!2 = t DO n := n!0
	TEST n=0 THEN Writef("Current type is %O3*N",t)
		 ELSE Writef("Current type is %S*N",n!1)
$)

AND set.type( n ) BE
$(
    LET buf, dsw = TC.TTP + (n<<8), ?
    dsw := SYSTEM(S.QIOW, IO.SMC, Term.lun, Term.flag, 0, 0, (@buf)<<1, 2)
$)

AND read.type() = VALOF
$(
    LET buf, dsw  =  TC.TTP, ?        // => Byte order = right,left

    dsw := SYSTEM(S.QIOW, IO.GMC, Term.lun, Term.flag, 0, 0, (@buf)<<1, 2)
    RESULTIS (@buf)%1
$)
