 
// File BCPLOCLISTHDR
 
// Header file for BCPL OCODE listing program
 
// Copyright R.D. Eager UKC   MCMLXXXIII
 
 
GET "LIBHDR"
 
MANIFEST $(
 
// Parameter decoder error codes
 
par.ok    = 0               // No errors
par.err   =  -320           // Format error in parameter string
par.amb   =  -321           // Ambiguous keyword
par.unk   =  -322           // Unknown keyword
par.xs    =  -323           // Too many parameters
par.dup   =  -324           // Duplicated parameter
par.mis   =  -325           // Missing keyword
$)
 
MANIFEST $(
linemax   = 132  // Number of characters on a line
pagedepth = 64   // Number of lines on a page
maxcol    = 2    // Number of columns on a page
colsize   = linemax/maxcol
$)
 
GLOBAL $(
iname              : 100
oname              : 101
paramdecode        : 102
options            : 103
matchstrings       : 104
old_stop           : 105   // Copy of entry point to library routine STOP
is                 : 106
os                 : 107
pagebuffer         : 108
colptr             : 109
pageptr            : 110
chptr              : 111
$)
 
MANIFEST $( // OCODE operations
s.true        = 4
s.false       = 5
s.rv          = 8
s.fnap        = 10
s.mult        = 11
s.div         = 12
s.rem         = 13
s.plus        = 14
s.minus       = 15
s.query       = 16
s.neg         = 17
s.abs         = 19
s.eq          = 20
s.ne          = 21
s.ls          = 22
s.gr          = 23
s.le          = 24
s.ge          = 25
s.not         = 30
s.lshift      = 31
s.rshift      = 32
s.logand      = 33
s.logor       = 34
s.eqv         = 35
s.neqv        = 36
s.lp          = 40
s.lg          = 41
s.ln          = 42
s.lstr        = 43
s.ll          = 44
s.llp         = 45
s.llg         = 46
s.lll         = 47
s.needs       = 48
s.section     = 49
s.rtap        = 51
s.goto        = 52
s.finish      = 68
s.switchon    = 70
s.global      = 76
s.mc          = 77
s.sp          = 80
s.sg          = 81
s.sl          = 82
s.stind       = 83
s.slctap      = 84
s.jump        = 85
s.jt          = 86
s.jf          = 87
s.endfor      = 88
s.labx        = 89
s.lab         = 90
s.stack       = 91
s.store       = 92
s.rstack      = 93
s.entry       = 94
s.save        = 95
s.fnrn        = 96
s.rtrn        = 97
s.res         = 98
s.datalab     = 100
s.iteml       = 101
s.itemn       = 102
s.endproc     = 103
s.prcl        = 104
s.rtcall      = 105
s.fncall      = 106
s.slctst      = 107
s.labr        = 108
s.mark        = 109
s.segend      = 110
s.setgl       = 111
s.getbyte     = 120
s.putbyte     = 121
$)
 
// End of file BCPLO_BCPLOHDR
 
