
// File BCPLQ_BCPLQSRC

// Version: Q1.14   (also alter MANIFESTs below)

// BCPL OMF code generator for ICL 2900 under VME

// Copyright (C) R.D. Eager   University of Kent   MCMLXXXIV


// History:
//   Q1.0  - Initial version
//   Q1.1  - Addition of code to add synonyms to output file.
//   Q1.2  - Addition of AMODE parameter and supporting code.
//         - Addition of full support for UTILITY parameter
//         - Global vector not generated for subroutine packages
//   Q1.3  - Corrections to handling of 'labv'.
//   Q1.4  - Addition of checks in 'getvec' calls.
//         - Many vectors now acquired via 'getvec'.
//   Q1.5  - Correction to DR initialisation when UTILITY=NO.
//   Q1.6  - Correction to RTRN/FNRN code when UTILITY=NO.
//         - Correction to system vector initialisation.
//   Q1.7  - Correction to initialise 'type3_count' at  start  of code
//           generation.
//   Q1.8  - Addition   of   DIRECTCALL   parameter,  to  enable  direct
//           (relative) calls to STATIC routines and functions.
//         - Correction  to ensure data area offset correct when writing
//           to OMF file.
//         - Modification  to  avoid  access  to  system   vector   when
//           generating an externally callable subroutine package.
//   Q1.9  - Warning  about  'no  globals set' suppressed for separately
//           callable code.
//         - Spurious instruction (LSS.X) suppressed  if  there  are  no
//           entry points to initialise.
//         - Code  altered  to  cater  for  STATICs stored in the PLT if
//           UTILITY=NO. Currently   this   is   not   switchable;    if
//           UTILITY=YES  then  STATICs  are  stored  at  the end of the
//           global vector, and if UTILITY=NO they  are  stored  in  the
//           PLT.
//         - Correction    to   'process_section_and_needs'   to   avoid
//           truncation of section names to 8 characters.
//   Q1.10 - Addition  of  table  linking  IINs to the corresponding PLT
//           entries (type 3 items only). This is  necessary  because  a
//           straight  scan  of  the  PLT would be confused by arbitrary
//           numbers of STATIC variables if they are being stored there.
//         - Correction  to  'loadlvx'  to yield correct (byte)
//           address if AMODE=BYTE.
//         - Correction to code for STATIC access, to ensure XNB  points
//           at the PLT before the access is made.
//         - Correction  to 'cgstring', to clear ACC slave after loading
//           address of in-line string constant.
//   Q1.11 - Reorganisation  of  code  handling 'iteml' and 'datalab' so
//           that labels are no longer stored in 'datav' or 'pltv',  but
//           in  a  new  table called 'slabv'. This avoids corruption of
//           label items by unfortunately phased table items.
//         - Removal of code to validate 'labv' at the end of a segment;
//           it does not do the job correctly any more, because  of  the
//           rearrangement of data structures.
//         - Correction to code of 'cgbyteselector', to use byte offsets
//           instead of word offsets if AMODE=BYTE.
//   Q1.12 - Correction  to  'dump_plt_fixups'  so  that  no reliance is
//           placed on previous table contents.
//         - Codegenerator version placed in OMF file as  VERSION  value
//           if VERSION parameter omitted.
//         - XNB value now restored on entry to a routine  or  function,
//           and after return from same if global.  This applies only if
//           UTILITY=NO.
//   Q1.13 - Correction to 'cggenselector' to clear ACC slave.
//         - Correction to 'print_sizes' for data area sizes.
//         - Correction  to  'start'  to  copy  and  default  module and
//           procedure names.
//   Q1.14 - Correction to 'getbyte' and 'putbyte' register slaving.
//         - Improvement to 'getbyte' and 'putbyte' constant code.

SECTION "ICL9CEZBCPLQ"


MANIFEST $(   // Alter these if changes are made
version = 1   // Major version number
edit    = 14   // Edit number within major version
$)

/* Stop codes:-
    0  - Success
 1000  - Parameter error
 1001  - Internally detected error
Others - I/O error
*/

MANIFEST $(

// Parameter decoder error codes

par.ok  =  0   // No errors
par.err = -1   // Format error
par.amb = -2   // Ambiguous keyword
par.unk = -3   // Unknown keyword
par.xs  = -4   // Too many parameters
par.dup = -5   // Duplicated parameter
par.mis = -6   // Missing keyword
par.igv = -7   // Illegal value for GLOBSIZE parameter
par.iwv = -8   // Illegal value for WORKSIZE parameter
par.itv = -9   // Illegal value for TRACE parameter
par.ipv = -10  // Illegal value for PROFILE parameter
par.inv = -11  // Illegal value for STATSIZE parameter
par.iov = -12  // Illegal value for OMF parameter
par.ivn = -13  // Illegal value for VERSION parameter
par.isv = -14  // Illegal value for STEER parameter
par.iuv = -15  // Illegal value for UTILITY parameter
par.iav = -16  // Illegal value for AMODE parameter
par.idv = -17  // Illegal value for DIRECTCALL parameter
$)


GET "BCPLQ_BCPLQHDR"

// Bits in COMREG(27) (EMAS only)

MANIFEST $(
cr.notrace  = #x00000040   // Disable tracing
cr.profile  = #x00000080   // Enable profiling
cr.code     = #x00004000   // Enable code listing
cr.opt      = #x00010000   // Disable all tracing and checks
$)

MANIFEST $( keymax = 16 $)

STATIC $( parptr = ?; parleng = ?; options = ?; old_readn = ? $)

STATIC $( old_plant = 0 $)

LET start() BE
$( LET keys = VEC keymax
   AND defaults = VEC keymax
   AND opt = VEC maxstrlength/bytesperword + 2*keymax
   AND comreg27 = emas_ -> comreg!27, 0
   AND traced_lib_file = emas_ -> "VME_OLIBT", "BCPLOCODELIBT"
   AND opt_lib_file = emas_ -> "VME_OLIBN", "BCPLOCODELIBN"
   AND omfn = VEC emas_ -> 7, 0
   AND pn = 16/bytesperword
   AND mn = 16/bytesperword

   options, procname, modulename := opt, pn, mn

   IF emas_ THEN
   $( TEST comreg!9 NE 0 THEN
      $( param := comreg!9 >> 2   // Pick up auxiliary parameters
         compiler_ := FALSE
      $)
      OR compiler_ := TRUE

      errorstream := comreg!40 GE 0

      TEST old_plant = 0 THEN old_plant := plant OR plant := old_plant
   $)

   keys!0  := keymax
   keys!1  := "OCODE"        ; defaults!1  := emas_ -> (compiler_ -> "T#OCODE", 0), "**STDAD"
   keys!2  := "LOCODE"       ; defaults!2  := 0
   keys!3  := "GLOBSIZE"     ; defaults!3  := "400"
   keys!4  := "WORKSIZE"     ; defaults!4  := "50000"
   keys!5  := "OMF"          ; defaults!5  := ""
   keys!6  := "PROCEDURE"    ; defaults!6  := 0
   keys!7  := "MODULE"       ; defaults!7  := 0
   keys!8  := "TRACE"        ; defaults!8  := "YES"
   keys!9  := "STATSIZE"     ; defaults!9  := "3000"
   keys!10 := "PROFILE"      ; defaults!10 := "NO"
   keys!11 := "CODELIST"     ; defaults!11 := 0
   keys!12 := "VERSION"      ; defaults!12 := "0000"
   keys!13 := "STEER"        ; defaults!13 := emas_ -> "NO", "YES"
   keys!14 := "UTILITY"      ; defaults!14 := emas_ -> "YES", "NO"
   keys!15 := "AMODE"        ; defaults!15 := 0
   keys!16 := "DIRECTCALL"   ; defaults!16 := 0

   UNLESS emas_ DO selectoutput(journal)

   TEST emas_ THEN
      writef("*N%SBCPL codegenerator (VME) - version Q%N.%N*N%S",
          compiler_ -> "", "*N*N              University of Kent ", version, edit, compiler_ -> "", "*N*N*N")
   OR
      writef("University of Kent BCPL codegenerator - version Q%N.%N*N", version, edit)

   FOR i = 1 TO param%0 DO
   $( LET c = param%i

      IF 'a' LE c LE 'z' THEN
         param%i := c - 'a' + 'A'
   $)

   paramdecode(keys, options)
   IF emas_ THEN
   $( IF param%0 = 1 & param%1 = '?' THEN
      $( selectoutput(journal)
         writes("Parameters are:-*N")
         FOR i = 1 TO keymax DO
         $( writes(keys!i)
            IF defaults!i NE 0 THEN writef("=%S", defaults!i)
            UNLESS i = keymax DO wrch(',')
         $)
         newline()
         stop(0)
      $)
      IF (options!0 GE 0) & NOT compiler_ & (options!1 NE 0) THEN
         options!0 := par.dup   // Duplicated parameter
   $)

   IF options!0 < 0 DO paramerr()

   FOR i = 1 TO keymax DO
      IF options!i = 0 THEN options!i := defaults!i

   TEST emas_ THEN
   $( LET p = comreg!52                 // Name of object file

      omfname := omfn
      move(0%p+1, p, omfname<<2)

      p := ".NULL"                      // Alter object file name to stop Subsystem
      move(p%0+1, p<<2, comreg!52)      // filling in history information
   $)
   OR
   $( check_yes_or_no(options!8, par.itv)
      check_yes_or_no(options!10, par.ipv)

      omfname := options!5
   $)

   globsize := strtonum(options!3)
   UNLESS 100 LE globsize LE 5000 DO options!0 := par.igv

   statsize := strtonum(options!9)
   UNLESS 200 LE statsize LE 50000 DO options!0 := par.inv

   progver := strtonum(options!12)
   UNLESS 0 LE progver LE 9999 DO options!0 := par.ivn
   IF progver = 0 THEN progver := version*100 + edit

   worksize := strtonum(options!4)
   UNLESS 25000 LE worksize LE 250000 DO options!0 := par.iwv

   IF options!0 < 0 DO paramerr()

   ocode := options!1
   locode := options!2

   $( LET t = omfname   // Set defaults for program and module names

      IF t%0 = 0 THEN t := "BCPLPRG"

      IF options!6 = 0 THEN
      $( LET p = getspace(32/bytesperword)

         FOR i = 0 TO t%0 DO p%i := t%i
         options!6 := p
      $)

      IF options!7 = 0 THEN
      $( LET p = getspace(32/bytesperword)

         FOR i = 0 TO t%0 DO p%i := t%i
         options!7 := p
      $)
   $)

   TEST emas_ THEN
   $( tracing_  := (comreg27 & cr.notrace) = 0
      profiling_:= (comreg27 & cr.profile) NE 0
      IF (comreg27 & cr.opt) NE 0 THEN
         tracing_, profiling_ := FALSE, FALSE
      codelist_ := (comreg27 & cr.code) NE 0
   $)
   OR
   $( tracing_ := matchstrings(options!8, "YES")
      profiling_ := matchstrings(options!10, "YES")
      codefile := options!11
      codelist_ := codefile NE 0
   $)

   IF options!0 >= 0 THEN
   $( LET x = options!13

      TEST matchstrings(x, "YES") THEN
         steering_ := TRUE
      OR TEST matchstrings(x, "NO") THEN
         steering_ := FALSE
      OR options!0 := par.isv   // Invalid value for STEER parameter
   $)

   IF options!0 >= 0 THEN
   $( LET x = options!14

      TEST matchstrings(x, "YES") THEN
         utility_ := TRUE
      OR TEST matchstrings(x, "NO") THEN
         utility_ := FALSE
      OR options!0 := par.iuv   // Invalid value for UTILITY parameter
   $)

   IF options!0 >= 0 THEN
   $( LET x = options!15

      IF x = 0 THEN x := utility_ -> "WORD", "BYTE"

      TEST matchstrings(x, "BYTE") THEN
         amode := am.byte
      OR TEST matchstrings(x, "WORD") THEN
         amode := am.word
      OR options!0 := par.iav   // Invalid value for AMODE parameter
   $)

   $( LET x = options!16

      IF x = 0 THEN x := utility_ -> "NO", "YES"

      TEST matchstrings(x, "YES") THEN
         directcall_ := TRUE
      OR TEST matchstrings(x, "NO") THEN
         directcall_ := FALSE
      OR options!0 := par.idv   // Invalid value for DIRECTCALL parameter
   $)

   IF options!0 < 0 THEN paramerr()

   $( LET x = options!6

      IF x = 0 THEN x := "BCPLPRG"

      FOR i = 0 TO x%0 DO procname%i := x%i
   $)

   $( LET x = options!7

      IF x = 0 THEN x := procname

      FOR i = 0 TO x%0 DO modulename%i := x%i
   $)

   IF locode = 0 THEN
      locode := tracing_ -> traced_lib_file, opt_lib_file

   truncate(modulename, "module name")
   truncate(procname, "program name")
   truncate(omfname, "name of OMF file")

   old_readn := readn
   readn := readnum   // Special version which checks for end of file

   xnbglobal := 0
   mainentry := 0
   mainprog_ := FALSE

   IF monitoring_ THEN
   $( LET mon_name = "T#MON"

      monfile := findoutput("T#MON")
      IF monfile < 0 THEN
      $( ioerror(mon_name, monfile)
         stop(ABS monfile)
      $)
      monitor("Start of monitor file*N")
   $)

   stop(ABS (aptovec(cgen, worksize)))
$)

AND check_yes_or_no(par, ecode) BE TEST emas_ THEN RETURN OR
   UNLESS matchstrings(par, "YES") \/ matchstrings(par, "NO") DO options!0 := ecode

AND truncate(str, mes) BE
   UNLESS str%0 LE 16 DO
   $( str%0 := 16
      comment("%S truncated to *'%S*'", mes, str)
   $)

AND iocp(ep, n) BE TEST NOT emas_ THEN RETURN OR
/* Interfaces to EMAS routine of the same name. Not used on VME. */
$( EXTERNAL $( s_iocp : "S#IOCP" $)
   s_iocp(ep, n)
$)

AND con_rdch() = NOT emas_ -> 0, VALOF
/* Special routine to read directly from connected OCODE file. Not  used
on VME. */
$( LET c = ?

   IF ocode_ptr GE !ocode_conad RESULTIS endstreamch

   c := ocode_conad%ocode_ptr
   ocode_ptr := ocode_ptr + 1
   RESULTIS c
$)

AND e_wrch(c) = NOT emas_ -> 0, VALOF
/* Write to EMAS error stream; not used on VME. */
$( LET o = comreg!23    // Current output channel

   iocp(9, comreg!40)   // SELECT OUTPUT(errors)
   iocp(5, c)           // PRINTCH(C)
   iocp(9, o)           // SELECT OUTPUT(O)

   RESULTIS 0
$)

AND monitor(s, a, b, c) BE TEST NOT monitoring_ THEN RETURN ELSE
/*  Output  formatted string 's' with parameters 'a', 'b' and 'c' to the
monitoring file. */
$( LET o = output()

   selectoutput(monfile)
   writef(s, a, b, c)
   selectoutput(o)
$)

AND paramerr() BE
$( LET mes = VALOF SWITCHON options!0 INTO
   $( CASE par.err:  RESULTIS "Illegal format"
      CASE par.amb:  RESULTIS "Ambiguous keyword"
      CASE par.unk:  RESULTIS "Keyword not recognised"
      CASE par.xs :  RESULTIS "Too many parameters"
      CASE par.dup:  RESULTIS "A parameter has been duplicated"
      CASE par.mis:  RESULTIS "Missing keyword"
      CASE par.itv:  RESULTIS "Illegal value for TRACE parameter"
      CASE par.ipv:  RESULTIS "Illegal value for PROFILE parameter"
      CASE par.igv:  RESULTIS "Illegal value for GLOBSIZE parameter"
      CASE par.inv:  RESULTIS "Illegal value for STATSIZE parameter"
      CASE par.iov:  RESULTIS "Illegal value for OMF parameter"
      CASE par.ivn:  RESULTIS "Illegal value for VERSION parameter"
      CASE par.iwv:  RESULTIS "Illegal value for WORKSIZE parameter"
      CASE par.isv:  RESULTIS "Illegal value for STEER parameter"
      CASE par.iuv:  RESULTIS "Illegal value for UTILITY parameter"
      CASE par.iav:  RESULTIS "Illegal value for AMODE parameter"
      CASE par.idv:  RESULTIS "Illegal value for DIRECTCALL parameter"
      DEFAULT:       RESULTIS ""
   $)
   selectoutput(journal)
   TEST emas_ THEN
      writef("%S%S*N", compiler_ -> "BCPLQ fails - ", "", mes)
   OR
      writef("Error in parameter list - %S*N", mes)

   stop(1000)
$)

AND paramdecode(keys, pars) BE
$( LET pmax, pnum = keys!0, 1
   LET wksp, pn = pars + pmax + 1, ?
   FOR i = 0 TO pmax DO pars!i := 0
   parptr := 0
   parleng := param%0
   $( LET c = getpar(wksp)
      pn := (c NE '=') -> pnum, VALOF
      $( LET n = findkey(keys, wksp)
         c := getpar(wksp)
         RESULTIS n
      $)
      pars!0 := VALOF
      $( LET l = wksp%0
         IF c = '='          RESULTIS par.err
         IF pn = -1          RESULTIS par.amb
         IF pn = -2          RESULTIS par.mis
         IF pn = 0           RESULTIS par.unk
         IF pn > pmax        RESULTIS par.xs
         IF l = 0            RESULTIS par.ok
         IF pars!pn NE 0     RESULTIS par.dup
         pars!pn := wksp
         wksp := wksp + l/bytesperword + 1
         RESULTIS par.ok
      $)
      UNLESS pars!0 = par.ok RETURN
      IF c = endstreamch RETURN
      pnum := pnum + 1
   $) REPEAT
$)

AND getpar(wksp) = VALOF
$( LET c, spcnt = ?, 0
   AND inpr, length = FALSE, 0

   $( c := getch(param)
      SWITCHON c INTO
      $( CASE endstreamch:
         CASE ',':
         CASE '=':
            wksp%0 := length
            RESULTIS c

         CASE '*S':
            spcnt := spcnt + 1
            ENDCASE

         DEFAULT:
            TEST inpr THEN
               FOR i = 1 TO spcnt DO
               $( length := length + 1
                  wksp%length := '*S'
               $)
            OR
               inpr := TRUE
            spcnt := 0
            length := length + 1
            wksp%length := c
      $)
   $) REPEAT
$)

AND findkey(keys, wksp) = VALOF
$( LET f = 0

   IF wksp%0 = 0 RESULTIS -2   // Missing keyword
   FOR i = 1 TO keys!0 DO
   $( IF matchstrings(wksp, keys!i) DO
      $( UNLESS f = 0 RESULTIS -1
         f := i
      $)
   $)
   RESULTIS f
$)

AND matchstrings(a, b) = VALOF
/* Yields TRUE iff 'a' is a leading substring of 'b'. */
$( LET l = a%0
   IF b%0 < l RESULTIS FALSE
   FOR i = 1 TO l DO
      UNLESS a%i = b%i RESULTIS FALSE
   RESULTIS TRUE
$)

AND getch(str) = VALOF
/* Yields the next character from the parameter string. */
$( parptr := parptr + 1
   RESULTIS parptr > parleng ->
   endstreamch, str%parptr
$)

AND strtonum(str) = VALOF
$( LET num = 0

   parptr := 0
   parleng := str%0

   IF parleng = 0 \/ str%1 < '0' \/ str%1 > '9' THEN
      RESULTIS -1                       // Invalid number

   $( LET n = getnum(str)
      IF n GE 10 BREAK
      num := num * 10 + n
   $) REPEAT

   RESULTIS num
$)

AND getnum(str) = VALOF
$( LET c = getch(str)
   RESULTIS ('0' LE c LE '9') -> c - '0', 99         // 99 is greater than
                                                     // the maximum base
$)

AND readnum() = terminator NE endstreamch -> old_readn(),
                   report("premature end of file on input")

AND getspace(n) = VALOF
/* Buffer routine for 'getvec' to enable efficient result checking. */
$( LET res = getvec(n)

   IF res = 0 THEN report("failed to allocate sufficient virtual storage")

   RESULTIS res
$)

AND cgen(v, vsize) = VALOF
$( LET s = ?
   AND cl = ?
   AND omfac = VEC emas_ -> 0, 1
   AND sectv = VEC maxstrlength/bytesperword

   IF NOT emas_ THEN
      omfaccess1 := omfac

   sectname := sectv
   sectname%0 := 0                      // Null section name by default

   plantcopy := plant   // Used to bypass code lister where necessary
   code_heading_done_ := FALSE

   IF codelist_ THEN
   $( TEST emas_ THEN
         cl := output()
      OR
      $( cl := findoutput(codefile)
         IF cl = 0 THEN
         $( ioerror(codefile, result2)
            RESULTIS result2
         $)
      $)

      selectoutput(cl)

      code_heading()

      plant := plantl   // Intercept calls to PLANT, to list the code produced
      codelist_ := TRUE
   $)

   comments := 0

   incode_ := TRUE

   IF emas_ THEN real_rdch := rdch

   IF utility_ THEN
   $( LET pr = profiling_   // Turn off profiling for library OCODE file

      profiling_ := FALSE

      initialise(v, vsize)

      s := findinput(locode)   // OCODE of BCPL library
      IF NOT emas_ THEN
         IF s = 0 THEN s := -(ABS result2)
      IF s < 0 THEN
      $( ioerror(locode, s)
         RESULTIS -s
      $)
      selectinput(s)
      IF emas_ THEN
      $( ocode_conad := getconad(s)
         IF ocode_conad > 0 THEN
         $( IF ocode_conad!3 NE 3 THEN   // Not a character file
            $( ioerror(locode, e.ift)
               RESULTIS e.ift
            $)
            ocode_ptr := ocode_conad!1   // Length of header
            rdch := con_rdch
         $)
      $)
      op := readop()
      trans("library OCODE")
      endread()

      profiling_ := pr
   $)

   TEST emas_ THEN
   $( rdch := real_rdch
      TEST compiler_ THEN
      $( s := findinput(ocode)    // OCODE of user program
         IF ocode_conad < 0 THEN
         $( ioerror(ocode, e.ift)
            RESULTIS -s
         $)
         selectinput(s)
         ocode_conad := getconad(s)
         IF s > 0 THEN
         $( IF ocode_conad!3 NE 3 THEN   // Not a character file
            $( ioerror(ocode, e.ift)
               RESULTIS e.ift
            $)
            ocode_ptr := ocode_conad!1   // Length of header
            rdch := con_rdch
         $)
      $)
      OR
      $( ocode_conad := comreg!46 >> 2
         TEST ocode_conad NE 0 THEN
         $( rdch := con_rdch
            ocode_ptr := ocode_conad!1   // Length of header
         $)
         OR
         $( prompt("CGEN: ")
            selectinput(sysin)
         $)
      $)
   $)
   OR
   $( s := findinput(ocode)   // OCODE of user program
      IF s = 0 THEN
      $( ioerror(ocode, result2)
         RESULTIS result2
      $)
      selectinput(s)
   $)

   // Discard the steering information in the OCODE file if required

   IF steering_ THEN
   $( LET nlsw_ = TRUE
      AND c = ?

      $( c := rdch()

         IF c = endstreamch THEN
            report("steering information missing from OCODE file")

         IF c = '**' & nlsw_ THEN    // * at start of line
         $( LET c2 = rdch()          // Inspect next non-space character

            WHILE c2 = '*S' DO c2 := rdch()

            IF c2 = '*N' BREAK       // Asterisk was only thing on line
         $)

         nlsw_ := c = '*N'
      $) REPEAT
   $)
   op := readop()
   process_section_and_needs()
   UNLESS utility_ DO                   // Cannot be done before, as main program status not known
      initialise(v, vsize)

   trans("user OCODE")
   endread()

   postamble()

   IF (codelength REM 4) NE 0 THEN   // Round to whole number of words
      plant(i.lb, v.b, 0)            // Padding instruction, never executed

   IF datap = 0 THEN data(0)            // Ensure data area not empty

   fixup_iils()

   IF codelist_ THEN
   $( list_data()

      TEST emas_ THEN
         UNLESS output() = journal DO
         $( endwrite()
            selectoutput(journal)
         $)
      OR
      $( selectoutput(codefile)
         endwrite()
         selectoutput(journal)
      $)
   $)

   print_sizes()

   IF omfname%0 NE 0 THEN
   $( s := findomfoutput()
      IF NOT emas_ THEN
         IF s = 0 THEN s := -(ABS result2)
      IF s < 0 THEN
      $( ioerror(omfname, s)
         RESULTIS -s
      $)

      IF emas_ THEN selectoutput(omfstrp)

      outputomf()

      endwrite()

      TEST emas_ THEN
      $( EXTERNAL $( s_trim : "S#TRIM" $)

         LET flag = ?

         s_trim(#x18000100, omfname<<2, #x28000001, @flag<<2)

         IF flag NE 0 THEN
         $( ioerror(omfname, flag)
            RESULTIS flag
         $)
      $)
      OR
         deselectomf()
   $)

   RESULTIS -comments
$)

AND initialise(v, vsize) BE
$( TEST utility_ THEN
   $( supportname := "BCPLRTSUPPORT"
      preludename := "BCPLPRELUDE"
      pltsize := 32
      max_iin := iin.max
   $)
   OR
   $( pltsize := 16
      max_iin := iin.proc            // No support references here
   $)

   datav := getspace(statsize + 2) + 3   // Allow for record header later

   globv := getspace(globsize + 3) + 3
   FOR i = 0 TO globsize DO globv!i := 0

   labk := getspace(max.staticlabels - 1)
   FOR i = 0 TO max.staticlabels - 1 DO labk!i := 0

   labv := getspace(max.labels - 1)
   dlabv := getspace(max.labels - 1)
   slabv := getspace(statsize - 1)

   codev := v + 3
   codemax := v + vsize - 4
   iilv := codemax + 4
   iilva := iilv

   datap, labkp, codelength, iilp := 0, 0, 0, 0

   FOR i = 0 TO vsize DO v!i := 0

   initialise_propslist()
   initialise_sys_vec()
   initialise_plt()
   initialise_module_map()

   static_chain := sysv + svstatchain

   preamble()
$)

AND size(str) = VALOF
$( LET n = str%0
   IF n > 32 THEN n := 32
   RESULTIS (n + 3)/4
$)

AND initialise_sys_vec() BE
$( LET skeleton_start = TABLE #x08000000 \/ iin.data,     // Body record, more follows for this area
                              #x00000000,                 // Displacement
                              #x00000000,                 // Size in bytes (filled in below)
                              #x29000000,                 // SVINW (unbounded, possibly scaled word descriptor)
                              #x00000000,
                              #x00000000,
                              #x00000000,
                              #x00000000,
                              #x00000000,
                              #x00000000,
                              #x00000000,
                              #x00000000,
                              #x19000000                  // SVINB (unbounded byte descriptor)

   sysv := getspace(svsize + 2) + 3   // Allow for record header
   FOR i = 0 TO 12 DO sysv!(i - 3) := skeleton_start!i
   FOR i = 10 TO svsize - 1 DO sysv!i := 0

   IF amode = am.byte THEN sysv!svinw := #X2B000000   // Unscaled descriptor

   sysv!(-1) := svsize*4   // Size of body record in bytes
$)

AND initialise_plt() BE
$( LET skeleton = TABLE #x08040000 \/ iin.plt,      // Body record, next is fixup
                        #x00000000,                 // Displacement
                        #x00000000,                 // Size of PLT in bytes (filled in at end)
                        #xe0000000,                 // Type 3/32 descriptor + code size in halfwords (filled in at end)
                        #x08000000 \/ iin.code,
                        #x28000000,                 // Bounded word descriptor + data size in words (filled in at end)
                        #x00000000 \/ iin.data,
                        #x00000002,
                        #x00000000 \/ iin.support,  // Only used if UTILITY = YES
                        #x00000000,
                        #x00000000 \/ iin.prelude   // Only used if UTILITY = YES

   pltmax := 4084
   pltv := getspace(pltmax/bytesperword + 2) + 3
   FOR i = 0 TO pltsize/4 + 2 DO   // Copy to PLT area
      pltv!(i - 3) := skeleton!i

   last_plt_link := pltsize/4 - 2       // Initial setting

   iin_table_max := 100                 // Initial size of IIN table
   iin_table := getspace(iin_table_max)
   FOR i = 0 TO iin_table_max DO iin_table!i := -1
$)

AND ioerror(file, ecode) BE
$( LET mes = ?

   selectoutput(journal)

   TEST emas_ THEN
      writef("%S", ssmessage(ABS ecode, file))
   OR
   $( mes := VALOF SWITCHON ecode INTO
      $( CASE e.syn:  RESULTIS "Syntax error in *'%S*'*N"
         DEFAULT   :  RESULTIS "File *'%S*' - response %N (%S%X8)*N"
      $)
      writef(mes, file, ecode, ecode < 0 -> "-", "", ABS ecode)
   $)
$)

AND findomfoutput() = VALOF
$( LET r = ?

   TEST emas_ THEN
   $( LET o = output()

      r := findoutput(omfname)
      IF r < 0 RESULTIS r
      omfstrp := r
      omfconad := getconad(r)
      IF omfconad > 0 THEN
      $( omfconad!3 := 4   // Data file
         omfconad!6 := #x10000002   // V 4096
         omfconad!7 := 0   // Record count
         selectoutput(r)
         changesize(omfconad!2+4096)   // Stop 'endwrite' from filling in header, even on small files
         selectoutput(o)
      $)
   $)
   OR
   $( LET ppdr0, ppdr1 = ?, ?

      // Set up descriptor to parameter pairs for selecting the RAM

      ppdr0 := #X28000012               // Word descriptor, 18 words (6 parameter pairs)
      ppdr1 := (TABLE   16, #x00200000, #x0,              // Capabilities
                        24, #x30000001, ?,                // ACCESS1 descriptor
                        29, 3,          0,                // Align at end of file
                         4, 0,          0,                // Position relative to current record
                         5, 1,          0,                // Displace to next record
                        12, 2,          0)                // Setaction - select next and new write

      ppdr1!5 := omfaccess1 << 2
      r := selectram(omfname, ppdr0, ppdr1<<2)

      IF r = 0 RESULTIS 0
   $)

   writef("OMF file connected - **%S*N", omfname)
   RESULTIS r
$)

AND preamble() BE
$( IF codelist_ THEN writef("***N** Initialisation code%S*N***N",
       utility_ -> "", mainprog_ -> " (main program)", " (subroutine package)")

   // This initialisation code MUST occupy a whole number of words,
   // or each BCPL segment will be non-word-aligned, and in-code literals
   // will not be picked up correctly.

   plant(i.std, v.l, 3)                            // Procedure strategic code
   plant(i.lxn, v.l, 4)

   TEST utility_ THEN
   $( // Stack a descriptor to a null string, in case program is called with no parameter
   
      plant(i.lsd, v.nil, #x18)                    // Build a byte descriptor
      plant(i.shs, v.nil, 24)
      plant(i.rot, v.nil, 32)
      plant(i.iad, v.nil, 2*bytesperword)
      plant(i.st, v.t, 0)
      plant(i.ldrl, v.t, 0)                        // Point 2 words beyond TOS
      plant(i.std, v.t, 0)
      plant(i.lss, v.nil, 0)                       // Make a null string
      plant(i.st, v.t, 0)                          // Stack it
   
      // Call .BCPLPRELUDE
   
      plant(i.prcl, v.nil, 4)
      plant(i.lss, v.x, 1)                         // Address of code area
      plant(i.sl, v.x, 3)                          // Address of data area
      plant(i.st, v.t, 0)
      plant(i.raln, v.nil, 7)
      plant(i.call, v.ix, 6)                       // .BCPLPRELUDE
      plant(i.lxn, v.l, 4)
   $)
   OR
   $( IF mainprog_ THEN
      $( plant(i.lct, v.x, 3)                      // Set CTB to start of system vector

         plant(i.lss, v.x, 3)
         IF amode = am.word THEN
            plant(i.ush, v.nil, -2)
         plant(i.st, v.c, svctbword)
   
         plant(i.lss, v.x, 1)                         // Address of code area
         plant(i.st, v.c, svacbcpl)                   // Save for future use
      $)
   $)

   // Save XNB in system vector (or global vector in case of subroutine package)

   TEST mainprog_ \/ utility_ THEN plant(i.stxn, v.c, svxnb) OR
   $( IF xnbglobal NE 0 THEN
         plant(i.stxn, v.c, (svsize + xnbglobal))
   $)

   IF codelength REM 4 NE 0 THEN
      plant(i.lb, v.b, 0)               // Pad to word-align
$)

AND postamble() BE
$( TEST utility_ THEN
   $( IF codelist_ THEN
         writes("***N** Call run-time support to enter START*N***N")

      IF profiling_ THEN
      $( plant(i.lss, v.nil, TRUE)
         plant(i.st, v.c, svsize + 6)              // Set PROFILE (global 6) to TRUE
      $)

      plant(i.prcl, v.nil, 4)
      plant(i.lsd, v.l, 5)                      // Descriptor to parameter string
      plant(i.slss, v.nil, globsize)
      plant(i.st, v.t, 0)
      plant(i.raln, v.nil, 8)
      plant(i.call, v.ix, 4)                    // .BCPLRTSUPPORT
      plant(i.exit, v.nil, 0)
   $)
   OR
   $( IF codelist_ THEN
         writef("***N** End of initialisation - %S*N***N",
                 mainentry = 0 -> "return to calling code", "call main entry")

      TEST mainentry NE 0 THEN
      $( plant(i.lsd, v.nil, #x18)      // Build a byte descriptor
         plant(i.shs, v.nil, 24)
         plant(i.rot, v.nil, 32)
         plant(i.iad, v.nil, 2*bytesperword)
         plant(i.st, v.t, 0)
         plant(i.ldrl, v.t, 0)          // Point 2 words beyond TOS (first new local)
         plant(i.stsf, v.b, 0)
         plant(i.stln, v.t, 0)
         plant(i.sbb, v.t, 0)           // Number of bytes in current frame
         plant(i.asf, v.nil, 60)        // Make new BCPL frame
         plant(i.sbb, v.nil, 20)        // Number of bytes of params
         plant(i.ldb, v.b, 0)           // Form destination desc
         plant(i.cyd, v.null, 0)        // Copy to make source desc
         plant(i.isb, v.b, 0)           // Adjust for source desc
         plant(i.isb, v.nil, 8)
         plant(i.mv, v.nil, #x100)      // Copy params to new frame (h=1)
         plant(i.ld, v.c, svinw)
         plant(i.jlk, v.nilf, -(codelength - mainentry)/2)
      $)
      OR
         IF mainprog_ THEN              // Complain about missing entry point
            report("main entry routine/function %S is missing", procname)

      plant(i.exit, v.nil, #x6c)
   $)
$)

AND initialise_propslist() BE
$( LET an = VEC 8
   AND plt_props1 = props1.plt

   IF NOT utility_ THEN plt_props1 := plt_props1 \/ #x10   // Make writeable

   propmax := 4084
   propv := getspace(propmax/bytesperword + 2)

   IF debugging_ THEN
   $( propsize := VALOF
      $( LET v = VEC 8
         LET s = size(modulename) + 4                                          // Size of type 0 entry
   
         s := s + size(areaname(v, iin.plt)) + 3 + (props2.plt = 0 -> 0, 1)    // Size of type 1 entry for PLT area
         s := s + size(areaname(v, iin.code)) + 3 + (props2.code = 0 -> 0, 1)  // Size of type 1 entry for code area
         s := s + size(areaname(v, iin.data)) + 3 + (props2.data = 0 -> 0, 1)  // Size of type 1 entry for data area
         s := s + size(procname) + 4                                           // Size of type 2 entry
         IF utility_ THEN
         $( s := s + size(preludename) + 2                                     // Size of type 3 entry for prelude (if used)
            s := s + size(supportname) + 2                                     // Size of type 3 entry for support (if used)
         $)

         RESULTIS s
      $)
      IF monitoring_ THEN monitor("Propsize = %N*N", propsize)
   $)

   propp := propv

   init_type0(modulename)
   init_type1(areaname(an, iin.plt), plt_props1, props2.plt, iin.plt)
   init_type1(areaname(an, iin.code), props1.code, props2.code, iin.code)
   init_type1(areaname(an, iin.data), props1.data, props2.data, iin.data)
   init_type2(procname, iin.proc, iin.code, iin.plt)
   type3_count := 0
   IF utility_ THEN
   $( init_type3(supportname, iin.support, 0)
      init_type3(preludename, iin.prelude, 0)
      first_plt_ref := 4
   $)

   TEST debugging_ THEN
      UNLESS propp - propv = propsize DO
         report("in compiler - propslist inconsistent - (%X8 -> %X8)", propv, propp)
   OR propsize := propp - propv
$)

AND initialise_module_map() BE
$( LET an = VEC 8
   AND p_plt, p_code, p_data = ?, ?, ?

   mapsize := VALOF
   $( LET v = VEC 8
      LET s = size(modulename) + 8                     // Size of type 16 entry

      s := s + size(areaname(v, iin.plt)) + 5          // Size of type 17 entry for PLT area
      s := s + size(areaname(v, iin.code)) + 5         // Size of type 17 entry for code area
      s := s + size(areaname(v, iin.data)) + 5         // Size of type 17 entry for data area
      s := s + size(procname) + 5                      // Size of type 18 entry
      s := s + 6                                       // Size of all 3 type 19 entries
      s := s + 2                                       // Size of type 32 terminal entry

      RESULTIS s
   $)
   IF monitoring_ THEN monitor("Mapsize = %N*N", mapsize)

   mapv := getspace(mapsize - 1)

   mapp := mapv

   p_plt := (mapp - mapv)*4
   init_type17(areaname(an, iin.plt), 0, iin.plt)

   p_data := (mapp - mapv)*4
   init_type17(areaname(an, iin.data), 0, iin.data)

   p_code := (mapp - mapv)*4
   init_type17(areaname(an, iin.code), #x80, iin.code)

   init_type18(procname, #x80)

   init_type16(modulename, progver)

   init_type19(iin.plt, p_plt)
   init_type19(iin.data, p_data)
   init_type19(iin.code, p_code)

   init_type32(3, 1)             // Chains, records

   IF debugging_ THEN
      UNLESS mapp - mapv = mapsize DO
         report("in compiler - module map inconsistent - (%X8 -> %X8)", mapv, mapp)
$)

AND init_type0(mod) BE
$( LET l = mod%0
   AND entrysize = ?

   IF l > 32 THEN l := 32
   entrysize := (l + 3)/4 + 4

   propp!0 := #x00400000 \/ entrysize   // Portability marker in module properties
   propp!1 := l   // 'max.iin' filled in at end

   name(mod, propp + 2, l)

   propp!(entrysize - 2) := #x00fffffc               // Portability marker (VME/B and VME/K only)
   propp!(entrysize - 1) := #x01000000 \/ largest_type1()

   propp := propp + entrysize
$)

AND init_type1(aname, props1, props2, iin) BE
$( LET l = aname%0
   AND entrysize = ?

   IF l > 32 THEN l := 32
   entrysize := (l + 3)/4 + 3
   IF props2 NE 0 THEN entrysize := entrysize + 1

   propp!0 := #x01000000 \/ (props1 << 16) \/ entrysize
   propp!1 := (iin << 16) \/ l   // Scope=0, Strength=0, Keyed=0

   name(aname, propp + 2, l)

   IF props2 NE 0 THEN
      propp!(entrysize - 2) := #x03000000 \/ props2

   last_prop_entry := propp
   propp := propp + entrysize
$)

AND init_type2(proc, iin, t1i, plti) BE
$( LET l = proc%0
   AND entrysize = ?

   IF l > 32 THEN l := 32
   entrysize := (l + 3)/4 + 3

   IF plti NE 0 THEN entrysize := entrysize + 1

   propp!0 := #x02000000 \/ entrysize
   propp!1 := #x0000c200 \/ (iin << 16) \/ l   // Scope=1, Strength=1, Keyed=1

   name(proc, propp + 2, l)

   propp!(entrysize - 1) := #x85000000 \/ t1i

   IF plti NE 0 THEN
      propp!(entrysize - 2) := #x82000000 \/ plti

   last_prop_entry := propp
   propp := propp + entrysize
$)

AND init_type3(proc, iin, extprops) BE
$( LET l = proc%0
   AND entrysize = ?

   IF l > 32 THEN l := 32
   entrysize := (l + 3)/4 + 2

   propp!0 := #x03000000 \/ (extprops << 16) \/ entrysize
   propp!1 := (iin << 16) \/ l

   name(proc, propp + 2, l)

   last_prop_entry := propp
   propp := propp + entrysize
   type3_count := type3_count + 1
$)

AND init_type16(mod, ver) BE
$( LET l = mod%0
   AND entrysize = ?
   AND dv = VEC 2
   AND tv = VEC 2

   IF l > 32 THEN l := 32
   entrysize := (l + 3)/4 + 8

   date(dv)

   IF emas_ THEN                        // Convert date format
   $( LET v = VEC 2

      move(8, (dv<<2)+1, (v<<2)+1)

      dv%0  := 10
      dv%1  := '1'
      dv%2  := '9'
      dv%3  := v%7
      dv%4  := v%8
      dv%5  := '/'
      dv%6  := v%4
      dv%7  := v%5
      dv%8  := '/'
      dv%9  := v%1
      dv%10 := v%2
   $)

   translate((dv << 2) + 1, 10, astoeb)

   timeofday(tv)

   IF emas_ THEN
   $( tv%3 := ':'                       // Convert time format
      tv%6 := ':'
   $)

   translate((tv << 2) + 1, 8, astoeb)

   mapp!0 := #x10e70000 \/ entrysize      // Language code 'X'
   mapp!1 := #xffffffff                   // End of chain
   mapp!2 := VALOF                        // Version number
             $( LET v = ?
                LET atv = @v

                FOR i = 3 TO 0 BY -1 DO
                $( atv%i := ver REM 10 + #xf0
                   ver := ver/10
                $)
                RESULTIS v
             $)
   move(10, (dv<<2)+1, (mapp+3)<<2)
   move(8, (tv<<2)+1, ((mapp+5)<<2)+2)

   name(mod, mapp + 8, l)
   0%(((mapp+8)*bytesperword)-1) := l   // Fill in name length

   mapp := mapp + entrysize
$)

AND init_type17(aname, props, iin) BE
$( LET l = aname%0
   AND entrysize = ?

   IF l > 32 THEN l := 32
   entrysize := (l + 3)/4 + 5

   mapp!0 := #x11000000 \/ (props << 16) \/ entrysize
   mapp!1 := #xfffffffF                                 // End of chain
   mapp!2 := 0                                          // Displacement (always zero)
   mapp!3 := iin >> 4                                   // Size filled in later
   mapp!4 := (iin << 28) \/ (iin << 16) \/ l

   name(aname, mapp + 5, l)

   mapp := mapp + entrysize
$)

AND init_type18(proc, reason) BE
$( LET l = proc%0
   AND entrysize = ?

   IF l > 32 THEN l := 32
   entrysize := (l + 3)/4 + 5

   mapp!0 := #x12000000 \/ (reason << 16) \/ entrysize
   mapp!1 := #xffffffff                      // End of chain
   mapp!2 := 0                               // Offset is always zero
   mapp!3 := l                               // Name use byte is zero

   name(proc, mapp + 4, l)

   mapp!(entrysize - 1) := #x01000000        // Filled in at end

   mapp := mapp + entrysize
$)

AND init_type19(iin, chain) BE
$( mapp!0 := #x13000000 \/ iin
   mapp!1 := chain

   mapp := mapp + 2
$)

AND init_type32(chains, records) BE
$( mapp!0 := #x20000000 \/ chains
   mapp!1 := records

   mapp := mapp + 2
$)

AND largest_type1() = VALOF
$( LET l = iin.data > iin.code -> iin.data, iin.code

   l := l > iin.plt -> l, iin.plt
   RESULTIS l
$)

AND areaname(v, iin) = VALOF
$( LET l = 6
   AND t = modulename%0
   AND a = iin = iin.code -> "CD001",
           iin = iin.data -> "DA001",
           iin = iin.plt  -> "PL001",
                             "XX999"

   FOR i = 1 TO l DO v%i := "ICL9BC"%i

   FOR i = l + 1 TO l + t DO v%i := modulename%(i - l)
   l := l + t

   t := a%0
   FOR i = l + 1 TO l + t DO v%i := a%(i - l)
   l := l + t

   v%0 := l
   RESULTIS v
$)

AND name(str, atname, length) BE
$( LET pad = 4 - (length REM 4)

   FOR i = 1 TO length DO
      atname%(i - 1) := str%i
   UNLESS pad = 4 DO
      FOR i = length + 1 TO length + pad DO
         atname%(i - 1) := #x40
   translate(atname << 2, length, astoeb)
$)

AND print_sizes() BE
$( LET n = ?

   writes("*N  Area             Size (bytes)*N*N")
   writef("  PLT          %I6   (%X8)*N", pltsize, pltsize)
   n := codelength + iilp*4
   writef("  Code         %I6   (%X8)*N", n, n)
   n := ((mainprog_ \/ utility_ -> svsize + globsize + 1, 0) + datap)*4
   writef("  Data         %I6   (%X8)*N*N", n, n)
$)

 .

// OMF output routines

GET "BCPLQ_BCPLQHDR"

LET outputomf() BE
$( dump_propslist()
   dump_plt()
   dump_plt_fixups()

   /*  If  a  main  program  is not being generated and we are not using
   UTILITY=YES, we are compiling a subroutine package.   This  does  not
   have  its  own  global vector, but relies on CTB pointing to the main
   global vector on entry.  Accordingly,  no  system  vector  or  global
   vector are generated in this case.  */

   IF mainprog_ \/ utility_ THEN
   $( dump_sys_vec()

      // Clear out fixup information from global vector

      FOR i = 0 TO globsize DO globv!i := 0

      dump_glob_vec()
   $)

   dump_data()
   dump_code()
   dump_iils()
   dump_module_map()
$)

AND dump_propslist() BE
$( LET pp = propv
   LET es = pp!0 & #xffff              // Get size of type 0 entry

   pp!1 := pp!1 \/ (max_iin << 16)     // Fill in maximum iin now

   pp := pp + es                       // Point to type 1 entry for PLT area
   es := pp!0 & #xffff                 // Get entry size
   pp!(es - 1) := pltsize              // Areasize in bytes

   pp := pp + es                       // Point to type 1 entry for code area
   es := pp!0 & #xffff                 // Get entry size
   pp!(es - 1) := codelength + iilp*4  // Areasize in bytes

   pp := pp + es                       // Point to type 1 entry for data area
   es := pp!0 & #xffff                 // Get entry size
   pp!(es - 1) := ((mainentry NE 0) \/ utility_ -> (svsize + globsize + 1)*4, 0) + datap*4
                                        // Areasize in bytes
   // Areasize in bytes

   last_prop_entry!1 := last_prop_entry!1 \/ #x00000100   // Last entry indicator

   outrec(propv, propsize*bytesperword)
$)

AND dump_plt() BE
$( pltv!(-1) := pltsize                   // PLT size in bytes
   pltv!0 := #xe0000000 \/ codelength/2   // Code descriptor to proc (bound in halfwords)
   pltv!2 := #x28000000 \/ datap          // Descriptor to data area (bound in words)

   IF monitoring_ THEN
   $( FOR i = pltv - 3 TO pltv + pltsize/4 - 1 DO
         monitor("Dump PLT entry - X%X8*N", !i)
   $)

   outrec(pltv - 3, pltsize + 12)         // 12 extra bytes for header
$)

AND dummy1() BE CODE "CODEON"

AND dump_plt_fixups() BE
$( LET fixtab = TABLE #x09030000 \/ iin.plt,   // Fixup record, last for this area
                      #x00000004,              // Extended descriptor address
                      #x00000003               // Complete descriptor (only used if type 3 entries in properties list)

   fixtab!2 := 3 \/ (first_plt_ref << 12)

   outrec(fixtab, type3_count = 0 -> 8, 12)
$)

AND dummy2() BE CODE "CODEOFF"

AND dump_sys_vec() BE
   outrec(sysv - 3, (svsize + 3)*bytesperword)

AND dump_glob_vec() BE
$( LET disp = svsize
   AND gs = globsize + 1

   $( LET size = (gs < 1021) -> gs, 1021

      gs := gs - size

      globv!(-3) := ((gs LE 0) & (datap = 0)) -> #x08020000 \/ iin.data,   // Body record, no more unshareable records
                                                 #x08000000 \/ iin.data    // Body record, more to follow
      globv!(-2) := disp*4                                                 // Displacement
      globv!(-1) := size*4                                                 // Size in bytes

      outrec(globv - 3, (size + 3)*bytesperword)

      globv := globv + size
      disp := disp + size
      IF gs LE 0 BREAK
   $) REPEAT
$)

AND dump_data() BE UNLESS datap = 0 DO
$( LET disp = mainprog_ \/ utility_ -> svsize + globsize + 1, 0
   AND dp = datap

   $( LET size = (dp < 1021) -> dp, 1021

      dp := dp - size

      datav!(-3) := (dp LE 0) -> #x08020000 \/ iin.data,   // Body record, no more unshareable records
                                 #x08000000 \/ iin.data    // Body record, more to follow
      datav!(-2) := disp*4                                 // Displacement
      datav!(-1) := size*4                                 // Size in bytes

      outrec(datav - 3, (size + 3)*bytesperword)

      datav := datav + size
      disp := disp + size
      IF dp LE 0 BREAK
   $) REPEAT
$)

AND dump_code() BE
$( LET disp = 0
   AND pl = codelength/bytesperword

   $( LET size = (pl < 1021) -> pl, 1021

      pl := pl - size

      codev!(-3) := ((pl LE 0) & (iilp = 0)) -> #x08010000 \/ iin.code,           // Body record, no more to follow
                                                        #x08000000 \/ iin.code    // Body record, more to follow
      codev!(-2) := disp*4          // Displacement
      codev!(-1) := size*4          // Size in bytes

      outrec(codev - 3, (size + 3)*bytesperword)

      codev := codev + size
      disp := disp + size
      IF pl LE 0 BREAK
   $) REPEAT
$)

AND fixup_iils() BE UNLESS iilp = 0 DO
$( LET base = codelength/2   // Base of IILs, in halfwords

   IF codelist_ THEN list_iils()

   FOR i = 0 TO iilp - 1 DO
   $( LET addr = base + i*2       // Address of this IIL, in halfwords
      AND chain = iilva!i         // Top of fixup chain for this IIL (halfword offset in CODEV)
      LET special_ = (chain & #x80000000) NE 0

      chain := chain & #x7fffffff

      UNTIL chain = 0 DO
      $( LET offset = addr - chain     // Offset in halfwords
         AND disp = chain*2            // Displacement (in bytes) of instruction within CODEV
         LET instruction = getword(codev, disp)

         IF special_ THEN
            offset := offset*2 + 2
         putword(codev, disp, (instruction & #xfffc0000) \/ offset)
         chain := instruction & #x3ffff
      $)
   $)
$)

AND dump_iils() BE UNLESS iilp = 0 DO
$( LET disp = codelength/4
   AND ip = iilp

   $( LET size = (ip < 1021) -> ip, 1021

      ip := ip - size

      iilv!(-3) := (ip LE 0) -> #x08010000 \/ iin.code,   // Body record, no more to follow
                                #x08000000 \/ iin.code    // Body record, more to follow
      iilv!(-2) := disp*4         // Displacement
      iilv!(-1) := size*4         // Size in bytes

      outrec(iilv - 3, (size + 3)*bytesperword)

      iilv := iilv + size
      disp := disp + size
      IF ip LE 0 BREAK
   $) REPEAT
$)

AND dump_module_map() BE
$( LET mp = mapv
   LET es = mp!0 & #xffff          // Get size of type 17 entry for PLT area

   mp!3 := mp!3 \/ (pltsize << 8)  // Areasize in bytes

   mp := mp + es                   // Point to type 17 entry for data area
   es := mp!0 & #xffff             // Get entry size
   mp!3 := mp!3 \/ ((svsize + globsize + 1 + datap)*4 << 8)  // Areasize in bytes

   mp := mp + es                   // Point to type 17 entry for code area
   es := mp!0 & #xffff             // Get entry size
   mp!3 := mp!3 \/ ((codelength + iilp*4) << 8)   // Areasize in bytes

   mp := mp + es                   // Point to type 18 entry
   es := mp!0 & #xffff             // Get entry size
   mp!(es - 1) := mp!(es - 1) \/ codelength

   outrec(mapv, mapsize*bytesperword)
$)

AND outrec(v, s) BE
/* Write a record to  the  OMF  file. The  record  is  's'  bytes  long,
starting at BCPL address 'v'. */
$( LET r = omf_write(v, s)

   IF r = 0 THEN
   $( ioerror(omfname, result2)
      endwrite()
      UNLESS emas_ DO
         deselectomf()
      stop(ABS result2)
   $)
$)

AND omf_write(ad, len) = emas_ -> VALOF
$( IF omfconad > 0 THEN
   $( len := len + 2   // Allow for record header
   
      WHILE omfconad!0 + len > omfconad!2 DO
      $( LET flag = changesize(omfconad!2 + 4096)
   
         IF flag NE 0 THEN
         $( result2 := flag
            RESULTIS 0
         $)
      $)
   
      move(2, (@len<<2)+2, (omfconad<<2)+omfconad!0)
      move(len-2, ad<<2, (omfconad<<2)+omfconad!0+2)
      omfconad!7 := omfconad!7 + 1   // Increment record count
   
      omfconad!0 := omfconad!0 + len
   $)

   RESULTIS 1   // Dummy nonzero result
$),
VALOF
$( LET ppdr0 = #x28000006
   AND ppdr1 = (TABLE 7, ?, ?, 0, 2, 0)    // Buffer address and action 'select next and newwrite'

   ppdr1!1 := #x18000000 + len
   ppdr1!2 := ad << 2

   RESULTIS access1(omfaccess1!0, omfaccess1!1, ppdr0, ppdr1<<2)
$)

AND deselectomf() BE TEST emas_ THEN RETURN OR
$( LET ppdr0 = #x28000003
   AND ppdr1 = (TABLE 0, 12, 0)

   access1(omfaccess1!0, omfaccess1!1, ppdr0, ppdr1<<2)

   IF NOT emas_ THEN                    // Add synonyms where required
   $( LET r2 = addalias(omfname, procname)
      LET saveresult2 = result2
      LET o = output()

      selectoutput(journal)

      TEST r2 = 0 & result2 NE 9109 THEN
         writef("Failed to add synonym *'%S*' - response %N (%S%X8)*N", procname,
            saveresult2, saveresult2 < 0 -> "-", "", ABS saveresult2)
      OR
         writef("Synonym added - *'%S*'*N", procname)

      selectoutput(o)
   $)
$)

AND getword(v, i) = VALOF
$( LET a = (v << 2) + i

   RESULTIS (0%a       << 24) +
            (0%(a + 1) << 16) +
            (0%(a + 2) << 08) +
            (0%(a + 3))
$)

AND putword(v, i, w) BE
$( LET a = (v << 2) + i

   0%a := w >> 24
   0%(a + 1) := (w >> 16) & #xff
   0%(a + 2) := (w >> 8) & #xff
   0%(a + 3) := w & #xff
$)

AND trans(file) BE
$( LET v = VEC tempvsize*tempsize - 1

   tempv := v

   FOR i = 0 TO max.labels - 1 DO
   $( labv!i := 0
      dlabv!i := 0
   $)

   IF op = s.end RETURN   // End of OCODE file

   incode_ := TRUE

   UNLESS op = s.stack DO
      report("corrupt OCODE file")

   ssf := readn()

   initstack(ssf)   // Initialises PENDINGOP as well

   labkp := 0

   branch(i.j, 0)   // Jump round main code

   switch_prefix := 'A'

   incode_ := FALSE

   clear_slaves()

   dr_a := svinw

   gencode(file)

   complab(0, FALSE)

   FOR i = 1 TO globaln DO
   $( LET n = readn()
      LET l = readl()

      IF n > globsize DO
      $( comment("global no %N outside global vector - not initialised", n)
         LOOP
      $)

      UNLESS globv!n = 0 DO
         comment("global no %N set previously - superseded", n)

      globv!n := l
   $)
   initialise_entrypoints()

   IF codelist_ THEN
      writes("***N****************************************** End of segment *
                  ********************************************N***N")

   op := readop()
$) REPEAT

AND process_section_and_needs() BE
$( SWITCHON op INTO
   $( DEFAULT:
         RETURN

      CASE s.section:
      $( LET l = readn()
         AND colon = 0

         FOR i = 1 TO l DO
         $( LET c = readn()

            IF c = ':' THEN colon := i
            sectname%i := c
         $)

         IF colon NE 0 THEN             // XNB global given
         $( LET n = 0
            AND ok_ = TRUE

            FOR i = colon + 1 TO l DO
            $( LET digit = sectname%i - '0'

               UNLESS 0 LE digit LE 9 DO ok_ := FALSE
               n := n*10 + digit
            $)

            IF n LE 0 THEN ok_ := FALSE

            TEST NOT ok_ THEN
            $( sectname%0 := l
               report("invalid global number in SECTION directive: '%S'", sectname)
            $)
            OR
            $( xnbglobal := n
               IF monitoring_ THEN monitor("XNBglobal = %N*N", xnbglobal)
            $)

            l := colon - 1              // Truncate to main name
         $)

         sectname%0 := l
         IF l > 8 THEN                  // Check for main program
         $( sectname%0 := 8
            IF match(sectname, "PROGRAM.") THEN
            $( mainprog_ := TRUE
               l := l - 8
               FOR i = 1 TO l DO
                  sectname%i := sectname%(i+8)
               IF monitoring_ THEN
                  monitor("Main program detected: Sectname = %S*N", sectname)
            $)
            sectname%0 := l
         $)
         UNLESS utility_ DO
            FOR i = 0 TO l DO
            $( LET c = sectname%i

               procname%i, modulename%i := c, c
            $)

         IF codelist_ THEN
            writef("***N** SECTION *"%S*"%S*N***N", sectname, mainprog_ -> " (main program)", "")

         ENDCASE
      $)

      CASE s.needs:
      $( LET l = readn()

         FOR i = 1 TO l DO readn()      // Ignore all information

         ENDCASE
      $)
   $)
   op := readop()
$) REPEAT

AND findpltword(n) = VALOF
/*  Allocates  a  word  in the PLT and initialises it to 'n'. Yields its
word offset from the start of the PLT. */
$( LET offset = pltsize/4

   IF monitoring_ THEN monitor("FINDPLTWORD - value = %N*N", n)

   pltv!offset := n

   pltsize := pltsize + bytesperword
   IF pltsize > pltmax THEN
      report("too many entries in PLT")

   RESULTIS offset
$)

AND findpltentry(s) = VALOF
/* Searches the properties list for the external reference  's'. If  not
found,  creates  a  new  type  3  entry and allocates space for the call
descriptor in the PLT.  In all cases, yields  the  word  offset  of  the
descriptor in the PLT. */
$( LET v = VEC 7
   AND l = s%0   // Length of external name
   LET n = (l + 3)/bytesperword
   AND pp = propv
   AND ps = propsize
   AND offset = ?

   IF l > 32 THEN l := 32
   FOR i = 1 TO l DO
      v%(i-1) := s%i
   FOR i = l + 1 TO n*bytesperword DO
      v%(i-1) := '*S'
   translate(v << 2, n*bytesperword, astoeb)

   // Scan properties list for first type 3 entry, or the rest of the list

   UNTIL (pp!0 & #xff000000) = #x03000000 \/ ps <= 0 DO
   $( LET es = pp!0 & #xffff
      pp := pp + es
      ps := ps - es
   $)

   // Scan the type 3 entries, looking for a match

   WHILE ps > 0 DO
   $( LET es = pp!0 & #xffff
      AND np = pp + 2   // Pointer to name
      AND flag = TRUE

      pp := pp + es
      ps := ps - es

      UNLESS l = ((pp - es)!1 & #xff) LOOP   // Name not of same length

      FOR i = 0 TO n - 1 DO
         UNLESS v!i = np!i DO flag := FALSE

      IF flag THEN RESULTIS VALOF   // Match has been found
      $( LET iin = (pp - es)!1 >> 16   // Corresponding iin for name

         IF debugging_ THEN
            IF iin > iin_table_max \/ iin_table!iin < 0 THEN
               report("in compiler - PLT item not found for entry with IIN of %N*N", iin)

         RESULTIS iin_table!iin
      $)
   $)

   // Name not found; create new PLT entry, and link it up

   $( offset := pltsize/4   // Word offset of new item

      // Zeroise the new PLT entry, and insert any link from previous one

      TEST type3_count = 0 THEN
         first_plt_ref := offset
      OR
         pltv!(last_plt_link) := offset - last_plt_link   // Offset from previous entry
      pltv!offset, pltv!(offset + 1) := 0, 0
      last_plt_link := offset

      pltsize := pltsize + 8
      IF pltsize > pltmax THEN
         report("too many entries in PLT")
   $)

   // Make a new type 3 entry in the properties list

   $( LET entrysize = (l + 3)/4 + 2

      // Fill in the details

      propsize := propsize + entrysize
      IF propsize > 1000 THEN
         report("properties list overflow")   // Temporary restriction
      max_iin := max_iin + 1   // Allocate new iin
      init_type3(s, max_iin, 0)   // No external properties

      // Put the iin into the new (skeleton) PLT entry

      pltv!(offset + 1) := max_iin

      // Add the item to the IIN table so that it may be found later

      IF max_iin > iin_table_max THEN   // Table has filled up - expand it
      $( LET p = getspace(max_iin + 100)

         FOR i = 0 TO iin_table_max DO
            p!i := iin_table!i          // Copy across existing entries

         FOR i = iin_table_max + 1 TO max_iin + 100 DO p!i := -1
                                        // Fill unused entries with marker
         freevec(iin_table)             // Get rid of old table
         iin_table := p                 // Start using new one
         iin_table_max := max_iin + 100
      $)
      iin_table!max_iin := offset

   $)
   RESULTIS offset   // Return word offset of new item within PLT
$)

AND initialise_entrypoints() BE
$( LET offset = 0
   AND setup_ = FALSE

   IF codelist_ THEN
      writef("***N** Code to set up entry points*N***N")

   // STATIC routines and functions

   UNLESS directcall_ DO
   $( FOR i = 0 TO labkp - 1 DO
      $( LET l = ?
   
         IF NOT setup_ THEN
         $( setup_ := TRUE
            plant(i.lss, v.x, 1)
         $)

         l := slabv!(labk!i)   // Get number of code label
         adjust(offset, labv!l)
         offset := labv!l
         TEST utility_ THEN
            plant(i.st, v.c, labk!i + svsize + globsize + 1)
         OR
            plant(i.st, v.x, labk!i)
      $)
   $)

   // GLOBAL routines and functions

   FOR i = 0 TO globsize DO
   $( LET l = globv!i

      IF l LE 0 LOOP   // No value, or initialised already

      IF NOT setup_ THEN
      $( setup_ := TRUE
         plant(i.lss, v.x, 1)
      $)

      adjust(offset, labv!l)
      offset := labv!l
      plant(i.st, v.c, svsize + i)
      globv!i := - globv!i         // Mark as initialised
   $)

   IF NOT setup_ THEN
      IF codelist_ THEN
         writes("***N** No entry points in this module*N***N")
$)

AND adjust(offset, addr) BE
$( LET op = i.uad

   offset := addr - offset
   IF offset < 0 THEN
   $( offset := -offset
      op := i.usb
   $)
   plant(op, v.nil, offset)
$)

AND report(mes, a, b, c, d, e, f, g, h, i, j, k) BE
$( selectoutput(journal)
   writes("Error - ")
   writef(mes, a, b, c, d, e, f, g, h, i, j, k); newline()
   IF omfname NE 0 THEN
      writes("*NOMF output abandoned*N")

   stop(1001)
$)

AND comment(mes, a, b, c, d, e, f, g, h, i, j, k) BE
$( LET o = output()

   selectoutput(journal)
   writes("Warning - ")
   writef(mes, a, b, c, d, e, f, g, h, i, j, k); newline()

   comments := comments + 1

   selectoutput(o)
$)

 .

GET "BCPLQ_BCPLQHDR"

LET gencode(file) BE
$( LET prev.ssp = -1   // Used for communication between the actions for the
                       // 'STACK n' and 'RTRN' opcodes
   op := readop()
   $( IF monitoring_ THEN
         monitor("**op=%N, labv!0=%X8*N", op, labv!0)

      SWITCHON op INTO
      $( DEFAULT:         report("illegal OCODE - %N", op)

         CASE s.lp:       loadt(k.loc, readn()); BREAK

         CASE s.lg:       loadt(k.ctb, readn() + svsize); BREAK

         CASE s.ln:       loadt(k.numb, readn()); BREAK

         CASE s.ll:       $( LET l = readl()
                             LET dl = dlabv!l

                             op := readop()

                             IF monitoring_ THEN
                                monitor("S.LL:  dl=%N, l=%N, op=%N*N", dl, l, op)

                             TEST (op = s.rtap \/ op = s.fnap \/ op = s.goto) & directcall_ THEN
                             $( TEST op = s.goto THEN cggoto(dl) OR cgapply(op, readn(), dl)
                                BREAK
                             $)
                             OR
                             $( TEST utility_ THEN
                                   loadt(k.ctb, dl + svsize + globsize + 1)
                                OR
                                   loadt(k.xnb, dl)
                                LOOP
                             $)
                          $)

         CASE s.true:
         CASE s.false:    loadt(k.numb, op = s.true); BREAK

         CASE s.lstr:     cgstring(readn()); BREAK

         CASE s.llp:      loadlvp(readn())
                          BREAK

         CASE s.llg:      loadlv(readn() + svsize)
                          BREAK

         CASE s.lll:      TEST utility_ THEN
                             loadlv(dlabv!readl() + svsize + globsize + 1)
                          OR
                             loadlvx(dlabv!readl())
                          BREAK

         CASE s.sp:       storein(k.loc, readn()); BREAK

         CASE s.sg:       storein(k.ctb, readn() + svsize); BREAK

         CASE s.sl:       TEST utility_ THEN
                             storein(k.ctb, dlabv!readl() + svsize + globsize + 1)
                          OR
                             storein(k.xnb, dlabv!readl())
                          BREAK

         CASE s.stind:    storei(); BREAK

         CASE s.not:      IF pendingop = s.eqv THEN
                          $( pendingop := s.neqv
                             BREAK
                          $)

         CASE s.mult: CASE s.div: CASE s.rem: CASE s.plus: CASE s.minus:
         CASE s.neg: CASE s.abs: CASE s.lshift: CASE s.rshift:
         CASE s.ge: CASE s.ls: CASE s.gr: CASE s.le: CASE s.eq: CASE s.ne:
         CASE s.logand: CASE s.logor: CASE s.eqv: CASE s.neqv: CASE s.getbyte:

                          cgpendingop(r.null)
                          pendingop := op
                          BREAK

         CASE s.rv:       cgrv(); LOOP

         CASE s.putbyte:  cgputbyte(); BREAK

         CASE s.slctap:
         CASE s.slctst:   cgselect(op); BREAK

         CASE s.endfor:   cgpendingop(r.null)
                          pendingop := s.le
                          op := s.jt   // Drop through

         CASE s.jt:
         CASE s.jf:       cgbranch(op = s.jt, readl())
                          BREAK

         CASE s.goto:     cggoto(-1); BREAK

         CASE s.jump:     cgpendingop(r.null)
                          store(0, ssp - 1)
                          asf(ssp - ssf)
                          branch(i.j, readl())
                          incode_ := FALSE
                          BREAK

         CASE s.labr:
         CASE s.labx:
         CASE s.lab:      complab(readl(), FALSE); BREAK

         CASE s.mark:
         CASE s.stack:    $( LET k = ?

                             cgpendingop(r.null)

                             $( k := readn()
                                op := readop()
                             $) REPEATWHILE op = s.stack \/ op = s.mark

                             IF op = s.rtrn THEN
                             $( prev.ssp := k
                                k := 2
                             $)

                             stack(k)
                             asf(k - ssf)
                             LOOP
                          $)

         CASE s.prcl:     cgpendingop(r.null)
                          store(0, ssp - 1)
                          resetdr()
                          plant(i.stxn, v.t, 0)
                          plant(i.stct, v.t, 0)
                          plant(i.std, v.t, 0)
                          plant(i.stln, v.t, 0)   // Must NOT be replaced by PRCL!
                          plant(i.asf, v.nil, 4)
                          ssf := ssf + 9
                          initstack(ssp + 9)
                          BREAK

         CASE s.store:    cgpendingop(r.null)
                          store(0, ssp - 1)
                          FOR a = tempv TO arg1 BY tempsize DO
                             IF h1!a = k.stack THEN h1!a := k.loc
                          asf(ssp - ssf)
                          BREAK

         CASE s.query:    loadt(k.numb, 0); BREAK

         CASE s.entry:    $( LET n = readn()
                             LET l = readl()

                             cgentry(n, l)
                          $)
                          BREAK

         CASE s.endproc:  readn()   // Ignore for now
                          BREAK

         CASE s.mc:       cgcode(readn()); BREAK

         CASE s.save:     $( LET n = readn()
                             freereg(r.acc)
                             freereg(r.b)
                             clear_slaves()
                             dr_a := svinw
                             plant(i.stln, v.t, 0)
                             plant(i.lsd, v.t, 0)
                             IF NOT utility_ THEN
                                plant(i.rot, v.nil, 32)
                             plant(i.raln, v.nil, 60)
                             plant(i.st, v.l, 0)
                             IF n GE 60 THEN
                                report("too many parameters declared in a routine or function")
                             ssf := n
                             initstack(n)
                             ssf := 60
                             op := readop()
                             UNLESS op = s.stack \/ op = s.mark DO asf(n - 60)
                             LOOP
                          $)

         CASE s.rtap:
         CASE s.fnap:     cgapply(op, readn(), -1); BREAK

         CASE s.rtcall:
         CASE s.fncall:   $( LET k = readn()
                             AND v = VEC maxstrlength/bytesperword + 1
                             LET l = readn()
                             AND offset = ?

                             FOR i = 1 TO l DO
                                v%i := readn()
                             v%0 := l

                             offset := findpltentry(v)

                             cgpendingop(r.null)
                             store(0, ssp - 1)
                             plant(i.raln, v.nil, ssp - k - 4)
                             TEST mainprog_ \/ utility_ THEN
                                plant(i.lxn, v.c, svxnb)
                             OR
                             $( TEST xnbglobal NE 0 THEN
                                   plant(i.lxn, v.c, svsize + xnbglobal)
                                OR
                                   report("external reference in module with no global defined in SECTION")
                             $)
                             IF codelist_ THEN
                                writef("***N** External reference to *"%S*"*N***N", v)
                             plant(i.call, v.ix, offset)
                             plant(i.ld, v.t, 0)
                             dr_a := svinw
                             plant(i.lct, v.t, 0)
                             plant(i.lxn, v.t, 0)
                             clear_slaves()
                             ssf := k
                             stack(k)
                             IF op = s.fncall THEN loadt(k.reg, r.acc)
                             BREAK
                          $)

         CASE s.fnrn:
         CASE s.rtrn:     cgpendingop(r.null)
                          resetdr()
                          IF op = s.fnrn THEN
                          $( movetor(r.acc, arg1)
                             stack(ssp - 1)
                          $)
                          asf(2 - ssp)
                          TEST utility_ THEN
                          $( plant(i.lln, v.t, 0)
                             plant(i.j, v.t, 0)
                          $)
                          OR
                          $( plant(i.lb, v.t, 0)
                             plant(i.lln, v.l, 0)
                             plant(i.asf, v.nil, -1)
                             plant(i.j, v.b, 0)
                           $)
                          incode_ := FALSE
                          UNLESS prev.ssp < 0 DO
                          $( ssp := prev.ssp
                             prev.ssp := -1
                          $)
                          initstack(ssp)
                          BREAK

         CASE s.res:      $( LET newsf = readn()
                             LET l = readl()
                             cgpendingop(r.null)
                             store(0, ssp - 2)
                             movetor(r.acc, arg1)
                             stack(ssp - 1)
                             UNLESS newsf = ssp DO
                                asf(newsf - ssp)
                             branch(i.j, l)
                             incode_ := FALSE
                             BREAK
                          $)

         CASE s.rstack:   initstack(readn())
                          loadt(k.reg, r.acc)
                          BREAK

         CASE s.finish:   // Compile as STOP(0)
                          cgpendingop(r.null)
                          resetdr()
                          stack(ssp + 2)
                          loadt(k.numb, 0)
                          loadt(k.ctb, svsize + gv.stop)
                          cgapply(s.rtap, ssp - 4, -1)
                          incode_ := FALSE
                          BREAK

         CASE s.switchon: cgswitch(); BREAK

         CASE s.global:   globaln := readn()
                          IF (globaln LE 0) & (mainprog_ \/ utility_) THEN
                             comment("no globals set in %S file", file)
                          RETURN

         CASE s.datalab:  $( LET v = VEC maxstrlength/bytesperword + 1
                             LET l = readl()
                             LET n = readn()
                             AND ptr = utility_ -> datap, pltsize/4
                             AND base = utility_ -> datav, pltv

                             v%0 := n
                             FOR i = 1 TO n DO
                                v%i := readn()

                             FOR i = n + 1 TO n + bytesperword - n REM bytesperword - 1 DO
                                v%i := 0   // Pad last word with nulls

                             IF NOT tracing_ \/ n = 0 THEN
                             $( dlabv!l := ptr
                                BREAK
                             $)

                             !static_chain := ptr            // Add to chain of STATIC names
                             static_chain := base + ptr      // Update pointer to end of chain
                             [utility_ -> data, findpltword](0)   // New end of chain
                             ptr := ptr + 1

                             FOR i = 0 TO n/bytesperword DO  // Output the name
                             $( [utility_ -> data, findpltword](v!i)
                                ptr := ptr + 1
                             $)

                             dlabv!l := ptr
                             BREAK
                          $)

         CASE s.itemn:    [utility_ -> data, findpltword](readn()); BREAK

         CASE s.iteml:    $( LET l = readl()

                             TEST utility_ THEN
                             $( labk!labkp := datap
                                slabv!datap := l
                                data(0)   // Filled in during initialisation
                             $)
                             OR
                             $( slabv!(pltsize/4) := l
                                labk!labkp := findpltword(0)
                             $)
                             labkp := labkp + 1
                             IF labkp GE max.staticlabels THEN
                                report("out of space for static routine cells")
                             BREAK
                          $)

         CASE s.end:      report("unexpected end of input file")
      $)
   $) REPEAT
$) REPEAT

AND readop() = VALOF
$( LET n = readnumber(10)

   IF terminator GE 0 RESULTIS n
   IF terminator = endstreamch RESULTIS s.end

   report("response %N (%S%X8) on input", terminator, terminator < 0 -> "-", "", ABS terminator)
$)

AND readl() = VALOF
$( LET a = 0
   AND c = rdch()
   AND n = ?

   WHILE c = '*S' \/ c = '*N' DO c := rdch()

   UNLESS c = 'L' DO report("no L where label expected")

   n := readnumber(10)

   IF n GE max.labels THEN
      report("too many *'labels*' in program")

   RESULTIS n
$)

AND cgpendingop(bestreg) BE
$( LET rand1, rand2 = arg1, arg2
   AND sw = FALSE
   AND f = ?
   AND r = ?

   IF pendingop = s.none RETURN

   SWITCHON pendingop INTO
   $( CASE s.eq:  f := i.je ; GOTO rel
      CASE s.ne:  f := i.jne; GOTO rel
      CASE s.ls:  f := i.jl ; GOTO rel
      CASE s.gr:  f := i.jg ; GOTO rel
      CASE s.le:  f := i.jle; GOTO rel
      CASE s.ge:  f := i.jge

            rel:  movecontor(r.b, -1)
                  IF h1!rand2 = k.numb THEN
                  $( rand1, rand2 := arg2, arg1
                     f := invop(f)
                  $)
                  IF h1!arg1 = k.stack = h1!arg2 THEN
                  $( rand1, rand2 := arg2, arg1
                     f := invop(f)
                  $)
                  IF regusedby(rand1) = r.acc THEN
                  $( rand1, rand2 := arg2, arg1
                     f := invop(f)
                  $)
                  movetor(r.acc, rand2)
                  TEST numberis(0, rand1) THEN
                     f := accop(f)
                  OR
                     comp(i.icp, rand1)
                  plant(f, v.nil, 3)
                  movecontor(r.b, 0)
                  lose1(r.b)
                  ENDCASE

      CASE s.eqv:
         sw := TRUE
      CASE s.neqv:
         IF regusedby(rand1) = r.acc THEN
            rand1, rand2 := arg2, arg1
         IF h1!arg1 = k.stack = h1!arg2 THEN
            rand1, rand2 := arg2, arg1
         movetor(r.acc, rand2)
         comp(i.neq, rand1)
         IF sw THEN plant(i.irsb, v.nil, -1)
         lose1(r.acc)
         ENDCASE

      CASE s.plus:
         IF h1!rand2 = k.numb THEN rand1, rand2 := arg2, arg1
         IF numberis(0, rand1) THEN
         $( h1!arg2, h2!arg2 := h1!rand2, h2!rand2
            stack(ssp - 1)
            ENDCASE
         $)
         IF h1!arg1 = k.stack = h1!arg2 THEN
            rand1, rand2 := arg2, arg1
         TEST bestreg = r.null THEN
         $( IF h1!rand1 = k.reg THEN
            $( LET r1, r2 = rand1, rand2
               rand1, rand2 := r2, r1
            $)
            IF regusedby(rand2) = r.b & regusedby(rand1) = r.acc THEN
            $( LET r1, r2 = rand1, rand2
               rand1, rand2 := r2, r1
            $)
            r := movetoanyr(rand2)
         $)
         OR
         $( IF regusedby(rand1) = bestreg THEN
            $( LET r1, r2 = rand1, rand2
               rand1, rand2 := r2, r1
            $)
            r := movetor(bestreg, rand2)
         $)
         comp(r = r.acc -> i.iad, i.adb, rand1)
         lose1(r)
         ENDCASE

      CASE s.minus:
         IF numberis(0, rand1) THEN
         $( stack(ssp - 1)
            ENDCASE
         $)
         f := i.isb
         IF (h1!rand2 = k.numb) \/ (h1!arg1 = k.stack = h1!arg2) \/ (h1!rand1 = k.reg) THEN
         $( rand1, rand2 := arg2, arg1
            f := i.irsb
         $)
         TEST f = i.isb THEN
            r := movetoanyr(rand2)
         OR
            r := movetor(r.acc, rand2)
         IF r = r.b THEN f := i.sbb
         comp(f, rand1)
         lose1(r)
         ENDCASE

      CASE s.mult:
         IF h1!rand2 = k.numb THEN rand1, rand2 := arg2, arg1
         IF numberis(0, rand1) THEN
         $( h1!arg2, h2!arg2 := k.numb, 0
            stack(ssp - 1)
            ENDCASE
         $)
         IF numberis(1, rand1) THEN
         $( h1!arg2, h2!arg2 := h1!rand2, h2!rand2
            stack(ssp - 1)
            ENDCASE
         $)
         IF h1!rand1 = k.reg THEN
         $( LET r1, r2 = rand1, rand2
            rand1, rand2 := r2, r1
         $)
         IF regusedby(rand2) = r.b & regusedby(rand1) = r.acc THEN
         $( LET r1, r2 = rand1, rand2
            rand1, rand2 := r2, r1
         $)
         IF h1!arg1 = k.stack = h1!arg2 THEN
            rand1, rand2 := arg2, arg1
         r := movetoanyr(rand2)
         comp(r = r.acc -> i.imy, i.myb, rand1)
         lose1(r)
         ENDCASE

      CASE s.div:
         IF numberis(1, rand1) THEN
         $( stack(ssp - 1)
            ENDCASE
         $)
         f := i.idv
         IF (h1!rand2 = k.numb) \/ (h1!arg1 = k.stack = h1!arg2) \/ regusedby(rand1) = r.acc THEN
         $( rand1, rand2 := arg2, arg1
            f := i.irdv
         $)
         movetor(r.acc, rand2)
         comp(f, rand1)
         lose1(r.acc)
         ENDCASE

      CASE s.rem:
      $( LET t = FALSE

         IF numberis(1, rand1) THEN
         $( h1!arg2, h2!arg2 := k.numb, 0
            stack(ssp - 1)
            ENDCASE
         $)

         IF regusedby(arg1) = r.acc THEN
            TEST isfree(r.b) THEN
            $( plant(i.st, v.b, 0)
               slave(r.b, acc_v, acc_a, acc_k)
               h2!arg1 := r.b
            $)
            OR
            $( plant(i.st, v.c, svwork)
               h1!arg1, h2!arg1 := k.ctb, svwork
            $)

         IF h1!arg1 = k.stack = h1!arg2 THEN
         $( h1!arg2 := k.loc
            t := TRUE
         $)
         movetor(r.acc, rand2)
         comp(i.imdv, rand1)
         plant(i.lss, v.t, 0)
         IF t THEN asf(-1)
         lose1(r.acc)
         ENDCASE
      $)

      CASE s.logor:
         sw := TRUE
      CASE s.logand:
         IF h1!rand2 = k.numb THEN rand1, rand2 := arg2, arg1
         IF numberis(sw, rand1) THEN
         $( h1!arg2, h2!arg2 := k.numb, sw
            stack(ssp - 1)
            ENDCASE
         $)
         IF numberis(NOT sw, rand1) THEN
         $( h1!arg2, h2!arg2 := h1!rand2, h2!rand2
            stack(ssp - 1)
            ENDCASE
         $)
         IF regusedby(rand1) = r.acc THEN
         $( LET r1, r2 = rand1, rand2
            rand1, rand2 := r2, r1
         $)
         IF h1!arg1 = k.stack = h1!arg2 THEN
            rand1, rand2 := arg2, arg1
         movetor(r.acc, rand2)
         comp(sw -> i.or, i.and, rand1)
         lose1(r.acc)
         ENDCASE

      CASE s.neg:
      CASE s.abs:
         sw := TRUE
      CASE s.not:
         movetor(r.acc, rand1)
         IF pendingop = s.abs THEN plant(i.jnn, v.nil, 3)
         plant(i.irsb, v.nil, sw -> 0, -1)
         h1!rand1, h2!rand1 := k.reg, r.acc
         unslave(r.acc)
         pendingop := s.none
         ENDCASE

      CASE s.lshift:
      $( LET t = FALSE

         IF regusedby(arg1) = r.acc THEN
            TEST isfree(r.b) THEN
            $( plant(i.st, v.b, 0)
               slave(r.b, acc_v, acc_a, acc_k)
               h2!arg1 := r.b
            $)
            OR
            $( plant(i.st, v.c, svwork)
               h1!arg1, h2!arg1 := k.ctb, svwork
            $)

         IF h1!arg1 = k.stack = h1!arg2 THEN
         $( h1!arg2 := k.loc
            t := TRUE
         $)
         movetor(r.acc, arg2)
         comp(i.ush, arg1)
         IF t THEN asf(-1)
         lose1(r.acc)
         ENDCASE
      $)

      CASE s.rshift:
         TEST h1!arg1 = k.numb THEN
         $( h2!arg1 := -h2!arg1
            movetor(r.acc, arg2)
            comp(i.ush, arg1)
         $)
         OR
         $( movecontor(r.b, 0)
            IF regusedby(arg1) = r.acc THEN
            $( plant(i.st, v.c, svwork)
               h1!arg1, h2!arg1 := k.ctb, svwork
            $)
            movetor(r.acc, arg2)
            comp(i.sbb, arg1)
            plant(i.ush, v.b, 0)
            unslave(r.b)
         $)
         lose1(r.acc)
         ENDCASE

      CASE s.getbyte:
      $( LET op = ?

         IF bestreg = r.null THEN bestreg := r.acc
         op := bestreg = r.acc -> i.lss, i.lb

         IF h1!rand1 = k.stack \/ (h1!rand1 = k.reg & h2!rand1 = r.b) THEN
            movetor(r.acc, rand1)

         TEST h1!rand2 = k.numb THEN
            movecontor(r.b, amode = am.byte -> h2!rand2, h2!rand2*bytesperword)
         OR
         $( movetor(r.b, rand2)
            UNLESS amode = am.byte DO
            $( plant(i.myb, v.nil, bytesperword)
               unslave(r.b)
            $)
         $)

         TEST h1!rand1 = k.reg & h2!rand1 = r.acc THEN
         $( plant(i.iad, v.b, 0)
            plant(i.st, v.b, 0)
            clear_slaves()
         $)
         OR
         $( UNLESS numberis(0, rand1) DO
            $( comp(i.adb, rand1)
               unslave(r.b)
            $)

            IF bestreg = r.acc THEN freereg(r.acc)
         $)

         TEST dr_a = svinb THEN
            plant(op, v.md, 0)
         OR
         $( plant(op, v.mic, svinb)
            dr_a := svinb
         $)
         lose1(bestreg)
         ENDCASE
      $)

      DEFAULT:
         report("in compiler - bad op in CGPENDINGOP - %N", pendingop)
   $)
$)

AND accop(op) = VALOF SWITCHON op INTO
   $( CASE i.je :  RESULTIS i.jz
      CASE i.jne:  RESULTIS i.jnz
      CASE i.jl :  RESULTIS i.jn
      CASE i.jg :  RESULTIS i.jp
      CASE i.jle:  RESULTIS i.jnp
      CASE i.jge:  RESULTIS i.jnn
      DEFAULT   :  report("in compiler - bad op in ACCOP - %N", op)
   $)

AND bop(op) = VALOF SWITCHON op INTO
   $( CASE i.je :  RESULTIS i.jzb
      CASE i.jne:  RESULTIS i.jnzb
      CASE i.jl :  RESULTIS i.jnb
      CASE i.jg :  RESULTIS i.jpb
      CASE i.jle:  RESULTIS i.jnpb
      CASE i.jge:  RESULTIS i.jnnb
      DEFAULT   :  report("in compiler - bad op in BOP - %N", op)
   $)

AND invop(op) = VALOF SWITCHON op INTO
   $( CASE i.je :
      CASE i.jne:  RESULTIS op
      CASE i.jl :  RESULTIS i.jg
      CASE i.jg :  RESULTIS i.jl
      CASE i.jle:  RESULTIS i.jge
      CASE i.jge:  RESULTIS i.jle
      DEFAULT   :  report("in compiler - bad op in INVOP - %N", op)
   $)

AND movetoanyr(a) = movetor(regfor(a), a)

AND regfor(a) = VALOF
$( IF h1!a = k.reg RESULTIS h2!a

   IF slaved(r.acc, h1!a, h2!a, 0) THEN
   $( freereg(r.acc)
      RESULTIS r.acc
   $)

   IF slaved(r.b, h1!a, h2!a, 0) THEN
   $( freereg(r.b)
      RESULTIS r.b
   $)

   IF isfree(r.acc) RESULTIS r.acc
   IF isfree(r.b) RESULTIS r.b

   freereg(r.acc)

   RESULTIS r.acc
$)

AND movetor(r, a) = VALOF
$( UNLESS h1!a = k.reg & h2!a = r DO
   $( freereg(r)
      IF slaved(r, h1!a, h2!a, 0) RESULTIS r
      TEST slaved(other(r), h1!a, h2!a, 0) THEN
         plant(r = r.acc -> i.lss, i.st, v.b, 0)
      OR
         comp(r = r.acc -> i.lss, i.lb, a)
      slave(r, h1!a, h2!a, 0)
      h1!a, h2!a := k.reg, r
   $)
   RESULTIS r
$)

AND movecontor(r, n) BE
$( freereg(r)
   IF slaved(r, k.numb, n, 0) RETURN
   plant(r = r.acc -> i.lss, i.lb, v.nil, n)
   slave(r, k.numb, n, 0)
$)

AND lose1(r) BE
$( ssp := ssp - 1
   pendingop := s.none

   TEST arg2 = tempv THEN
      h1!arg2, h2!arg2, h3!arg2 := k.loc, ssp - 2, ssp - 2
   OR
   $( arg1 := arg2
      arg2 := arg2 - tempsize
   $)
   h1!arg1, h2!arg1, h3!arg1 := k.reg, r, ssp - 1

   unslave(r)
$)

AND regusedby(t) = h1!t = k.reg -> h2!t, r.null

AND freereg(r) BE
   FOR t = tempv TO arg1 BY tempsize DO
      IF regusedby(t) = r THEN
      $( LET type = k.loc
         IF h3!t > ssf THEN asf(h3!t - ssf)

         TEST h3!t = ssf THEN
         $( plant(r = r.acc -> i.st, i.stb, v.t, 0)
            type := k.stack
            ssf := ssf + 1
         $)
         OR
         $( plant(r = r.acc -> i.st, i.stb, v.l, h3!t)
            IF slaved(other(r), k.loc, h3!t, 0) THEN unslave(other(r))
         $)
         h1!t, h2!t := type, h3!t

         slave(r, k.loc, h3!t, 0)
         RETURN
      $)

AND isfree(r) = VALOF
$( FOR t = tempv TO arg1 BY tempsize DO
      IF regusedby(t) = r RESULTIS FALSE
   RESULTIS TRUE
$)

AND resetdr() BE
$( UNLESS dr_a = svinw DO
   $( plant(i.ld, v.c, svinw)
      dr_a := svinw
   $)
$)

AND numberis(n, a) = h1!a = k.numb & h2!a = n

AND storei() BE
$( LET r, v = ?, ?
   AND k = ?

   cgpendingop(r.b)

   k := h1!arg1

   IF k = k.reg & h2!arg1 = r.acc THEN
   $( freereg(r.b)
      plant(i.st, v.b, 0)
      h2!arg1 := r.b
   $)

   TEST k = k.reg & h2!arg1 = r.b THEN
   $( movetor(r.acc, arg2)
      TEST dr_a = svinw THEN
         plant(i.st, v.md, 0)
      OR
      $( plant(i.st, v.mic, svinw)
         dr_a := svinw
      $)
      clear_slaves()
   $)
   OR
   $( r := movetoanyr(arg2)
      resetdr()
      IF k = k.xnb THEN set_xnb()
      v := k = k.loc -> v.dl,
           k = k.ctb -> v.dc,
           k = k.xnb -> v.dx,
           k = k.numb -> v.d,
                         report("in compiler - illegal K in STOREI - %N", k)

      plant(r = r.acc -> i.st, i.stb, v, h2!arg1)
      IF k = k.xnb THEN restore_xnb()
   $)

   UNLESS (acc_v = k.svctbword) \/ (acc_v = k.lnb) DO unslave(r.acc)
   UNLESS (b_v   = k.svctbword) \/ (b_v   = k.lnb) DO unslave(r.b)
   stack(ssp - 2)
$)

AND slave(r, v, a, k) BE
$( IF v = k.stack THEN v := k.loc

   TEST r = r.acc THEN
      acc_v, acc_a, acc_k := v, a, k
   OR TEST r = r.b THEN
      b_v, b_a, b_k := v, a, k
   OR report("in compiler - bad R in SLAVE - %N", r)
$)

AND unslave(r) BE
   TEST r = r.acc THEN
      acc_v := k.none
   OR TEST r = r.b THEN
      b_v := k.none
   OR UNLESS r = r.null DO
         report("in compiler - bad R in UNSLAVE - %N", r)

AND clear_slaves() BE
   acc_v, b_v := k.none, k.none

AND slaved(r, v, a, k) = VALOF
   TEST r = r.acc THEN
      RESULTIS acc_v = v &
               acc_a = a &
               acc_k = 0
   OR
   TEST r = r.b THEN
      RESULTIS b_v = v &
               b_a = a &
               b_k = 0
   OR report("in compiler - bad R in SLAVED - %N", r)

AND other(r) = r = r.acc -> r.b,
               r = r.b -> r.acc,
                  report("in compiler - bad R in OTHER - %N", r)

AND set_xnb() = VALOF
/* If necessary, sets XNB to the correct value for access to the PLT. If
no code is generated, yields FALSE; otherwise, yields TRUE. */
$( IF mainprog_ \/ utility_ RESULTIS FALSE

   /* TEMPORARY --- NO CODE GENERATED */
   IF xnbglobal = 0 THEN
      report("attempted access to STATIC in module with no global defined in SECTION directive")
//   TEST xnbglobal = 0 THEN
//      report("attempted access to STATIC in module with no global defined in SECTION directive")
//   OR
//   $( plant(i.stxn, v.c, 0)             // Save old value
//      plant(i.lxn, v.c, svsize + xnbglobal)
//   $)
//   RESULTIS TRUE
   RESULTIS FALSE
$)

AND restore_xnb() BE TEST TRUE THEN RETURN OR
/* Restores the value in XNB (if any) saved by 'set_xnb'. */
$( UNLESS mainprog_ \/ utility_ DO
      plant(i.lxn, v.c, 0)
$)

 .

GET "BCPLQ_BCPLQHDR"

LET store(a, b) BE
$( LET base, p = h3!tempv, ?
   AND stacking_ = FALSE
   AND size = 1
   AND r = r.acc

   IF a < base THEN a := base
   IF b > ssp - 1 THEN b := ssp - 1

   p := tempv + (a - base)*tempsize

   UNTIL a > b DO
   $( TEST local(p) THEN
         IF stacking_ DO
         $( plant(r = r.acc -> i.st, i.stb, v.t, 0)
            ssf := ssf + size
            stacking_ := FALSE
            r := r.acc
         $)
      OR
      $( IF h3!p > (stacking_ -> ssf + size, ssf) THEN asf(h3!p - ssf)

         TEST stacking_ THEN
            TEST r = r.b & regusedby(p) = r.acc THEN
            $( plant(i.stb, v.t, 0)
               slave(r.b, k.loc, ssf, 0)
               ssf := ssf + 1
               size := 1
               r := r.acc
            $)
            OR
            $( comp(r = r.acc -> i.slss, i.slb, p)
               unslave(r)
               ssf := ssf + size
               size := 1
            $)
         OR
            TEST h1!p = k.reg THEN
            $( LET rr = regusedby(p)

               TEST h3!p < ssf THEN
               $( plant(rr = r.acc -> i.st, i.stb, v.l, h3!p)
                  IF slaved(other(rr), k.loc, h3!p, 0) THEN
                     unslave(other(rr))
                  slave(rr, k.loc, h3!p, 0)
               $)
               OR
               $( r := rr
                  stacking_ := TRUE
               $)
            $)
            OR
            $( UNLESS isfree(r) DO
               $( LET t = VALOF
                  $( FOR i = tempv TO arg1 BY tempsize DO
                        IF regusedby(i) = r RESULTIS i
                     report("in compiler - in STORE")
                  $)
                  TEST isfree(r.b) THEN
                  $( plant(i.st, v.b, 0)
                     slave(r.b, acc_v, acc_a, acc_k)
                     h2!t := r.b
                  $)
                  OR
                  $( plant(r = r.acc -> i.st, i.stb, v.c, svwork)
                     h1!t, h2!t := k.ctb, svwork
                  $)
               $)
               movetor(r, p)
               size := 1
               TEST h3!p < ssf THEN
               $( plant(r = r.acc -> i.st, i.stb, v.l, h3!p)
                  IF slaved(other(r), k.loc, h3!p, 0) THEN
                     unslave(other(r))
                  slave(r, k.loc, h3!p, 0)
               $)
               OR
                  stacking_ := TRUE
            $)

         h1!p, h2!p := k.stack, h3!p
      $)
      a, p := a + 1, p + tempsize
   $)

   p := p - tempsize

   IF stacking_ THEN
   $( TEST h3!p < ssf THEN
      $( plant(r = r.acc -> i.st, i.stb, v.l, h3!p)
         IF slaved(other(r), k.loc, h3!p, 0) THEN
            unslave(other(r))
      $)
      OR
      $( plant(r = r.acc -> i.st, i.stb, v.t, 0)
         ssf := ssf + size
      $)
      slave(r, k.loc, h3!p, 0)
   $)
$)

AND local(a) = ((h1!a = k.loc) \/ (h1!a = k.stack)) & h2!a = h3!a

AND initstack(n) BE
$( arg2, arg1 := tempv, tempv + tempsize
   UNLESS ssf = n DO asf(n - ssf)

   ssp, ssf := n, n
   pendingop := s.none

   h1!arg2, h2!arg2, h3!arg2 := k.loc, n - 2, n - 2
   h1!arg1, h2!arg1, h3!arg1 := k.loc, n - 1, n - 1
$)

AND loadt(v, a) BE
$( cgpendingop(r.null)
   arg2 := arg1
   arg1 := arg1 + tempsize
   IF arg1 GE tempv + tempvsize*tempsize DO
      report("in compiler - overflow of simulated stack")
   h1!arg1, h2!arg1, h3!arg1 := v, a, ssp
   ssp := ssp + 1
$)

AND stack(n) BE
$( pendingop := s.none

   IF n > ssp THEN
   $( store(0, ssp - 1)
      initstack(n)
      RETURN
   $)

   UNTIL n = ssp DO
   $( IF h1!arg1 = k.stack THEN h1!arg1 := k.loc
      IF h1!arg1 = acc_v & h3!arg1 = acc_a THEN unslave(r.acc)
      IF h1!arg1 = b_v   & h3!arg1 = b_a   THEN unslave(r.b)
      IF arg2 = tempv THEN
      $( TEST n = (ssp - 1) THEN
         $( asf(n - ssf)
            ssp := n
            h1!arg1, h2!arg1, h3!arg1 := h1!arg2, h2!arg2, h3!arg2
            h1!arg2, h2!arg2, h3!arg2 := k.loc, ssp - 2, ssp - 2
         $)
         OR initstack(n)
         RETURN
      $)
      arg1, arg2 := arg1 - tempsize, arg2 - tempsize
      ssp := ssp - 1
   $)

   IF ssf > ssp THEN asf(ssp - ssf)
$)

AND storein(s, n) BE
$( LET r = ?

   cgpendingop(r.null)

   r := movetoanyr(arg1)

   IF slaved(other(r), s, n, 0) THEN unslave(other(r))

   slave(r, s, n, 0)

   TEST s = k.loc THEN
   $( IF n > ssf DO asf(n - ssf)
      IF n = ssf THEN
      $( plant(r = r.acc -> i.st, i.stb, v.t, 0)
         ssf := ssf + 1
         stack(ssp - 1)
         RETURN
      $)
      plant(r = r.acc -> i.st, i.stb, v.l, n)
   $)
   OR TEST s = k.ctb \/ s = k.xnb THEN
   $( IF s = k.xnb THEN set_xnb()
      plant(r = r.acc -> i.st, i.stb, s = k.ctb -> v.c, v.x, n)
      IF s = k.xnb THEN restore_xnb()
   $)
   OR report("in compiler - bad type in STOREIN - %N", s)

   stack(ssp - 1)
$)

AND cgapply(type, k, statlab) BE
/*  'statlab'  is -1 for a normal call. All other values mean that it is
the offset within 'slabv' of an item containing the label of  the  entry
point  of  a routine or function to be called directly (with a relative,
rather than indirect, JLK).  */
$( IF (ssp - k) GE (statlab < 0 -> 60, 59) THEN
      report("too many parameters in a %S call", type = s.rtap -> "routine", "function")

   cgpendingop(r.null)
   resetdr()

   TEST statlab < 0 THEN                // Normal call
   $( IF regusedby(arg1) = r.acc THEN
      $( freereg(r.b)
         plant(i.st, v.b, 0)
         h2!arg1 := r.b
      $)
   
      store(0, ssp - 2)
   
      IF h1!arg1 = k.stack \/ h1!arg1 = k.numb THEN
         movetor(r.b, arg1)
   
      asf(60 - (ssp - k - 1))
   
      TEST regusedby(arg1) = r.b THEN
         plant(i.jlk, v.b, 0)
      OR comp(i.jlk, arg1)
   $)
   OR
   $( LET dest = slabv!statlab

      store(0, ssp - 1)
      asf(60 - (ssp - k))

      branch(i.jlk, dest)
   $)

   clear_slaves()

   ssf := k
   stack(k)

   IF statlab GE 0 THEN
   $( TEST xnbglobal NE 0 THEN
         plant(i.lxn, v.c, svsize + xnbglobal)
      OR
         IF mainprog_ THEN
            plant(i.lxn, v.c, svxnb)
   $)

   IF op = s.fnap THEN loadt(k.reg, r.acc)
$)

AND loadlv(offset) BE
$( LET r = ?

   cgpendingop(r.null)

   IF amode = am.byte THEN
      offset := offset*bytesperword

   TEST acc_v = k.svctbword THEN
   $( LET a = acc_a

      freereg(r.acc)
      plant(i.iad, v.nil, offset - a)
   $)
   OR
   $( freereg(r.acc)
      plant(i.lss, v.c, svctbword)
      plant(i.iad, v.nil, offset)
   $)

   slave(r.acc, k.svctbword, offset, 0)

   loadt(k.reg, r.acc)
$)

AND loadlvp(offset) BE
$( cgpendingop(r.null)

   IF amode = am.byte THEN
      offset := offset*bytesperword

   TEST acc_v = k.lnb THEN
   $( LET a = acc_a

      freereg(r.acc)
      plant(i.iad, v.nil, offset - a)
   $)
   OR
   $( freereg(r.b)
      freereg(r.acc)
      plant(i.stln, v.b, 0)
      plant(i.lss, v.b, 0)
      UNLESS amode = am.byte DO
         plant(i.ush, v.nil, -2)
      plant(i.iad, v.nil, offset)
      unslave(r.b)
   $)

   slave(r.acc, k.lnb, offset, 0)

   loadt(k.reg, r.acc)
$)

AND loadlvx(offset) BE
$( LET r = ?

   cgpendingop(r.null)

   IF amode = am.byte THEN offset := offset*bytesperword

   freereg(r.acc)
   TEST mainprog_ THEN
   $( plant(i.stxn, v.t, 0)
      plant(i.lss, v.t, 0)
   $)
   OR
   $( IF xnbglobal = 0 THEN
         report("attempted access to STATIC in module with no global defined in SECTION directive")
      plant(i.lss, v.c, svsize + xnbglobal)
   $)

   UNLESS amode = am.byte DO
      plant(i.ush, v.nil, -2)
   plant(i.iad, v.nil, offset)

   slave(r.acc, k.xnbword, offset, 0)

   loadt(k.reg, r.acc)
$)

AND cgrv() BE
$( LET v = ?
   AND r = r.acc

   cgpendingop(r.b)

   IF h1!arg1 = k.reg & h2!arg1 = r.acc THEN
   $( freereg(r.b)
      plant(i.st, v.b, 0)
      h2!arg1 := r.b
   $)

   IF h1!arg1 = k.reg & h2!arg1 = r.b THEN
   $( op := readop()
      IF op = s.rv THEN r := r.b
      IF r = r.acc THEN freereg(r.acc)

      $( LET inst = (r = r.acc -> i.lss, i.lb)

         TEST dr_a = svinw THEN
            plant(inst, v.md, 0)
         OR
         $( plant(inst, v.mic, svinw)
            dr_a := svinw
         $)
      $)

      h1!arg1, h2!arg1 := k.reg, r
      unslave(r.b)
      unslave(r)
      RETURN
   $)

   v := h1!arg1 = k.loc -> v.dl,
        h1!arg1 = k.ctb -> v.dc,
        h1!arg1 = k.xnb -> v.dx,
        h1!arg1 = k.numb -> v.d,
                           report("in compiler - bad K in CGRV - %N", h1!arg1)

   op := readop()
   IF op = s.rv THEN r := r.b

   freereg(r)
   unslave(r)
   resetdr()
   IF v = v.dx THEN set_xnb()
   plant(r = r.acc -> i.lss, i.lb, v, h2!arg1)
   IF v = v.dx THEN restore_xnb()
   h1!arg1, h2!arg1 := k.reg, r
$)

AND cgputbyte() BE
$( LET r, op = ?, ?

   cgpendingop(r.null)
   store(0, ssp - 4)

   IF h1!arg1 = k.stack \/ (h1!arg1 = k.reg & h2!arg1 = r.b) THEN
      movetor(r.acc, arg1)

   TEST h1!arg2 = k.numb THEN
      movecontor(r.b, amode = am.byte -> h2!arg2, h2!arg2*bytesperword)
   OR
   $( movetor(r.b, arg2)
      UNLESS amode = am.byte DO
      $( plant(i.myb, v.nil, bytesperword)
         unslave(r.b)
      $)
   $)

   TEST h1!arg1 = k.reg & h2!arg1 = r.acc THEN
   $( plant(i.iad, v.b, 0)
      plant(i.st, v.b, 0)
      clear_slaves()
   $)
   OR
      UNLESS numberis(0, arg1) DO
      $( comp(i.adb, arg1)
         unslave(r.b)
      $)

   stack(ssp - 2)

   movetor(r.acc, arg1)
   TEST dr_a = svinb THEN
      plant(i.st, v.md, 0)
   OR
   $( plant(i.st, v.mic, svinb)
      dr_a := svinb
   $)
   stack(ssp - 1)
   clear_slaves()
$)

AND cgselect(op) BE
$( LET size = readn()
   LET shift = readn()
   LET offset = readn()

   TEST size = bitsperbyte & (shift REM bitsperbyte = 0) THEN
      cgbyteselector(op, shift, offset)
   OR
      cggenselector(op, size, shift, offset)
$)

AND cgbyteselector(op, shift, offset) BE
$( LET index = bytesperword - shift/bitsperbyte - 1 + (amode = am.byte -> offset, offset*bytesperword)
   AND r = ?
   AND inst = (op = s.slctap -> i.lss, i.st)

   cgpendingop(r.null)
   r := movetoanyr(arg1)

   TEST r = r.acc THEN
   $( UNLESS amode = am.byte DO
         plant(i.ush, v.nil, 2)
      UNLESS index = 0 DO
         plant(i.iad, v.nil, index)
      freereg(r.b)
      plant(i.st, v.b, 0)
   $)
   OR TEST r = r.b THEN
   $( UNLESS amode = am.byte DO
         plant(i.myb, v.nil, bytesperword)
      UNLESS index = 0 DO
         plant(i.adb, v.nil, index)
      IF op = s.slctap THEN
         freereg(r.acc)
   $)
   OR report("in compiler - bad R in CGBYTESELECTOR - %N", r)

   IF op = s.slctst THEN
      comp(i.lss, arg2)

   TEST dr_a = svinb THEN
      plant(inst, v.md, 0)
   OR
   $( plant(inst, v.mic, svinb)
      dr_a := svinb
   $)

   clear_slaves()
   TEST op = s.slctap THEN
      h1!arg1, h2!arg1 := k.reg, r.acc
   OR
      stack(ssp - 2)
$)

AND cggenselector(op, size, shift, offset) BE
$( cgpendingop(r.b)

   IF h1!arg1 = k.reg & h2!arg1 = r.acc THEN
   $( freereg(r.b)
      plant(i.st, v.b, 0)
      h2!arg1 := r.b
   $)

   movetor(r.b, arg1)
   UNLESS offset = 0 DO
   $( plant(i.adb, v.nil, offset)
      unslave(r.b)
   $)

   TEST op = s.slctap THEN
   $( freereg(r.acc)
      TEST dr_a = svinw THEN
         plant(i.lss, v.md, 0)
      OR
      $( plant(i.lss, v.mic, svinw)
         dr_a := svinw
      $)
      UNLESS shift = 0 DO
         plant(i.ush, v.nil, -shift)
      UNLESS (size + shift) = bitsperword DO
         plant(i.and, v.nil, mask(size))
      h1!arg1, h2!arg1 := k.reg, r.acc

      unslave(r.acc)
   $)
   OR
   $( movetor(r.acc, arg2)
      UNLESS (size + shift) = bitsperword DO
         plant(i.and, v.nil, mask(size))
      UNLESS shift = 0 DO
         plant(i.ush, v.nil, shift)
      TEST dr_a = svinw THEN
         plant(i.slss, v.md, 0)
      OR
      $( plant(i.slss, v.mic, svinw)
         dr_a := svinw
      $)
      plant(i.and, v.nil, NOT (mask(size) << shift))
      plant(i.or, v.t, 0)
      plant(i.st, v.md, 0)
      clear_slaves()
      stack(ssp - 2)
   $)
$)

AND mask(n) = (1 << n) - 1

AND cggoto(statlab) BE
/* 'statlab' is -1 for a normal call. For all other values, 'statlab' is
the offset within 'slabv'  of  an  item  containing  the  label  of  the
relevant destination of the jump. */
$( TEST statlab < 0 THEN
   $( LET a = h2!arg1
   
      cgpendingop(r.b)
   
      store(0, ssp - 2)
   
      resetdr()
   
      SWITCHON h1!arg1 INTO
      $( CASE k.ctb:
            plant(i.j, v.c, a)
            ENDCASE
   
         CASE k.xnb:
         $( LET xnbaltered_ = set_xnb()

            TEST NOT xnbaltered_ THEN
               plant(i.j, v.x, a)
            OR
            $( freereg(r.b)
               plant(i.lb, v.x, a)
               restore_xnb()
               plant(i.j, v.b, 0)
            $)
            ENDCASE
         $)

         CASE k.reg:
            IF a = r.acc THEN
            $( freereg(r.b)
               plant(i.st, v.b, 0)
            $)
            plant(i.j, v.b, 0)
            ENDCASE
   
         CASE k.loc:
            plant(i.j, v.l, 0)
            ENDCASE
   
         DEFAULT:
            report("in compiler - bad K in CGGOTO - %N", h1!arg1)
      $)
      stack(ssp - 1)
   $)
   OR
   $( LET dest = slabv!statlab

      cgpendingop(r.null)

      store(0, ssp - 1)
      branch(i.j, dest)
   $)
   incode_ := FALSE
$)

AND data(v) BE
$( datav!datap := v
   datap := datap + 1
   IF datap GE statsize THEN
      report("out of space for STATICs and strings")
$)

AND cgstring(n) BE
$( LET wordlength = n/bytesperword + 1
   AND m, a = 0, n
   AND ptr, iptr = ?, ?

   TEST utility_ THEN
      loadlv(datap + svsize + globsize + 1)
   OR
   $( cgpendingop(r.null)
      freereg(r.acc)

      plant(i.jlk, v.nilf, 2)
      plant(i.lss, v.t, 0)

      ptr, iptr := codelength/2, iilp

      plant(i.uad, v.nilf, 0)
      UNLESS amode = am.byte DO
         plant(i.ush, v.nil, -2)
      loadt(k.reg, r.acc)
      unslave(r.acc)
   $)

   FOR i = 1 TO wordlength DO
   $( LET w = 0

      FOR j = 0 TO bytesperword - 1 DO
      $( (@w)%j := a
         m := m + 1
         a := (m > n) -> 0, readn()
      $)
      TEST utility_ THEN data(w) OR const(w, TRUE)
   $)
   UNLESS utility_ DO
      iilva!iptr := ptr \/ #x80000000    // Flag for string reference
$)

AND cgcode(n) BE
$( STATIC $( c_ptr = ?; c_max = ?; c_vec = ? $)

   LET s_rdch() = VALOF
   $( IF c_ptr = c_max RESULTIS endstreamch
      c_ptr := c_ptr + 1
      $( LET c = c_vec%c_ptr

         IF 'a' LE c LE 'z' THEN c := c - 'a' + 'A'

         RESULTIS c
      $)
   $)

   AND s_unrdch() BE c_ptr := c_ptr - 1

   LET v = VEC maxstrlength/bytesperword + 1
   AND word = 0
   AND save_rdch = rdch
   AND item_read = FALSE
   AND size = ?

   v%0 := n
   FOR i = 1 TO n DO
      v%i := readn()

   IF n = 6 & match(v, "CODEON") THEN
   $( plant := plantl   // Turn on code listing
      codelist_ := TRUE
      TEST code_heading_done_ THEN newline() OR code_heading()
      RETURN
   $)
   IF n = 7 & match(v, "CODEOFF") THEN
   $( plant := plantcopy   // Turn off code listing
      codelist_ := FALSE
      RETURN
   $)

   cgpendingop(r.null)
   store(0, ssp - 1)
   asf(ssp - ssf)
   clear_slaves()
   resetdr()

   c_ptr, c_max, c_vec := 0, n, v

   terminator := '*S'
   rdch := s_rdch

   $( LET radix = 10

      UNTIL terminator = '#' \/
            '0' LE terminator LE '9' \/
            terminator = '*N' \/
            terminator = endstreamch DO
         terminator := rdch()

      IF terminator = endstreamch BREAK

      IF terminator = '*N' THEN
      $( UNLESS item_read DO   // Blank line
         $( terminator := '*S'
            LOOP
         $)
         item_read := FALSE
         terminator := '*S'
         codeout(size, word)
         word := 0
         LOOP
      $)

      TEST terminator = '#' THEN
      $( radix := 8
         terminator := rdch()
         IF 'a' LE terminator LE 'z' THEN
            terminator := terminator - ('a' - 'A')
         TEST terminator = 'X' THEN radix := 16 OR
         TEST terminator = 'O' THEN radix := 8 OR
         TEST terminator = 'B' THEN radix := 2 OR
            s_unrdch()
      $) OR s_unrdch()
      IF terminator = endstreamch BREAK

      TEST item_read THEN
         word := word \/ readnumber(radix)
      OR
      $( item_read := TRUE
         size := readnumber(radix)
      $)
      IF terminator = endstreamch BREAK
   $) REPEAT

   rdch := save_rdch
   IF item_read THEN codeout(size, word)
$)

AND match(a, b) = VALOF
$( UNLESS a%0 = b%0 RESULTIS FALSE

   FOR i = 1 TO a%0 DO
   $( LET ac, bc = a%i, b%i

      IF 'a' LE ac LE 'z' THEN ac := ac - 'a' + 'A'
      IF 'a' LE bc LE 'z' THEN bc := bc - 'a' + 'A'

      UNLESS ac = bc RESULTIS FALSE
   $)
   RESULTIS TRUE
$)

AND codeout(size, word) BE IF incode_ THEN
$( IF codelist_ THEN writeaddress(codelength)

   SWITCHON size INTO
   $( CASE 2:
         IF codelist_ THEN
            writef("       HWORD*TX*'%X4*'         %X4*N", word, word)
         ohword(word)
         ENDCASE

      CASE 4:
         IF codelist_ THEN
            writef("       WORD*TX*'%X8*'     %X8*N", word, word)
         ofword(word)
         ENDCASE

      DEFAULT:
         IF codelist_ THEN newline()
         comment("invalid item size in CODE section - %N", size)
   $)
$)


AND cgentry(n, l) BE
$( LET wordlength = n/bytesperword + 1
   LET p, m, a = (utility_ -> datap, pltsize/4), 0, n
   AND name = VEC maxstrlength/bytesperword
   AND namep = 0

   IF codelist_ THEN
      writes("***N** Entry point of ")

   FOR i = 1 TO wordlength DO
   $( LET w = 0

      FOR j = 0 TO bytesperword - 1 DO
      $( (@w)%j := a
         m := m + 1
         a := (m > n) -> '*S', readn()
         UNLESS a = '*S' DO
         $( namep := namep + 1
            name%namep := a
         $)
         IF codelist_ THEN wrch(a)
      $)
      IF tracing_ \/ profiling_ THEN [utility_ -> data, findpltword](w)
   $)
   name%0 := namep
   IF monitoring_ THEN
   $( monitor("Name = '%S', length = %N*N", name, namep)
      monitor("Sectname = '%S', length = %N*N", sectname, sectname%0)
   $)
   IF sectname%0 NE 0 & match(sectname, name) THEN
   $( IF codelist_ THEN
         writes("  (Main entry for section)")

      mainentry := codelength
      IF monitoring_ THEN
         monitor("Main entry encountered, name = %S, offset = X%X8*N", name, mainentry)
   $)
   IF codelist_ THEN writes("*N***N")

   complab(l, TRUE)
   IF tracing_ \/ profiling_ THEN
   $( freereg(r.acc)
      freereg(r.b)
      plant(i.lss, v.nilf, utility_ -> (p + svsize + globsize + 1), p)
      plant(i.jlk, v.c, svtrentry)
   $)

   TEST xnbglobal NE 0 THEN
      plant(i.lxn, v.c, svsize + xnbglobal)
   OR
      IF mainprog_ THEN
         plant(i.lxn, v.c, svxnb)

   IF profiling_ DO plant_profile()
$)

AND plant_profile() BE TEST utility_ THEN
$( LET p = datap

   data(0)   // Allocate space for the profile counter

   freereg(r.b)

   plant(i.lb, v.b, 0)   // No-op (unique pattern marking profile code)
   plant(i.lb, v.c, p + svsize + globsize + 1)
   plant(i.adb, v.nil, 1)
   plant(i.stb, v.c, p + svsize + globsize + 1)
   unslave(r.b)
$)
OR
$( LET p = findpltword(0)

   freereg(r.b)

   plant(i.lb, v.b, 0)   // No-op (unique pattern marking profile code)
   set_xnb()
   plant(i.lb, v.x, p)
   plant(i.adb, v.nil, 1)
   plant(i.stb, v.x, p)
   restore_xnb()
   unslave(r.b)
$)

AND set_sf(newsf) BE
$( freereg(r.acc)
   freereg(r.b)
   clear_slaves()

   plant(i.stsf, v.b, 0)
   plant(i.stln, v.t, 0)
   plant(i.lss, v.b, 0)
   plant(i.isb, v.t, 0)
   plant(i.ush, v.nil, -2)
   plant(i.irsb, v.nil, newsf)
   plant(i.st, v.b, 0)
   plant(i.asf, v.b, 0)

   ssf := newsf
$)

AND asf(n) BE UNLESS n = 0 DO
$( plant(i.asf, v.nil, n)

   IF n < 0 THEN
      FOR i = ssf - 1 TO ssf - n - 1 DO
      $( IF slaved(r.acc, k.loc, i, 0) THEN unslave(r.acc)
         IF slaved(r.b, k.loc, i, 0) THEN unslave(r.b)
      $)

   ssf := ssf + n
$)

AND comp(f, arg) BE
$( LET v = h1!arg
   AND var = ?
   AND factor = storeop(f) -> 1, -1

   IF v = k.reg & h2!arg = r.acc THEN
      TEST f = i.lb THEN
      $( plant(i.st, v.b, 0)
         slave(r.b, acc_v, acc_a, acc_k)
         RETURN
      $)
      OR
      $( plant(i.st, v.t, 0)
         v := k.st
      $)

   IF v = k.stack & h2!arg = (ssf - 1) THEN
   $( v := k.st
      ssf := ssf + factor
   $)

   var := v = k.loc -> v.l,
          v = k.stack -> v.l,
          v = k.ctb -> v.c,
          v = k.xnb -> v.x,
          v = k.st  -> v.t,
          v = k.numb -> v.nil,
          v = k.reg & h2!arg = r.b -> v.b,
                       report("in compiler - bad variant in COMP - %N", v)

   IF v = k.xnb THEN set_xnb()
   plant(f, var, h2!arg)
   IF v = k.xnb THEN restore_xnb()
$)

AND storeop(op) = (op = i.st) \/ (op = i.stb) \/ (op = i.std) \/
                  (op = i.stln) \/ (op = i.stsf) \/ (op = i.stxn) \/ (op = i.stct)

AND plant(op, var, addr) BE
$( LET k, k., k.. = #B11, 0, 0
   AND op24 = op >> 24

   UNLESS incode_ RETURN

   IF var = v.lab \/ var = v.mlab THEN   // Branch, or label placement
   $( TEST op = i.lab THEN complabx(addr, var) OR branchx(op, addr, var)
      RETURN
   $)

   IF var = v.null THEN var := v.nil
   IF (#x80 LE op24 LE #xb6) & ((op24 & #xf) LE 6) THEN   // Secondary format
   $( UNLESS var = v.nil DO
         report("in compiler - illegal variant for secondary format opcode - %N*N", var)

      TEST (addr & #x00800000) = 0 THEN   // 16 bit form
         ohword((op >> 16) \/ addr)
      OR                                  // 32 bit form
         ofword(op \/ (addr & #x01ffffff))
      RETURN
   $)

   IF (op & #xf0000000) = 0 THEN   // Tertiary format
   $( UNLESS var = v.nil DO
         report("in compiler - illegal variant for tertiary format opcode - %N*N", var)
      ofword(op \/ (addr & #x3ffff))
      RETURN
   $)

   SWITCHON var INTO
   $( CASE v.l:
         k., k.. := 0, 2
         IF usmall(addr) THEN k := #B01
         ENDCASE

      CASE v.nil:
         IF (op = i.j \/ op = i.jlk) & (addr GE 0) THEN ENDCASE   // Forward jumps must not be shortened
         IF (op = i.exit & usmall(addr)) \/ small(addr) THEN
                                                    // Short form of literal
         $( k := #B00
            addr := addr & #x7f
            ENDCASE
         $)
         IF medium(addr) THEN                       // Long form of literal
         $( addr := addr & #x3ffff
            ENDCASE
         $)
         $( LET n = const(addr, FALSE)              // Get appropriate IIL
            LET chain = iilva!n
            iilva!n := codelength/2                 // Add to chain
            plantcopy(op, v.p, chain)
            RETURN
         $)

      CASE v.nilf:   // Guaranteed 18-bit literal
         UNLESS medium(addr) DO
            report("in compiler - 18-bit literal too big")
         addr := addr & #x3ffff
         ENDCASE

      CASE v.t:
         k., k.. := 0, 6
         ENDCASE

      CASE v.b:
         k., k.. := 0, 7
         ENDCASE

      CASE v.d:
         k., k.. := 1, 0
         IF addr = 0 THEN k., k.. := 2, 7
         UNLESS medium(addr) DO
         $( LET n = const(addr, FALSE)
            LET chain = iilva!n
            iilva!n := codelength/2
            plantcopy(op, v.dp, chain)
            RETURN
         $)
         addr := addr & (small(addr) -> #x7f, #x3ffff)
         ENDCASE

      CASE v.md:
         k., k.. := 3, 7
         ENDCASE

      CASE v.x:
         k., k.. := 0, 3
         ENDCASE

      CASE v.ix:
         k., k.. := 2, 3
         ENDCASE

      CASE v.p:
         k., k.. := 0, 4
         ENDCASE

      CASE v.c:
         k., k.. := 0, 5
         ENDCASE

      CASE v.dt:
         k., k.. := 1, 6
         ENDCASE

      CASE v.dl:
         k., k.. := 1, 2
         ENDCASE

      CASE v.dc:
         k., k.. := 1, 5
         ENDCASE

      CASE v.dx:
         k., k.. := 1, 3
         ENDCASE

      CASE v.dp:
         k., k.. := 1, 4
         ENDCASE

      CASE v.mic:
         k., k.. := 3, 5
         ENDCASE

      CASE v.ic:
         k., k.. := 2, 5
         ENDCASE

      DEFAULT:
         report("in compiler - illegal variant in PLANT - %N", var)
   $)

   UNLESS k = #B11 DO
   $( ohword((op >> 16) \/ (k << 7) \/ addr)
      RETURN
   $)

   IF (k.. = 6) \/ (k.. = 7) DO
   $( ohword((op >> 16) \/ (k << 7) \/ (k. << 5) \/ (k.. << 2))
      RETURN
   $)

   ofword(op \/ (k << 23) \/ (k. << 21) \/ (k.. << 18) \/ addr)
$)

AND small(addr) = -64 LE addr LE 63

AND usmall(addr) = 0 LE addr LE 127

AND medium(addr) = -131072 LE addr LE 131071

AND const(value, new_) = VALOF
/*  Allocate  a  32-bit constant and return its offset in the IIL table.
If 'new_' is TRUE, do not attempt to re-use a  value  that  has  already
been allocated. */
$( UNLESS new_ DO
      FOR i = 0 TO iilp - 1 DO   // See if value allocated already
         IF iilv!i = value RESULTIS i

   // New IIL is to be allocated

   codemax := codemax - 2     // Steal space from code area
   IF codemax*4 LE codelength THEN
      report("out of space for code and IILs (use WORKSIZE parameter to increase)")

   // Move base of IIL values down by 2 words

   iilv := iilv - 2
   FOR i = 0 TO iilp - 1 DO
      iilv!i := iilv!(i + 2)

   // Move base of IIL chain pointers down by 1 word

   iilva := iilva - 1
   FOR i = 0 TO iilp - 1 DO
      iilva!i := iilva!(i + 1)

   iilv!iilp, iilva!iilp := value, 0
   iilp := iilp + 1
   RESULTIS iilp - 1
$)

AND ofword(w) BE
/* Output the full word 'w' to the code area.  */
$( ohword(w >> 16)
   ohword(w)
$)

AND ohword(hw) BE
/* Output the halfword 'hw' to the code area.  */
$( codev%codelength := hw >> 8
   codev%(codelength + 1) := hw
   codelength := codelength + 2
   IF codelength GE codemax*4 DO
      report("out of space for code and IILs (use WORKSIZE parameter to increase)")
$)

AND complab(l, routine_entry) BE compl(l, routine_entry, v.lab)

AND mcomplab(l) BE compl(l, FALSE, v.mlab)

AND compl(l, routine_entry, v) BE
$( cgpendingop(r.null)
   store(0, ssp - 1)
   asf(ssp - ssf)
   IF v = v.lab THEN resetdr()
   incode_ := TRUE
   clear_slaves()
   IF monitoring_ THEN
      monitor("In compl; l=%N, re=%N, v=%N*N", l, routine_entry, v)
   plant(i.lab, v, l)
   UNLESS routine_entry \/ v = v.mlab DO
   $( IF goto_destination(l) THEN set_sf(ssp)
      IF profiling_ THEN plant_profile()
   $)
$)

AND complabx(l, v) BE
$( LET lvec = v = v.lab -> labv, mlabv

   IF monitoring_ THEN monitor("In complabx - l=%N, v=%N*N", l, v)

   IF l GE (v = v.lab -> max.labels, maxswitchlabels) THEN
      report("too many *'labels*' in program")

   IF monitoring_ THEN monitor("complabx - lvec!%N=%X8*N", l, lvec!l)

   IF lvec!l < 0 THEN   // Forward references exist to this label
   $( LET addr = codelength/2          // Address of label, in halfwords
      AND chain = -lvec!l              // Top of fixup chain for this label (byte offset in CODEV)

      IF monitoring_ THEN
         monitor("complabx - forward refs - addr=%X8, chain=%X8*N", addr, chain)
      UNTIL chain = 0 DO
      $( LET offset = addr - chain/2   // Offset in halfwords
         AND disp = chain              // Displacement (in bytes) of instruction in CODEV
         LET instruction = getword(codev, disp)

         putword(codev, disp, (instruction & #xfffc0000) \/ offset)
         chain := instruction & #x3ffff
      $)
   $)
   lvec!l := codelength   // Place the label
$)

AND goto_destination(lab) = VALOF
$( FOR i = 0 TO labkp - 1 DO
   $( LET item = labk!i
      LET lab_name = slabv!item
      IF lab_name = lab RESULTIS TRUE   // If label is GOTO destination, SF must be reset
   $)
   RESULTIS FALSE
$)

AND branch(op, lab) BE
$( resetdr()
   plant(op, v.lab, lab)
$)

AND mbranch(op, lab) BE plant(op, v.mlab, lab)

AND branchx(op, lab, v) BE
$( LET lvec = v = v.lab -> labv, mlabv

   IF lab GE (v = v.lab -> max.labels, maxswitchlabels) THEN
      report("too many *'labels*' in program")

   IF monitoring_ THEN monitor("branchx - op=%X2, l=%N, v=%N*N", op>>24, lab, v)

   TEST lvec!lab > 0 THEN   // Label already set
   $( LET offset = (lvec!lab - codelength)/2

      TEST op = i.jx THEN
         plantcopy(i.j, v.nilf, offset)
      OR
         plantcopy(op, v.nil, offset)
   $)
   OR
   $( IF op = i.jx THEN op := i.j
      IF monitoring_ THEN monitor("branchx - label not yet set codelength=%X8*N", codelength)
      TEST lvec!lab = 0 THEN   // First use of label
      $( lvec!lab := -codelength
         plantcopy(op, v.nil, 0)   // Zero is end of chain
         IF monitoring_ THEN monitor("branchx - first use of label %N*N", lab)
      $)
      OR
      $( LET p = codelength
         plantcopy(op, v.nil, -lvec!lab)   // Add to chain
         lvec!lab := -p                // New end of chain
      $)
   $)
$)

AND cgbranch(b, l) BE
$( LET f = ?
   AND rand1, rand2 = arg1, arg2
   AND r = ?

   SWITCHON pendingop INTO
   $( DEFAULT:        cgpendingop(r.null)
                      store(0, ssp - 2)
                      resetdr()   // Do this here to avoid corrupting CC later
                      r := movetoanyr(arg1)
                      f := b -> i.jne, i.je
                      f := [r = r.acc -> accop, bop](f)
                      stack(ssp - 1)
                      branch(f, l)
                      RETURN

      CASE s.ne:      b := NOT b
      CASE s.eq:      f := b -> i.je, i.jne
                      ENDCASE

      CASE s.ls:      b := NOT b
      CASE s.ge:      f := b -> i.jge, i.jl
                      ENDCASE

      CASE s.le:      b := NOT b
      CASE s.gr:      f := b -> i.jg, i.jle
                      ENDCASE
   $)
   store(0, ssp - 3)

   IF (h1!rand2 = k.numb) \/ (h1!rand1 = k.stack = h1!rand2)  \/ (regusedby(rand1) = r.acc) THEN
   $( rand1, rand2 := arg2, arg1
      f := invop(f)
   $)

   r := movetoanyr(rand2)

   resetdr()   // Do this here to avoid corrupting CC later

   TEST numberis(0, rand1) THEN
      f := [r = r.acc -> accop, bop](f)
   OR
      comp(r = r.acc -> i.icp, i.cpb, rand1)

   stack(ssp - 2)
   branch(f, l)
$)

 .

GET "BCPLQ_BCPLQHDR"


STATIC $( defaultlabel = ? $)

STATIC $( caselv = ?; caseuv = ?; casel = ?; mlabno = ? $)

LET cgswitch() BE
$( LET clv = VEC maxswitchlabels
   AND cuv = VEC maxswitchlabels
   AND clab = VEC maxswitchlabels
   AND mlv = VEC maxswitchlabels
   AND n = readn()   // Number of CASEs

   resetdr()

   mlabv := mlv

   IF n > maxswitchlabels THEN
      report("too many CASEs in a SWITCHON")

   FOR i = 0 TO maxswitchlabels DO
      mlv!i := 0

   mlabno := 0

   defaultlabel := readl()

   cgpendingop(r.acc)
   store(0, ssp - 2)
   movetor(r.acc, arg1)
   stack(ssp - 1)

   FOR i = 1 TO n DO
   $( LET k = readn()
      LET l = readl()
      AND j = i - 1

      UNTIL j = 0 DO
      $( IF k GE clv!j BREAK
         clv!(j + 1), cuv!(j + 1), clab!(j + 1) := clv!j, cuv!j, clab!j
         j := j - 1
      $)
      clv!(j + 1), cuv!(j + 1), clab!(j + 1) := k, k, l
   $)

   // Merge adjoining CASEs

   FOR i = n - 1 TO 1 BY -1 DO
   $( LET pll, plu = labv!(clab!i), labv!(clab!(i + 1))

      UNLESS pll = plu LOOP   // They don't label the same code

      UNLESS (cuv!i + 1) = clv!(i + 1) LOOP   // They aren't adjacent values

      cuv!i := cuv!(i + 1)
      n := n - 1
      FOR j = i + 1 TO n DO
         clv!j, cuv!j, clab!j := clv!(j + 1), cuv!(j + 1), clab!(j + 1)
   $)

   caselv, caseuv, casel := clv, cuv, clab

   resetdr()   // Do this here to avoid corrupting CC later

   switch(1, n, FALSE, FALSE)

   switch_prefix := switch_prefix + 1
   IF switch_prefix = ('Z' + 1) THEN switch_prefix := 'a'
   IF switch_prefix = ('z' + 1) THEN switch_prefix := 'A'
$)

AND switch(b, t, lwb, upb) BE
$( LET instns, ncases = 0, t - b + 1
   AND l = caselv!b               // Lowest CASE value
   AND u = caseuv!t               // Highest CASE value
   LET range = u/2 - l/2 + 3

   FOR i = b TO t DO
      instns := instns + (caselv!i = caseuv!i -> 2, 4)

   TEST instns/2 < range THEN
   $( TEST ncases LE 5 THEN
      $( FOR i = b TO t DO
         $( TEST caselv!i = caseuv!i THEN
               reljump(i.je, caselv!i, branch, casel!i)
            OR
            $( LET lab = nextmlab()
               reljump(i.jl, caselv!i, mbranch, lab)
               reljump(i.jle, caseuv!i, branch, casel!i)
               mcomplab(lab)
            $)
         $)
         branch(i.j, defaultlabel)
      $)
      OR
      $( LET half = b + ncases/2
         AND lab = nextmlab()

         reljump(i.jg, caseuv!half, mbranch, lab)
         switch(b, half, lwb, TRUE)
         mcomplab(lab)
         switch(half + 1, t, FALSE, upb)
      $)
   $)
   OR
   $( UNLESS lwb DO
         reljump(i.jl, l, branch, defaultlabel)

      UNLESS upb DO
         reljump(i.jg, u, branch, defaultlabel)

      UNLESS l = 2 DO
        plant(i.isb, v.nil, l-2)   // Normalise

      plant(i.jlk, v.nilf, 2)
      plant(i.ush, v.nil, 2)
      plant(i.uad, v.t, 0)
      plant(i.st, v.b, 0)
      plant(i.j, v.b, 0)

      FOR i = l TO u DO
      $( TEST (b > t) \/ (caselv!b > i) THEN
            branch(i.jx, defaultlabel)
         OR
         $( branch(i.jx, casel!b)
            IF i = caseuv!b THEN b := b + 1
         $)
      $)
   $)
$)

AND nextmlab() = VALOF
$( mlabno := mlabno + 1
   RESULTIS mlabno
$)

AND reljump(op, val, r, lab) BE
$( TEST val = 0 THEN
      op := accop(op)
   OR
      plant(i.icp, v.nil, val)
   r(op, lab)
$)

AND plantl(op, var, addr) BE
$( LET codeaddr = codelength
   AND largeconst = FALSE
   AND v = var

   TEST v = v.lab \/ v = v.mlab THEN
   $( LET c = v = v.lab -> "L", VALOF $( LET s = (TABLE 0, 0)

                                         s%0 := 2   // Form a string
                                         s%1 := 'M'
                                         s%2 := switch_prefix
                                         RESULTIS s
                                      $)
      IF incode_ THEN
      $( writeaddress(codeaddr)
         TEST op = i.lab THEN    // Placement of label
            writef("%S%N*N", c, addr)
         OR                      // Branch
         $( LET length = (v = v.lab -> 15, 14)
            AND a = addr

            writef("       %S*T%S", opcode(op), c)
            writeljn(addr, length)
         $)
      $)
      plantcopy(op, var, addr)
      v := v.lab
   $)
   OR
   $( IF incode_ THEN
      $( IF var = v.null THEN var := v.nil
         plantcopy(op, var, addr)
         writeaddress(codeaddr)
         IF v = v.nil \/ v = v.d THEN
            UNLESS small(addr) \/ medium(addr) DO
            $( writef("       %S.%S*TI", opcode(op), v = v.nil -> "P", "DP")
               writeljn(const(addr, FALSE), 15)
               largeconst := TRUE
            $)

         UNLESS largeconst DO
         $( writef("       %S%S%S*T", opcode(op), v = v.nil \/ v = v.nilf \/ v = v.null -> "", ".", variant(v))
            TEST completing_variant(v) THEN
               writes("                ") OR writeljn(addr, 16)
         $)
      $)
   $)

   UNLESS (v = v.lab) & (op = i.lab) DO
   $( LET length = codelength - codeaddr
      AND instruction = getword(codev, codeaddr)

      IF length = 2 THEN instruction := instruction >> 16
      UNLESS length = 0 DO
      $( writehex(instruction, length*2)
         IF largeconst THEN
            writef("      ** IIL, value = X*'%X8*' (%N)", addr, addr)

         newline()
      $)
   $)
$)

AND writeaddress(addr) BE
   writef("      C+%X6  ", addr)

AND writeljn(n, w) BE
$( TEST (n NE 0) & ((n << 1) = 0) THEN
   $( writes("-2147483648")
      w := w - 11
   $)
   OR
   $( IF n < 0 THEN
      $( wrch('-')
         w := w - 1
         n := -n
      $)
      wlj(n, @w)
   $)
   FOR i = 1 TO w DO wrch('*S')
$)

AND wlj(n, atw) BE
$( IF n > 9 DO wlj(n/10, atw)
   wrch(n REM 10 + '0')
   !atw := !atw - 1
$)

AND opcode(op) = VALOF SWITCHON op INTO
$( CASE i.adb :  RESULTIS "ADB"
   CASE i.and :  RESULTIS "AND"
   CASE i.asf :  RESULTIS "ASF"
   CASE i.call:  RESULTIS "CALL"
   CASE i.cpb :  RESULTIS "CPB"
   CASE i.cyd :  RESULTIS "CYD"
   CASE i.exit:  RESULTIS "EXIT"
   CASE i.iad :  RESULTIS "IAD"
   CASE i.icp :  RESULTIS "ICP"
   CASE i.idv :  RESULTIS "IDV"
   CASE i.imdv:  RESULTIS "IMDV"
   CASE i.imy :  RESULTIS "IMY"
   CASE i.inca:  RESULTIS "INCA"
   CASE i.irdv:  RESULTIS "IRDV"
   CASE i.irsb:  RESULTIS "IRSB"
   CASE i.isb :  RESULTIS "ISB"
   CASE i.j   :
   CASE i.jx  :  RESULTIS "J"
   CASE i.je  :  RESULTIS "JE"
   CASE i.jg  :  RESULTIS "JG"
   CASE i.jge :  RESULTIS "JGE"
   CASE i.jl  :  RESULTIS "JL"
   CASE i.jle :  RESULTIS "JLE"
   CASE i.jlk :  RESULTIS "JLK"
   CASE i.jn  :  RESULTIS "JN"
   CASE i.jnb :  RESULTIS "JNB"
   CASE i.jne :  RESULTIS "JNE"
   CASE i.jnn :  RESULTIS "JNN"
   CASE i.jnnb:  RESULTIS "JNNB"
   CASE i.jnp :  RESULTIS "JNP"
   CASE i.jnpb:  RESULTIS "JNPB"
   CASE i.jnz :  RESULTIS "JNZ"
   CASE i.jnzb:  RESULTIS "JNZB"
   CASE i.jp  :  RESULTIS "JP"
   CASE i.jpb :  RESULTIS "JPB"
   CASE i.jz  :  RESULTIS "JZ"
   CASE i.jzb :  RESULTIS "JZB"
   CASE i.lab :  RESULTIS "LAB"
   CASE i.lb  :  RESULTIS "LB"
   CASE i.lct :  RESULTIS "LCT"
   CASE i.ld  :  RESULTIS "LD"
   CASE i.ldb :  RESULTIS "LDB"
   CASE i.ldrl:  RESULTIS "LDRL"
   CASE i.lln :  RESULTIS "LLN"
   CASE i.lsd :  RESULTIS "LSD"
   CASE i.lsq :  RESULTIS "LSQ"
   CASE i.lss :  RESULTIS "LSS"
   CASE i.lxn :  RESULTIS "LXN"
   CASE i.mv  :  RESULTIS "MV"
   CASE i.myb :  RESULTIS "MYB"
   CASE i.neq :  RESULTIS "NEQ"
   CASE i.or  :  RESULTIS "OR"
   CASE i.prcl:  RESULTIS "PRCL"
   CASE i.raln:  RESULTIS "RALN"
   CASE i.rot :  RESULTIS "ROT"
   CASE i.sbb :  RESULTIS "SBB"
   CASE i.shs :  RESULTIS "SHS"
   CASE i.sl  :  RESULTIS "SL"
   CASE i.slb :  RESULTIS "SLB"
   CASE i.slsd:  RESULTIS "SLSD"
   CASE i.slsq:  RESULTIS "SLSQ"
   CASE i.slss:  RESULTIS "SLSS"
   CASE i.st  :  RESULTIS "ST"
   CASE i.stb :  RESULTIS "STB"
   CASE i.stct:  RESULTIS "STCT"
   CASE i.std :  RESULTIS "STD"
   CASE i.stln:  RESULTIS "STLN"
   CASE i.stsf:  RESULTIS "STSF"
   CASE i.stxn:  RESULTIS "STXN"
   CASE i.uad :  RESULTIS "UAD"
   CASE i.usb :  RESULTIS "USB"
   CASE i.ush :  RESULTIS "USH"

   DEFAULT    :  report("in compiler - illegal opcode - %N", op)
$)

AND variant(v) = VALOF SWITCHON v INTO
$( CASE v.b   :  RESULTIS "B"
   CASE v.c   :  RESULTIS "C"
   CASE v.d   :  RESULTIS "D"
   CASE v.dt  :  RESULTIS "DT"
   CASE v.ix  :  RESULTIS "IX"
   CASE v.l   :  RESULTIS "L"
   CASE v.md  :  RESULTIS "MD"
   CASE v.p   :  RESULTIS "P"
   CASE v.t   :  RESULTIS "T"
   CASE v.x   :  RESULTIS "X"
   CASE v.dl  :  RESULTIS "DL"
   CASE v.dc  :  RESULTIS "DC"
   CASE v.dx  :  RESULTIS "DX"
   CASE v.dp  :  RESULTIS "DP"
   CASE v.mic :  RESULTIS "MIC"
   CASE v.ic  :  RESULTIS "IC"
   CASE v.null:
   CASE v.nilf:
   CASE v.nil :  RESULTIS ""

   DEFAULT    :  report("in compiler - illegal variant in VARIANT")
$)

AND list_iils() BE UNLESS iilp = 0 DO
$( writes("*N*N*T*TImplied in-code literals*N*N")
   writes("       Address                Value*N")

   writes("*T               Hexadecimal  Decimal*N*N")

   FOR i = 0 TO iilp - 1 DO
   $( LET value = iilv!i
      writeaddress(codelength + i*4)
      writef("I%N", i)
      writef("*T%X8    %N*N", value, value)
   $)
   newline()
$)

AND completing_variant(v) = v = v.b  \/
                            v = v.dt \/
                            v = v.md \/
                            v = v.null \/
                            v = v.t

AND code_heading() BE
$( writef("*N*T    Listing of code for module *'%S*'*N*N", modulename)
   writes("       Address        Opcode*TOperand           Code*N*N")
   code_heading_done_ := TRUE
$)

AND list_data() BE
$( writef("*N*N*T*TData area%S*N*N",
          mainprog_ \/ utility_ -> " (excluding system vector and global vector)", "")

   FOR i = 0 TO datap - 1 BY 8 DO
   $( LET max = 7

      writef("      D+%X6   ", mainprog_ \/ utility_ -> (svsize + globsize + i + 1)*4, 0)

      IF i + max GE datap THEN max := datap - i - 1

      FOR j = 0 TO max DO
         writef("%X8  ", datav!(i + j))
      FOR j = max + 1 TO 7 DO writes("          ")
      FOR j = 0 TO max DO
         wchars(datav!(i + j))
      newline()
   $)
   newline()
$)

AND wchars(w) BE
$( FOR i = 24 TO 0 BY -8 DO
   $( LET b = (w >> i) & #xff

      UNLESS '*S' LE b LE #x7e DO b := '*S'
      wrch(b)
   $)
$)

// End of file BCPLQ_BCPLQSRC

