
// File BCPLQ_BCPLQHDR

// Header file for BCPL OMF code generator for ICL 2900 under VME

// Copyright (C) R.D. Eager   University of Kent   MCMLXXXIV


GET "LIBHDR"


MANIFEST $( debugging_ = TRUE $)   // Set to TRUE during development and testing

MANIFEST $( emas_ = TRUE $)   // Set to true if code generator to run on EMAS

MANIFEST $( monitoring_ = emas_ & debugging_ & FALSE $)   // Set to enable monitoring to file

// Variables

GLOBAL $(
globsize                     : 100   // Number of globals in program
worksize                     : 101   // Size of work area (kb)
tracing_                     : 102   // Controls whether tracing code is to be generated
profiling_                   : 103   // Controls whether profiling code is to be generated
progver                      : 104   // Program 'version number' assigned by user
codelist_                    : 105   // Controls listing of code produced
ocode                        : 106   // Name of user program OCODE file
locode                       : 107   // Name of BCPL library OCODE file
procname                     : 108   // Name of program entry point (BCPL string)
modulename                   : 109   // Name of module (BCPL string)
omfname                      : 110   // Name of OMF file
omfconad                     : 111   // Connect address of OMF file (EMAS only)
supportname                  : 112   // Name of main external support procedure (BCPL string)
preludename                  : 113   // Name of external 'prelude' procedure (BCPL string)
omfroute                     : 114   // Route used for OMF output (VME only)
omfstrp                      : 114   // Stream pointer for OMF file (EMAS only)
comments                     : 115   // Number of comments to user
last_prop_entry              : 116   // Points to last entry in properties list
statsize                     : 117   // Number of words for STATICs and table items
monfile                      : 118   // Stream pointer for monitoring file (EMAS only)
omfaccess1                   : 118   // Pointer to 'access1' descriptor for OMF output file (VME only)
steering_                    : 119   // TRUE iff steering info in user OCODE file to be ignored

propv                        : 120   // Base of properties list vector
datav                        : 121   // Base of vector containing STATICs and table items
sysv                         : 122   // Base of system vector image
globv                        : 123   // Base of global vector image
labk                         : 124   // Base of vector of 'static' label pointers
labv                         : 125   // Base of vector of label addresses
pltv                         : 126   // Base of PLT image
iilv                         : 127   // Base of vector of IILs
codev                        : 128   // Base of program code image
codemax                      : 129   // Points to last word usable for code or IILs

propp                        : 130   // Points to next free word in 'propv'
datap                        : 131   // Points to next free word in 'datav'
iilp                         : 132   // Number of IILs allocated
globaln                      : 133   // Number of GLOBALs to be initialised in current segment
labkp                        : 134   // Points to next free entry in 'labk'
pltsize                      : 135   // Size of PLT, in bytes
max_iin                      : 136   // Largest iin used
ocode_conad                  : 137   // Connect address of OCODE file (EMAS only)
propsize                     : 138   // Length of properties list, in words
mapp                         : 139   // Points to next free word in 'mapv'

incode_                      : 140   // TRUE iff current point in code can be reached at runtime
ssp                          : 141   // Simulated stack pointer
ssf                          : 142   // Real value of stack front in simulation
tempv                        : 143   // Base of simulated portion of stack
pendingop                    : 144   // Pending OCODE operation
op                           : 145   // Current OCODE operation
arg1                         : 146   // Top item on simulated stack
arg2                         : 147   // Next-to-top item on simulated stack
mlabv                        : 148   // Base of vector of switch label addresses
switch_prefix                : 149   // Unique letter used in each set of switch labels
acc_v                        : 150   // \
acc_a                        : 151   //  | Slave locations for ACC
acc_k                        : 152   // /
b_v                          : 153   // \
b_a                          : 154   //  | Slave locations for B
b_k                          : 155   // /
dr_a                         : 156   // Flag giving current contents of DR
static_chain                 : 157   // Current end of STATIC name chain
iilva                        : 158   // Base of vector of IIL chain pointers
mapsize                      : 159   // Length of module map, in words
mapv                         : 160   // Base of module map vector
compiler_                    : 161   // TRUE iff called from phase 1 (EMAS only)
errorstream                  : 162   // TRUE iff a separate output stream for errors has been specified
codelength                   : 163   // Length of program, in bytes
ocode_ptr                    : 164   // Current position in OCODE file (EMAS only)
codefile                     : 165   // Stream pointer for code listing file (VME only)
real_rdch                    : 169   // Copy of entry point to library 'rdch' function (EMAS only)
code_heading_done_           : 172   // TRUE iff code listing header has been printed
sectname                     : 173   // Name of section being compiled
utility_                     : 174   // TRUE iff compiling a normal BCPL program
sum1_v                       : 175   // \
sum1_a                       : 176   //  |
sum1_k                       : 177   //  |_ Slave locations for indirection
sum2_v                       : 178   //  |
sum2_a                       : 179   //  |
sum2_k                       : 180   // /
mainprog_                    : 181   // TRUE iff compiling a "main program" (not utility)
type3_count                  : 182   // Number of type 3 entries in properties list
amode                        : 183   // Addressing mode compiled (byte or word)
mainentry                    : 184   // Offset of any main entry point (if UTILITY=NO).  Zero if none
xnbglobal                    : 185   // Global to save XNB (subroutine packages only)
pltmax                       : 186   // Current max size of PLT vector (bytes)
propmax                      : 187   // Current max size of properties list vector (bytes)
directcall_                  : 188   // TRUE iff STATIC calls to be direct ones
dlabv                        : 189   // Base of vector of STATIC 'label' numbers
first_plt_ref                : 190   // Offset of first linked item in PLT ref chain
last_plt_link                : 191   // Offset of last linked item in PLT ref chain
iin_table                    : 192   // Base of table of iins <--> PLT entries
iin_table_max                : 193   // Offset of last available slot in 'iin_table'
slabv                        : 194   // Base of vector of STATIC routine labels
$)

// Routines

GLOBAL $(
accop                        : 200
asf                          : 201
bop                          : 202
branch                       : 203
cgapply                      : 204
cgbranch                     : 205
cgcode                       : 206
cgen                         : 207
cgentry                      : 208
cggoto                       : 209
cgpendingop                  : 210
cgputbyte                    : 211
cgrv                         : 212
cgselect                     : 213
cgstring                     : 214
cgswitch                     : 215
clear_slaves                 : 216
code_heading                 : 217
comment                      : 218
comp                         : 219
complab                      : 220
const                        : 221
data                         : 222
deselectomf                  : 223
findpltentry                 : 224
findpltword                  : 225
fixup_iils                   : 226
freereg                      : 227
gencode                      : 228
getspace                     : 229
getword                      : 230
init_type3                   : 231
initstack                    : 232
invop                        : 233
ioerror                      : 234
isfree                       : 235
list_data                    : 236
list_iils                    : 237
loadlv                       : 238
loadlvp                      : 239
loadlvx                      : 240
loadt                        : 241
match                        : 242
mbranch                      : 243
mcomplab                     : 244
medium                       : 245
monitor                      : 246
movecontor                   : 247
movetoanyr                   : 248
movetor                      : 249
numberis                     : 250
other                        : 251
outputomf                    : 252
plant                        : 253
plant_profile                : 254
plantcopy                    : 255
plantl                       : 256
process_section_and_needs    : 257
putword                      : 258
readl                        : 259
readop                       : 260
regusedby                    : 261
report                       : 262
resetdr                      : 263
restore_xnb                  : 264
set_sf                       : 265
set_xnb                      : 266
slave                        : 267
slaved                       : 268
small                        : 269
stack                        : 270
store                        : 271
storei                       : 272
storein                      : 273
trans                        : 274
unslave                      : 275
writeaddress                 : 276
$)

MANIFEST $(   // Subsystem error codes (EMAS only)
e.ift   = 267   // Invalid file type
$)

// Addressing modes (selected by parameter)

MANIFEST $(
am.byte    = 0   // Byte addressing (nonstandard BCPL)
am.word    = 1   // Word addressing (standard BCPL)
$)

// Selectors for items on simulated stack

MANIFEST $(
h1    = 0                            // Type of item
h2    = 1                            // Offset of item
h3    = 2                            // SSP for item
$)

// Types of item on simulated stack and in register slaves

MANIFEST $(
k.ctb       = 0                      // Item in data segment
k.loc       = 1                      // Local variable
k.numb      = 2                      // Constant
k.reg       = 3                      // Item in a register
k.st        = 4                      // Item on top of stack
k.svctbword = 5                      // Item is word address in CTB plus a constant
k.lnb       = 6                      // Item is value in LNB plus a constant
k.stack     = 7                      // Item on stack - not local variable
k.sum       = 8                      // Item is sum of items in sum.. slaves
k.xnb       = 9                      // Item in PLT
k.xnbword   = 10                     // Item is word address in XNB plus a constant
k.none      = 11                     // Item not one of above
$)

// Types of register

MANIFEST $(
r.null   = -1                        // Pseudo-register
r.acc    = 0                         // ACC
r.b      = 1                         // B
$)

// Tunable MANIFESTs

MANIFEST $(
max.labels          = 5000           // Maximum number of compiler-generated labels
max.staticlabels    = 500            // Maximum number of static cells containing code addresses
maxswitchlabels     = 300            // Maximum number of CASE labels in a SWITCHON
svsize              = 60             // Size of system vector
tempsize            = 3              // Size of an item in simulated stack
tempvsize           = 100            // Maximum number of items on simulated stack
$)

// Offsets of items in system vector

MANIFEST $(
svinw               = 0               // Unbounded, scaled word descriptor
svtrentry           = 2               // Trace entry point
svctbword           = 3               // Word address of system vector
svacbcpl            = 5               // Address of start of program code
svinb               = 9               // Unbounded, scaled byte descriptor
svstatchain         = 14              // Head of STATIC name chain
svswsupport         = 23              // Entry to SWITCHON support code
svxnb               = 32              // Address of program's PLT
svwork              = svsize          // Workspace for compiled code and run-time support
$)

// Offsets of items in global vector

MANIFEST $(
gv.stop          =  4
$)

// IINs of objects in OMF file

MANIFEST $(
iin.plt       = 1                     // PLT area
iin.code      = 2                     // Code area
iin.data      = 3                     // Data area (system vector, GLOBALs and STATICs)
iin.proc      = 4                     // Program entry point
iin.support   = 5                     // External support procedure (if used)
iin.prelude   = 6                     // External 'prelude' procedure (if used)

iin.max       = 6                     // Largest iin used (disregarding NEEDS and EXTERNAL references)
$)

// Area properties

MANIFEST $(
props1.plt    = #x0d                  // Read, PLT, Align=1
props1.code   = #x68                  // Read, Pure, EPB
props1.data   = #x18                  // Read, Write
props2.plt    = 0
props2.code   = 0
props2.data   = 0
$)

// OCODE operations

MANIFEST $(
s.none           = 0   // Pseudo-operation
s.true           = 4
s.false          = 5
s.rv             = 8
s.fnap           = 10
s.mult           = 11
s.div            = 12
s.rem            = 13
s.plus           = 14
s.minus          = 15
s.query          = 16
s.neg            = 17
s.abs            = 19
s.eq             = 20
s.ne             = 21
s.ls             = 22
s.gr             = 23
s.le             = 24
s.ge             = 25
s.not            = 30
s.lshift         = 31
s.rshift         = 32
s.logand         = 33
s.logor          = 34
s.eqv            = 35
s.neqv           = 36
s.lp             = 40
s.lg             = 41
s.ln             = 42
s.lstr           = 43
s.ll             = 44
s.llp            = 45
s.llg            = 46
s.lll            = 47
s.needs          = 48
s.section        = 49
s.rtap           = 51
s.goto           = 52
s.finish         = 68
s.switchon       = 70
s.global         = 76
s.mc             = 77
s.sp             = 80
s.sg             = 81
s.sl             = 82
s.stind          = 83
s.slctap         = 84
s.jump           = 85
s.jt             = 86
s.jf             = 87
s.endfor         = 88
s.labx           = 89
s.lab            = 90
s.stack          = 91
s.store          = 92
s.rstack         = 93
s.entry          = 94
s.save           = 95
s.fnrn           = 96
s.rtrn           = 97
s.res            = 98
s.datalab        = 100
s.iteml          = 101
s.itemn          = 102
s.endproc        = 103
s.prcl           = 104   // 2900-specific; used to implement EXTERNALs
s.rtcall         = 105   // 2900-specific; used to implement EXTERNALs
s.fncall         = 106   // 2900-specific; used to implement EXTERNALs
s.slctst         = 107
s.labr           = 108
s.mark           = 109
s.getbyte        = 120
s.putbyte        = 121
s.end            = 130   // Pseudo-operation
$)

// Opcodes

MANIFEST $(
i.adb     = #x20000000
i.and     = #x8a000000
i.asf     = #x6e000000
i.call    = #x1e000000
i.cpb     = #x26000000
i.cyd     = #x12000000
i.exit    = #x38000000
i.iad     = #xe0000000
i.icp     = #xe6000000
i.idv     = #xaa000000
i.imdv    = #xae000000
i.imy     = #xea000000
i.inca    = #x14000000
i.irdv    = #xac000000
i.irsb    = #xe4000000
i.isb     = #xe2000000
i.j       = #x1a000000
i.jx      = #x03e00000   // Jump instruction that can't be 'shortened'
i.je      = #x03000000
i.jg      = #x02400000
i.jge     = #x03400000
i.jl      = #x02800000
i.jle     = #x03800000
i.jlk     = #x1c000000
i.jn      = #x04c00000
i.jnb     = #x05c00000
i.jne     = #x02e00000
i.jnn     = #x06c00000
i.jnnb    = #x07c00000
i.jnp     = #x06a00000
i.jnpb    = #x07a00000
i.jnz     = #x06800000
i.jnzb    = #x07800000
i.jp      = #x04a00000
i.jpb     = #x05a00000
i.jz      = #x04800000
i.jzb     = #x05800000
i.lab     = #x00000000   // Pseudo-op (normally illegal instruction)
i.lb      = #x7a000000
i.lct     = #x30000000
i.ld      = #x78000000
i.ldb     = #x76000000
i.ldrl    = #x70000000
i.lln     = #x7c000000
i.lsd     = #x64000000
i.lsq     = #x66000000
i.lss     = #x62000000
i.lxn     = #x7e000000
i.mv      = #xb2000000
i.myb     = #x2a000000
i.neq     = #x8e000000
i.or      = #x8c000000
i.prcl    = #x18000000
i.raln    = #x6c000000
i.rot     = #xca000000
i.sbb     = #x22000000
i.shs     = #xcc000000
i.sl      = #x40000000
i.slb     = #x52000000
i.slsd    = #x44000000
i.slsq    = #x46000000
i.slss    = #x42000000
i.st      = #x48000000
i.stb     = #x5a000000
i.stct    = #x36000000
i.std     = #x58000000
i.stln    = #x5c000000
i.stsf    = #x5e000000
i.stxn    = #x4c000000
i.uad     = #xc0000000
i.usb     = #xc2000000
i.ush     = #xc8000000
$)

// Opcode variants

MANIFEST $(
v.b                 = 0
v.c                 = 1
v.d                 = 2
v.dt                = 3
v.ix                = 4
v.l                 = 5
v.lab               = 6    // Pseudo-variant
v.md                = 7
v.nil               = 8    // Pseudo-variant (minimum size literal)
v.p                 = 9
v.t                 = 10
v.x                 = 11
v.dl                = 12
v.dc                = 13
v.dp                = 14
v.mlab              = 15   // Pseudo-variant
v.mic               = 16
v.ic                = 17
v.nilf              = 18   // Pseudo-variant (guaranteed 18-bit literal)
v.dx                = 19
v.null              = 20   // No operand or variant
$)

// Miscellaneous constants

MANIFEST $(
bitsperbyte         = bitsperword/bytesperword
$)

// End of file BCPLQ_BCPLQHDR

