
// File BCPLV1_SYNSRC

// BCPL compiler - phase 1 - lexical and syntax routines

// Copyright (C) R.D. Eager  University of Kent   MCMLXXXVI


GET "BCPLV1_SYNHDR"

MANIFEST $( plist_names_ = TRUE $)   // Set FALSE to save space

LET comp(v, treemax) BE
$( LET savecode = charcode
   AND tpvec = VEC treeprintmax - 1
   AND a = ?

   treeprintvec := tpvec
   FOR i = 0 TO treeprintmax - 1 DO treeprintvec!i := 0

   linecount, prline := 1, 0

   $( treep, treeq, treevec := v + treemax, v, v
      reportcount := 0

      a := formtree()

      charcode := savecode     // In case error occurred in a GET string
      IF a = 0 THEN
      $( total_reports := total_reports + reportcount
         BREAK   // In case errors cause production of a null tree
      $)

      IF reportmax < 0 THEN       // Out of space - give up
      $( total_reports := total_reports + 1
         BREAK
      $)
      advise("Tree size %N", treemax + treevec - treep)

      UNLESS reportcount GE reportmax DO
         IF treelist_ THEN
         $( writes("*NAE Tree*N")
            plist(a, 0, treeprintmax)
            newline()
         $)

      TEST reportcount = 0 THEN
      $( selectoutput(ocode)
         compileae(a)
         selectoutput(sysout)
      $)
      OR syntax_errors_ := TRUE
      advise("   Free space %N*N", treep - treevec)

      total_reports := total_reports + reportcount
   $) REPEATUNTIL sourcestream = 0
$)

AND plist(x, n, d) BE
$( LET size = 0
   AND step, i = 1, 2

   TEST x = 0 THEN
      writes("<Nil>")
   OR TEST smallnumber(x) THEN writen(x)
   OR SWITCHON h1!x INTO
   $( CASE s.number:
         writen(h2!x)
         ENDCASE

      CASE s.name:
         writes(x + 2)
         ENDCASE

      CASE s.string:
         writef("*"%S*"", x + 1)
         ENDCASE

      CASE s.seqlist:
         i := i + 2
         step := 2                      // Drop through

      CASE s.commalist:CASE s.deflist:
         size := h2!x + 2
         GOTO out

      CASE s.for:
         size := size + 2

      CASE s.cond:CASE s.fndef:CASE s.rtdef:CASE s.extdef:
      CASE s.test:CASE s.slctr:
         size := size + 1

      CASE s.section:CASE s.needs:CASE s.vecap:CASE s.byteap:CASE s.fnap:
      CASE s.mult:CASE s.div:CASE s.rem:CASE s.plus:CASE s.minus:
      CASE s.eq:CASE s.ne:CASE s.ls:CASE s.gr:CASE s.le:CASE s.ge:
      CASE s.lshift:CASE s.rshift:CASE s.logand:CASE s.logor:
      CASE s.eqv:CASE s.neqv:CASE s.comma:
      CASE s.and:CASE s.valdef:CASE s.vecdef:
      CASE s.ass:CASE s.rtap:CASE s.colon:CASE s.if:CASE s.unless:
      CASE s.while:CASE s.until:CASE s.repeatwhile:CASE s.repeatuntil:
      CASE s.switchon:CASE s.case:CASE s.let:
      CASE s.manifest:CASE s.static:CASE s.global:CASE s.external:
      CASE s.slctap:
         size := size + 1

      CASE s.valof:CASE s.lv:CASE s.rv:CASE s.neg:CASE s.not:CASE s.abs:
      CASE s.table:CASE s.goto:CASE s.resultis:CASE s.repeat:
      CASE s.default:CASE s.code:
         size := size + 1

      CASE s.loop:
      CASE s.break:CASE s.return:CASE s.finish:CASE s.endcase:
      CASE s.true:CASE s.false:CASE s.query:

      DEFAULT:
         size := size + 1

      out:
         IF n = d THEN
         $( writes("<etc>")
            ENDCASE
         $)

         TEST plist_names_ THEN
            writef("<%S>", opfn(h1!x))
         OR
            writef("<OP%N>", h1!x)

         WHILE i LE size DO
         $( newline()
            FOR j = 0 TO n - 1 DO
               writes(treeprintvec!j)

            writes("**-")
            treeprintvec!n := i = size -> "  ", "! "
            plist(h1!(x + i - 1), n + 1, d)
            i := i + step
         $)
   $)
$)

AND opfn(op) = NOT plist_names_ -> 0, VALOF SWITCHON op INTO
$( CASE s.abs:         RESULTIS "ABS"
   CASE s.and:         RESULTIS "AND"
   CASE s.ass:         RESULTIS "ASS"
   CASE s.break:       RESULTIS "BREAK"
   CASE s.byteap:      RESULTIS "BYTEAP"
   CASE s.case:        RESULTIS "CASE"
   CASE s.code:        RESULTIS "CODE"
   CASE s.colon:       RESULTIS "COLON"
   CASE s.comma:       RESULTIS "COMMA"
   CASE s.commalist:   RESULTIS "COMMALIST"
   CASE s.cond:        RESULTIS "COND"
   CASE s.default:     RESULTIS "DEFAULT"
   CASE s.deflist:     RESULTIS "DEFLIST"
   CASE s.div:         RESULTIS "DIV"
   CASE s.endcase:     RESULTIS "ENDCASE"
   CASE s.eq:          RESULTIS "EQ"
   CASE s.eqv:         RESULTIS "EQV"
   CASE s.extdef:      RESULTIS "EXTDEF"
   CASE s.external:    RESULTIS "EXTERNAL"
   CASE s.false:       RESULTIS "FALSE"
   CASE s.finish:      RESULTIS "FINISH"
   CASE s.fnap:        RESULTIS "FNAP"
   CASE s.fndef:       RESULTIS "FNDEF"
   CASE s.for:         RESULTIS "FOR"
   CASE s.ge:          RESULTIS "GE"
   CASE s.global:      RESULTIS "GLOBAL"
   CASE s.goto:        RESULTIS "GOTO"
   CASE s.gr:          RESULTIS "GR"
   CASE s.if:          RESULTIS "IF"
   CASE s.le:          RESULTIS "LE"
   CASE s.let:         RESULTIS "LET"
   CASE s.logand:      RESULTIS "LOGAND"
   CASE s.logor:       RESULTIS "LOGOR"
   CASE s.loop:        RESULTIS "LOOP"
   CASE s.ls:          RESULTIS "LS"
   CASE s.lshift:      RESULTIS "LSHIFT"
   CASE s.lv:          RESULTIS "LV"
   CASE s.manifest:    RESULTIS "MANIFEST"
   CASE s.minus:       RESULTIS "MINUS"
   CASE s.mult:        RESULTIS "MULT"
   CASE s.ne:          RESULTIS "NE"
   CASE s.needs:       RESULTIS "NEEDS"
   CASE s.neg:         RESULTIS "NEG"
   CASE s.neqv:        RESULTIS "NEQV"
   CASE s.not:         RESULTIS "NOT"
   CASE s.plus:        RESULTIS "PLUS"
   CASE s.query:       RESULTIS "QUERY"
   CASE s.rem:         RESULTIS "REM"
   CASE s.repeat:      RESULTIS "REPEAT"
   CASE s.repeatuntil: RESULTIS "REPEATUNTIL"
   CASE s.repeatwhile: RESULTIS "REPEATWHILE"
   CASE s.resultis:    RESULTIS "RESULTIS"
   CASE s.return:      RESULTIS "RETURN"
   CASE s.rshift:      RESULTIS "RSHIFT"
   CASE s.rtap:        RESULTIS "RTAP"
   CASE s.rtdef:       RESULTIS "RTDEF"
   CASE s.rv:          RESULTIS "RV"
   CASE s.section:     RESULTIS "SECTION"
   CASE s.seqlist:     RESULTIS "SEQLIST"
   CASE s.slctap:      RESULTIS "SLCTAP"
   CASE s.slctr:       RESULTIS "SLCTR"
   CASE s.static:      RESULTIS "STATIC"
   CASE s.switchon:    RESULTIS "SWITCHON"
   CASE s.table:       RESULTIS "TABLE"
   CASE s.test:        RESULTIS "TEST"
   CASE s.true:        RESULTIS "TRUE"
   CASE s.unless:      RESULTIS "UNLESS"
   CASE s.until:       RESULTIS "UNTIL"
   CASE s.valdef:      RESULTIS "VALDEF"
   CASE s.valof:       RESULTIS "VALOF"
   CASE s.vecap:       RESULTIS "VECAP"
   CASE s.vecdef:      RESULTIS "VECDEF"
   CASE s.while:       RESULTIS "WHILE"
   DEFAULT:            RESULTIS "???"
$)
  .

GET "BCPLV1_SYNHDR"

LET nextsymb() BE
$( nlpending_ := FALSE

   $( IF pptrace_ THEN wrch(ch)

      SWITCHON ch INTO

      $( CASE '*P':
         CASE '*N': linecount := linecount + 1
                    nlpending_ := TRUE  // Ignorable characters
         CASE '*T':
         CASE '*S': rch() REPEATWHILE ch = '*S'
                    LOOP

         CASE '0':CASE '1':CASE '2':CASE '3':CASE '4':
         CASE '5':CASE '6':CASE '7':CASE '8':CASE '9':
                    read_number(10)
                    RETURN

         CASE 'a':CASE 'b':CASE 'c':CASE 'd':CASE 'e':
         CASE 'f':CASE 'g':CASE 'h':CASE 'i':CASE 'j':
         CASE 'k':CASE 'l':CASE 'm':CASE 'n':CASE 'o':
         CASE 'p':CASE 'q':CASE 'r':CASE 's':CASE 't':
         CASE 'u':CASE 'v':CASE 'w':CASE 'x':CASE 'y':
         CASE 'z':
                    ch := ch - ('a' - 'A')   // Map lower case to upper case

         CASE 'A':CASE 'B':CASE 'C':CASE 'D':CASE 'E':
         CASE 'F':CASE 'G':CASE 'H':CASE 'I':CASE 'J':
         CASE 'K':CASE 'L':CASE 'M':CASE 'N':CASE 'O':
         CASE 'P':CASE 'Q':CASE 'R':CASE 'S':CASE 'T':
         CASE 'U':CASE 'V':CASE 'W':CASE 'X':CASE 'Y':
         CASE 'Z':
                    $( LET c = ch

                       rch()
                       read_tag(c)
                       symb := lookupword()
                       IF symb = s.get THEN $( pushget(); LOOP $)
                       RETURN
                    $)

         CASE '$':  multichar("()", s.lsect, s.rsect, 0)
                    IF symb = 0 THEN synreport(1)
                    read_tag('$')
                    lookupword()
                    RETURN

         CASE '{':
         CASE '}':  symb := ch = '{' -> s.lsect, s.rsect
                    rch()
                    read_tag('$')
                    lookupword()
                    RETURN

         CASE '[':
         CASE '(':  symb := s.lparen; BREAK
         CASE ']':
         CASE ')':  symb := s.rparen; BREAK

         CASE '#':  $( LET radix = 8
                       rch()
                       UNLESS '0' LE ch LE '7' DO
                       $( IF 'a' LE ch LE 'z' THEN ch := ch - ('a' - 'A')
                          SWITCHON ch INTO
                          $( DEFAULT :  synreport(13)
                             CASE 'B':  radix := 2
                             CASE 'O':  ENDCASE
                             CASE 'X':  radix := 16
                          $)
                          rch()
                       $)
                       read_number(radix)
                       RETURN
                    $)

         CASE '?':  symb := s.query; BREAK
         CASE '+':  symb := s.plus; BREAK
         CASE ',':  symb := s.comma; BREAK
         CASE ';':  symb := s.semicolon; BREAK
         CASE '@':  symb := s.lv; BREAK
         CASE '&':  symb := s.logand; BREAK
         CASE '=':  symb := s.eq; BREAK
         CASE '!':  symb := s.vecap; BREAK
         CASE '%':  symb := s.byteap; BREAK
         CASE '**': symb := s.mult; BREAK

         CASE '/':
         CASE '|':  $( LET delim = ch
                       rch()
                       IF delim = '/' & ch = '\' DO $( symb := s.logand; BREAK $)
                       IF ch = delim THEN
                       $( rch() REPEATUNTIL ch = '*N' \/ ch = endstreamch
                          LOOP
                       $)
                       UNLESS ch = '**' DO
                       $( symb := delim = '/' -> s.div, s.logor
                          RETURN
                       $)

                       rch()
                       $( TEST ch = '**' THEN
                          $( rch()
                             IF ch = delim BREAK
                             LOOP
                          $)
                          OR IF ch = '*N' THEN linecount := linecount + 1

                          IF ch = endstreamch THEN synreport(26, delim)
                          rch()
                       $) REPEAT
                       rch()
                       LOOP
                    $)

         CASE '\':  multichar("/=", s.logor, s.ne, s.not)
                    RETURN

         CASE '~':  multichar("=", s.ne, s.not)
                    RETURN

         CASE '<':  multichar("=<", s.le, s.lshift, s.ls)
                    RETURN

         CASE '>':  multichar("=>", s.ge, s.rshift, s.gr)
                    RETURN

         CASE '-':  multichar(">", s.cond, s.minus)
                    RETURN

         CASE ':':  multichar("=:", s.ass, s.slctap, s.colon)
                    RETURN

         CASE '*'': rch()
                    decval := rdstrch()
                    symb := s.number
                    UNLESS ch = '*'' DO synreport(4)
                    BREAK

         CASE '*"': $( LET i = 0

                       rch()
                       UNTIL ch = '*"' DO
                       $( IF i = maxstrlength THEN synreport(3)
                          i := i + 1
                          wordv%i := rdstrch()
                       $)
                       wordv%0 := i
                       wordsize := i/bytesperword
                       FOR j = i + 1 TO (wordsize + 1)*bytesperword - 1 DO
                          wordv%j := 0   // Pad out last word with nulls
                       symb := s.string
                       BREAK
                    $)

         DEFAULT:   TEST ch = endstreamch THEN
         CASE '.':  $( IF getp = 0 THEN
                       $( symb := s.end
                          IF ch = endstreamch THEN
                          $( endread()
                             sourcestream := 0
                          $)
                          RETURN
                       $)

                       popget()
                    $)
                    OR
                    $( LET c = ch
                       ch := '*S'
                       synreport(2, c)
                       rch()
                    $)
                    LOOP
      $)
   $) REPEAT

   rch()
$)

AND multichar(chars, a, b, c, d) BE
$( LET t = @chars
   AND step = @b - @a
   AND i, lim = 1, chars%0

   rch()
   UNTIL i > lim DO
   $( IF ch = chars%i THEN
      $( rch()
         BREAK
      $)
      i := i + 1
   $)

   symb := t!(i*step)
$)

AND read_number(radix) BE
$( LET d = value(ch)

   decval := d
   symb := s.number
   IF d GE radix THEN synreport(13)

   $( rch()
      d := value(ch)
      IF d = 63 RETURN
      IF d GE radix THEN synreport(13)
      decval := radix*decval + d
   $) REPEAT
$)

AND value(ch) = '0' LE ch LE '9' -> ch-'0',
                'A' LE ch LE 'F' -> ch - ('A'-10),
                'a' LE ch LE 'f' -> ch - ('a'-10),
                63

AND rdstrch() = VALOF
$( LET k = ch

   rch()

   IF k = '*N' THEN synreport(14)

   IF k = '**' THEN
   $( IF ch = '*N' \/ ch = '*S' \/ ch = '*T' THEN
      $( $( IF ch = '*N' THEN linecount := linecount + 1
            rch()
         $) REPEATWHILE ch = '*N' \/ ch = '*S' \/ ch = '*T'
         UNLESS ch = '**' DO synreport(14)
         rch()
         LOOP
      $)

      k := ch
      IF 'a' LE ch LE 'z' THEN ch := ch - ('a' - 'A')

      IF ch = 'T' THEN k := '*T'
      IF ch = 'S' THEN k := '*S'
      IF ch = 'N' THEN k := '*N'
      IF ch = 'L' THEN k := '*L'
      IF ch = 'B' THEN k := '*B'
      IF ch = 'C' THEN k := '*C'
      IF ch = 'P' THEN k := '*P'

      TEST ch = 'X' \/ ch = 'O' \/ ('0' LE ch LE '7') THEN
      $( LET r, n = 8, 3

         TEST ch = 'X' THEN
         $( r, n := 16, 2
            rch()
         $)
         OR IF ch = 'O' THEN rch()
         k := read_octal_or_hex(r, n)
         IF k > 255 THEN synreport(14)
         RESULTIS k   // Don't translate *Xnn or *nnn
      $)
      OR rch()
   $)

   RESULTIS charcode(k)
$) REPEAT

AND read_octal_or_hex(radix, digits) = VALOF
$( LET answer = 0

   FOR i = 1 TO digits DO
   $( LET valch = value(ch)

      IF valch >= radix THEN synreport(14)
      answer := answer*radix + valch
      rch()
   $)

   RESULTIS answer
$)

 .

GET "BCPLV1_SYNHDR"

STATIC $( codep = ? $)

LET declsyswords() BE
$( codep := TABLE
      s.abs,s.and,
      s.be,s.break,s.by,
      s.case,
      s.default,s.do,
      s.or,s.endcase,s.eq,s.eqv,s.external,
      s.false,s.finish,s.for,
      s.ge,s.get,s.global,s.goto,s.gr,
      s.if,s.into,
      s.le,s.let,s.logand,s.logor,s.loop,s.ls,s.lshift,s.lv,
      s.manifest,
      s.ne,s.needs,s.neqv,s.not,
      s.slctap,s.or,
      s.rem,s.repeat,s.repeatuntil,s.repeatwhile,s.resultis,s.return,s.rshift,s.vecap,
      s.section,s.slctr,s.static,s.switchon,
      s.table,s.test,s.do,s.to,s.true,
      s.unless,s.until,
      s.valof,s.vec,
      s.while,
      s.name,
      s.code

      d("ABS/AND/*
        *BE/BREAK/BY/*
        *CASE/*
        *DEFAULT/DO/*
        *ELSE/ENDCASE/EQ/EQV/EXTERNAL/*
        *FALSE/FINISH/FOR/*
        *GE/GET/GLOBAL/GOTO/GR/*
        *IF/INTO/*
        *LE/LET/LOGAND/LOGOR/LOOP/LS/LSHIFT/LV/*
        *MANIFEST/*
        *NE/NEEDS/NEQV/NOT/*
        *OF/OR//")

      d("REM/REPEAT/REPEATUNTIL/REPEATWHILE/RESULTIS/RETURN/RSHIFT/RV/*
        *SECTION/SLCT/STATIC/SWITCHON/*
        *TABLE/TEST/THEN/TO/TRUE/*
        *UNLESS/UNTIL/*
        *VALOF/VEC/*
        *WHILE//")

      d("$//"); nulltag := wordnode

      IF enablecode_ THEN d("CODE//")
$)

AND d(words) BE
$( LET i, length = 1, 0

   $( LET c = words%i

      TEST c = '/' THEN
      $( IF length = 0 RETURN   // End of list
         wordv%0 := length
         wordsize := length/bytesperword
         FOR j = length + 1 TO (wordsize + 1)*bytesperword - 1 DO
            wordv%j := 0   // Pad with nulls
         lookupword()
         h1!wordnode := !codep
         codep := codep + 1
         length := 0
      $)
      OR
      $( length := length + 1
         wordv%length := c
      $)

      i := i + 1
   $) REPEAT
$)

AND lookupword() = VALOF
$( LET hashval = (wordv!0+wordv!wordsize >> 1) REM nametablesize
   AND i = 0

   wordnode := nametable!hashval

   UNTIL wordnode = 0 \/ i > wordsize DO
      TEST wordnode!(i+2) = wordv!i THEN
         i := i + 1
      OR
         wordnode, i := h2!wordnode, 0

   IF wordnode = 0 THEN
   $( wordnode := newvec(wordsize + 3)
      h1!wordnode, h2!wordnode := s.name, nametable!hashval
      FOR i = 0 TO wordsize DO wordnode!(i + 2) := wordv!i
      nametable!hashval := wordnode
   $)

   RESULTIS h1!wordnode
$)

 .

GET "BCPLV1_SYNHDR"

LET rch() BE
$( ch := rdch()

   IF prsource_ & (getp = 0 \/ list_gets_) & (ch NE endstreamch) THEN
   $( UNLESS linecount = prline DO
      $( writef(getp = 0 -> "%$  %I5  ", "%N.%I5  ", getp/getitemsize, linecount)
         prline := linecount
      $)
      wrch(ch)
   $)

   chcount := chcount + 1
   chbuf!(chcount & (chbufsize-1)) := ch
$)

AND wrchbuf() BE
$( writes("...")
   FOR p = chcount - chbufsize + 1 TO chcount DO
   $( LET k = chbuf!(p & (chbufsize-1))
      UNLESS k LE 0 DO wrch(k)
   $)
   newline()
$)

AND read_tag(char) BE
$( LET charp = 1

   wordv%1 := char

   $( TEST 'a' LE ch LE 'z' THEN
         ch := ch - ('a' - 'A')   // Map lower case to upper case
      OR
      $( UNLESS 'A' LE ch LE 'Z' \/
                '0' LE ch LE '9' \/
                ch = '_' \/
                ch = '.' BREAK
      $)

      charp := charp + 1
      wordv%charp := ch
      rch()
   $) REPEAT

   wordv%0 := charp
   wordsize := charp/bytesperword
   FOR i = charp + 1 TO (wordsize + 1)*bytesperword - 1 DO
      wordv%i := 0   // Pad last word with nulls
$)

 .

GET "BCPLV1_SYNHDR"

STATIC $( hold_synreport = 0 $)

LET newvec(n) = VALOF
$( treep := treep - n
   IF treep LE treeq THEN
   $( reportmax := -1
      synreport(6)
   $)
   RESULTIS treep
$)

AND list1(x) = VALOF
$( LET p = newvec(1)
   p!0 := x
   RESULTIS p
$)

AND list2(x, y) = VALOF
$( LET p = newvec(2)
   p!0, p!1 := x, y
   RESULTIS p
$)

AND list3(x, y, z) = VALOF
$( LET p = newvec(3)
   p!0, p!1, p!2 := x, y, z
   RESULTIS p
$)

AND list4(x, y, z, t) = VALOF
$( LET p = newvec(4)
   p!0, p!1, p!2, p!3 := x, y, z, t
   RESULTIS p
$)

AND list5(x, y, z, t, u) = VALOF
$( LET p = newvec(5)
   p!0, p!1, p!2, p!3, p!4 := x, y, z, t, u
   RESULTIS p
$)

AND list6(x, y, z, t, u, v) = VALOF
$( list4(z, t, u, v)
   RESULTIS list2(x, y)
$)

AND makelist(k, n) = VALOF
$( LET q = treeq + n

   IF treep - treeq < 2 THEN
   $( reportmax := -1
      synreport(6)
   $)

   UNTIL q = treeq DO
   $( q, treep := q - 1, treep - 1
      !treep := !q
   $)
   treep := treep - 2
   h1!treep, h2!treep := k, n
   RESULTIS treep
$)

AND synreport(n, a) BE
$( report(synmessage(n), a, linecount, syninfo)

   IF n = 2 \/ n = 27 RETURN   // No recovery necessary after illegal characters
   nlpending_ := FALSE

   UNTIL symb = s.lsect \/ symb = s.rsect \/
         symb = s.let \/ symb = s.and \/
         symb = s.end \/ nlpending_ DO nextsymb()
   longjump(rec_p, rec_l)
$)

AND syninfo() BE
$( wrchbuf()
   newline()
$)

AND formtree() =  VALOF
$( LET gv = VEC getsize*getitemsize - 1
   AND wv = VEC maxstrlength/bytesperword
   AND nv = VEC nametablesize - 1
   AND cb = VEC chbufsize - 1

   getv, getp, gett := gv, 0, getsize*getitemsize - 1

   wordv := wv

   nametable := nv
   FOR i = 0 TO nametablesize - 1 DO nametable!i := 0

   chbuf, chcount := cb, 0
   FOR i = 0 TO chbufsize - 1 DO chbuf!i := 0

   rec_p, rec_l := level(), l

   abort_p, abort_l := rec_p, ftabort

   rch()

   IF ch = endstreamch RESULTIS 0

   // Ensure that compiler is restartable without reloading

   TEST hold_synreport = 0 THEN
      hold_synreport := synreport
   OR
      synreport := hold_synreport

   querynode, zeronode := list1(s.query), list2(s.number, 0)

   declsyswords()

l:
   $( $( nextsymb()

         IF ppdebug_ THEN   //   PP debugging option
         $( writef("%N %S*N", symb, wordv) 
            IF symb = s.end THEN RESULTIS 0
            GOTO l
         $)

         $( LET rsprog(n) = VALOF
            $( LET a = ?
               AND savecharcode = charcode

               charcode := host_code
               nextsymb()
               charcode := savecharcode
               UNLESS symb = s.string DO synreport(5)
               a := rbexp()
               RESULTIS list3(n, a, rprog())
            $)
            AND rprog() = symb = s.needs -> rsprog(s.needs), read_block_body()

            LET a = symb = s.section -> rsprog(s.section), rprog()
            IF symb = s.end RESULTIS a
            synreport(7)
         $)
      $) REPEAT

   ftabort:
      IF reportmax < 0 RESULTIS 1  // Run out of space - give up
      $( LET savep, saver = prsource_, synreport
         AND null() BE RETURN
         prsource_, synreport := FALSE, null
         UNTIL symb = s.end DO nextsymb()
         prsource_, synreport := savep, saver
         RESULTIS 1     // Dummy non-zero value
      $)
   $)
$)

AND synmessage(n) = VALOF SWITCHON n INTO
   $( DEFAULT: selectoutput(journal)
               writef("*N** Compiler error %N; ", n)
               writes("please notify software staff*N")
               writef("Error is near line %N*N", linecount)
               stop(1002)

      CASE 01: RESULTIS "*'(*' or *')*' expected after *'$*'"
      CASE 02: RESULTIS "Illegal character - X%X2 -"
      CASE 03: RESULTIS "String too long"
      CASE 04: RESULTIS "Missing *' in character constant"
      CASE 05: RESULTIS "String expected"
      CASE 06: RESULTIS "Compiler workspace exhausted (use L flag to increase)"
      CASE 07: RESULTIS "Incorrect termination"
      CASE 08: RESULTIS "Name expected"
      CASE 09: RESULTIS "Untagged *'$)*' or *'}*' mismatch"
      CASE 10: RESULTIS "*'$(*' or *'{*' expected"
      CASE 11: RESULTIS "*'$)*' or *'}*' expected"
      CASE 12: RESULTIS "Invalid expression"
      CASE 13: RESULTIS "Error in number"
      CASE 14: RESULTIS "Error in string or character constant"
      CASE 15: RESULTIS "*')*' missing"
      CASE 16: RESULTIS "*',*' missing"
      CASE 17: RESULTIS "*'=*' or *'BE*' expected"
      CASE 18: RESULTIS "*'=*' or *'(*' expected"
      CASE 19: RESULTIS "Unexpected *':*'"
      CASE 20: RESULTIS "Invalid command"
      CASE 21: RESULTIS "*'OR*' or *'ELSE*' expected"
      CASE 22: RESULTIS "*'=*' expected"
      CASE 23: RESULTIS "*'TO*' expected"
      CASE 24: RESULTIS "*'INTO*' expected"
      CASE 25: RESULTIS "*':*' expected"
      CASE 26: RESULTIS "*'**%C*' missing"
      CASE 27: RESULTIS "Use of character *'%C*' - not in 1900 character set - "
   $)

 .

GET "BCPLV1_SYNHDR"

LET read_block_body() = VALOF
$( LET p, l = rec_p, rec_l
   AND a, lc = 0, ?
   LET ptr = @a

   $( LET op = ?

      rec_p, rec_l := level(), recover

      ignore(s.semicolon)
      lc := linecount

      SWITCHON symb INTO
      $( CASE s.manifest: CASE s.static: CASE s.global: CASE s.external:
            op := symb
            nextsymb()
            !ptr := rdsect(op = s.external -> rdextdefs, rdcdefs, op = s.global -> s.colon, s.eq)
            ENDCASE

         CASE s.let:
            nextsymb()
            !ptr := rdef()

         recover:
            $( LET qtr = ptr

               WHILE symb = s.and DO
               $( nextsymb()
                  $( LET lc2 = linecount

                     !qtr := list4(s.and, !qtr, rdef(), lc2)
                     qtr := @h3!(!qtr)
                   $)
               $)
            $)
            op := s.let
            ENDCASE

         DEFAULT:
            !ptr := rdseq()

         CASE s.rsect: CASE s.end:
            BREAK
      $)
      !ptr := list4(op, !ptr, 0, lc)
      ptr := @h3!(!ptr)
   $) REPEAT

   rec_p, rec_l := p, l
   RESULTIS a
$)

AND rdseq() = VALOF
$( LET q, n = treeq, 0

   $( ignore(s.semicolon)
      treeq!1 := rcom()
      treeq!0 := linecount
      treeq, n := treeq + 2, n + 2
   $) REPEATUNTIL symb = s.rsect \/ symb = s.end
   treeq := q

   RESULTIS makelist(s.seqlist, n)
$)

AND rdcdefs(sep) = VALOF
$( LET q, n = treeq, 0
   AND p, l = rec_p, rec_l

   rec_p, rec_l := level(), recover

   $( treeq!0 := rname()
      UNLESS symb = sep DO synreport(sep = s.colon -> 25, 22)
      nextsymb()
      treeq!1 := rexp(0)
      treeq, n := treeq + 2, n + 2

   recover:
      ignore(s.semicolon)
   $) REPEATWHILE symb = s.name

   rec_p, rec_l := p, l
   treeq := q

   RESULTIS makelist(s.deflist, n)
$)

AND rdextdefs() = VALOF
$( LET q, n = treeq, 0
   AND p, l = rec_p, rec_l

   rec_p, rec_l := level(), recover

   $( treeq!0 := rname()
      treeq!1 := treeq!0
      IF symb = s.colon THEN
      $( LET savecharcode = charcode

         charcode := host_code
         nextsymb()
         charcode := savecharcode
         UNLESS symb = s.string DO synreport(5)
         $( LET c = newvec(wordsize + 2)
            h1!c := s.string
            FOR i = 0 TO wordsize DO c!(i + 1) := wordv!i
            nextsymb()
            treeq!1 := c
         $)
      $)
      treeq, n := treeq + 2, n + 2

   recover:
      ignore(s.semicolon)
   $) REPEATWHILE symb = s.name

   rec_p, rec_l := p, l
   treeq := q

   RESULTIS makelist(s.deflist, n)
$)

AND rdsect(r, sep) = VALOF
$( LET tag, a = wordnode, 0

   checkfor(s.lsect, 10)
   a := r(sep)
   UNLESS symb = s.rsect DO
   $( synreport(11)
      UNTIL symb = s.rsect \/ symb = s.end DO nextsymb()
   $)
   TEST tag = wordnode THEN nextsymb()
   OR
     IF wordnode = nulltag THEN
      $( symb := 0
         synreport(9)
      $)

   RESULTIS a
$)

AND rnamelist() = VALOF
$( LET q, n = treeq, 0

   $( treeq!0 := rname()
      treeq, n := treeq + 1, n + 1
      UNLESS symb = s.comma BREAK
      nextsymb()
   $) REPEAT

   treeq := q
   IF n = 1 RESULTIS q!0
   IF n = 2 RESULTIS list3(s.comma, q!0, q!1)

   RESULTIS makelist(s.commalist, n)
$)

AND rname() = VALOF
$( LET a = wordnode

   checkfor(s.name, 8)
   RESULTIS a
$)

AND ignore(item) BE IF symb = item THEN nextsymb()

AND checkfor(item, n) BE
$( UNLESS symb = item DO synreport(n)
   nextsymb()
$)

 .

GET "BCPLV1_SYNHDR"

LET rbexp() = VALOF
$( LET a, op = ?, symb

   SWITCHON symb INTO
   $( DEFAULT:
         synreport(12)

      CASE s.query:
         nextsymb()
         RESULTIS querynode

      CASE s.true:
      CASE s.false:
      CASE s.name:
         a := wordnode
         nextsymb()
         RESULTIS a

      CASE s.slctr:
         a := list4(s.slctr, rnexp(0), 0, 0)
         IF symb = s.colon THEN
         $( h3!a := rnexp(0)
            IF symb = s.colon THEN h4!a := rnexp(0)
         $)
         RESULTIS a

      CASE s.string:
         a := newvec(wordsize+2)
         h1!a := s.string
         FOR i = 0 TO wordsize DO a!(i+1) := wordv!i
         nextsymb()
         RESULTIS a

      CASE s.number:
         a := decval = 0 -> zeronode,
              smallnumber(decval) -> decval,
              list2(s.number, decval)
         nextsymb()
         RESULTIS a

      CASE s.lparen:
         a := rnexp(0)
         checkfor(s.rparen, 15)
         RESULTIS a

      CASE s.valof:
         nextsymb()
         RESULTIS list2(s.valof, rcom())

      CASE s.vecap:
         op := s.rv

      CASE s.lv:
      CASE s.rv:
         RESULTIS list2(op, rnexp(35))

      CASE s.plus:
         RESULTIS rnexp(34)

      CASE s.minus:
         a := rnexp(34)
         IF smallnumber(a) RESULTIS list2(s.number, -a)
         TEST h1!a = s.number THEN h2!a := -(h2!a)
         OR a := list2(s.neg, a)
         RESULTIS a

      CASE s.abs:
         RESULTIS list2(op, rnexp(34))

      CASE s.not:
         RESULTIS list2(op, rnexp(24))

      CASE s.table:
         nextsymb()
         RESULTIS list2(s.table, rexplist())
   $)
$)

AND rnexp(n) = VALOF
$( nextsymb()
   RESULTIS rexp(n)
$)

AND rexp(n) = VALOF
$( LET a = rbexp()
   AND b, p = 0, 0

   $( LET op, q = symb, 0

      IF nlpending_ RESULTIS a

      SWITCHON op INTO
      $( DEFAULT:
            RESULTIS a

         CASE s.lparen:
            nextsymb()
            b := symb = s.rparen -> 0, rexplist()
            checkfor(s.rparen, 15)
            a := list3(s.fnap, a, b)
            LOOP

         CASE s.slctap:
         CASE s.vecap:
            p := 40
            ENDCASE

         CASE s.byteap:
            p := 38
            ENDCASE

         CASE s.rem:CASE s.mult:CASE s.div:
            p := 35
            ENDCASE

         CASE s.plus:CASE s.minus:
            p := 34
            ENDCASE

         CASE s.eq:CASE s.ne:CASE s.le:CASE s.ge:CASE s.ls:CASE s.gr:
            IF n >= 30 RESULTIS a

            $( LET c = 0

               $( b := rnexp(30)
                  a := list3(op, a, b)
                  c := c = 0 -> a, list3(s.logand, c, a)
                  a, op := b, symb
               $) REPEATWHILE s.eq LE op LE s.ge

               a := c
            $)
            LOOP

         CASE s.lshift:CASE s.rshift:
            p, q := 25, 30
            ENDCASE

         CASE s.logand:
            p := 23
            ENDCASE

         CASE s.logor:
            p := 22
            ENDCASE

         CASE s.eqv:CASE s.neqv:
            p := 21
            ENDCASE

         CASE s.cond:
            IF n >= 13 RESULTIS a
            b := rnexp(0)
            checkfor(s.comma, 16)
            a := list4(s.cond, a, b, rexp(0))
            LOOP
      $)

      IF n >= p RESULTIS a
      a := list3(op, a, rnexp(q = 0 -> p, q))
   $) REPEAT
$)

AND rexplist() = VALOF
$( LET q, n = treeq, 0

   $( treeq!0 := rexp(0)
      treeq, n := treeq + 1, n + 1
      UNLESS symb = s.comma BREAK
      nextsymb()
   $) REPEAT

   treeq := q
   IF n = 1 RESULTIS q!0
   IF n = 2 RESULTIS list3(s.comma, q!0, q!1)

   RESULTIS makelist(s.commalist, n)
$)

 .

GET "BCPLV1_SYNHDR"

LET rdef() = VALOF
$( LET n = rnamelist()

   SWITCHON symb INTO
   $( CASE s.lparen:
      $( LET a = 0

         nextsymb()
         UNLESS h1!n = s.name DO synreport(8)
         IF symb = s.name DO a := rnamelist()
         checkfor(s.rparen, 15)

         IF symb = s.be THEN
         $( nextsymb()
            RESULTIS list5(s.rtdef, n, a, rcom(), 0)
         $)

         IF symb = s.eq RESULTIS list5(s.fndef, n, a, rnexp(0), 0)

         synreport(17)
      $)

      DEFAULT:
         synreport(18)

      CASE s.eq:
         nextsymb()
         IF symb = s.vec THEN
         $( nextsymb()
            UNLESS h1!n = s.name DO synreport(8)
            RESULTIS list3(s.vecdef, n, rexp(0))
         $)
         RESULTIS list3(s.valdef, n, rexplist())
   $)
$)

 .

GET "BCPLV1_SYNHDR"

LET rbcom() = VALOF
$( LET a, op = ?, symb

   SWITCHON symb INTO
   $( DEFAULT:
         RESULTIS 0

      CASE s.name:CASE s.number:CASE s.string:
      CASE s.true:CASE s.false:CASE s.lv:CASE s.rv:CASE s.vecap:
      CASE s.lparen:CASE s.slctr:
         a := rexplist()

         IF symb = s.ass THEN
         $( op := s.ass
            nextsymb()
            RESULTIS list3(op, a, rexplist())
         $)

         IF smallnumber(a) THEN synreport(20)

         IF symb = s.colon THEN
         $( UNLESS h1!a = s.name DO synreport(19)
            nextsymb()
            RESULTIS list4(s.colon, a, rbcom(), 0)
         $)

         IF h1!a = s.fnap THEN
         $( h1!a := s.rtap
            RESULTIS a
         $)

         synreport(20)
         RESULTIS a

      CASE s.goto:CASE s.resultis:CASE s.code:
         RESULTIS list2(op, rnexp(0))

      CASE s.if:CASE s.unless:
      CASE s.while:CASE s.until:
         a := rnexp(0)
         ignore(s.do)
         RESULTIS list3(op, a, rcom())

      CASE s.test:
      $( LET b = ?

         a := rnexp(0)
         ignore(s.do)
         b := rcom()
         checkfor(s.or, 21)
         RESULTIS list4(s.test, a, b, rcom())
      $)

      CASE s.for:
      $( LET i, j, k = ?, ?, 0

         nextsymb()
         a := rname()
         checkfor(s.eq, 22)
         i := rexp(0)
         checkfor(s.to, 23)
         j := rexp(0)
         IF symb = s.by THEN k := rnexp(0)
         ignore(s.do)
         RESULTIS list6(s.for, a, i, j, k, rcom())
      $)

      CASE s.loop:
      CASE s.break:CASE s.return:CASE s.finish:CASE s.endcase:
         a := wordnode
         nextsymb()
         RESULTIS a

      CASE s.switchon:
         a := rnexp(0)
         checkfor(s.into, 24)
         RESULTIS list3(s.switchon, a, rdsect(rdseq))

      CASE s.case:
         a := rnexp(0)
         checkfor(s.colon, 25)
         RESULTIS list3(s.case, a, rbcom())

      CASE s.default:
         nextsymb()
         checkfor(s.colon, 25)
         RESULTIS list2(s.default, rbcom())

      CASE s.lsect:
         RESULTIS rdsect(read_block_body)
   $)
$)

AND rcom() = VALOF
$( LET a = rbcom()

   IF a = 0 THEN synreport(20)

   WHILE symb = s.repeat \/ symb = s.repeatwhile \/ symb = s.repeatuntil DO
   $( LET op = symb

      nextsymb()
      TEST op = s.repeat THEN a := list2(op, a)
      OR a := list3(op, a, rexp(0))
   $)
   RESULTIS a
$)

// End of file BCPLV1_SYNSRC

